/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.invoker.impl;

import com.bizvane.dynamicdatasource.call.http.RestTemplateUtils;
import com.bizvane.dynamicdatasource.call.invoker.Invoker;
import com.bizvane.dynamicdatasource.call.registry.RouteRepository;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class LocalInvoker
implements Invoker {
    private final RestTemplate restTemplate;

    public LocalInvoker(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    public boolean supports(String type) {
        return "LOCAL".equals(type);
    }

    @Override
    public <T> T invoke(RouteRepository.Route rout, HttpMethod method, boolean isJsonBody, String api, Object request, Class<T> responseType) {
        String url = rout.getHttpUrl() + (rout.getServiceContextPath() != null ? rout.getServiceContextPath() : "") + api;
        return new RestTemplateUtils(this.restTemplate).sendRequest(method, url, request, isJsonBody, responseType);
    }
}

