/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.http;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.bizvane.dynamicdatasource.call.http.OkHttpProperties;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateUtils {
    private final RestTemplate restTemplate;

    @Autowired
    public RestTemplateUtils(OkHttpProperties okHttpProperties) {
        this(okHttpProperties.buildClientBuilder());
    }

    public RestTemplateUtils(OkHttpClient.Builder clientBuilder) {
        String tenantId = DynamicDataSourceContextHolder.peek();
        if (null != tenantId) {
            clientBuilder.addInterceptor(chain -> {
                Request originalRequest = chain.request();
                Request newRequest = originalRequest.newBuilder().header("tenantId", tenantId).build();
                return chain.proceed(newRequest);
            });
        }
        OkHttpClient client = clientBuilder.build();
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)new OkHttp3ClientHttpRequestFactory(client));
    }

    public <T> T sendRequest(HttpMethod method, String url, Object params, boolean isJsonBody, Class<T> clazz) {
        if (method == HttpMethod.GET) {
            if (params != null && params instanceof Map) {
                Map paramMap = (Map)params;
                StringBuilder sb = new StringBuilder(url);
                if (!url.contains("?")) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                for (Map.Entry entry : paramMap.entrySet()) {
                    sb.append((String)entry.getKey()).append("=").append(entry.getValue()).append("&");
                }
                url = sb.deleteCharAt(sb.length() - 1).toString();
            }
            return (T)this.restTemplate.getForObject(url, clazz, new Object[0]);
        }
        if (method == HttpMethod.POST) {
            HttpEntity requestEntity;
            HttpHeaders headers = new HttpHeaders();
            if (isJsonBody) {
                headers.setContentType(MediaType.APPLICATION_JSON);
                requestEntity = new HttpEntity(params, (MultiValueMap)headers);
            } else {
                LinkedMultiValueMap formData = new LinkedMultiValueMap();
                if (params != null && params instanceof Map) {
                    Map paramMap = (Map)params;
                    for (Map.Entry entry : paramMap.entrySet()) {
                        formData.add(entry.getKey(), entry.getValue());
                    }
                }
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                requestEntity = new HttpEntity((Object)formData, (MultiValueMap)headers);
            }
            return (T)this.restTemplate.postForObject(url, (Object)requestEntity, clazz, new Object[0]);
        }
        return null;
    }
}

