/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.invoker.impl;

import com.bizvane.dynamicdatasource.call.http.RestTemplateUtils;
import com.bizvane.dynamicdatasource.call.invoker.Invoker;
import com.bizvane.dynamicdatasource.call.registry.RouteRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
public class DiscoveryInvoker
implements Invoker {
    @Autowired
    LoadBalancerClient loadBalancer;
    @Autowired
    RestTemplateUtils restTemplateUtils;

    @Override
    public boolean supports(String type) {
        return "DISCOVERY".equals(type);
    }

    @Override
    public <T> T invoke(RouteRepository.Route rout, HttpMethod method, boolean isJsonBody, String api, Object request, Class<T> responseType) {
        ServiceInstance instance = this.loadBalancer.choose(rout.getServiceName());
        String url = instance.getUri() + (rout.getServiceContextPath() != null ? rout.getServiceContextPath() : "") + api;
        return this.restTemplateUtils.sendRequest(method, url, request, isJsonBody, responseType);
    }
}

