/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.registry;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class RouteRepository {
    private JdbcTemplate jdbcTemplate;
    private final Cache<Key, Route> cache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).refreshAfterWrite(5L, TimeUnit.MINUTES).build(key -> this.queryFromDb(((Key)key).tenantId, ((Key)key).module));

    @Autowired
    public void defaultJdbcTemplate(@Qualifier(value="primary") DataSource ds) {
        this.jdbcTemplate = new JdbcTemplate(ds);
    }

    public Route getRoute(String tenantId, String module) {
        return (Route)this.cache.get((Object)new Key(tenantId, module), key -> this.queryFromDb(((Key)key).tenantId, ((Key)key).module));
    }

    private Route queryFromDb(String tenantId, String module) {
        try {
            if (null == tenantId || tenantId.isEmpty()) {
                tenantId = "default";
            }
            return (Route)this.jdbcTemplate.queryForObject("SELECT tenant_id, module_name, call_type, http_url, service_name, service_context_path FROM t_sys_service_route WHERE valid = 1 and tenant_id = ? AND module_name = ?", new Object[]{tenantId, module}, (rs, rowNum) -> {
                Route rout = new Route();
                rout.setTenantId(rs.getString("tenant_id"));
                rout.setModuleName(rs.getString("module_name"));
                rout.setCallType(rs.getString("call_type"));
                rout.setHttpUrl(rs.getString("http_url"));
                rout.setServiceName(rs.getString("service_name"));
                rout.setServiceContextPath(rs.getString("service_context_path"));
                return rout;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class Route {
        private String tenantId;
        private String moduleName;
        private String callType;
        private String httpUrl;
        private String serviceName;
        private String serviceContextPath;

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public String getCallType() {
            return this.callType;
        }

        public void setCallType(String callType) {
            this.callType = callType;
        }

        public String getHttpUrl() {
            return this.httpUrl;
        }

        public void setHttpUrl(String httpUrl) {
            this.httpUrl = httpUrl;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getServiceContextPath() {
            return this.serviceContextPath;
        }

        public void setServiceContextPath(String serviceContextPath) {
            this.serviceContextPath = serviceContextPath;
        }
    }

    public static class Key {
        private final String tenantId;
        private final String module;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.tenantId, key.tenantId) && Objects.equals(this.module, key.module);
        }

        public int hashCode() {
            return Objects.hash(this.tenantId, this.module);
        }

        public Key(String tenantId, String module) {
            this.tenantId = tenantId;
            this.module = module;
        }
    }
}

