/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.registry;

import com.bizvane.dynamicdatasource.call.invoker.Invoker;
import com.bizvane.dynamicdatasource.call.registry.RouteRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;

@Configuration
public class InvokerRegistry {
    private final List<Invoker> invokers;

    @Autowired
    public InvokerRegistry(List<Invoker> invokerList) {
        this.invokers = invokerList;
    }

    public <T> T invoke(RouteRepository.Route rout, HttpMethod method, boolean isJsonBody, String api, Object request, Class<T> responseType) {
        Invoker matched = this.invokers.stream().filter(invoker -> invoker.supports(rout.getCallType())).findFirst().orElseThrow(() -> new RuntimeException("No invoker found"));
        return matched.invoke(rout, method, isJsonBody, api, request, responseType);
    }
}

