/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.http;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateUtils {
    private final RestTemplate restTemplate;

    @Autowired
    public RestTemplateUtils(RestTemplateBuilder builder) {
        this.restTemplate = builder.additionalInterceptors(new ClientHttpRequestInterceptor[]{(request, body, execution) -> {
            request.getHeaders().add("tenantId", DynamicDataSourceContextHolder.peek());
            return execution.execute(request, body);
        }}).build();
    }

    public <T> T sendRequest(HttpMethod method, String url, Object params, boolean isJsonBody, Class<T> clazz) {
        if (method == HttpMethod.GET) {
            if (params != null && params instanceof Map) {
                Map paramMap = (Map)params;
                StringBuilder sb = new StringBuilder(url);
                if (!url.contains("?")) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                for (Map.Entry entry : paramMap.entrySet()) {
                    sb.append((String)entry.getKey()).append("=").append(entry.getValue()).append("&");
                }
                url = sb.deleteCharAt(sb.length() - 1).toString();
            }
            return (T)this.restTemplate.getForObject(url, clazz, new Object[0]);
        }
        if (method == HttpMethod.POST) {
            HttpEntity requestEntity;
            HttpHeaders headers = new HttpHeaders();
            if (isJsonBody) {
                headers.setContentType(MediaType.APPLICATION_JSON);
                requestEntity = new HttpEntity(params, (MultiValueMap)headers);
            } else {
                LinkedMultiValueMap formData = new LinkedMultiValueMap();
                if (params != null && params instanceof Map) {
                    Map paramMap = (Map)params;
                    for (Map.Entry entry : paramMap.entrySet()) {
                        formData.add(entry.getKey(), entry.getValue());
                    }
                }
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                requestEntity = new HttpEntity((Object)formData, (MultiValueMap)headers);
            }
            return (T)this.restTemplate.postForObject(url, (Object)requestEntity, clazz, new Object[0]);
        }
        return null;
    }
}

