/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.invoker.impl;

import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.bizvane.dynamicdatasource.call.invoker.Invoker;
import com.bizvane.dynamicdatasource.call.registry.RouteRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class HttpInvoker
implements Invoker {
    private final RestTemplate restTemplate;

    @Autowired
    public HttpInvoker(RestTemplateBuilder builder) {
        this.restTemplate = builder.additionalInterceptors(new ClientHttpRequestInterceptor[]{(request, body, execution) -> {
            request.getHeaders().add("tenantId", DynamicDataSourceContextHolder.peek());
            return execution.execute(request, body);
        }}).build();
    }

    @Override
    public boolean supports(String type) {
        return "HTTP".equals(type);
    }

    @Override
    public <T> T invoke(RouteRepository.Rout rout, String api, Object request, Class<T> responseType) {
        String url = rout.getHttpUrl() + api;
        return (T)this.restTemplate.postForObject(url, request, responseType, new Object[0]);
    }
}

