/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.invoker.impl;

import com.bizvane.dynamicdatasource.call.invoker.Invoker;
import com.bizvane.dynamicdatasource.call.registry.RouteRepository;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class LocalInvoker
implements Invoker {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    private final Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>();

    @Override
    public boolean supports(String type) {
        return "LOCAL".equals(type);
    }

    @Override
    public <T> T invoke(RouteRepository.Rout rout, String api, Object request, Class<T> responseType) {
        Object o = this.internalCall(api, request);
        return (T)(o != null ? o : null);
    }

    private Object internalCall(String url, Object request) {
        HandlerMethod handlerMethod = this.getHandlerMethod(url);
        if (handlerMethod == null) {
            return null;
        }
        Method method = handlerMethod.getMethod();
        Object handlerBean = handlerMethod.getBean();
        Object[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 1 || !parameterTypes[0].equals(request.getClass())) {
            throw new IllegalArgumentException("The parameter types do not match: " + Arrays.toString(parameterTypes));
        }
        Class<?> declaringClass = method.getDeclaringClass();
        Object targetObject = AopProxyUtils.getSingletonTarget((Object)handlerBean);
        if (targetObject == null) {
            targetObject = handlerBean;
        }
        if (!declaringClass.isInstance(targetObject)) {
            throw new IllegalArgumentException("The object instance passed in is not an instance of the class that declares the method :" + declaringClass);
        }
        try {
            return ReflectionUtils.invokeMethod((Method)method, (Object)handlerBean, (Object[])new Object[]{request});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private HandlerMethod getHandlerMethod(String url) {
        try {
            return this.requestMappingHandlerMapping.getHandlerMethods().entrySet().stream().filter(entry -> ((RequestMappingInfo)entry.getKey()).getPatternsCondition().getPatterns().contains(url)).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

