/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.call.invoker.impl;

import com.bizvane.dynamicdatasource.call.invoker.Invoker;
import com.bizvane.dynamicdatasource.call.registry.RouteRepository;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class LocalInvoker
implements Invoker {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    private final Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>();

    @Override
    public boolean supports(String type) {
        return "LOCAL".equals(type);
    }

    @Override
    public <T> T invoke(RouteRepository.Rout rout, String api, Object request, Class<T> responseType) {
        return (T)(null == this.internalCall(api, request) ? null : this.internalCall(api, request));
    }

    private Object internalCall(String url, Object request) {
        Object handlerBean = this.getHandlerBean(url);
        if (handlerBean != null) {
            try {
                HandlerMethod handlerMethod = this.requestMappingHandlerMapping.getHandlerMethods().entrySet().stream().filter(entry -> ((RequestMappingInfo)entry.getKey()).getPatternsCondition().getPatterns().contains(url)).findFirst().map(Map.Entry::getValue).orElse(null);
                if (handlerMethod != null) {
                    Method method = handlerMethod.getMethod();
                    return method.invoke(handlerBean, request);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object getHandlerBean(String url) {
        try {
            return this.requestMappingHandlerMapping.getHandlerMethods().entrySet().stream().filter(entry -> ((RequestMappingInfo)entry.getKey()).getPatternsCondition().getPatterns().contains(url)).findFirst().map(entry -> ((HandlerMethod)entry.getValue()).getBean()).orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

