/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.async;

import com.bizvane.dynamicdatasource.async.TenantAsyncProperties;
import com.bizvane.dynamicdatasource.async.TenantContextPropagator;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
@EnableConfigurationProperties(value={TenantAsyncProperties.class})
public class TenantAsyncAutoConfiguration {
    @Autowired
    private TenantContextPropagator propagator;
    @Autowired
    private TenantAsyncProperties tenantAsyncProperties;

    @Bean(value={"tenantAwareExecutor"})
    public Executor tenantAwareExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.tenantAsyncProperties.getAsync().getCorePoolSize());
        executor.setMaxPoolSize(this.tenantAsyncProperties.getAsync().getMaxPoolSize());
        executor.setQueueCapacity(this.tenantAsyncProperties.getAsync().getQueueCapacity());
        executor.setThreadNamePrefix("Tenant-Async-");
        if (this.propagator != null) {
            executor.setTaskDecorator(runnable -> this.propagator.wrap(runnable));
        }
        executor.initialize();
        return executor;
    }
}

