/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.interceptor;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TenantInterceptor
implements HandlerInterceptor {
    public static final String TENANT_ID = "tenantId";
    @Autowired
    DataSource dataSource;
    @Autowired
    DefaultDataSourceCreator defaultDataSourceCreator;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String tenantId = request.getHeader(TENANT_ID);
        if (tenantId != null && !tenantId.isEmpty()) {
            DynamicDataSourceContextHolder.push((String)tenantId);
            try {
                DynamicRoutingDataSource routingDataSource = this.dataSource.unwrap(DynamicRoutingDataSource.class);
                Map tenantDataSourceMap = routingDataSource.getDataSources();
                if (!tenantDataSourceMap.isEmpty() && !tenantDataSourceMap.containsKey(tenantId)) {
                    List<Map<String, String>> maps = this.loadDataSourceConfigsFromDefaultDataSource(this.dataSource, tenantId);
                    for (Map<String, String> map : maps) {
                        DataSource dataSource = this.defaultDataSourceCreator.createDataSource(new DataSourceProperty().setPoolName(map.get(TENANT_ID)).setUrl(map.get("url")).setUsername(map.get("username")).setPassword(map.get("password")).setDriverClassName(map.get("driverClassName")));
                        routingDataSource.addDataSource(map.get(TENANT_ID), dataSource);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        DynamicDataSourceContextHolder.poll();
    }

    private List<Map<String, String>> loadDataSourceConfigsFromDefaultDataSource(DataSource dataSource, String tenantId) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        return jdbcTemplate.query("SELECT tenant_id, url, username, password, driver_class_name FROM t_sys_data_sources where valid = 1 and tenant_id = ? limit 1", new Object[]{tenantId}, (rs, rowNum) -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(TENANT_ID, rs.getString("tenant_id"));
            map.put("url", rs.getString("url"));
            map.put("username", rs.getString("username"));
            map.put("password", rs.getString("password"));
            map.put("driverClassName", rs.getString("driver_class_name"));
            return map;
        });
    }
}

