/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.config;

import com.baomidou.dynamic.datasource.provider.AbstractJdbcDataSourceProvider;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import feign.RequestInterceptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DynamicDataSourceConfig {
    @Bean
    public DynamicDataSourceProvider dynamicDataSourceProvider(DynamicDataSourceProperties properties) {
        final Map datasourceMap = properties.getDatasource();
        DataSourceProperty masterDataSourceProperty = (DataSourceProperty)datasourceMap.get(properties.getPrimary());
        return new AbstractJdbcDataSourceProvider(masterDataSourceProperty.getDriverClassName(), masterDataSourceProperty.getUrl(), masterDataSourceProperty.getUsername(), masterDataSourceProperty.getPassword()){

            protected Map<String, DataSourceProperty> executeStmt(Statement statement) {
                try {
                    ResultSet resultSet = statement.executeQuery(" SELECT tenant_id, url, username, password, driver_class_name FROM t_sys_data_sources where valid = 1 ");
                    while (resultSet.next()) {
                        String tenantId = resultSet.getString("tenant_id");
                        String username = resultSet.getString("username");
                        String password = resultSet.getString("password");
                        String url = resultSet.getString("url");
                        String driver = resultSet.getString("driver_class_name");
                        DynamicDataSourceConfig.addDatasource(tenantId, username, password, url, driver, datasourceMap);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                return datasourceMap;
            }
        };
    }

    private static void addDatasource(String tenantId, String username, String password, String url, String driver, Map<String, DataSourceProperty> datasourceMap) {
        DataSourceProperty property = new DataSourceProperty();
        property.setUsername(username);
        property.setUrl(url);
        property.setDriverClassName(driver);
        property.setPassword(password);
        datasourceMap.put(tenantId, property);
    }

    @Bean
    public RequestInterceptor tenantIdFeignInterceptor() {
        return requestTemplate -> {
            String tenantId = DynamicDataSourceContextHolder.peek();
            if (tenantId != null) {
                requestTemplate.header("tenantId", new String[]{tenantId});
            }
        };
    }
}

