/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource.loader;

import com.bizvane.dynamicdatasource.DataSourceService;
import com.bizvane.dynamicdatasource.config.DataSourceConfig;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class DataSourceConfigLoader
implements CommandLineRunner {
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private DataSource defaultDataSource;

    public void run(String ... args) {
        System.out.println("DataSourceConfigLoader init");
        List<DataSourceConfig> dataSourceConfigs = this.loadDataSourceConfigsFromDefaultDataSource(this.defaultDataSource);
        for (DataSourceConfig config : dataSourceConfigs) {
            this.dataSourceService.addDataSource(config.getTenantId(), config.getUrl(), config.getUsername(), config.getPassword(), config.getDriverClassName());
        }
    }

    private List<DataSourceConfig> loadDataSourceConfigsFromDefaultDataSource(DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        List configs = jdbcTemplate.query("SELECT tenant_id, url, username, password, driver_class_name FROM t_sys_data_sources", (rs, rowNum) -> {
            DataSourceConfig config = new DataSourceConfig();
            config.setTenantId(rs.getString("tenant_id"));
            config.setUrl(rs.getString("url"));
            config.setUsername(rs.getString("username"));
            config.setPassword(rs.getString("password"));
            config.setDriverClassName(rs.getString("driver_class_name"));
            return config;
        });
        return configs;
    }
}

