/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource;

import com.bizvane.dynamicdatasource.DataSourceService;
import com.bizvane.dynamicdatasource.DynamicRoutingDataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;

@Configuration
public class TenantInterceptor
implements HandlerInterceptor {
    @Autowired
    private DataSourceService dataSourceService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String tenantId = request.getHeader("tenantId");
        if (tenantId != null && !tenantId.isEmpty()) {
            DynamicRoutingDataSource.setTenantId(tenantId);
            this.dataSourceService.getDataSource(tenantId);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        DynamicRoutingDataSource.clearTenantId();
    }
}

