/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.dynamicdatasource;

import com.bizvane.dynamicdatasource.DataSourceProperties;
import com.bizvane.dynamicdatasource.DynamicRoutingDataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class DataSourceService {
    private final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private final DataSourceProperties dataSourceProperties;
    private DynamicRoutingDataSource dynamicRoutingDataSource;

    @Bean
    @Primary
    public DataSource routingDataSource() {
        this.dynamicRoutingDataSource = new DynamicRoutingDataSource();
        DataSource defaultDataSource = this.createDefaultDataSource();
        this.dynamicRoutingDataSource.setDefaultTargetDataSource(defaultDataSource);
        HashMap<String, DataSource> targetDataSources = new HashMap<String, DataSource>();
        targetDataSources.put("0", defaultDataSource);
        this.dynamicRoutingDataSource.setTargetDataSources(targetDataSources);
        this.dynamicRoutingDataSource.afterPropertiesSet();
        return this.dynamicRoutingDataSource;
    }

    @Autowired
    public DataSourceService(DataSourceProperties dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }

    @Bean
    public DataSource createDefaultDataSource() {
        String url = this.dataSourceProperties.getDefaultUrl();
        String username = this.dataSourceProperties.getDefaultUsername();
        String password = this.dataSourceProperties.getDefaultPassword();
        String driverClassName = this.dataSourceProperties.getDefaultDriverClassName();
        return DataSourceBuilder.create().url(url).username(username).password(password).driverClassName(driverClassName).build();
    }

    public DataSource getDataSource(String tenantId) {
        DataSource dataSource;
        if (!this.dataSourceMap.containsKey(tenantId) && (dataSource = this.createDataSource(tenantId)) != null) {
            this.dataSourceMap.put(tenantId, dataSource);
            this.dynamicRoutingDataSource.setTargetDataSources(new HashMap<String, DataSource>(this.dataSourceMap));
            this.dynamicRoutingDataSource.afterPropertiesSet();
        }
        return this.dataSourceMap.get(tenantId);
    }

    private DataSource createDataSource(String tenantId) {
        try {
            String schemaPrefix = this.dataSourceProperties.getSchemaPrefix();
            String url = this.dataSourceProperties.getDefaultUrl().replace(this.dataSourceProperties.getDefaultDatabase(), schemaPrefix + tenantId);
            String username = this.dataSourceProperties.getDefaultUsername();
            String password = this.dataSourceProperties.getDefaultPassword();
            String driverClassName = this.dataSourceProperties.getDefaultDriverClassName();
            return DataSourceBuilder.create().url(url).username(username).password(password).driverClassName(driverClassName).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

