/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.rocketmq.rocketutils;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.bizvane.customized.common.utils.SpringContextUtil;
import com.bizvane.customized.rocketmq.rocketutils.RocketMQConfig;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public abstract class RocketMQConsumeInit
extends RocketMQConfig {
    @PostConstruct
    public void consumerFactory() {
        if (this.validation()) {
            System.out.println("\u672a\u914d\u7f6e\u597d-\u6d88\u8d39\u8005-MQ\u914d\u7f6e");
            return;
        }
        if (this.isNotConsume()) {
            System.out.println("consumeThreadNums=0,\u4e0d\u542f\u52a8\u6d88\u8d39\u8005");
            return;
        }
        Properties consumerProperties = new Properties();
        consumerProperties.setProperty("ConsumerId", this.getConsumeId());
        consumerProperties.setProperty("AccessKey", this.accessKey);
        consumerProperties.setProperty("SecretKey", this.secretKey);
        consumerProperties.setProperty(this.ONSAddr, this.namesrvAddr);
        consumerProperties.put("MessageModel", "CLUSTERING");
        consumerProperties.put("ConsumeThreadNums", this.consumeThreadNums);
        Consumer consumer = ONSFactory.createConsumer((Properties)consumerProperties);
        consumer.subscribe(this.setTopic(), this.setTag(), this.messageListener());
        consumer.start();
        System.out.println("\u6d88\u8d39\u8005\u542f\u52a8\u6210\u529f:" + JSONObject.toJSONString((Object)consumerProperties));
    }

    public MessageListener messageListener() {
        return (message, consumeContext) -> ((RocketMQConsumeInit)SpringContextUtil.getBean((String)this.getMessageListenerBeanName(this.getClass().getSimpleName()))).processMessage(message);
    }

    protected abstract Action processMessage(Message var1);

    public abstract String getConsumeId();

    public abstract String setTopic();

    public abstract String setTag();

    private String getMessageListenerBeanName(String className) {
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }
}

