/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.rocketmq.messagelisterner;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.Message;
import com.bizvane.customized.common.constants.MemberDistributionConstants;
import com.bizvane.customized.common.system.RedisManager;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.facade.models.po.CusDistributionPO;
import com.bizvane.customized.facade.models.po.CusDistributionPOExample;
import com.bizvane.customized.facade.models.po.CusDistributionRecordPO;
import com.bizvane.customized.facade.models.po.CusDistributionRegxPO;
import com.bizvane.customized.mappers.CusDistributionPOMapper;
import com.bizvane.customized.mappers.CusDistributionRecordPOMapper;
import com.bizvane.customized.mappers.CusDistributionRegxPOMapper;
import com.bizvane.customized.rocketmq.rocketutils.RocketMQConsumeInit;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.models.OrderModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderListener
extends RocketMQConsumeInit {
    private static final Logger log = LoggerFactory.getLogger(OrderListener.class);
    @Value(value="${customizedmq.orderconsume.consumeId}")
    private String consumeId;
    @Value(value="${customizedmq.orderconsume.topic}")
    private String topic;
    @Autowired
    private CusDistributionPOMapper cusDistributionPOMapper;
    @Autowired
    private CusDistributionRecordPOMapper cusDistributionRecordPOMapper;
    @Autowired
    private CusDistributionRegxPOMapper cusDistributionRegxPOMapper;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    @Transactional
    protected Action processMessage(Message message) {
        CusDistributionRegxPO cusDistributionRegx;
        String msg = new String(message.getBody());
        OrderModel orderModel = (OrderModel)JacksonUtil.json2Obj((String)msg, OrderModel.class);
        log.info("enter processMessage param:{}", (Object)JacksonUtil.bean2Json((Object)orderModel));
        RedisClient redisClient = RedisManager.getInstince();
        CusDistributionRecordPO cusDistributionRecordPO = new CusDistributionRecordPO();
        cusDistributionRecordPO.setBrandId(orderModel.getBrandId());
        cusDistributionRecordPO.setSysCompanyId(orderModel.getSysCompanyId());
        cusDistributionRecordPO.setOrderNo(orderModel.getOrderNo());
        cusDistributionRecordPO.setTradeAmount(orderModel.getCommodityAmount());
        cusDistributionRecordPO.setCommodityAmount(orderModel.getTradeAmount());
        cusDistributionRecordPO.setConsumeDate(orderModel.getPlaceOrderTime());
        cusDistributionRecordPO.setServiceStoreId(orderModel.getServiceStoreId());
        CusDistributionRegxPO cusDistributionRegxPO = new CusDistributionRegxPO();
        cusDistributionRegxPO.setBrandId(orderModel.getBrandId());
        cusDistributionRegxPO.setSysCompanyId(orderModel.getSysCompanyId());
        List regxPOS = this.cusDistributionRegxPOMapper.selectByBrandIdAndCompanyId(cusDistributionRegxPO);
        if (regxPOS.size() > 0 && (cusDistributionRegx = (CusDistributionRegxPO)regxPOS.get(0)).getCommissionStatus() == 1) {
            CusDistributionPOExample cusDistributionPOExample = new CusDistributionPOExample();
            CusDistributionPOExample.Criteria distributionCriteria = cusDistributionPOExample.createCriteria();
            distributionCriteria.andBrandIdEqualTo(orderModel.getBrandId()).andSysCompanyIdEqualTo(orderModel.getSysCompanyId()).andMemberCodeEqualTo(orderModel.getMemberCode()).andDistribBindStatusEqualTo(Integer.valueOf(2)).andSuperiorMemberCodeIsNotNull().andValidEqualTo(Boolean.valueOf(true));
            List cusDistributionPOS = this.cusDistributionPOMapper.selectByExample(cusDistributionPOExample);
            if (cusDistributionPOS.size() > 0) {
                CusDistributionPO cusDistributionPO = (CusDistributionPO)cusDistributionPOS.get(0);
                CusDistributionPOExample cusDistributionEx = new CusDistributionPOExample();
                CusDistributionPOExample.Criteria criteria = cusDistributionEx.createCriteria();
                criteria.andDistributionStatusEqualTo(Integer.valueOf(1)).andMemberCodeEqualTo(cusDistributionPO.getSuperiorMemberCode()).andValidEqualTo(Boolean.valueOf(true));
                List distributionPOS = this.cusDistributionPOMapper.selectByExample(cusDistributionEx);
                if (distributionPOS.size() > 0 && cusDistributionPO.getDistribBindCreateDate().before(orderModel.getCreateDate())) {
                    boolean exists = redisClient.exists(orderModel.getSysCompanyId() + "MEMBER_DISTRIBUTION_REGX_KEY" + orderModel.getBrandId());
                    MemberInfoModel memberInfoModel = new MemberInfoModel();
                    memberInfoModel.setMemberCode(cusDistributionPO.getSuperiorMemberCode());
                    ResponseData memberInfoResData = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
                    MemberInfoModel memberInfo = (MemberInfoModel)memberInfoResData.getData();
                    cusDistributionRecordPO.setpPhone(memberInfo.getPhone());
                    cusDistributionRecordPO.setpName(memberInfo.getName());
                    cusDistributionRecordPO.setpMemberCode(memberInfo.getMemberCode());
                    cusDistributionRecordPO.setServiceStoreId(memberInfo.getServiceStoreId());
                    MemberInfoModel memberInfoModelC = new MemberInfoModel();
                    memberInfoModelC.setMemberCode(orderModel.getMemberCode());
                    ResponseData memberModelData = this.memberInfoApiService.getSingleMemberModel(memberInfoModelC);
                    MemberInfoModel memberInfoC = (MemberInfoModel)memberModelData.getData();
                    cusDistributionRecordPO.setcMemberCode(memberInfoC.getMemberCode());
                    cusDistributionRecordPO.setcName(memberInfoC.getName());
                    cusDistributionRecordPO.setcPhone(memberInfoC.getPhone());
                    cusDistributionRecordPO.setCardNo(memberInfoC.getCardNo());
                    Integer commissionObtainDetailType = null;
                    BigDecimal commissionRation = null;
                    Integer commissionPeriod = null;
                    if (exists) {
                        JSONObject jsonObject = JSONObject.parseObject((String)redisClient.get(orderModel.getSysCompanyId() + "MEMBER_DISTRIBUTION_REGX_KEY" + orderModel.getBrandId()).toString());
                        log.info("processMessage redis content:{}", (Object)JacksonUtil.bean2Json((Object)jsonObject));
                        JSONObject map = jsonObject;
                        Integer commissionObtainType = (Integer)map.get("commissionObtainType");
                        commissionObtainDetailType = (Integer)map.get("commissionObtainDetailType");
                        commissionRation = (BigDecimal)map.get("commissionRation");
                        commissionPeriod = (Integer)map.get("commissionPeriod");
                    } else {
                        commissionObtainDetailType = cusDistributionRegx.getCommissionObtainDetailType();
                        commissionRation = cusDistributionRegx.getCommissionRation();
                        commissionPeriod = cusDistributionRegx.getCommissionPeriod();
                    }
                    if (commissionObtainDetailType.equals(MemberDistributionConstants.COMMISSION_OBTAINDETAILTYPE)) {
                        if (memberInfo.getServiceStoreId().equals(orderModel.getServiceStoreId())) {
                            this.calcuComission(orderModel, cusDistributionRecordPO, commissionRation, commissionPeriod);
                        }
                    } else {
                        this.calcuComission(orderModel, cusDistributionRecordPO, commissionRation, commissionPeriod);
                    }
                }
            }
        }
        return Action.CommitMessage;
    }

    private void calcuComission(OrderModel orderModel, CusDistributionRecordPO cusDistributionRecordPO, BigDecimal commissionRation, Integer commissionPeriod) {
        BigDecimal comission = commissionRation.multiply(orderModel.getTradeAmount()).divide(new BigDecimal("100"));
        int comissionEnd = comission.setScale(0, 4).intValue();
        cusDistributionRecordPO.setCommission(Integer.valueOf(comissionEnd));
        cusDistributionRecordPO.setCommissionStatus(MemberDistributionConstants.UNSETTLEMENT);
        cusDistributionRecordPO.setRegx(commissionRation + "%");
        cusDistributionRecordPO.setVersion(Integer.valueOf(1));
        cusDistributionRecordPO.setCreateDate(new Date());
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(orderModel.getPlaceOrderTime());
        ((Calendar)calendar).add(5, commissionPeriod);
        cusDistributionRecordPO.setDealDate(calendar.getTime());
        cusDistributionRecordPO.setValid(Boolean.valueOf(true));
        this.cusDistributionRecordPOMapper.insert(cusDistributionRecordPO);
    }

    public String setTopic() {
        return this.topic;
    }

    public String setTag() {
        return "register_tag_order";
    }

    public String getConsumeId() {
        return this.consumeId;
    }
}

