/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.rocketmq.messagelisterner;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.Message;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysOfflineOrgPo;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.Cus361StoreFieldsRequestVo;
import com.bizvane.centerstageservice.models.vo.SysOfflineOrgVo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.centerstageservice.rpc.SysOfflineOrgServcieRpc;
import com.bizvane.customized.common.constants.Cus361ResponseEnum;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.facade.models.po.Cus361FailedBatchDataPO;
import com.bizvane.customized.facade.models.po.Cus361StoreCodeMappingPO;
import com.bizvane.customized.facade.models.po.Cus361StoreFieldsPO;
import com.bizvane.customized.facade.models.vo.Cus361StoreFieldsVo;
import com.bizvane.customized.mappers.Cus361DistributorDataPoMapper;
import com.bizvane.customized.mappers.Cus361FailedBatchDataPOMapper;
import com.bizvane.customized.mappers.Cus361PrecinctAreaPOMapper;
import com.bizvane.customized.mappers.Cus361StoreCodeMappingPOMapper;
import com.bizvane.customized.mappers.Cus361StoreFieldsPOMapper;
import com.bizvane.customized.rocketmq.rocketutils.RocketMQConsumeInit;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class Cus361StoreFieldsListener
extends RocketMQConsumeInit {
    private static final Logger log = LoggerFactory.getLogger(Cus361StoreFieldsListener.class);
    @Value(value="${customizedmq.cus361storefields.consumeId}")
    private String consumeId;
    @Value(value="${customizedmq.cus361storefields.topic}")
    private String topic;
    @Autowired
    Cus361StoreFieldsPOMapper cus361StoreFieldsPOMapper;
    @Autowired
    StoreServiceRpc storeServiceRpc;
    @Autowired
    BrandServiceRpc brandServiceRpc;
    @Autowired
    Cus361FailedBatchDataPOMapper failedBatchDataPOMapper;
    @Autowired
    Cus361StoreCodeMappingPOMapper storeCodeMappingPOMapper;
    @Autowired
    Cus361PrecinctAreaPOMapper cus361PrecinctAreaPOMapper;
    @Autowired
    Cus361DistributorDataPoMapper cus361DistributorDataPoMapper;
    @Autowired
    private SysOfflineOrgServcieRpc sysOfflineOrgServcieRpc;
    @Autowired
    RocketMQTemplate rocketMQTemplate;
    Cus361FailedBatchDataPO failedDataPo = new Cus361FailedBatchDataPO();

    protected Action processMessage(Message message) {
        log.info("Cus361StoreFieldsListener start ! !");
        String msg = new String(message.getBody());
        Cus361StoreFieldsVo vo = (Cus361StoreFieldsVo)JacksonUtil.json2Obj((String)msg, Cus361StoreFieldsVo.class);
        log.info("Cus361StoreFieldsListener enter processMessage param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        String brandCode = vo.getBrandCode();
        SysBrandPo brandPo = new SysBrandPo();
        if ("361LIST".equals(brandCode)) {
            String errorReason;
            log.info("\u54c1\u724cCode\u4e3a361LIST");
            brandPo.setBrandCode("361DZ");
            ResponseData brandDzResponseData = this.brandServiceRpc.getBrandIdAndCompanyIdByCode(brandPo);
            if (brandDzResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                log.info("brandServiceRpc getBrandIdAndCompanyIdByCode \u67e5\u8be2\u4e0d\u5230\u6570\u636e");
                return null;
            }
            brandPo.setBrandCode("361ET");
            ResponseData brandEtResponseData = this.brandServiceRpc.getBrandIdAndCompanyIdByCode(brandPo);
            if (brandEtResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                log.info("brandServiceRpc getBrandIdAndCompanyIdByCode \u67e5\u8be2\u4e0d\u5230\u6570\u636e");
                return null;
            }
            brandPo = (SysBrandPo)brandDzResponseData.getData();
            Long dzBrandId = brandPo.getSysBrandId();
            Long sysCompanyId = brandPo.getSysCompanyId();
            brandPo = (SysBrandPo)brandEtResponseData.getData();
            Long etBrandId = brandPo.getSysBrandId();
            if (this.idCompanyOrBrandIdBlank(dzBrandId, etBrandId, sysCompanyId)) {
                return null;
            }
            SysStorePo sysStorePo = this.getStore(vo, dzBrandId, etBrandId, sysCompanyId);
            if (this.isStoreNull(vo, sysStorePo, errorReason = Cus361ResponseEnum.CUS_361_STORE_FAILED_GET_INFO_BY_361DZ.getMessage())) {
                return Action.CommitMessage;
            }
            Cus361StoreFieldsPO fieldsPO = this.getCusStore(sysStorePo, vo);
            this.addAndUpdate361Store(sysStorePo, fieldsPO);
        } else {
            Long sysCompanyId;
            Long etBrandId;
            brandPo.setBrandCode(brandCode);
            ResponseData brandResponseData = this.brandServiceRpc.getBrandIdAndCompanyIdByCode(brandPo);
            if (brandResponseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                log.info("brandServiceRpc getBrandIdAndCompanyIdByCode \u67e5\u8be2\u4e0d\u5230\u6570\u636e");
                return null;
            }
            brandPo = (SysBrandPo)brandResponseData.getData();
            Long dzBrandId = brandPo.getSysBrandId();
            SysStorePo sysStorePo = this.getStore(vo, dzBrandId, etBrandId = null, sysCompanyId = brandPo.getSysCompanyId());
            if (sysStorePo == null) {
                log.error("\u6839\u636e\u54c1\u724ccode {} \u67e5\u8be2\u4e3a\u7a7a", (Object)brandCode);
                return Action.CommitMessage;
            }
            Cus361StoreFieldsPO fieldsPO = this.getCusStore(sysStorePo, vo);
            this.addAndUpdate361Store(sysStorePo, fieldsPO);
        }
        return Action.CommitMessage;
    }

    private boolean isStoreNull(Cus361StoreFieldsVo vo, SysStorePo sysStorePo, String errorReason) {
        if (sysStorePo == null) {
            log.error(errorReason);
            this.failedDataPo.setBatchNo(vo.getBatchNo());
            this.failedDataPo.setBatchDataType("30");
            this.failedDataPo.setErrorPk(vo.getStoreCode());
            this.failedDataPo.setErrorBody(vo.toString());
            this.failedDataPo.setErrorReason(errorReason);
            this.failedDataPo.setCreateDate(new Date());
            this.failedDataPo.setStatus("0");
            this.failedBatchDataPOMapper.insertSelective(this.failedDataPo);
            return true;
        }
        return false;
    }

    public SysStorePo getStore(Cus361StoreFieldsVo vo, Long dzBrandId, Long etBrandId, Long sysCompanyId) {
        log.info("Cus361StoreFieldsListener getStore method params:{},{},{},{}", new Object[]{JSONObject.toJSONString((Object)vo), dzBrandId, etBrandId, sysCompanyId});
        SysStorePo storePo = new SysStorePo();
        storePo.setSysBrandId(dzBrandId);
        storePo.setSysCompanyId(sysCompanyId);
        storePo.setSlaveSysBrandId(String.valueOf(etBrandId));
        storePo.setSlaveStoreOrcode("null");
        storePo.setSysStoreOfflineCode(vo.getStoreCode());
        storePo.setSysStoreOnlineCode(vo.getStoreCode());
        storePo.setStoreId(vo.getStoreCode());
        storePo.setStoreName(vo.getStoreName());
        storePo.setStorePhone(vo.getStorePhone());
        storePo.setStoreOrcode(vo.getStoreOrcode());
        storePo.setStoreType(!"".equals(vo.getStoreType()) ? Integer.valueOf(Integer.parseInt(vo.getStoreType())) : null);
        if (null != storePo.getStoreType()) {
            if (storePo.getStoreType() == 10) {
                storePo.setDictionaryCode("1001");
            } else if (storePo.getStoreType() == 20) {
                storePo.setDictionaryCode("1002");
            } else if (storePo.getStoreType() == 40) {
                storePo.setDictionaryCode("1003");
            } else if (storePo.getStoreType() == 50) {
                storePo.setDictionaryCode("1004");
            }
        }
        storePo.setShopOwner(vo.getStoreOwner());
        storePo.setStoreInfo(vo.getStoreInfo());
        storePo.setProvinceName(vo.getProvince());
        storePo.setCityName(vo.getCity());
        storePo.setAreaName(vo.getCounty());
        storePo.setDetailedAddress(vo.getDetailedAddress());
        storePo.setLng(vo.getLng());
        storePo.setLat(vo.getLat());
        storePo.setStoreBusinessTime(vo.getStoreBusinessTime());
        storePo.setModelType(!"".equals(vo.getModelType()) ? vo.getModelType() : null);
        storePo.setBusinessStatus(!"".equals(vo.getBusinessStatus()) ? vo.getBusinessStatus() : null);
        if (storePo.getBusinessStatus() == 10 || storePo.getBusinessStatus() == 20) {
            storePo.setStatus(Boolean.valueOf(true));
        } else {
            storePo.setStatus(Boolean.valueOf(false));
        }
        storePo.setStoreSize(!"".equals(vo.getStoreSize()) ? vo.getStoreSize() : null);
        storePo.setOfflineOrgCode(vo.getOfflineOrgCode());
        storePo.setValid(Boolean.valueOf(true));
        return storePo;
    }

    private boolean idCompanyOrBrandIdBlank(Long dzBrandId, Long etBrandId, Long sysCompanyId) {
        if (null == dzBrandId) {
            log.error("\u5927\u88c5\u54c1\u724cid\u4e3a\u7a7a");
            return true;
        }
        if (null == etBrandId) {
            log.error("\u513f\u7ae5\u54c1\u724cid\u4e3a\u7a7a");
            return true;
        }
        if (null == sysCompanyId) {
            log.error("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
            return true;
        }
        return false;
    }

    public Cus361StoreFieldsPO getCusStore(SysStorePo storePo, Cus361StoreFieldsVo vo) {
        log.info("Cus361StoreFieldsListener getCusStore method param : {},{}", (Object)JSONObject.toJSONString((Object)storePo), (Object)JSONObject.toJSONString((Object)vo));
        Cus361StoreFieldsPO fieldsPO = new Cus361StoreFieldsPO();
        BeanUtils.copyProperties((Object)vo, (Object)fieldsPO);
        fieldsPO.setSysCompanyId(storePo.getSysCompanyId());
        fieldsPO.setSysBrandId(storePo.getSysBrandId());
        fieldsPO.setStoreCode(storePo.getSysStoreOfflineCode());
        fieldsPO.setCorpCode(vo.getCorpCode());
        fieldsPO.setAreaCode(vo.getAreaCode());
        fieldsPO.setSapCustomerCode(vo.getSapCustomerCode());
        fieldsPO.setOriginStoreCode(vo.getOriginStoreCode());
        fieldsPO.setBusinessType(vo.getBusinessType());
        fieldsPO.setModifiedDate(new Date());
        fieldsPO.setValid(Boolean.valueOf(true));
        return fieldsPO;
    }

    public ResponseData addAndUpdate361Store(SysStorePo storePo, Cus361StoreFieldsPO fieldsPO) {
        log.info("Cus361StoreFieldsListener addAndUpdateStore method param:{},{}", (Object)JSONObject.toJSONString((Object)storePo), (Object)JSONObject.toJSONString((Object)fieldsPO));
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        SysStorePo sysStorePo = (SysStorePo)this.storeServiceRpc.getStoreByOfflineCode(storePo.getSysStoreOfflineCode(), storePo.getSysCompanyId()).getData();
        Cus361StoreFieldsPO cusFieldsPO = this.cus361StoreFieldsPOMapper.getCus361Store(storePo.getSysStoreOfflineCode());
        if (StringUtils.isNotBlank((CharSequence)fieldsPO.getAreaCode())) {
            String areaName = this.cus361PrecinctAreaPOMapper.getAreaName(fieldsPO.getAreaCode());
            if (StringUtils.isBlank((CharSequence)areaName)) {
                log.info("addAndUpdateStore \u6839\u636eareaCode\u67e5\u8be2\u533a\u57df\u4e3a\u7a7a param:{}", (Object)fieldsPO.getAreaCode());
            }
            storePo.setBizArea(areaName);
        }
        if (StringUtils.isNotBlank((CharSequence)fieldsPO.getCorpCode())) {
            String corpName = this.cus361DistributorDataPoMapper.getCorpName(fieldsPO.getCorpCode());
            if (StringUtils.isBlank((CharSequence)corpName)) {
                log.info("addAndUpdateStore \u6839\u636ecorpCode\u67e5\u8be2\u4e3a\u7a7a param:{}", (Object)fieldsPO.getCorpCode());
            }
            storePo.setDistributorName(corpName);
        }
        Cus361StoreFieldsRequestVo requestVo = new Cus361StoreFieldsRequestVo();
        BeanUtils.copyProperties((Object)fieldsPO, (Object)requestVo);
        BeanUtils.copyProperties((Object)storePo, (Object)requestVo);
        requestVo.setStoreBusinessTime(storePo.getStoreBusinessTime() == null ? null : storePo.getStoreBusinessTime().replace("-", ""));
        if (null == sysStorePo) {
            try {
                this.storeServiceRpc.addStore(requestVo);
                sysStorePo = (SysStorePo)this.storeServiceRpc.getStoreByOfflineCode(storePo.getSysStoreOfflineCode(), storePo.getSysCompanyId()).getData();
                this.storeServiceRpc.generateQRCodeForMuster(sysStorePo.getSysCompanyId(), sysStorePo.getSysStoreId());
                log.info("\u65b0\u589e\u5e97\u94fa\u5237\u65b0\u95e8\u5e97\u4e8c\u7ef4\u7801:" + sysStorePo.getSysStoreId());
            }
            catch (Exception e) {
                log.info("\u65b0\u589e\u5e97\u94fa\u5f02\u5e38:" + storePo.getSysStoreOfflineCode());
                log.error("e:", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        } else {
            this.storeServiceRpc.updateStore(storePo);
        }
        if (null == cusFieldsPO) {
            fieldsPO.setCreateDate(new Date());
            this.cus361StoreFieldsPOMapper.insertSelective(fieldsPO);
        } else {
            fieldsPO.setCusStoreFieldsId(cusFieldsPO.getCusStoreFieldsId());
            this.cus361StoreFieldsPOMapper.updateByPrimaryKeySelective(fieldsPO);
        }
        Cus361StoreCodeMappingPO mappingPO = this.storeCodeMappingPOMapper.queryCodeMappingInfo(storePo.getSysStoreOfflineCode());
        if (null == mappingPO) {
            mappingPO = new Cus361StoreCodeMappingPO();
            mappingPO.setSysCompanyId(storePo.getSysCompanyId());
            mappingPO.setSysBrandId(storePo.getSysBrandId());
            mappingPO.setSapCode(storePo.getSysStoreOfflineCode());
            mappingPO.setOriginStoreCode(fieldsPO.getOriginStoreCode());
            mappingPO.setZipCode(fieldsPO.getCorpCode());
            mappingPO.setValid(Boolean.valueOf(true));
            log.info("Cus361StoreFieldsListener addStoreCodeMapping param : {}", (Object)JSONObject.toJSONString((Object)mappingPO));
            this.storeCodeMappingPOMapper.insertSelective(mappingPO);
        } else {
            int count = this.storeCodeMappingPOMapper.updateSapCode(fieldsPO.getCorpCode(), fieldsPO.getOriginStoreCode(), storePo.getSysStoreOnlineCode());
            if (count == 0) {
                log.info("Cus361StoreFieldsListener addAndUpdate361Store updateFailed param:{},{},{}", new Object[]{fieldsPO.getCorpCode(), fieldsPO.getOriginStoreCode(), storePo.getSysStoreOnlineCode()});
            }
        }
        log.info("[Cus361StoreFieldsListener-addAndUpdate361Store-info-],sendRequest:{}", (Object)JSONObject.toJSONString((Object)sysStorePo));
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("topic_361_customized_store_sync_message").build(), (Object)JSON.toJSONString((Object)sysStorePo));
        log.info("[Cus361StoreFieldsListener-addAndUpdate361Store-info-],sendResult:{}", (Object)JSONObject.toJSONString((Object)sendResult));
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    private void insertOfflineOrg(SysStorePo storePo) {
        String offlineOrgCode = storePo.getOfflineOrgCode();
        SysOfflineOrgVo sysOfflineOrgVo = new SysOfflineOrgVo();
        sysOfflineOrgVo.setSysCompanyId(storePo.getSysCompanyId());
        sysOfflineOrgVo.setOfflineOrgCode(offlineOrgCode);
        sysOfflineOrgVo.setValid(Boolean.TRUE);
        Long count = (Long)this.sysOfflineOrgServcieRpc.selectCountByVo(sysOfflineOrgVo).getData();
        if (count != null && count == 0L) {
            SysOfflineOrgPo sysOfflineOrgPo = new SysOfflineOrgPo();
            sysOfflineOrgPo.setOfflineOrgCode(offlineOrgCode);
            sysOfflineOrgPo.setSysCompanyId(storePo.getSysCompanyId());
            log.info("\u7ebf\u4e0b\u7ec4\u7ec7\u8868\u63d2\u5165:{}", (Object)JSONObject.toJSONString((Object)sysOfflineOrgPo));
            ResponseData sysOfflineOrgServcieRpcResp = this.sysOfflineOrgServcieRpc.insert(sysOfflineOrgPo);
            if (sysOfflineOrgServcieRpcResp.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                log.info(String.format("\u7ebf\u4e0b\u7ec4\u7ec7\u8868\u63d2\u5165\u5931\u8d25,%s", sysOfflineOrgServcieRpcResp.getMessage()));
            }
        }
    }

    public String getConsumeId() {
        return this.consumeId;
    }

    public String setTopic() {
        return this.topic;
    }

    public String setTag() {
        return "*";
    }
}

