/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.rocketmq.messagelisterner;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.Message;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.facade.models.po.Cus361PrecinctAreaPO;
import com.bizvane.customized.facade.models.vo.Cus361PrecinctAreaVo;
import com.bizvane.customized.mappers.Cus361PrecinctAreaPOMapper;
import com.bizvane.customized.rocketmq.rocketutils.RocketMQConsumeInit;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class Cus361PrecinctAreaListener
extends RocketMQConsumeInit {
    private static final Logger log = LoggerFactory.getLogger(Cus361PrecinctAreaListener.class);
    @Value(value="${customizedmq.cus361precinctarea.consumeId}")
    private String consumeId;
    @Value(value="${customizedmq.cus361precinctarea.topic}")
    private String topic;
    @Autowired
    Cus361PrecinctAreaPOMapper cus361PrecinctAreaPOMapper;

    protected Action processMessage(Message message) {
        log.info("Cus361PrecinctAreaListener start ! !");
        String msg = new String(message.getBody());
        Cus361PrecinctAreaVo vo = (Cus361PrecinctAreaVo)JacksonUtil.json2Obj((String)msg, Cus361PrecinctAreaVo.class);
        log.info("Cus361PrecinctAreaListener enter processMessage param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        Cus361PrecinctAreaPO precinctAreaPO = this.cus361PrecinctAreaPOMapper.queryCus361PrecinctArea((Cus361PrecinctAreaPO)vo);
        Cus361PrecinctAreaPO newPrecinctAreaPo = new Cus361PrecinctAreaPO();
        if (null == precinctAreaPO) {
            newPrecinctAreaPo.setSysCompanyId(vo.getSysCompanyId());
            newPrecinctAreaPo.setAreaCode(vo.getAreaCode());
            newPrecinctAreaPo.setAreaInfo(vo.getAreaInfo());
            newPrecinctAreaPo.setCreateDate(new Date());
            newPrecinctAreaPo.setModifiedDate(new Date());
            newPrecinctAreaPo.setValid(Boolean.valueOf(true));
            try {
                this.cus361PrecinctAreaPOMapper.insertSelective(newPrecinctAreaPo);
            }
            catch (Exception e) {
                log.error("Cus361PrecinctAreaListener insertSelective error:{}, param:{}", (Object)e, (Object)JacksonUtil.bean2Json((Object)vo));
            }
        } else {
            precinctAreaPO.setAreaInfo(vo.getAreaInfo());
            precinctAreaPO.setModifiedDate(new Date());
            this.cus361PrecinctAreaPOMapper.updateCus361PrecinctArea(precinctAreaPO);
        }
        return Action.CommitMessage;
    }

    public String getConsumeId() {
        return this.consumeId;
    }

    public String setTopic() {
        return this.topic;
    }

    public String setTag() {
        return "*";
    }
}

