/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.rocketmq.messagelisterner;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.Message;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.facade.models.po.Cus361ChannelDataPO;
import com.bizvane.customized.facade.models.vo.Cus361ChannelDataVo;
import com.bizvane.customized.mappers.Cus361ChannelDataPOMapper;
import com.bizvane.customized.rocketmq.rocketutils.RocketMQConsumeInit;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class Cus361ChannelDataListener
extends RocketMQConsumeInit {
    private static final Logger log = LoggerFactory.getLogger(Cus361ChannelDataListener.class);
    @Value(value="${customizedmq.cus361channeldata.consumeId}")
    private String consumeId;
    @Value(value="${customizedmq.cus361channeldata.topic}")
    private String topic;
    @Autowired
    Cus361ChannelDataPOMapper cus361ChannelDataPOMapper;

    protected Action processMessage(Message message) {
        log.info("Cus361ChannelDataListener start ! !");
        String msg = new String(message.getBody());
        Cus361ChannelDataVo vo = (Cus361ChannelDataVo)JacksonUtil.json2Obj((String)msg, Cus361ChannelDataVo.class);
        log.info("Cus361ChannelDataListener enter processMessage param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        Cus361ChannelDataPO channelDataPo = this.cus361ChannelDataPOMapper.queryCus361ChannelData((Cus361ChannelDataPO)vo);
        Cus361ChannelDataPO newChannelDataPo = new Cus361ChannelDataPO();
        if (null == channelDataPo) {
            newChannelDataPo.setSysCompanyId(vo.getSysCompanyId());
            newChannelDataPo.setChannelName(vo.getChannelName());
            newChannelDataPo.setCorpCode(vo.getCorpCode());
            newChannelDataPo.setSapCustomerCode(vo.getSapCustomerCode());
            newChannelDataPo.setCreateDate(new Date());
            newChannelDataPo.setModifiedDate(new Date());
            newChannelDataPo.setValid(Boolean.valueOf(true));
            try {
                this.cus361ChannelDataPOMapper.insertSelective(newChannelDataPo);
            }
            catch (Exception e) {
                log.error("Cus361ChannelDataListener insertSelective error:{}, param:{}", (Object)e, (Object)JacksonUtil.bean2Json((Object)vo));
            }
        } else {
            channelDataPo.setChannelName(vo.getChannelName());
            channelDataPo.setModifiedDate(new Date());
            this.cus361ChannelDataPOMapper.updateCus361ChannelData(channelDataPo);
        }
        return Action.CommitMessage;
    }

    public String getConsumeId() {
        return this.consumeId;
    }

    public String setTopic() {
        return this.topic;
    }

    public String setTag() {
        return "*";
    }
}

