/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.zssj.service.impl;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.OssZssjALiYun;
import com.bizvane.customized.company.zssj.service.CusOrderZssjService;
import com.bizvane.customized.facade.models.vo.zssj.CusOrderZssjQualityReqVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CusOrderZssjServiceImpl
implements CusOrderZssjService {
    private static final Logger log = LoggerFactory.getLogger(CusOrderZssjServiceImpl.class);
    @Autowired
    private OssZssjALiYun ossZssjALiYun;
    private static OSS ossClient;

    public ResponseData<String> getOrderQualityImgUrl(CusOrderZssjQualityReqVo zssjQualityReqVo) {
        log.info("CusOrderZssjServiceImpl getOrderQualityImgUrl method zssjQualityReqVo:{}", (Object)JacksonUtil.bean2Json((Object)zssjQualityReqVo));
        if (this.ossZssjALiYun == null) {
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u8bf7\u6c42\u8bbf\u95ee");
        }
        try {
            this.initOssClient();
            String targetFilePathName = this.buildTargetFilePathName(zssjQualityReqVo);
            boolean foundFileFlag = ossClient.doesObjectExist(this.ossZssjALiYun.getBucketName(), targetFilePathName);
            if (!foundFileFlag) {
                log.info("\u8ba2\u5355\u53f7{},\u8d28\u4fdd\u5355\u6587\u4ef6\u4e0d\u5b58\u5728", (Object)zssjQualityReqVo.getOrderNo());
                return new ResponseData();
            }
            URL targetUrl = ossClient.generatePresignedUrl(this.ossZssjALiYun.getBucketName(), targetFilePathName, new Date(System.currentTimeMillis() + 300000L));
            log.info("\u8ba2\u5355\u53f7{},\u8d28\u4fdd\u5355\u6587\u4ef6\u5730\u5740\u4e3a:{}", (Object)zssjQualityReqVo.getOrderNo(), (Object)targetUrl);
            return new ResponseData((Object)targetUrl);
        }
        catch (Exception e) {
            log.error("\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return new ResponseData(SysResponseEnum.FAILED.getCode(), "\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    private String buildTargetFilePathName(CusOrderZssjQualityReqVo zssjQualityReqVo) {
        if (zssjQualityReqVo.getPlaceOrderTime() == null) {
            return zssjQualityReqVo.getMemberCardNo() + "/" + zssjQualityReqVo.getOrderNo() + ".png";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(zssjQualityReqVo.getPlaceOrderTime());
        return calendar.get(1) + "/" + (calendar.get(2) + 1) + "/" + zssjQualityReqVo.getOrderNo() + ".png";
    }

    private void initOssClient() {
        if (ossClient == null) {
            log.info("localOssClient\u521d\u59cb\u5316\u5f00\u59cb,ossZssjALiYun:{}", (Object)JacksonUtil.bean2Json((Object)this.ossZssjALiYun));
            ossClient = new OSSClientBuilder().build(this.ossZssjALiYun.getEndpoint(), this.ossZssjALiYun.getAccessKeyId(), this.ossZssjALiYun.getAccessKeySecret());
            log.info("localOssClient\u521d\u59cb\u5316\u6210\u529f");
        }
    }
}

