/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.yiwen.service.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.bizvane.baisonBase.facade.models.yw.YwRechargeCardInfoRequestVo;
import com.bizvane.baisonBase.facade.models.yw.YwRechargeCardInfoResponseVo;
import com.bizvane.baisonBase.facade.rpc.YwRechargeCardServiceRpc;
import com.bizvane.customized.facade.interfaces.CusYwRechargeServiceFeign;
import com.bizvane.customized.facade.models.po.CusYwQuickRechargePOExample;
import com.bizvane.customized.facade.models.po.CusYwRechargeCardStylePO;
import com.bizvane.customized.facade.models.po.CusYwRechargeCardStylePOExample;
import com.bizvane.customized.facade.models.po.CusYwRechargeExplainPo;
import com.bizvane.customized.facade.models.po.CusYwRechargeExplainPoExample;
import com.bizvane.customized.facade.models.po.CusYwRechargeRecordPo;
import com.bizvane.customized.facade.models.po.CusYwRechargeRulePO;
import com.bizvane.customized.facade.models.po.CusYwRechargeRulePOExample;
import com.bizvane.customized.facade.models.vo.yiwen.CusYwRechargeRuleVo;
import com.bizvane.customized.facade.models.vo.yiwen.RechargeCardYwQueryVo;
import com.bizvane.customized.facade.models.vo.yiwen.RechargeCardYwResponseVo;
import com.bizvane.customized.facade.models.vo.yiwen.YwRechargeQueryVo;
import com.bizvane.customized.facade.models.vo.yiwen.YwRechargeRecordVo;
import com.bizvane.customized.mappers.CusYwQuickRechargePOMapper;
import com.bizvane.customized.mappers.CusYwRechargeCardStylePOMapper;
import com.bizvane.customized.mappers.CusYwRechargeExplainPoMapper;
import com.bizvane.customized.mappers.CusYwRechargeRecordPoMapper;
import com.bizvane.customized.mappers.CusYwRechargeRulePOMapper;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CusYwRechargeServiceFeignImpl
implements CusYwRechargeServiceFeign {
    private static final Logger log = LoggerFactory.getLogger(CusYwRechargeServiceFeignImpl.class);
    @Autowired
    private CusYwRechargeCardStylePOMapper cusYwRechargeCardStylePOMapper;
    @Autowired
    private CusYwQuickRechargePOMapper cusYwQuickRechargePOMapper;
    @Autowired
    private CusYwRechargeRulePOMapper cusYwRechargeRulePOMapper;
    @Autowired
    private CusYwRechargeExplainPoMapper cusYwRechargeExplainPoMapper;
    @Autowired
    RocketMQTemplate rocketMQTemplate;
    @Autowired
    private YwRechargeCardServiceRpc ywRechargeCardServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private CusYwRechargeRecordPoMapper cusYwRechargeRecordPoMapper;

    public ResponseData<Double> judgeAndGetGiveAmount(YwRechargeQueryVo ywRechargeQueryVo) {
        CusYwRechargeExplainPo cusYwRechargeExplainPo;
        Integer customLimit;
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        Long sysBrandId = ywRechargeQueryVo.getSysBrandId();
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        Long cardType = ywRechargeQueryVo.getCardType();
        if (cardType == null) {
            responseData.setMessage("cardType\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        Double rechargeMoney = ywRechargeQueryVo.getRechargeMoney();
        if (rechargeMoney == null) {
            responseData.setMessage("rechargeMoney\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        CusYwRechargeExplainPoExample cusYwRechargeExplainPoExample = new CusYwRechargeExplainPoExample();
        cusYwRechargeExplainPoExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        List cusYwRechargeExplainPoList = this.cusYwRechargeExplainPoMapper.selectByExample(cusYwRechargeExplainPoExample);
        if (CollectionUtils.isNotEmpty((Collection)cusYwRechargeExplainPoList) && (customLimit = (cusYwRechargeExplainPo = (CusYwRechargeExplainPo)cusYwRechargeExplainPoList.get(0)).getCustomLimit()) == 2) {
            Double customStartMoney = cusYwRechargeExplainPo.getCustomStartMoney();
            Double customEndMoney = cusYwRechargeExplainPo.getCustomEndMoney();
            if (rechargeMoney < customStartMoney || rechargeMoney > customEndMoney) {
                responseData.setMessage("\u5145\u503c\u91d1\u989d\u4e0d\u5728\u4e0d\u5728\u9650\u5236\u8303\u56f4\u5185");
                responseData.setCode(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
                return responseData;
            }
        }
        CusYwRechargeRulePOExample cusYwRechargeRulePOExample = new CusYwRechargeRulePOExample();
        cusYwRechargeRulePOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        List cusYwRechargeRulePOList = this.cusYwRechargeRulePOMapper.selectByExample(cusYwRechargeRulePOExample);
        cusYwRechargeRulePOList.sort(Comparator.comparing(CusYwRechargeRulePO::getStartMoney));
        YwRechargeQueryVo queryVo = new YwRechargeQueryVo();
        cusYwRechargeRulePOList.stream().anyMatch(rechargeRulePO -> {
            if (rechargeMoney >= rechargeRulePO.getStartMoney() && rechargeMoney <= rechargeRulePO.getEndMoney()) {
                queryVo.setGiveMoney(Double.valueOf(rechargeMoney * (double)rechargeRulePO.getGiveProportion().intValue() / 100.0));
                return true;
            }
            return false;
        });
        responseData.setData((Object)queryVo.getGiveMoney());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData<CusYwRechargeRuleVo> getMbrRechargeRule(CusYwRechargeExplainPo po) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        Long sysBrandId = po.getSysBrandId();
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e3a\u7a7a!");
            return responseData;
        }
        Long cardType = po.getCardType();
        if (cardType == null) {
            responseData.setMessage("cardType\u4e3a\u7a7a!");
            return responseData;
        }
        CusYwRechargeExplainPoExample cusYwRechargeExplainPoExample = new CusYwRechargeExplainPoExample();
        cusYwRechargeExplainPoExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        List cusYwRechargeExplainPoList = this.cusYwRechargeExplainPoMapper.selectByExample(cusYwRechargeExplainPoExample);
        if (CollectionUtils.isEmpty((Collection)cusYwRechargeExplainPoList)) {
            log.info("\u54c1\u724c:{},\u4e0b\u6ca1\u6709\u5145\u503c\u8bbe\u7f6e");
            responseData.setMessage("\u8be5\u54c1\u724c\u6ca1\u6709\u5145\u503c\u8bbe\u7f6e");
            return responseData;
        }
        CusYwRechargeExplainPo cusYwRechargeExplainPo = (CusYwRechargeExplainPo)cusYwRechargeExplainPoList.get(0);
        CusYwRechargeRuleVo cusYwRechargeRuleVo = new CusYwRechargeRuleVo();
        cusYwRechargeRuleVo.setExplainContent(cusYwRechargeExplainPo.getExplainContent());
        cusYwRechargeRuleVo.setCustomLimit(cusYwRechargeExplainPo.getCustomLimit());
        cusYwRechargeRuleVo.setGiveSet(cusYwRechargeExplainPo.getGiveSet());
        cusYwRechargeRuleVo.setCustomStartMoney(cusYwRechargeExplainPo.getCustomStartMoney());
        cusYwRechargeRuleVo.setCustomEndMoney(cusYwRechargeExplainPo.getCustomEndMoney());
        CusYwRechargeRulePOExample cusYwRechargeRulePOExample = new CusYwRechargeRulePOExample();
        cusYwRechargeRulePOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        List cusYwRechargeRulePOList = this.cusYwRechargeRulePOMapper.selectByExample(cusYwRechargeRulePOExample);
        cusYwRechargeRuleVo.setRuleList(cusYwRechargeRulePOList);
        CusYwQuickRechargePOExample cusYwQuickRechargePOExample = new CusYwQuickRechargePOExample();
        cusYwQuickRechargePOExample.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        List cusYwQuickRechargePOList = this.cusYwQuickRechargePOMapper.selectByExample(cusYwQuickRechargePOExample);
        cusYwRechargeRuleVo.setQuickList(cusYwQuickRechargePOList);
        responseData.setData((Object)cusYwRechargeRuleVo);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData<PageInfo<YwRechargeCardInfoResponseVo>> getCardList(RechargeCardYwQueryVo rechargeCardYwQueryVo) {
        ResponseData responseData = new ResponseData();
        Long cardType = rechargeCardYwQueryVo.getCardType();
        Long sysBrandId = rechargeCardYwQueryVo.getSysBrandId();
        YwRechargeCardInfoRequestVo ywRechargeCardInfoRequestVo = new YwRechargeCardInfoRequestVo();
        if (cardType != null) {
            ywRechargeCardInfoRequestVo.setCategoryCode(String.valueOf(cardType));
        }
        ywRechargeCardInfoRequestVo.setPage(rechargeCardYwQueryVo.getPageNum());
        ywRechargeCardInfoRequestVo.setLimit(rechargeCardYwQueryVo.getPageSize());
        ywRechargeCardInfoRequestVo.setPhone(rechargeCardYwQueryVo.getPhone());
        ywRechargeCardInfoRequestVo.setBindStatus(Integer.valueOf(1));
        ywRechargeCardInfoRequestVo.setStatus(Integer.valueOf(-1));
        log.info("\u8c03\u7528\u7ebf\u4e0b\u5361\u5217\u63a5\u53e3\u5165\u53c2::{}", (Object)JSON.toJSONString((Object)ywRechargeCardInfoRequestVo));
        ResponseData storedCardList = this.ywRechargeCardServiceRpc.getStoredCardList(ywRechargeCardInfoRequestVo);
        if (storedCardList.getCode() != SysResponseEnum.SUCCESS.getCode()) {
            log.info("\u8c03\u7528\u7ebf\u4e0b\u5361\u5217\u63a5\u53e3\u5931\u8d25:{}", (Object)storedCardList.getMessage());
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8c03\u7528\u7ebf\u4e0b\u63a5\u53e3\u5931\u8d25");
            return responseData;
        }
        if (CollectionUtils.isEmpty((Collection)((PageInfo)storedCardList.getData()).getList())) {
            log.info("\u7ebf\u4e0b\u50a8\u503c\u5361\u4e0d\u5b58\u5728:{}", (Object)rechargeCardYwQueryVo.getPhone());
            responseData.setCode(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getCode());
            responseData.setMessage("\u7ebf\u4e0b\u50a8\u503c\u5361\u4e0d\u5b58\u5728");
            return responseData;
        }
        log.info("\u8c03\u7528\u7ebf\u4e0b\u5361\u5217\u8868\u63a5\u53e3\u8fd4\u56de:{}", (Object)JSON.toJSONString((Object)storedCardList));
        CusYwRechargeCardStylePOExample example = new CusYwRechargeCardStylePOExample();
        if (cardType != null) {
            example.createCriteria().andSysBrandIdEqualTo(sysBrandId).andCardTypeEqualTo(cardType).andValidEqualTo(Boolean.TRUE);
        }
        List cardStylePOList = this.cusYwRechargeCardStylePOMapper.selectByExample(example);
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setBrandId(sysBrandId);
        memberInfoModel.setPhone(rechargeCardYwQueryVo.getPhone());
        ResponseData memberInfoModelResponseData = this.memberInfoApiService.getMemberModel(memberInfoModel);
        if (memberInfoModelResponseData == null || memberInfoModelResponseData.getData() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
            return responseData;
        }
        memberInfoModel = (MemberInfoModel)memberInfoModelResponseData.getData();
        YwRechargeRecordVo ywRechargeRecordVo = new YwRechargeRecordVo();
        ywRechargeRecordVo.setSysBrandId(sysBrandId);
        ywRechargeRecordVo.setCardType(cardType);
        ywRechargeRecordVo.setCardNo(memberInfoModel.getCardNo());
        CusYwRechargeRecordPo historyMaxRechargeLevelRule = this.cusYwRechargeRecordPoMapper.queryHistoryMaxRechargeLevelRule(ywRechargeRecordVo);
        CusYwRechargeRulePO cusYwRechargeRulePO = null;
        if (historyMaxRechargeLevelRule != null) {
            cusYwRechargeRulePO = this.cusYwRechargeRulePOMapper.selectByPrimaryKey(historyMaxRechargeLevelRule.getCusYiwenMbrRechargeRuleId());
        }
        CusYwRechargeRulePO rechargeRulePO = cusYwRechargeRulePO;
        PageInfo page = null;
        List list = null;
        if (storedCardList.getCode() == SysResponseEnum.SUCCESS.getCode() && storedCardList.getData() != null) {
            page = (PageInfo)storedCardList.getData();
            list = page.getList();
            list = list.stream().map(ywRechargeCardInfoResponseVo -> {
                if (rechargeRulePO != null && rechargeRulePO.getValid().booleanValue()) {
                    ywRechargeCardInfoResponseVo.setStyleUrl(rechargeRulePO.getLevelImg());
                    ywRechargeCardInfoResponseVo.setCategoryName(rechargeRulePO.getLevelName());
                } else if (CollectionUtils.isNotEmpty((Collection)cardStylePOList)) {
                    ywRechargeCardInfoResponseVo.setStyleUrl(((CusYwRechargeCardStylePO)cardStylePOList.get(0)).getStyleUrl());
                    ywRechargeCardInfoResponseVo.setCategoryName(null);
                }
                log.info("ywRechargeCardInfoResponseVo:{}", (Object)JSON.toJSONString((Object)ywRechargeCardInfoResponseVo));
                return ywRechargeCardInfoResponseVo;
            }).collect(Collectors.toList());
        }
        page.setList(list);
        log.info("list:{}", (Object)JSON.toJSONString(list));
        responseData.setData((Object)page);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<RechargeCardYwResponseVo> getCardInfo(RechargeCardYwQueryVo rechargeCardYwQueryVo) {
        return null;
    }

    public ResponseData<String> sendMq(YwRechargeRecordVo vo) {
        String cardNo;
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        Long sysBrandId = vo.getSysBrandId();
        if (sysBrandId == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)(cardNo = vo.getCardNo()))) {
            responseData.setMessage("\u4f1a\u5458\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        Double rechargeMoney = vo.getRechargeMoney();
        if (rechargeMoney == null) {
            responseData.setMessage("\u5145\u503c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        Long cardType = vo.getCardType();
        if (cardType == null) {
            responseData.setMessage("\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("public_yiwen_recharge_record").build(), (Object)JSON.toJSONString((Object)vo));
        String messageId = sendResult.getMsgId();
        responseData.setData((Object)messageId);
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        log.info("RechargeServiceImpl sendMq \u6d88\u606f\u53d1\u9001\u5b8c\u6210mq\u8fd4\u56de\u7684msgId:{},", (Object)messageId, (Object)sendResult);
        return responseData;
    }
}

