/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.notice;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.facade.interfaces.URNoticeServiceFeign;
import com.bizvane.customized.facade.models.po.CusUrRechargeCardPO;
import com.bizvane.customized.facade.models.po.CusUrRechargeCardRecordPO;
import com.bizvane.customized.facade.models.vo.ur.notice.NoticeMemberLevelChangeReqVo;
import com.bizvane.customized.facade.models.vo.ur.notice.NoticeRechargeCardChangeReqVo;
import com.bizvane.customized.facade.models.vo.ur.notice.NoticeRechargeCardChangeRspVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ur/notice"})
public class URNoticeService
implements URNoticeServiceFeign {
    private static final Logger log = LoggerFactory.getLogger(URNoticeService.class);
    private static final String RECHARGE_CARD_CHANGE_REMIND = "/v1/rechargeCard/change/remind";
    private static final String MEMINFO_CHANGE_REMIND = "/v1/memInfo/change/remind";
    private static final String HEADER_APP_KEY = "appkey";
    @Value(value="${ur.serverUrl}")
    private String UR_SERVER_URL;
    @Value(value="${ur.appKey}")
    private String APP_KEY;
    @Resource
    private MemberInfoApiService memberInfoApiService;

    public ResponseData<NoticeRechargeCardChangeRspVo> noticeRechargeCardChange(CusUrRechargeCardPO cardPO, CusUrRechargeCardRecordPO rechargeCardRecordPO, BigDecimal amount, BigDecimal giveAmount) {
        log.info("URNoticeService-noticeRechargeCardChange,cardPO={},rechargeCardRecordPO={},amount={},giveAmount={}", new Object[]{JSON.toJSONString((Object)cardPO), JSON.toJSONString((Object)rechargeCardRecordPO), amount, giveAmount});
        ResponseData responseData = new ResponseData();
        if (null == cardPO || null == rechargeCardRecordPO) {
            responseData.setCode(-1);
            responseData.setMessage("\u5fc5\u586b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        try {
            Date recordTime = rechargeCardRecordPO.getCreateDate();
            Integer type = rechargeCardRecordPO.getType();
            NoticeRechargeCardChangeReqVo reqVo = new NoticeRechargeCardChangeReqVo();
            reqVo.setAugmentFlowNumber(rechargeCardRecordPO.getRecordNo());
            reqVo.setAugmentTime(null != recordTime ? DateUtil.format((Date)recordTime, (String)"yyyy-MM-dd HH:mm:ss") : null);
            reqVo.setBrandId(String.valueOf(cardPO.getSysBrandId()));
            reqVo.setCardCode(cardPO.getCardNo());
            MemberInfoModel memberInfoModel = new MemberInfoModel();
            memberInfoModel.setBrandId(cardPO.getSysBrandId());
            memberInfoModel.setMemberCode(cardPO.getMemberCode());
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(memberInfoModel);
            if (null != singleMemberModel && null != singleMemberModel.getData() && singleMemberModel.getCode() == 0) {
                MemberInfoModel memberModelData = (MemberInfoModel)singleMemberModel.getData();
                reqVo.setMemCode(memberModelData.getCardNo());
            }
            if (null == amount) {
                amount = BigDecimal.ZERO;
            }
            if (null == giveAmount) {
                giveAmount = BigDecimal.ZERO;
            }
            reqVo.setAugmentAmount(giveAmount.add(amount));
            reqVo.setGiftAugmentAmount(giveAmount);
            reqVo.setPrincipalAugmentAmount(amount);
            Integer changeType = null;
            if (Objects.equals(type, 1) || Objects.equals(type, 2)) {
                reqVo.setRechargeGiftBalance(cardPO.getGiveBalanceTotal().add(giveAmount));
                reqVo.setRechargePrincipalBalance(cardPO.getRechargeBalanceTotal().add(amount));
                reqVo.setRechargeBalance(reqVo.getRechargeGiftBalance().add(reqVo.getRechargePrincipalBalance()));
                if (Objects.equals(type, 1)) {
                    changeType = 3;
                }
                if (Objects.equals(type, 2)) {
                    changeType = 1;
                }
            } else if (Objects.equals(type, 4) || Objects.equals(type, 3)) {
                reqVo.setRechargeGiftBalance(cardPO.getGiveBalanceTotal().subtract(giveAmount));
                reqVo.setRechargePrincipalBalance(cardPO.getRechargeBalanceTotal().subtract(amount));
                reqVo.setRechargeBalance(reqVo.getRechargeGiftBalance().add(reqVo.getRechargePrincipalBalance()));
                if (Objects.equals(type, 3)) {
                    changeType = 3;
                    if (rechargeCardRecordPO.getSurplusAmount().compareTo(BigDecimal.ZERO) == 0 && rechargeCardRecordPO.getSurplusGiveAmount().compareTo(BigDecimal.ZERO) == 0) {
                        changeType = 4;
                    }
                }
                if (Objects.equals(type, 4)) {
                    changeType = 2;
                }
            } else {
                responseData.setCode(-1);
                responseData.setMessage("\u7c7b\u578b\u4e0d\u5339\u914d");
                return responseData;
            }
            reqVo.setChangeType(changeType);
            reqVo.setTenantId(Integer.valueOf(0));
            log.info("URNoticeService-noticeRechargeCardChange,repVO={}", (Object)JSON.toJSONString((Object)reqVo));
            long start = System.currentTimeMillis();
            String url = this.UR_SERVER_URL + RECHARGE_CARD_CHANGE_REMIND;
            HttpRequest httpRequest = ((HttpRequest)HttpRequest.post((String)url).header(HEADER_APP_KEY, this.APP_KEY)).body(JacksonUtil.bean2Json((Object)reqVo));
            log.info("URNoticeService-noticeRechargeCardChange-\u8c03\u7528UR\u63a5\u53e3\u5f00\u59cb,url={},body={}", (Object)url, (Object)JacksonUtil.bean2Json((Object)reqVo));
            String result = httpRequest.execute().body();
            log.info("URNoticeService-noticeRechargeCardChange-\u8c03\u7528UR\u63a5\u53e3\u7ed3\u675f,url={},body={},consumeTime={},response={}", new Object[]{url, JacksonUtil.bean2Json((Object)reqVo), System.currentTimeMillis() - start, result});
            NoticeRechargeCardChangeRspVo rspVo = null;
            if (StrUtil.isNotBlank((CharSequence)result)) {
                rspVo = (NoticeRechargeCardChangeRspVo)JSON.parseObject((String)result, NoticeRechargeCardChangeRspVo.class);
            }
            if (null == rspVo || !Objects.equals("0", rspVo.getResultStatus())) {
                responseData.setCode(-1);
                responseData.setMessage("\u50a8\u503c\u5361\u5145\u503c\u53d8\u52a8\u901a\u77e5UR\u5931\u8d25");
                return responseData;
            }
            responseData.setData((Object)rspVo);
        }
        catch (Exception e) {
            log.error("URNoticeService-noticeRechargeCardChange-\u8c03\u7528UR\u63a5\u53e3\u53d1\u751f\u5f02\u5e38,cardPO={},exception={}", (Object)JacksonUtil.bean2Json((Object)cardPO), (Object)ExceptionUtil.getMessage((Throwable)e));
            log.error("URNoticeService-noticeRechargeCardChange-\u8c03\u7528UR\u63a5\u53e3\u53d1\u751f\u5f02\u5e38,exception=", (Throwable)e);
            responseData.setCode(-1);
            responseData.setMessage(e.getMessage());
        }
        return responseData;
    }

    public ResponseData<NoticeRechargeCardChangeRspVo> noticeMemberLevelChange(NoticeMemberLevelChangeReqVo reqVo) {
        log.info("URNoticeService-noticeMemberLevelChange,reqVo={}", (Object)JSON.toJSONString((Object)reqVo));
        ResponseData responseData = new ResponseData();
        if (null == reqVo || StrUtil.isBlank((CharSequence)reqVo.getCardCode())) {
            responseData.setCode(-1);
            responseData.setMessage("\u4f1a\u5458\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return responseData;
        }
        try {
            log.info("URNoticeService-noticeMemberLevelChange,repVO={}", (Object)JSON.toJSONString((Object)reqVo));
            long start = System.currentTimeMillis();
            String url = this.UR_SERVER_URL + MEMINFO_CHANGE_REMIND;
            HttpRequest httpRequest = ((HttpRequest)HttpRequest.post((String)url).header(HEADER_APP_KEY, this.APP_KEY)).body(JacksonUtil.bean2Json((Object)reqVo));
            log.info("URNoticeService-noticeMemberLevelChange-\u8c03\u7528UR\u63a5\u53e3\u5f00\u59cb,url={},body={}", (Object)url, (Object)JacksonUtil.bean2Json((Object)reqVo));
            String result = httpRequest.execute().body();
            log.info("URNoticeService-noticeMemberLevelChange-\u8c03\u7528UR\u63a5\u53e3\u7ed3\u675f,url={},body={},consumeTime={},response={}", new Object[]{url, JacksonUtil.bean2Json((Object)reqVo), System.currentTimeMillis() - start, result});
            NoticeRechargeCardChangeRspVo rspVo = null;
            if (StrUtil.isNotBlank((CharSequence)result)) {
                rspVo = (NoticeRechargeCardChangeRspVo)JSON.parseObject((String)result, NoticeRechargeCardChangeRspVo.class);
            }
            if (null == rspVo || !Objects.equals("0", rspVo.getResultStatus())) {
                responseData.setCode(-1);
                responseData.setMessage("\u4f1a\u5458\u4fe1\u606f\u53d8\u52a8\u901a\u77e5UR\u5931\u8d25");
                return responseData;
            }
            responseData.setData((Object)rspVo);
        }
        catch (Exception e) {
            log.error("URNoticeService-noticeMemberLevelChange-\u8c03\u7528UR\u63a5\u53e3\u53d1\u751f\u5f02\u5e38,reqVo={},exception={}", (Object)JSON.toJSONString((Object)reqVo), (Object)ExceptionUtil.getMessage((Throwable)e));
            log.error("URNoticeService-noticeMemberLevelChange-\u8c03\u7528UR\u63a5\u53e3\u53d1\u751f\u5f02\u5e38,exception=", (Throwable)e);
            responseData.setCode(-1);
            responseData.setMessage(e.getMessage());
        }
        return responseData;
    }

    public ResponseData<NoticeRechargeCardChangeRspVo> memberLevelChange(NoticeMemberLevelChangeReqVo reqVo) {
        return this.noticeMemberLevelChange(reqVo);
    }
}

