/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.service.impl;

import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.StorageCardListRequestVO;
import com.bizvane.connectorservice.entity.common.StorageCardRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.ConnectorServiceFeign;
import com.bizvane.couponfacade.interfaces.UtilsServiceFeign;
import com.bizvane.customized.common.utils.Assert;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.common.utils.UUIDGenerator;
import com.bizvane.customized.company.ur.members.models.storage.dto.ConsumeStorageDto;
import com.bizvane.customized.company.ur.members.models.storage.dto.SendStorageDTO;
import com.bizvane.customized.company.ur.members.models.storage.vo.StorageRecordVo;
import com.bizvane.customized.company.ur.members.service.StorageOpsService;
import com.bizvane.customized.facade.enums.StorageCardDonate.StorageCardDonateFromStatusEnum;
import com.bizvane.customized.facade.enums.StorageCardDonate.StorageCardDonateOverStatusEnum;
import com.bizvane.customized.facade.enums.StorageCardDonate.StorageCardDonateToStatusEnum;
import com.bizvane.customized.facade.enums.StorageOpsTypeEnum;
import com.bizvane.customized.facade.exception.CustomizedException;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardDonate;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardDonateExample;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardPO;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardPOExample;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardRecordPO;
import com.bizvane.customized.facade.models.vo.CusUrStorageCardReceivedVO;
import com.bizvane.customized.mappers.CusUrMbrStorageCardDonateMapper;
import com.bizvane.customized.mappers.CusUrMbrStorageCardPOMapper;
import com.bizvane.customized.mappers.CusUrMbrStorageCardRecordPOMapper;
import com.bizvane.members.facade.service.ur.UrMemberApiService;
import com.bizvane.members.facade.ur.vo.MemberRequestCardNoVo;
import com.bizvane.members.facade.ur.vo.MemberResponseCardNoVo;
import com.bizvane.members.facade.ur.vo.MembersEsRequestVo;
import com.bizvane.members.facade.ur.vo.MembersEsResponseVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StorageOpsServiceImpl
implements StorageOpsService {
    private static final Logger log = LoggerFactory.getLogger(StorageOpsServiceImpl.class);
    @Autowired
    private CusUrMbrStorageCardPOMapper cusUrMbrStorageCardPOMapper;
    @Autowired
    private CusUrMbrStorageCardRecordPOMapper cusUrMbrStorageCardRecordPOMapper;
    @Autowired
    private UrMemberApiService urMemberApiService;
    @Autowired
    private UtilsServiceFeign utilsServiceFeign;
    @Autowired
    private CusUrMbrStorageCardDonateMapper cusUrMbrStorageCardDonateMapper;
    @Autowired
    private ConnectorServiceFeign connectorServiceFeign;

    public ResponseData<String> addStorageOps(StorageRecordVo vo) {
        CusUrMbrStorageCardPO storageCardPO = CusUrMbrStorageCardPO.builder().memberCode(vo.getMemberCode()).storageCardNo(vo.getStorageCardNum()).brandId(vo.getBrandId()).sysCompanyId(vo.getSysCompanyId()).createUserId(vo.getCreateUserId()).createUserName(vo.getCreateUserName()).createDate(new Date()).vipCardNo(vo.getVipCardNum()).balance(vo.getBalance()).password(vo.getPassword()).build();
        ResponseData storageCardNumBarCode = this.utilsServiceFeign.getBarcode(storageCardPO.getStorageCardNo());
        ResponseData passwordBarCode = this.utilsServiceFeign.getBarcode(storageCardPO.getPassword());
        storageCardPO.setCardNoBarCode((String)storageCardNumBarCode.getData());
        storageCardPO.setPasswordBarCode((String)passwordBarCode.getData());
        this.cusUrMbrStorageCardPOMapper.insertSelective(storageCardPO);
        if (!"3".equals(vo.getRemark())) {
            String uuid = UUIDGenerator.get20UUID();
            CusUrMbrStorageCardRecordPO recordPO = CusUrMbrStorageCardRecordPO.builder().sysCompanyId(vo.getSysCompanyId()).mbrName(vo.getVipName()).brandId(vo.getBrandId()).memberCode(vo.getMemberCode()).opsName(vo.getCreateUserName()).mbrCardNo(vo.getVipCardNum()).vipCardNo(vo.getVipCardNum()).storageCardNo(vo.getStorageCardNum()).opType(Integer.valueOf(StorageOpsTypeEnum.ADD.getCode())).balance(vo.getBalance()).mbrPhone(vo.getPhone()).createDate(new Date()).remark("\u64cd\u4f5c\u4eba\uff1a" + vo.getCreateUserName()).billNo(uuid).targetName("-").overage(vo.getBalance()).build();
            this.cusUrMbrStorageCardRecordPOMapper.insertSelective(recordPO);
            StorageCardRequestVO cardRequestVO = new StorageCardRequestVO();
            cardRequestVO.setBrandId(vo.getBrandId());
            cardRequestVO.setCardCode(vo.getVipCardNum());
            cardRequestVO.setStoredCardNo(vo.getStorageCardNum());
            cardRequestVO.setUpdateBalance(vo.getBalance());
            cardRequestVO.setCreater(vo.getCreateUserName());
            cardRequestVO.setVipName(vo.getVipName());
            cardRequestVO.setPhone(vo.getPhone());
            cardRequestVO.setType("1");
            cardRequestVO.setBalance(vo.getBalance());
            cardRequestVO.setDocumentNo(uuid);
            cardRequestVO.setCorpCode(vo.getSysCompanyId().toString());
            StorageCardListRequestVO requestVO = new StorageCardListRequestVO();
            ArrayList<StorageCardRequestVO> storageCardRequestVOS = new ArrayList<StorageCardRequestVO>();
            storageCardRequestVOS.add(cardRequestVO);
            requestVO.setList(storageCardRequestVOS);
            requestVO.setBrandId(vo.getBrandId());
            Result result = this.connectorServiceFeign.batchSaveStorageCard(requestVO);
            if (result.getCode() != 0) {
                log.info("\u50a8\u503c\u5361\u65b0\u589e\u540c\u6b65\u7ebf\u4e0b\u5931\u8d25");
            }
        }
        return ResponseDataUtil.getSuccessData((Object)"success");
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ResponseData<String> updateStorageOps(CusUrMbrStorageCardPO cusUrMbrStorageCardPO) {
        int count = this.cusUrMbrStorageCardPOMapper.updateBalanceByStorageCardNo(cusUrMbrStorageCardPO);
        if (count == 0) {
            return ResponseDataUtil.getFailedData(null, (String)"\u8bf7\u8f93\u5165\u6b63\u786e\u5361\u53f7\u6216\u91d1\u989d");
        }
        CusUrMbrStorageCardPOExample cusUrMbrStorageCardPOExample = new CusUrMbrStorageCardPOExample();
        CusUrMbrStorageCardPOExample.Criteria criteria = cusUrMbrStorageCardPOExample.createCriteria();
        criteria.andStorageCardNoEqualTo(cusUrMbrStorageCardPO.getStorageCardNo());
        List cusUrMbrStorageCardPOS = this.cusUrMbrStorageCardPOMapper.selectByExample(cusUrMbrStorageCardPOExample);
        MemberRequestCardNoVo memberRequestCardNoVo = new MemberRequestCardNoVo();
        memberRequestCardNoVo.setSysCompanyId(cusUrMbrStorageCardPO.getSysCompanyId());
        memberRequestCardNoVo.setBrandId(cusUrMbrStorageCardPO.getBrandId());
        memberRequestCardNoVo.setCardNo(((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getVipCardNo());
        memberRequestCardNoVo.setWxMembers(Boolean.valueOf(true));
        ResponseData membersInfoByCardNoRes = this.urMemberApiService.getMembersInfoByCardNo(memberRequestCardNoVo);
        if (membersInfoByCardNoRes.getCode() == SysResponseEnum.FAILED.getCode() || membersInfoByCardNoRes.getData() == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u8be5\u5361\u53f7\u6301\u6709\u8005\u4e0d\u662f\u4f1a\u5458");
        }
        String uuid = UUIDGenerator.get20UUID();
        CusUrMbrStorageCardRecordPO cusUrMbrStorageCardRecordPO = CusUrMbrStorageCardRecordPO.builder().sysCompanyId(cusUrMbrStorageCardPO.getSysCompanyId()).brandId(cusUrMbrStorageCardPO.getBrandId()).opsName(cusUrMbrStorageCardPO.getCreateUserName()).mbrCardNo(((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getVipCardNo()).balance(cusUrMbrStorageCardPO.getBalance()).storageCardNo(cusUrMbrStorageCardPO.getStorageCardNo()).createDate(new Date()).opType(Integer.valueOf(StorageOpsTypeEnum.EDIT.getCode())).billNo(uuid).overage(((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getBalance()).targetName("-").mbrName(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getName()).mbrPhone(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getPhone()).memberCode(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getMemberCode()).remark("\u64cd\u4f5c\u4eba\uff1a" + cusUrMbrStorageCardPO.getCreateUserName()).build();
        this.cusUrMbrStorageCardRecordPOMapper.insertSelective(cusUrMbrStorageCardRecordPO);
        StorageCardRequestVO cardRequestVO = new StorageCardRequestVO();
        cardRequestVO.setBrandId(cusUrMbrStorageCardPO.getBrandId());
        cardRequestVO.setCardCode(cusUrMbrStorageCardPO.getVipCardNo());
        cardRequestVO.setStoredCardNo(cusUrMbrStorageCardPO.getStorageCardNo());
        cardRequestVO.setUpdateBalance(cusUrMbrStorageCardPO.getBalance());
        cardRequestVO.setCreater(cusUrMbrStorageCardPO.getCreateUserName());
        cardRequestVO.setVipName(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getName());
        cardRequestVO.setPhone(((MemberResponseCardNoVo)membersInfoByCardNoRes.getData()).getPhone());
        cardRequestVO.setBalance(((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getBalance());
        cardRequestVO.setType("2");
        cardRequestVO.setDocumentNo(uuid);
        cardRequestVO.setCorpCode(cusUrMbrStorageCardPO.getSysCompanyId().toString());
        StorageCardListRequestVO requestVO = new StorageCardListRequestVO();
        ArrayList<StorageCardRequestVO> storageCardRequestVOS = new ArrayList<StorageCardRequestVO>();
        storageCardRequestVOS.add(cardRequestVO);
        requestVO.setList(storageCardRequestVOS);
        requestVO.setBrandId(cusUrMbrStorageCardPO.getBrandId());
        log.info("\u6d41\u6c34\u5199\u7ebf\u4e0bbatchSaveStorageCard param:{}", (Object)requestVO);
        Result result = this.connectorServiceFeign.batchSaveStorageCard(requestVO);
        if (result.getCode() != 0) {
            log.info("\u50a8\u503c\u5361\u5145\u503c\u540c\u6b65\u7ebf\u4e0b\u5931\u8d25");
        }
        log.info("\u6d41\u6c34\u5199\u7ebf\u4e0bbatchSaveStorageCard \u51fa\u53c2:{}", (Object)result);
        return ResponseDataUtil.getSuccessData((Object)"success");
    }

    @Transactional
    public void sendStorageOps(SendStorageDTO so) {
        CusUrMbrStorageCardRecordPO cusUrMbrStorageCardRecordPO = CusUrMbrStorageCardRecordPO.builder().sysCompanyId(so.getSysCompanyId()).brandId(so.getBrandId()).memberCode(so.getFromMemberCode()).vipName(so.getFromVipName()).vipCardNo(so.getFromVipCardNo()).phone(so.getFromPhone()).balance(so.getBalance().negate()).opType(Integer.valueOf(StorageOpsTypeEnum.SEND.getCode())).targetName(so.getToTargetName()).opsName(so.getFromVipName()).billNo(so.getBillNo()).overage(so.getOldBalance().subtract(so.getBalance())).createDate(new Date()).valid(Boolean.valueOf(true)).version(Integer.valueOf(1)).storageCardNo(so.getFromStorageCardNo()).mbrName(so.getFromVipName()).mbrCardNo(so.getFromVipCardNo()).mbrPhone(so.getFromPhone()).orderNo("-").remark(so.getFromVipName() + "\u8f6c\u8d60" + so.getToTargetName()).build();
        this.cusUrMbrStorageCardRecordPOMapper.insert(cusUrMbrStorageCardRecordPO);
        CusUrMbrStorageCardDonate cusUrMbrStorageCardDonate = CusUrMbrStorageCardDonate.builder().sysCompanyId(so.getSysCompanyId()).brandId(so.getBrandId()).fromMemberCode(so.getFromMemberCode()).fromVipName(so.getFromVipName()).fromPhone(so.getFromPhone()).fromVipCardNo(so.getFromVipCardNo()).fromStatus(Integer.valueOf(StorageCardDonateFromStatusEnum.SED.getState())).toTargetName(so.getToTargetName()).toTargetMemberCode(so.getToTargetMemberCode()).toStatus(Integer.valueOf(StorageCardDonateToStatusEnum.PENDING_RECEPTION.getState())).balance(so.getBalance()).overStatus(Integer.valueOf(StorageCardDonateOverStatusEnum.UNDONE.getState())).createDate(new Date()).valid(Boolean.valueOf(true)).build();
        this.cusUrMbrStorageCardDonateMapper.insert(cusUrMbrStorageCardDonate);
        int count = this.cusUrMbrStorageCardPOMapper.deBalanceByMemberCode(so.getBalance(), so.getFromMemberCode());
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u8f6c\u589e\u5931\u8d25\uff0c\u60a8\u7684\u50a8\u503c\u5361\u4f59\u989d\u4e0d\u8db3");
    }

    @Transactional
    public ResponseData<String> batchReceivedStorageOps(CusUrStorageCardReceivedVO vo, List<CusUrMbrStorageCardDonate> cusUrMbrStorageCardDonates, BigDecimal oldBlance, String storageCarNo, MembersEsResponseVo membersEsResponseVo) {
        BigDecimal balances = new BigDecimal(0);
        ArrayList<Long> ids = new ArrayList<Long>(cusUrMbrStorageCardDonates.size());
        ArrayList<CusUrMbrStorageCardRecordPO> recordPOS = new ArrayList<CusUrMbrStorageCardRecordPO>(cusUrMbrStorageCardDonates.size());
        ArrayList<StorageCardRequestVO> storageCardRequestVOList = new ArrayList<StorageCardRequestVO>(cusUrMbrStorageCardDonates.size());
        for (CusUrMbrStorageCardDonate donate : cusUrMbrStorageCardDonates) {
            BigDecimal singleBalance = donate.getBalance();
            balances = balances.add(singleBalance);
            oldBlance = oldBlance.add(singleBalance);
            ids.add(donate.getMbrStorageDonate());
            String billNo = UUIDGenerator.get20UUID();
            recordPOS.add(CusUrMbrStorageCardRecordPO.builder().sysCompanyId(vo.getSysCompanyId()).brandId(vo.getBrandId()).memberCode(donate.getFromMemberCode()).vipName(donate.getFromVipName()).vipCardNo(donate.getFromVipCardNo()).phone(donate.getFromPhone()).balance(singleBalance).opType(Integer.valueOf(StorageOpsTypeEnum.RECEIVE.getCode())).billNo(billNo).targetName(donate.getToTargetName()).opsName(donate.getToTargetName()).overage(oldBlance).valid(Boolean.valueOf(true)).version(Integer.valueOf(1)).mbrName(donate.getToTargetName()).mbrCardNo(vo.getVipCardNo()).mbrPhone(membersEsResponseVo.getPhone()).storageCardNo(storageCarNo).orderNo("-").remark(donate.getFromVipName() + "\u8f6c\u8d60" + donate.getToTargetName()).build());
            StorageCardRequestVO storageCardRequestVO = new StorageCardRequestVO();
            storageCardRequestVO.setCardCode(vo.getVipCardNo());
            storageCardRequestVO.setVipName(donate.getToTargetName());
            storageCardRequestVO.setSex(membersEsResponseVo.getGender());
            storageCardRequestVO.setPhone(membersEsResponseVo.getPhone());
            storageCardRequestVO.setUpdateBalance(singleBalance);
            storageCardRequestVO.setBalance(oldBlance);
            storageCardRequestVO.setStoredCardNo(storageCarNo);
            storageCardRequestVO.setCreater(donate.getToTargetName());
            storageCardRequestVO.setTransferPerson(donate.getFromVipName());
            storageCardRequestVO.setDonee(donate.getToTargetName());
            storageCardRequestVO.setType(String.valueOf(StorageOpsTypeEnum.RECEIVE.getCode()));
            storageCardRequestVO.setDocumentNo(billNo);
            storageCardRequestVO.setCorpCode(String.valueOf(vo.getSysCompanyId()));
            storageCardRequestVOList.add(storageCardRequestVO);
        }
        int count = this.cusUrMbrStorageCardPOMapper.addBalanceByMemberCode(balances, vo.getMemberCode());
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u589e\u52a0\u53d7\u8d60\u4eba\u50a8\u503c\u5361\u4f59\u989d\u9519\u8bef");
        count = this.cusUrMbrStorageCardDonateMapper.updateByPrimaryKeyList(ids);
        Assert.isTrue((count == ids.size() ? 1 : 0) != 0, (String)"\u66f4\u65b0\u50a8\u503c\u4f59\u989d\u4e2d\u95f4\u8868\u8bb0\u5f55\u9519\u8bef");
        this.cusUrMbrStorageCardRecordPOMapper.insertBatch(recordPOS);
        StorageCardListRequestVO requestVO = new StorageCardListRequestVO();
        requestVO.setBrandId(vo.getBrandId());
        requestVO.setList(storageCardRequestVOList);
        Result result = this.connectorServiceFeign.batchSaveStorageCard(requestVO);
        log.info("StorageOpsServiceImpl batchReceivedStorageOps batchSaveStorageCard result code : {}, message : {}, data : {}", new Object[]{result.getCode(), result.getMessage(), result.getData()});
        return new ResponseData((Object)String.valueOf(balances.doubleValue()));
    }

    @Transactional
    public void singleReceived(CusUrMbrStorageCardDonate donate) {
        CusUrMbrStorageCardDonateExample singleExample = new CusUrMbrStorageCardDonateExample();
        singleExample.createCriteria().andMbrStorageDonateEqualTo(donate.getMbrStorageDonate()).andFromStatusEqualTo(Integer.valueOf(StorageCardDonateFromStatusEnum.SED.getState())).andToStatusEqualTo(Integer.valueOf(StorageCardDonateToStatusEnum.PENDING_RECEPTION.getState())).andOverStatusEqualTo(Integer.valueOf(StorageCardDonateOverStatusEnum.UNDONE.getState()));
        CusUrMbrStorageCardDonate updateDonate = CusUrMbrStorageCardDonate.builder().fromStatus(Integer.valueOf(StorageCardDonateFromStatusEnum.BAK.getState())).toStatus(Integer.valueOf(StorageCardDonateToStatusEnum.REFUNDED.getState())).overStatus(Integer.valueOf(StorageCardDonateOverStatusEnum.REFUNDED.getState())).modifiedDate(new Date()).build();
        int count = this.cusUrMbrStorageCardDonateMapper.updateByExampleSelective(updateDonate, singleExample);
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u4fee\u6539\u8f85\u52a9\u4e2d\u95f4\u8868\u72b6\u6001\u51fa\u9519");
        CusUrMbrStorageCardPOExample example2 = new CusUrMbrStorageCardPOExample();
        example2.createCriteria().andMemberCodeEqualTo(donate.getFromMemberCode());
        List cusUrMbrStorageCardPOS = this.cusUrMbrStorageCardPOMapper.selectByExample(example2);
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)cusUrMbrStorageCardPOS) ? 1 : 0) != 0, (String)("\u50a8\u503c\u5361\u6570\u636e\u9519\u8bef by membercode : " + donate.getFromMemberCode()));
        String billNo = UUIDGenerator.get20UUID();
        CusUrMbrStorageCardRecordPO cusUrMbrStorageCardRecordPO = CusUrMbrStorageCardRecordPO.builder().sysCompanyId(donate.getSysCompanyId()).brandId(donate.getBrandId()).memberCode(donate.getFromMemberCode()).vipName(donate.getFromVipName()).vipCardNo(donate.getFromVipCardNo()).phone(donate.getFromPhone()).balance(donate.getBalance()).opType(Integer.valueOf(StorageOpsTypeEnum.BACK.getCode())).billNo(billNo).targetName(donate.getToTargetName()).createDate(new Date()).overage(((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getBalance().add(donate.getBalance())).valid(Boolean.valueOf(true)).version(Integer.valueOf(1)).orderNo("-").opsName("-").mbrName(donate.getFromVipName()).mbrCardNo(donate.getFromVipCardNo()).mbrPhone(donate.getFromPhone()).storageCardNo(((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getStorageCardNo()).remark(donate.getFromVipName() + "\u7ed9" + donate.getToTargetName() + "\u7684\u8f6c\u8d60\u88ab\u9000\u56de").build();
        this.cusUrMbrStorageCardRecordPOMapper.insert(cusUrMbrStorageCardRecordPO);
        count = this.cusUrMbrStorageCardPOMapper.addBalanceByMemberCode(donate.getBalance(), donate.getFromMemberCode());
        MembersEsRequestVo membersEsRequestVo = new MembersEsRequestVo();
        membersEsRequestVo.setSysCompanyId(donate.getSysCompanyId());
        membersEsRequestVo.setBrandId(donate.getBrandId());
        membersEsRequestVo.setMemberCodeList(Collections.singletonList(donate.getFromMemberCode()));
        log.info("StorageOpsServiceImpl singleReceived get member phone params : {}", (Object)membersEsRequestVo.toString());
        ResponseData membersListPageable = this.urMemberApiService.getMembersListPageable(membersEsRequestVo);
        PageInfo data = (PageInfo)membersListPageable.getData();
        log.info("StorageOpsServiceImpl singleReceived get member phone result : {}", (Object)data.getList());
        Assert.isTrue((data.getTotal() == 1L ? 1 : 0) != 0, (String)"\u65e0\u6548\u64cd\u4f5c");
        StorageCardListRequestVO requestVO = new StorageCardListRequestVO();
        requestVO.setBrandId(donate.getBrandId());
        StorageCardRequestVO storageCardRequestVO = new StorageCardRequestVO();
        storageCardRequestVO.setCardCode(donate.getFromVipCardNo());
        storageCardRequestVO.setVipName(donate.getFromVipName());
        storageCardRequestVO.setSex(((MembersEsResponseVo)data.getList().get(0)).getGender());
        storageCardRequestVO.setPhone(donate.getFromPhone());
        storageCardRequestVO.setUpdateBalance(donate.getBalance());
        storageCardRequestVO.setBalance(((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getBalance().add(donate.getBalance()));
        storageCardRequestVO.setStoredCardNo(((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getStorageCardNo());
        storageCardRequestVO.setTransferPerson(donate.getFromVipName());
        storageCardRequestVO.setDonee(donate.getToTargetName());
        storageCardRequestVO.setType(String.valueOf(StorageOpsTypeEnum.BACK.getCode()));
        storageCardRequestVO.setDocumentNo(billNo);
        storageCardRequestVO.setCorpCode(String.valueOf(donate.getSysCompanyId()));
        requestVO.setList(Collections.singletonList(storageCardRequestVO));
        Result result = this.connectorServiceFeign.batchSaveStorageCard(requestVO);
        log.info("StorageOpsServiceImpl batchReceivedStorageOps batchSaveStorageCard result code : {}, message : {}, data : {}", new Object[]{result.getCode(), result.getMessage(), result.getData()});
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u50a8\u503c\u91d1\u989d\u9000\u56de\u51fa\u9519");
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void consumeStorageOps(ConsumeStorageDto consumeStorageDto) {
        CusUrMbrStorageCardPO cusUrMbrStorageCardPO = new CusUrMbrStorageCardPO();
        cusUrMbrStorageCardPO.setStorageCardNo(consumeStorageDto.getStorageCardNo());
        cusUrMbrStorageCardPO.setBalance(consumeStorageDto.getBalance());
        int count = this.cusUrMbrStorageCardPOMapper.updateBalanceByStorageCardNo(cusUrMbrStorageCardPO);
        if (count == 0) {
            throw new CustomizedException("\u50a8\u503c\u5361\u4f59\u989d\u4e0d\u8db3");
        }
        CusUrMbrStorageCardPOExample cusUrMbrStorageCardPOExample = new CusUrMbrStorageCardPOExample();
        CusUrMbrStorageCardPOExample.Criteria criteria = cusUrMbrStorageCardPOExample.createCriteria();
        criteria.andStorageCardNoEqualTo(cusUrMbrStorageCardPO.getStorageCardNo());
        List cusUrMbrStorageCardPOS = this.cusUrMbrStorageCardPOMapper.selectByExample(cusUrMbrStorageCardPOExample);
        CusUrMbrStorageCardRecordPO cusUrMbrStorageCardRecordPO = new CusUrMbrStorageCardRecordPO();
        cusUrMbrStorageCardRecordPO.setSysCompanyId(consumeStorageDto.getSysCompanyId());
        cusUrMbrStorageCardRecordPO.setBrandId(consumeStorageDto.getBrandId());
        cusUrMbrStorageCardRecordPO.setOpsName(consumeStorageDto.getOpsCode());
        cusUrMbrStorageCardRecordPO.setMemberCode(consumeStorageDto.getMemberCode());
        cusUrMbrStorageCardRecordPO.setVipCardNo(consumeStorageDto.getVipCardNo());
        cusUrMbrStorageCardRecordPO.setBalance(consumeStorageDto.getBalance());
        cusUrMbrStorageCardRecordPO.setStorageCardNo(consumeStorageDto.getStorageCardNo());
        cusUrMbrStorageCardRecordPO.setCreateDate(new Date());
        cusUrMbrStorageCardRecordPO.setOpType(Integer.valueOf(StorageOpsTypeEnum.POS_CONSUME.getCode()));
        cusUrMbrStorageCardRecordPO.setBillNo(consumeStorageDto.getOpsCode());
        cusUrMbrStorageCardRecordPO.setMbrCardNo(consumeStorageDto.getVipCardNo());
        cusUrMbrStorageCardRecordPO.setMbrName(consumeStorageDto.getVipName());
        cusUrMbrStorageCardRecordPO.setMbrPhone(consumeStorageDto.getPhone());
        cusUrMbrStorageCardRecordPO.setOrderNo(consumeStorageDto.getOrderNo());
        cusUrMbrStorageCardRecordPO.setRemark(StorageOpsTypeEnum.POS_CONSUME.getMsg());
        cusUrMbrStorageCardRecordPO.setOverage(((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getBalance());
        cusUrMbrStorageCardRecordPO.setTargetName("-");
        cusUrMbrStorageCardRecordPO.setVerifyId(consumeStorageDto.getVerifyId());
        this.cusUrMbrStorageCardRecordPOMapper.insertSelective(cusUrMbrStorageCardRecordPO);
        StorageCardRequestVO cardRequestVO = new StorageCardRequestVO();
        cardRequestVO.setBrandId(consumeStorageDto.getBrandId());
        cardRequestVO.setCardCode(consumeStorageDto.getVipCardNo());
        cardRequestVO.setStoredCardNo(consumeStorageDto.getStorageCardNo());
        cardRequestVO.setUpdateBalance(consumeStorageDto.getBalance());
        cardRequestVO.setVipName(consumeStorageDto.getVipName());
        cardRequestVO.setPhone(consumeStorageDto.getPhone());
        cardRequestVO.setDocumentNo(consumeStorageDto.getOrderNo());
        cardRequestVO.setType("5");
        cardRequestVO.setBalance(((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getBalance());
        cardRequestVO.setCorpCode(consumeStorageDto.getSysCompanyId().toString());
        cardRequestVO.setBalance(((CusUrMbrStorageCardPO)cusUrMbrStorageCardPOS.get(0)).getBalance());
        StorageCardListRequestVO requestVO = new StorageCardListRequestVO();
        ArrayList<StorageCardRequestVO> storageCardRequestVOS = new ArrayList<StorageCardRequestVO>();
        storageCardRequestVOS.add(cardRequestVO);
        requestVO.setList(storageCardRequestVOS);
        requestVO.setBrandId(consumeStorageDto.getBrandId());
        log.info("StorageOpsServiceImpl batchSaveStorageCard param:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        Result result = this.connectorServiceFeign.batchSaveStorageCard(requestVO);
        if (result.getCode() != 0) {
            log.info("\u50a8\u503c\u5361\u6d41\u6c34\u6d88\u8d39\u7ebf\u4e0b\u5931\u8d25");
        }
        log.info("StorageOpsServiceImpl batchSaveStorageCard \u51fa\u53c2:{}", (Object)JacksonUtil.bean2Json((Object)result));
    }
}

