/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.service.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.SysAccountPo;
import com.bizvane.connectorservice.util.StringUtil;
import com.bizvane.customized.common.constants.MbrIntegralResetConstants;
import com.bizvane.customized.common.constants.MbrIntegralResetResponseEnum;
import com.bizvane.customized.common.constants.SysResponseEnum;
import com.bizvane.customized.common.system.RedisManager;
import com.bizvane.customized.common.thread.ThreadPool;
import com.bizvane.customized.common.utils.DateUtil;
import com.bizvane.customized.common.utils.UUIDGenerator;
import com.bizvane.customized.company.ur.members.service.MbrIntegralResetService;
import com.bizvane.customized.company.ur.members.service.impl.MbrIntegralResetImpl;
import com.bizvane.customized.facade.models.po.CusUrMbrIntegralFailPO;
import com.bizvane.customized.facade.models.po.CusUrMbrIntegralFailPOExample;
import com.bizvane.customized.facade.models.po.CusUrMbrIntegralResetBatchPO;
import com.bizvane.customized.facade.models.po.CusUrMbrIntegralResetBatchPOExample;
import com.bizvane.customized.facade.models.po.CusUrMbrIntegralResetPO;
import com.bizvane.customized.facade.models.po.CusUrMbrIntegralResetPOExample;
import com.bizvane.customized.facade.models.vo.CusUrMbrAddIntegralResetVO;
import com.bizvane.customized.facade.models.vo.CusUrMbrIntegralResetResponseVo;
import com.bizvane.customized.facade.models.vo.CusUrMbrIntegralResetVO;
import com.bizvane.customized.facade.utils.ClearPointConvertDateUtils;
import com.bizvane.customized.facade.utils.TimeUtils;
import com.bizvane.customized.mappers.CusUrMbrIntegralFailPOMapper;
import com.bizvane.customized.mappers.CusUrMbrIntegralResetBatchPOMapper;
import com.bizvane.customized.mappers.CusUrMbrIntegralResetPOMapper;
import com.bizvane.members.facade.enums.DirectionEnum;
import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.es.vo.Order;
import com.bizvane.members.facade.es.vo.SearchRangRequest;
import com.bizvane.members.facade.service.api.IntegralChangeApiService;
import com.bizvane.members.facade.service.api.MembersAdvancedSearchApiService;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import com.bizvane.members.facade.service.datafetch.model.DisableIntegralResetAboutExpireModel;
import com.bizvane.members.facade.vo.MemberInfoVo;
import com.bizvane.messagefacade.interfaces.SendPointMsgServiceFeign;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.redisutils.RedisTemplateServiceImpl;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageHelper;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.otto.flummi.Flummi;
import de.otto.flummi.aggregations.AggregationBuilder;
import de.otto.flummi.aggregations.FilterAggregationBuilder;
import de.otto.flummi.aggregations.SumAggregationBuilder;
import de.otto.flummi.query.QueryBuilder;
import de.otto.flummi.query.QueryBuilders;
import de.otto.flummi.request.SearchRequestBuilder;
import de.otto.flummi.response.AggregationResult;
import de.otto.flummi.response.SearchResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MbrIntegralResetImpl
implements MbrIntegralResetService {
    private static final Logger log = LoggerFactory.getLogger(MbrIntegralResetImpl.class);
    public static final String ASIA_SHANGHAI = "Asia/Shanghai";
    public static final String YYYY_MM_DD_T_HH_MM_SS_SSS_0800 = "yyyy-MM-dd'T'HH:mm:ss.SSS+0800";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String INTEGRAL_PAGE = "IntegralPage";
    public static final String INTEGRAL_MBR_NUM = "IntegralMbrNum";
    public static final String INTEGRAL_PAGE_MIN_ID = "IntegralPageMinId";
    public static final String SEND_MSG_MBR_NUM = "sendMsgMbrNum";
    public static final String SEND_MSG_PAGE_MIN_ID = "sendMsgPageMinId";
    public static final String INTEGRAL_EXPIRE = "INTEGRAL_EXPIRE";
    public static final String SEND_MSG_CLEAR_POINT_REDES = "SEND_MSG_CLEAR_POINT_REDES_";
    @Autowired
    private CusUrMbrIntegralResetPOMapper cusUrMbrIntegralResetPOMapper;
    @Autowired
    private CusUrMbrIntegralFailPOMapper cusUrMbrIntegralFailPOMapper;
    @Autowired
    private MembersAdvancedSearchApiService membersAdvancedSearchApiService;
    @Autowired
    private IntegralChangeApiService integralChangeApiService;
    @Autowired
    private RedisTemplateServiceImpl<String, String> redisTemplateService;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;
    @Autowired
    private Flummi flummi;
    @Autowired
    private ClearPointConvertDateUtils clearPointConvertDateUtils;
    @Autowired
    private SendPointMsgServiceFeign sendPointMsgServiceFeign;
    @Autowired
    private RedissonTemplate redissonTemplate;
    @Autowired
    private CusUrMbrIntegralResetBatchPOMapper cusUrMbrIntegralResetBatchPOMapper;
    @Value(value="${ur.serviceStoreId}")
    private String serviceStoreIds;

    public ResponseData<PageInfo<CusUrMbrIntegralResetPO>> getMbrIntegralResetList(CusUrMbrIntegralResetVO vo, SysAccountPo sysAccountPo) {
        log.info("enter customized getList method param:" + this.getClass().getName(), (Object)JSONObject.toJSONString((Object)vo));
        ResponseData ResponseData2 = new ResponseData();
        vo.setSysBrandId(sysAccountPo.getBrandId());
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        List list = this.cusUrMbrIntegralResetPOMapper.selectByVo(vo);
        PageInfo pageInfo = new PageInfo(list);
        ResponseData2.setData((Object)pageInfo);
        return ResponseData2;
    }

    public ResponseData<String> runFillToPerform(String integralResetId) {
        ResponseData responseData = new ResponseData();
        RedisClient redisClient = RedisManager.getInstince();
        boolean exists = redisClient.exists("PERFORM_STATE_INTEGRAL_KEY" + integralResetId);
        if (exists) {
            responseData.setCode(SysResponseEnum.REPEAT_FAILED.getCode());
            responseData.setMessage(SysResponseEnum.REPEAT_FAILED.getMessage());
            return responseData;
        }
        this.taskCountAdd(Long.valueOf(integralResetId));
        redisClient.set("PERFORM_STATE_INTEGRAL_KEY" + integralResetId, (Object)"Y", Long.valueOf(600L));
        1 runnable = new /* Unavailable Anonymous Inner Class!! */;
        ThreadPool.run((Runnable)runnable);
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskCountAdd(Long integralResetId) {
        try {
            this.redissonTemplate.getRLock("SEND_MSG_CLEAR_POINT_REDES_" + integralResetId, 10L, TimeUnit.SECONDS);
            CusUrMbrIntegralResetPO resetPO = this.cusUrMbrIntegralResetPOMapper.selectByPrimaryKey(integralResetId);
            if (null != resetPO) {
                Integer count = null != resetPO.getExecuteNum() ? resetPO.getExecuteNum() : 0;
                resetPO.setExecuteNum(count);
                this.cusUrMbrIntegralResetPOMapper.updateByPrimaryKeySelective(resetPO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.redissonTemplate.getRUnLook("SEND_MSG_CLEAR_POINT_REDES_" + integralResetId);
        }
    }

    public ResponseData<List<CusUrMbrIntegralResetPO>> selectByVo(CusUrMbrIntegralResetVO vo) {
        log.info("selectByVo method param:{},{}", (Object)this.getClass().getName(), (Object)JSONObject.toJSONString((Object)vo));
        Assert.isTrue((vo != null && vo.getSysBrandId() != null ? 1 : 0) != 0, (String)"SysBrandId\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseData ResponseData2 = new ResponseData();
        List list = this.cusUrMbrIntegralResetPOMapper.selectByVo(vo);
        ResponseData2.setData((Object)(CollectionUtils.isNotEmpty((Collection)list) ? list : new ArrayList()));
        return ResponseData2;
    }

    public ResponseData<String> runFill(String integralResetId) {
        ResponseData responseData = new ResponseData();
        CusUrMbrIntegralFailPOExample example = new CusUrMbrIntegralFailPOExample();
        example.createCriteria().andIntegralResetIdEqualTo(Long.valueOf(integralResetId)).andStateEqualTo(Boolean.valueOf(false));
        PageHelper.startPage((int)1, (int)MbrIntegralResetConstants.pageOneHundred);
        List list = this.cusUrMbrIntegralFailPOMapper.selectByExample(example);
        PageInfo pageInfo = new PageInfo(list);
        for (int i = 0; i < pageInfo.getPages(); ++i) {
            PageHelper.startPage((int)i, (int)MbrIntegralResetConstants.pageOneHundred);
            List faillist = this.cusUrMbrIntegralFailPOMapper.selectByExample(example);
            ArrayList memberCodeList = new ArrayList();
            HashMap map = new HashMap();
            faillist.forEach(vo -> {
                memberCodeList.add(vo.getMemberCode());
                map.put(vo.getMemberCode(), vo.getIntegralFailId());
            });
            MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
            membersInfoSearchVo.setBrandId(((CusUrMbrIntegralFailPO)faillist.get(0)).getSysBrandId());
            membersInfoSearchVo.setSysCompanyId(((CusUrMbrIntegralFailPO)faillist.get(0)).getSysCompanyId());
            membersInfoSearchVo.setMemberCodeList(memberCodeList);
            membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
            membersInfoSearchVo.setPageSize(MbrIntegralResetConstants.pageOneHundred);
            ResponseData memberInfoModelListNum = this.membersAdvancedSearchApiService.search(membersInfoSearchVo);
            ((PageInfo)memberInfoModelListNum.getData()).getList().forEach(vo -> {
                try {
                    ResponseData integerResponseData = this.delIntegralByMemberCode(vo.getMemberCode(), vo.getBrandId(), DateUtil.format((Date)((CusUrMbrIntegralFailPO)faillist.get(0)).getKeepDate(), (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                    if (integerResponseData.getCode() != 0) {
                        throw new Exception("method delIntegralByMemberCode error");
                    }
                    int integralRg = (Integer)integerResponseData.getData();
                    ResponseData response = this.deductIntegral(vo.getMemberCode(), integralRg, vo.getCountIntegral().intValue(), vo.getSysCompanyId(), vo.getBrandId());
                    if (response.getCode() == 0) {
                        log.info("enter runFillToPerform Out ok" + vo.getMemberCode() + response.getMessage());
                        CusUrMbrIntegralFailPO cusUrMbrIntegralFailPO = new CusUrMbrIntegralFailPO();
                        cusUrMbrIntegralFailPO.setIntegralFailId((Long)map.get(vo.getMemberCode()));
                        cusUrMbrIntegralFailPO.setModifiedDate(new Date());
                        cusUrMbrIntegralFailPO.setState(Boolean.valueOf(true));
                        this.cusUrMbrIntegralFailPOMapper.updateByPrimaryKeySelective(cusUrMbrIntegralFailPO);
                        if (integralRg >= vo.getCountIntegral()) {
                            this.updateIntegralState(Long.valueOf(integralResetId), MbrIntegralResetConstants.INTEGRAL_STATE_NONEED.intValue());
                        }
                        this.updateIntegralState(Long.valueOf(integralResetId), 3);
                    } else {
                        log.info("enter runFillToPerform Out fail" + vo.getMemberCode() + response.getMessage());
                    }
                }
                catch (Exception e) {
                    log.info("enter runFillToPerform Out Exception" + vo.getMemberCode() + e);
                }
            });
        }
        return responseData;
    }

    public ResponseData<String> runTask(String str) {
        ResponseData ResponseData2 = new ResponseData();
        List list = this.cusUrMbrIntegralResetPOMapper.selectByPerformState();
        for (CusUrMbrIntegralResetPO po : list) {
            this.runMbrIntegralReset(po);
        }
        return ResponseData2;
    }

    public void creatNewCircularTask(CusUrMbrIntegralResetPO po) {
        try {
            if (null != po.getExecutionType() && 1 == po.getExecutionType() && null != po.getPerformState() && 1 == po.getPerformState()) {
                CusUrMbrIntegralResetPO resetPO = new CusUrMbrIntegralResetPO();
                BeanUtils.copyProperties((Object)resetPO, (Object)po);
                Date keepDate = this.clearPointConvertDateUtils.addYearDate(resetPO.getKeepDate(), 1);
                Date startDate = this.clearPointConvertDateUtils.addYearDate(resetPO.getStartDate(), 1);
                resetPO.setStartDate(startDate);
                resetPO.setKeepDate(keepDate);
                Date startDateOfDay = DateUtil.getStartDateOfDay((Date)startDate);
                Date endDateOfDay = DateUtil.getEndDateOfDay((Date)startDate);
                CusUrMbrIntegralResetBatchPOExample example = new CusUrMbrIntegralResetBatchPOExample();
                example.createCriteria().andValidEqualTo(Boolean.TRUE).andIntegralResetIdEqualTo(resetPO.getIntegralResetId()).andStartDateBetween(startDateOfDay, endDateOfDay);
                List list = this.cusUrMbrIntegralResetBatchPOMapper.selectByExample(example);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    log.info("\u5df2\u5b58\u5728\u65b0\u7684\u6267\u884c\u5faa\u73af\u4efb\u52a1\uff01\u4efb\u52a1id:{}\uff0c\u6279\u6b21id:{}", (Object)po.getIntegralResetId(), (Object)((CusUrMbrIntegralResetBatchPO)list.get(0)).getResetBatchId());
                    return;
                }
                MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
                membersInfoSearchVo.setBrandId(resetPO.getSysBrandId());
                membersInfoSearchVo.setSysCompanyId(resetPO.getSysCompanyId());
                membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
                membersInfoSearchVo.setPageSize(Integer.valueOf(10));
                if (StringUtils.isNotBlank((String)resetPO.getLevel())) {
                    ArrayList<Long> levelID = new ArrayList<Long>();
                    levelID.add(Long.valueOf(resetPO.getLevel()));
                    membersInfoSearchVo.setLevelID(levelID);
                }
                membersInfoSearchVo.setOpenCardTimeFrom(keepDate);
                ResponseData memberInfoModelLists = this.membersAdvancedSearchApiService.search(membersInfoSearchVo);
                CusUrMbrIntegralResetBatchPO batchPO = new CusUrMbrIntegralResetBatchPO();
                BeanUtils.copyProperties((Object)batchPO, (Object)resetPO);
                batchPO.setTargetNumber(Integer.valueOf(0));
                batchPO.setShouldNumber(Integer.valueOf(0));
                if (memberInfoModelLists.getData() != null) {
                    batchPO.setTargetNumber(Integer.valueOf((int)((PageInfo)memberInfoModelLists.getData()).getTotal()));
                }
                batchPO.setStartDate(startDate);
                batchPO.setKeepDate(keepDate);
                batchPO.setBatchCode(UUIDGenerator.get12UUID());
                batchPO.setAlreadyNumber(Integer.valueOf(0));
                batchPO.setFailureNumber(Integer.valueOf(0));
                batchPO.setSuccessfullyNumber(Integer.valueOf(0));
                batchPO.setZeroNumber(Integer.valueOf(0));
                batchPO.setPerformState(MbrIntegralResetConstants.PERFORM_STATE_WAIT);
                batchPO.setPerformStateName("\u5f85\u6267\u884c");
                this.cusUrMbrIntegralResetBatchPOMapper.insertSelective(batchPO);
                this.cusUrMbrIntegralResetPOMapper.updateByPrimaryKeySelective(resetPO);
            }
        }
        catch (Exception e) {
            log.info("\u5faa\u73af\u6267\u884c\u4efb\u52a1\u66f4\u65b0\u6267\u884c\u65f6\u95f4\u548c\u79ef\u5206\u8fc7\u671f\u65f6\u95f4\u5931\u8d252\uff1a{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public ResponseData createNewIntegralResetById(Long integralResetId) {
        ResponseData responseData = new ResponseData();
        if (null != integralResetId) {
            CusUrMbrIntegralResetPO integralResetPO = this.cusUrMbrIntegralResetPOMapper.selectByPrimaryKey(integralResetId);
            if (null == integralResetPO) {
                responseData.setMessage("\u672a\u67e5\u8be2\u5230\u6709\u6548\u4efb\u52a1");
                responseData.setCode(-1);
            }
            if (!integralResetPO.getValid().booleanValue()) {
                responseData.setMessage("\u672a\u67e5\u8be2\u5230\u6709\u6548\u4efb\u52a1");
                responseData.setCode(-1);
            }
            this.creatNewCircularTask(integralResetPO);
        } else {
            Date startDateOfDay = this.clearPointConvertDateUtils.getStartDate(new Date());
            Date endDateOfDay = this.clearPointConvertDateUtils.getEndDate(new Date());
            CusUrMbrIntegralResetPOExample example = new CusUrMbrIntegralResetPOExample();
            example.createCriteria().andValidEqualTo(Boolean.TRUE).andExecutionTypeEqualTo(Integer.valueOf(1)).andStartDateBetween(startDateOfDay, endDateOfDay);
            List list = this.cusUrMbrIntegralResetPOMapper.selectByExample(example);
            for (CusUrMbrIntegralResetPO po : list) {
                this.creatNewCircularTask(po);
            }
        }
        return responseData;
    }

    public ResponseData<CusUrMbrIntegralResetResponseVo> getMbrIntegralResetListByParentId(Long integralResetId, Boolean executionType) {
        ResponseData responseData = new ResponseData();
        CusUrMbrIntegralResetResponseVo vo = new CusUrMbrIntegralResetResponseVo();
        try {
            List<Object> list = new ArrayList<CusUrMbrIntegralResetBatchPO>();
            CusUrMbrIntegralResetPO resetPO = this.cusUrMbrIntegralResetPOMapper.selectByPrimaryKey(integralResetId);
            BeanUtils.copyProperties((Object)vo, (Object)resetPO);
            if (executionType.booleanValue()) {
                CusUrMbrIntegralResetBatchPOExample example = new CusUrMbrIntegralResetBatchPOExample();
                example.createCriteria().andSysBrandIdEqualTo(resetPO.getSysBrandId()).andIntegralResetIdEqualTo(resetPO.getIntegralResetId()).andValidEqualTo(Boolean.valueOf(true));
                example.setOrderByClause("start_date desc");
                list = this.cusUrMbrIntegralResetBatchPOMapper.selectByExample(example);
            } else {
                CusUrMbrIntegralResetBatchPO po = new CusUrMbrIntegralResetBatchPO();
                BeanUtils.copyProperties((Object)po, (Object)resetPO);
                po.setBatchCode(resetPO.getTaskCode());
                list.add(po);
            }
            vo.setBatchList(list);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u79ef\u5206\u6e05\u96f6\u6267\u884c\u5217\u8868\u5931\u8d25\uff1a{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            responseData.setCode(-1);
            responseData.setMessage("\u67e5\u8be2\u79ef\u5206\u6e05\u96f6\u6267\u884c\u5217\u8868\u5931\u8d25");
        }
        responseData.setData((Object)vo);
        return responseData;
    }

    public ResponseData<PageInfo<CusUrMbrIntegralResetPO>> runMbrIntegralReset(CusUrMbrIntegralResetPO vo) {
        ResponseData memberInfoModelListPageData;
        this.taskCountAdd(vo.getIntegralResetId());
        log.info("enter customized getList method param:" + this.getClass().getName(), (Object)JSONObject.toJSONString((Object)vo));
        ResponseData ResponseData2 = new ResponseData();
        MembersInfoSearchVo membersInfoSearchVo = this.buildMembersInfoSearchVo(vo);
        ResponseData memberInfoModelListNum = this.membersAdvancedSearchApiService.search(membersInfoSearchVo);
        if (memberInfoModelListNum == null || memberInfoModelListNum.getData() == null || CollectionUtils.isEmpty((Collection)((PageInfo)memberInfoModelListNum.getData()).getList())) {
            if (null != vo.getPerformState() && vo.getPerformState() == 1) {
                vo.setPerformState(MbrIntegralResetConstants.PERFORM_STATE_COMPLETE);
                vo.setPerformStateName("\u5df2\u6267\u884c");
                this.cusUrMbrIntegralResetPOMapper.updateByPrimaryKeySelective(vo);
            }
            log.info("membersAdvancedSearchApiService#search,\u641c\u7d22\u7ed3\u679c\u4e3a\u7a7a,\u65e0\u9700\u6267\u884c,{}", (Object)JSONObject.toJSONString((Object)memberInfoModelListNum));
            return new ResponseData(SysResponseEnum.SUCCESS.getCode(), (Object)new PageInfo());
        }
        Long minMbrId = 0L;
        String minMbrIdStrRedisKey = "IntegralPageMinId" + vo.getTaskCode();
        String integralMbrNumRedisKey = "IntegralMbrNum" + vo.getTaskCode();
        String minMbrIdStr = (String)this.redisTemplateService.stringGetStringByKey((Object)minMbrIdStrRedisKey);
        if (StringUtils.isNotBlank((String)minMbrIdStr)) {
            log.info("redisTemplateService#stringGetStringByKey,\u503c\u4e3a{}", (Object)minMbrIdStr);
            minMbrId = Long.valueOf(minMbrIdStr);
        }
        long integralMbrAllNum = ((PageInfo)memberInfoModelListNum.getData()).getTotal();
        log.info("taskCode={},minMbrIdStrRedisKey={},minMbrId={},integralMbrNumRedisKey={},\u8d77\u59cbintegralMbrNum={},\u603b\u6570\u4e3a={}", new Object[]{vo.getTaskCode(), minMbrIdStrRedisKey, minMbrId, integralMbrNumRedisKey, this.redisTemplateService.getIncrValue(integralMbrNumRedisKey), integralMbrAllNum});
        int i = 0;
        while (true) {
            this.buildNextMembersInfoSearchVo(membersInfoSearchVo, minMbrId);
            this.redisTemplateService.stringSetValueAndExpireTime((Object)minMbrIdStrRedisKey, (Object)String.valueOf(minMbrId), 60000000L);
            log.info("membersAdvancedSearchApiService#search,\u641c\u7d22\u6761\u4ef6:{}", (Object)JSONObject.toJSONString((Object)membersInfoSearchVo));
            log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},membersAdvancedSearchApiService#search\u5f00\u59cb\u641c\u7d22", (Object)vo.getTaskCode(), (Object)(++i));
            memberInfoModelListPageData = this.membersAdvancedSearchApiService.search(membersInfoSearchVo);
            log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},membersAdvancedSearchApiService#search\u641c\u7d22\u5b8c\u6210", (Object)vo.getTaskCode(), (Object)i);
            if (SysResponseEnum.SUCCESS.getCode() != memberInfoModelListPageData.getCode()) {
                log.info("membersAdvancedSearchApiService#search,\u8bbf\u95ee\u5931\u8d25,res:{}", (Object)JSONObject.toJSONString((Object)memberInfoModelListPageData));
                throw new RuntimeException("membersAdvancedSearchApiService#search,\u8bbf\u95ee\u5931\u8d25");
            }
            if (memberInfoModelListPageData == null || memberInfoModelListPageData.getData() == null || CollectionUtils.isEmpty((Collection)((PageInfo)memberInfoModelListPageData.getData()).getList())) break;
            List memberInfoModelList = ((PageInfo)memberInfoModelListPageData.getData()).getList();
            List collect = Arrays.stream(this.serviceStoreIds.trim().split(",")).map(src -> Long.valueOf(src)).collect(Collectors.toList());
            int j = 0;
            for (MemberInfoVo memberInfoVo : memberInfoModelList) {
                log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},j={},\u5355\u4e2a\u4f1a\u5458\u5faa\u73af\u5f00\u59cb\u6267\u884c", new Object[]{vo.getTaskCode(), i, ++j});
                this.redisTemplateService.incr(integralMbrNumRedisKey, 60000L);
                if (StringUtil.isNotNull((Object)memberInfoVo.getServiceStoreId()) && (((Long)collect.get(0)).equals(memberInfoVo.getServiceStoreId()) || ((Long)collect.get(1)).equals(memberInfoVo.getServiceStoreId()) || ((Long)collect.get(2)).equals(memberInfoVo.getServiceStoreId()))) continue;
                while (ThreadPool.threadPoolExecutor.getQueue().remainingCapacity() <= 0) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception e) {
                        log.info("\u7ebf\u7a0b\u6c60\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
                log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},j={},\u5355\u4e2a\u4f1a\u5458\u5faa\u73af\u6267\u884c\u5f00\u542f\u591a\u7ebf\u7a0b", new Object[]{vo.getTaskCode(), i, j});
                int finalI = i;
                int finalJ = j;
                ThreadPool.run(() -> {
                    try {
                        log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},j={},\u5f00\u59cb\u8ba1\u7b97\u6d41\u6c34\u6536\u5165\u79ef\u5206,threadId:{},threadName:{}", new Object[]{vo.getTaskCode(), finalI, finalJ, Thread.currentThread().getId(), Thread.currentThread().getName()});
                        ResponseData integerResponseData = this.delIntegralByMemberCode(memberInfoVo.getMemberCode(), memberInfoVo.getBrandId(), DateUtil.format((Date)vo.getKeepDate(), (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                        log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},j={},\u5b8c\u6210\u8ba1\u7b97\u6d41\u6c34\u6536\u5165\u79ef\u5206", new Object[]{vo.getTaskCode(), finalI, finalJ});
                        if (integerResponseData.getCode() != 0) {
                            throw new Exception("method delIntegralByMemberCode error");
                        }
                        int integralRg = (Integer)integerResponseData.getData();
                        Integer state = MbrIntegralResetConstants.INTEGRAL_STATE_NONEED;
                        if (memberInfoVo.getCountIntegral() - integralRg > 0) {
                            log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},j={},\u5f00\u59cb\u79ef\u5206\u6e05\u96f6", new Object[]{vo.getTaskCode(), finalI, finalJ});
                            ResponseData responseData = this.deductIntegral(memberInfoVo.getMemberCode(), integralRg, memberInfoVo.getCountIntegral().intValue(), vo.getSysCompanyId(), vo.getSysBrandId());
                            log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},j={},\u5b8c\u6210\u79ef\u5206\u6e05\u96f6", new Object[]{vo.getTaskCode(), finalI, finalJ});
                            if (responseData.getCode() != 0) {
                                log.error("method deductIntegral error:" + responseData.getMessage());
                                throw new Exception("method deductIntegral error:" + responseData.getMessage());
                            }
                            state = MbrIntegralResetConstants.INTEGRAL_STATE_SUCCESS;
                            if (integralRg >= memberInfoVo.getCountIntegral()) {
                                log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},j={},\u4e0d\u9700\u8981\u6e05\u96f6", new Object[]{vo.getTaskCode(), finalI, finalJ});
                                this.updateIntegralState(vo.getIntegralResetId(), MbrIntegralResetConstants.INTEGRAL_STATE_NONEED.intValue());
                            }
                        }
                        log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},j={},\u5f00\u59cb\u66f4\u65b0\u4efb\u52a1\u8868", new Object[]{vo.getTaskCode(), finalI, finalJ});
                        this.updateIntegralState(vo.getIntegralResetId(), state.intValue());
                        log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},j={},\u5b8c\u6210\u66f4\u65b0\u4efb\u52a1\u8868", new Object[]{vo.getTaskCode(), finalI, finalJ});
                        if (this.redisTemplateService.getIncrValue(integralMbrNumRedisKey) == integralMbrAllNum) {
                            log.info("\u6b63\u5e38\u60c5\u51b5\u4e0b,\u6700\u540e\u4e00\u6761\u4f1a\u5458\u6570\u636e,\u6761\u6570:{},\u4fee\u6539\u4efb\u52a1\u72b6\u6001", (Object)integralMbrAllNum);
                            this.updateIntegralEnd(vo.getIntegralResetId());
                        }
                    }
                    catch (Exception e) {
                        log.info("enter customized ServiceintegralChangeOperate memberCode:{},\u5f02\u5e38\u4fe1\u606f:{}", (Object)memberInfoVo.getMemberCode(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
                        CusUrMbrIntegralFailPO cusUrMbrIntegralFailPO = new CusUrMbrIntegralFailPO();
                        cusUrMbrIntegralFailPO.setIntegralResetId(vo.getIntegralResetId());
                        cusUrMbrIntegralFailPO.setMemberCode(memberInfoVo.getMemberCode());
                        cusUrMbrIntegralFailPO.setCreateDate(new Date());
                        cusUrMbrIntegralFailPO.setSysCompanyId(vo.getSysCompanyId());
                        cusUrMbrIntegralFailPO.setSysBrandId(vo.getSysBrandId());
                        cusUrMbrIntegralFailPO.setTaskName(vo.getTaskName());
                        cusUrMbrIntegralFailPO.setState(Boolean.valueOf(false));
                        cusUrMbrIntegralFailPO.setStartDate(vo.getStartDate());
                        cusUrMbrIntegralFailPO.setKeepDate(vo.getKeepDate());
                        cusUrMbrIntegralFailPO.setValid(Boolean.valueOf(true));
                        this.cusUrMbrIntegralFailPOMapper.insertSelective(cusUrMbrIntegralFailPO);
                        this.updateIntegralState(vo.getIntegralResetId(), MbrIntegralResetConstants.INTEGRAL_STATE_FAIL.intValue());
                        if (this.redisTemplateService.getIncrValue(integralMbrNumRedisKey) == integralMbrAllNum) {
                            log.info("\u5f02\u5e38\u60c5\u51b5\u4e0b,\u6700\u540e\u4e00\u6761\u4f1a\u5458\u6570\u636e,\u6761\u6570:{},\u4fee\u6539\u4efb\u52a1\u72b6\u6001", (Object)integralMbrAllNum);
                            this.updateIntegralEnd(vo.getIntegralResetId());
                        }
                        log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},j={},\u5f02\u5e38\u66f4\u65b0\u4efb\u52a1\u8868", new Object[]{vo.getTaskCode(), finalI, finalJ});
                    }
                });
                log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},j={},\u5355\u4e2a\u4f1a\u5458\u5faa\u73af\u6267\u884c\u5b8c\u6210", new Object[]{vo.getTaskCode(), i, j});
            }
            minMbrId = ((MemberInfoVo)memberInfoModelList.get(memberInfoModelList.size() - 1)).getMbrMemberId();
            log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1taskcode={},i={},\u8be5\u6279\u91cf\u6e05\u96f6\u5b8c\u6210", (Object)vo.getTaskCode(), (Object)i);
        }
        log.info("membersAdvancedSearchApiService#search,\u67e5\u8be2\u4f1a\u5458\u7ed3\u675f,res:{}", (Object)JSONObject.toJSONString((Object)memberInfoModelListPageData));
        ResponseData2.setData((Object)new PageInfo());
        return ResponseData2;
    }

    private void buildNextMembersInfoSearchVo(MembersInfoSearchVo membersInfoSearchVo, Long minMbrId) {
        log.info("\u672c\u641c\u7d22\u6700\u5c0f\u4e00\u4e2a\u4f1a\u5458mbrMemberId:{}", (Object)minMbrId);
        if (minMbrId != null) {
            ArrayList<SearchRangRequest> searchRangRequestList = new ArrayList<SearchRangRequest>();
            SearchRangRequest objectSearchRangRequest = new SearchRangRequest();
            objectSearchRangRequest.setMin(minMbrId.toString());
            searchRangRequestList.add(objectSearchRangRequest);
            membersInfoSearchVo.setMbrMemberIdRanges(searchRangRequestList);
            membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
        } else {
            log.info("mbrMemberId\u4e3a\u7a7a,\u4e3a\u907f\u514d\u6b7b\u5faa\u73af,\u9700\u8981\u5f3a\u5236\u5206\u9875");
            membersInfoSearchVo.setPageNumber(Integer.valueOf(membersInfoSearchVo.getPageNumber() + 1));
        }
    }

    private MembersInfoSearchVo buildMembersInfoSearchVo(CusUrMbrIntegralResetPO vo) {
        MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
        membersInfoSearchVo.setBrandId(vo.getSysBrandId());
        membersInfoSearchVo.setSysCompanyId(vo.getSysCompanyId());
        membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
        membersInfoSearchVo.setPageSize(MbrIntegralResetConstants.pageOneThousand);
        ArrayList<Order> orderByList = new ArrayList<Order>();
        Order orderBy = new Order();
        orderBy.setDirection(DirectionEnum.ASC);
        orderBy.setProperty("mbrMemberId");
        orderByList.add(orderBy);
        membersInfoSearchVo.setOrders(orderByList);
        if (StringUtils.isNotBlank((String)vo.getLevel())) {
            ArrayList<Long> levelID = new ArrayList<Long>();
            levelID.add(Long.valueOf(vo.getLevel()));
            membersInfoSearchVo.setLevelID(levelID);
        }
        membersInfoSearchVo.setOpenCardTimeFrom(vo.getKeepDate());
        return membersInfoSearchVo;
    }

    public ResponseData<String> deductIntegral(String memberCode, int IntegralRg, int nowIntegral, Long sysCompanyId, Long brandId) {
        ResponseData responseData = new ResponseData();
        if (IntegralRg < nowIntegral) {
            IntegralChangeRequestModel changeRequestModel = new IntegralChangeRequestModel();
            changeRequestModel.setBrandId(brandId);
            changeRequestModel.setSysCompanyId(sysCompanyId);
            changeRequestModel.setMemberCode(memberCode);
            changeRequestModel.setChangeBills("\u79ef\u5206\u6e05\u96f6");
            changeRequestModel.setChangeIntegral(Integer.valueOf(nowIntegral - IntegralRg));
            changeRequestModel.setChangeType("1");
            changeRequestModel.setBusinessType("3");
            log.info("enter customizedintegralChangeOperate  method param:" + this.getClass().getName(), (Object)JSONObject.toJSONString((Object)changeRequestModel));
            IntegralChangeResponseModel vo = this.integralChangeApiService.integralChangeOperate(changeRequestModel);
            log.info("enter customizedintegralChangeOperate  method out:" + this.getClass().getName(), (Object)JSONObject.toJSONString((Object)vo));
            responseData.setCode(vo.getCode().intValue());
            responseData.setMessage(vo.getMessage());
        }
        return responseData;
    }

    public ResponseData<Integer> delIntegralByMemberCode(String memberCode, Long brandId, String keepDate, String startDate) {
        ResponseData responseData = new ResponseData();
        log.info("enter customized delIntegralByMemberCode method param:" + memberCode + brandId + keepDate + startDate);
        try {
            BoolQueryBuilder builder = org.elasticsearch.index.query.QueryBuilders.boolQuery();
            builder.must((org.elasticsearch.index.query.QueryBuilder)org.elasticsearch.index.query.QueryBuilders.matchQuery((String)"brandId", (Object)brandId));
            builder.must((org.elasticsearch.index.query.QueryBuilder)org.elasticsearch.index.query.QueryBuilders.matchQuery((String)"memberCode", (Object)memberCode));
            builder.must((org.elasticsearch.index.query.QueryBuilder)org.elasticsearch.index.query.QueryBuilders.matchQuery((String)"changeWay", (Object)"2"));
            BoolQueryBuilder createTimeBuilder = org.elasticsearch.index.query.QueryBuilders.boolQuery();
            createTimeBuilder.must((org.elasticsearch.index.query.QueryBuilder)org.elasticsearch.index.query.QueryBuilders.rangeQuery((String)"changeDate").includeLower(true).includeUpper(true).timeZone("Asia/Shanghai").from((Object)MbrIntegralResetImpl.dateFormat((String)keepDate)).to((Object)MbrIntegralResetImpl.dateFormat((String)startDate)));
            builder.filter((org.elasticsearch.index.query.QueryBuilder)createTimeBuilder);
            Gson gson = new Gson();
            JsonObject jsonObj = (JsonObject)gson.fromJson(builder.toString(), JsonObject.class);
            SearchRequestBuilder searchRequestBuilder = this.flummi.prepareSearch(new String[]{"t_mbr_integral_record"}).setTypes(new String[]{"doc"}).setQuery(jsonObj);
            searchRequestBuilder.addAggregation((AggregationBuilder)new FilterAggregationBuilder("sum_GroupName").withFilter((QueryBuilder)QueryBuilders.termQuery((String)"changeWay", (String)"2")).subAggregation((AggregationBuilder)new SumAggregationBuilder("sum_changeIntegral", "changeIntegral")));
            log.info("delIntegralByMemberCode\u5165\u53c2\u6761\u4ef6\uff1a{}", (Object)JSONObject.toJSONString((Object)searchRequestBuilder));
            SearchResponse searchResponse = searchRequestBuilder.execute();
            AggregationResult sum_changeIntegral = (AggregationResult)((AggregationResult)searchResponse.getAggregations().get("sum_GroupName")).getNestedAggregations().get("sum_changeIntegral");
            log.info("delIntegralByMemberCode out\uff1a" + sum_changeIntegral.toString().replace("}", "").replace("SumAggregationResult{value=", ""));
            responseData.setData((Object)Integer.valueOf(sum_changeIntegral.toString().replace(".0}", "").replace("SumAggregationResult{value=", "")));
        }
        catch (Exception e) {
            log.error("enter customized delIntegralByMemberCode method param:" + memberCode + brandId + keepDate + startDate);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        return responseData;
    }

    public ResponseData<String> updateIntegralState(Long integralResetId, int state) {
        ResponseData ResponseData2 = new ResponseData();
        CusUrMbrIntegralResetPO po = new CusUrMbrIntegralResetPO();
        if (state == 3) {
            po.setRemark(SysResponseEnum.SUCCESS.getMessage());
        } else if (state == 2) {
            po.setSuccessfullyNumber(MbrIntegralResetConstants.EXEC_NUMBER);
            po.setAlreadyNumber(MbrIntegralResetConstants.EXEC_NUMBER);
        } else if (state == 1) {
            po.setFailureNumber(MbrIntegralResetConstants.EXEC_NUMBER);
            po.setAlreadyNumber(MbrIntegralResetConstants.EXEC_NUMBER);
        } else if (state == 0) {
            po.setZeroNumber(MbrIntegralResetConstants.EXEC_NUMBER);
            po.setAlreadyNumber(MbrIntegralResetConstants.EXEC_NUMBER);
        }
        po.setIntegralResetId(integralResetId);
        po.setPerformState(MbrIntegralResetConstants.PERFORM_STATE_EXECUTING);
        po.setPerformStateName("\u6267\u884c\u4e2d");
        int i = this.cusUrMbrIntegralResetPOMapper.updateNumberByPrimaryKey(po);
        if (i != 1) {
            ResponseData2.setCode(200);
        }
        return ResponseData2;
    }

    public ResponseData<String> updateIntegralEnd(Long integralResetId) {
        ResponseData ResponseData2 = new ResponseData();
        int i = this.cusUrMbrIntegralResetPOMapper.updatePerformStateByPrimaryKey(integralResetId);
        if (i != 1) {
            ResponseData2.setCode(200);
        }
        ResponseData2.setData((Object)"");
        return ResponseData2;
    }

    public ResponseData<PageInfo<CusUrMbrIntegralResetPO>> addMbrIntegralResetList(CusUrMbrAddIntegralResetVO vo, SysAccountPo loginUser) {
        log.info("enter customized getList method param:" + this.getClass().getName(), (Object)JSONObject.toJSONString((Object)vo));
        ResponseData ResponseData2 = new ResponseData();
        if (!this.isAllowAddByLevelAndPerformStateCount(loginUser.getSysCompanyId(), loginUser.getBrandId(), vo.getLevel())) {
            ResponseData2.setCode(MbrIntegralResetResponseEnum.OPERATE_FAILED_ADD_ALREADY_EXISTS.getCode());
            ResponseData2.setMessage(MbrIntegralResetResponseEnum.OPERATE_FAILED_ADD_ALREADY_EXISTS.getMessage());
            return ResponseData2;
        }
        CusUrMbrIntegralResetPO po = new CusUrMbrIntegralResetPO();
        MembersInfoSearchVo membersInfoSearchVo = new MembersInfoSearchVo();
        membersInfoSearchVo.setBrandId(loginUser.getBrandId());
        membersInfoSearchVo.setSysCompanyId(loginUser.getSysCompanyId());
        membersInfoSearchVo.setPageNumber(Integer.valueOf(1));
        membersInfoSearchVo.setPageSize(Integer.valueOf(10));
        if (StringUtils.isNotBlank((String)vo.getLevel())) {
            ArrayList<Long> levelID = new ArrayList<Long>();
            levelID.add(Long.valueOf(vo.getLevel()));
            membersInfoSearchVo.setLevelID(levelID);
        }
        if (null != vo.getExecutionType() && 1 == vo.getExecutionType()) {
            Date date = this.clearPointConvertDateUtils.convertDate(vo.getKeepYear().intValue(), vo.getKeepDateStr());
            if (null == date) {
                log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1\u4fdd\u7559\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
                ResponseData2.setCode(MbrIntegralResetResponseEnum.OPERATE_FAILED_ERROR.getCode());
                ResponseData2.setMessage(MbrIntegralResetResponseEnum.OPERATE_FAILED_ERROR.getMessage());
                return ResponseData2;
            }
            Date startDate = this.clearPointConvertDateUtils.convertDate(3, vo.getStartDateStr());
            if (null == startDate) {
                log.info("\u79ef\u5206\u6e05\u96f6\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
                ResponseData2.setCode(MbrIntegralResetResponseEnum.OPERATE_FAILED_ERROR.getCode());
                ResponseData2.setMessage(MbrIntegralResetResponseEnum.OPERATE_FAILED_ERROR.getMessage());
                return ResponseData2;
            }
            if (startDate.getTime() <= date.getTime()) {
                log.info("\u6267\u884c\u65f6\u95f4\u5e94\u5927\u4e8e\u6e05\u96f6\u8303\u56f4\u65f6\u95f4\u6761\u4ef6");
                ResponseData2.setCode(MbrIntegralResetResponseEnum.KEEP_DATE_GT_STATE_DATE_ERROR.getCode());
                ResponseData2.setMessage(MbrIntegralResetResponseEnum.KEEP_DATE_GT_STATE_DATE_ERROR.getMessage());
                return ResponseData2;
            }
            if (startDate.getTime() <= new Date().getTime()) {
                Calendar startSearchCalendar = Calendar.getInstance();
                startSearchCalendar.setTime(startDate);
                startSearchCalendar.add(1, 1);
                startDate = startSearchCalendar.getTime();
                Calendar keepSearchCalendar = Calendar.getInstance();
                keepSearchCalendar.setTime(date);
                keepSearchCalendar.add(1, 1);
                date = keepSearchCalendar.getTime();
            }
            vo.setStartDate(startDate);
            vo.setKeepDate(date);
        }
        membersInfoSearchVo.setOpenCardTimeFrom(vo.getKeepDate());
        ResponseData memberInfoModelLists = this.membersAdvancedSearchApiService.search(membersInfoSearchVo);
        if (memberInfoModelLists.getData() != null) {
            po.setTargetNumber(Integer.valueOf((int)((PageInfo)memberInfoModelLists.getData()).getTotal()));
            po.setShouldNumber(Integer.valueOf((int)((PageInfo)memberInfoModelLists.getData()).getTotal()));
        }
        po.setTaskCode(UUIDGenerator.get12UUID());
        po.setLevel(vo.getLevel());
        po.setSysCompanyId(loginUser.getSysCompanyId());
        po.setSysBrandId(loginUser.getBrandId());
        po.setCreateDate(new Date());
        po.setCreateUserId(loginUser.getSysAccountId());
        po.setCreateUserName(loginUser.getName());
        po.setValid(Boolean.valueOf(true));
        po.setAlreadyNumber(MbrIntegralResetConstants.PERFORM_NUMBER);
        po.setSuccessfullyNumber(MbrIntegralResetConstants.PERFORM_NUMBER);
        po.setFailureNumber(MbrIntegralResetConstants.PERFORM_NUMBER);
        po.setZeroNumber(MbrIntegralResetConstants.PERFORM_NUMBER);
        po.setPerformState(MbrIntegralResetConstants.PERFORM_STATE_WAIT);
        po.setPerformStateName("\u5f85\u6267\u884c");
        po.setStartDateStr(vo.getStartDateStr());
        po.setKeepDateStr(vo.getKeepDateStr());
        po.setDays(vo.getDays());
        po.setKeepYear(vo.getKeepYear());
        po.setStartYear(vo.getStartYear());
        po.setExecutionType(vo.getExecutionType());
        po.setSendMsgStatus(vo.getSendMsgStatus());
        po.setLevelName(vo.getLevelName());
        po.setTaskName(vo.getTaskName());
        Date toDayStart = DateUtil.getStartDateOfDay((Date)TimeUtils.getNowDate());
        Date keepDate = vo.getKeepDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(toDayStart);
        calendar.add(1, -2);
        Date twoYearsAgoDate = calendar.getTime();
        if (keepDate.getTime() < twoYearsAgoDate.getTime()) {
            ResponseData2.setCode(MbrIntegralResetResponseEnum.OPERATE_FAILED_ADD_KEEPDATE_ERROR.getCode());
            ResponseData2.setMessage(MbrIntegralResetResponseEnum.OPERATE_FAILED_ADD_KEEPDATE_ERROR.getMessage());
            return ResponseData2;
        }
        po.setKeepDate(keepDate);
        Date startDate = vo.getStartDate();
        calendar.setTime(toDayStart);
        calendar.add(5, 1);
        Date lastDayDate = calendar.getTime();
        calendar.setTime(toDayStart);
        calendar.add(1, 1);
        Date lastYearDate = calendar.getTime();
        if (startDate.getTime() < lastDayDate.getTime() || startDate.getTime() > lastYearDate.getTime()) {
            ResponseData2.setCode(MbrIntegralResetResponseEnum.OPERATE_FAILED_ADD_STARTDATE_ERROR.getCode());
            ResponseData2.setMessage(MbrIntegralResetResponseEnum.OPERATE_FAILED_ADD_STARTDATE_ERROR.getMessage());
            return ResponseData2;
        }
        po.setStartDate(startDate);
        int i = this.cusUrMbrIntegralResetPOMapper.insertSelective(po);
        this.cusUrMbrIntegralResetPOMapper.updateByPrimaryKeySelective(po);
        try {
            CusUrMbrIntegralResetBatchPO batchPO = new CusUrMbrIntegralResetBatchPO();
            BeanUtils.copyProperties((Object)batchPO, (Object)po);
            batchPO.setBatchCode(UUIDGenerator.get12UUID());
            this.cusUrMbrIntegralResetBatchPOMapper.insertSelective(batchPO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (i != 1) {
            ResponseData2.setCode(200);
        }
        ResponseData2.setData((Object)new PageInfo());
        return ResponseData2;
    }

    public ResponseData<PageInfo<CusUrMbrIntegralResetPO>> disableMbrIntegralReset(Long integralResetId, SysAccountPo loginUser) {
        log.info("enter customized getList method param:" + this.getClass().getName(), (Object)JSONObject.toJSONString((Object)integralResetId));
        ResponseData ResponseData2 = new ResponseData();
        CusUrMbrIntegralResetPO cusUrMbrIntegralReset = this.cusUrMbrIntegralResetPOMapper.selectByPrimaryKey(integralResetId);
        Integer performState = cusUrMbrIntegralReset.getPerformState();
        if (performState == 2) {
            ResponseData2.setCode(MbrIntegralResetResponseEnum.OPERATE_FAILED_DISABLE_STATEEXEC_ERROR.getCode());
            ResponseData2.setMessage(MbrIntegralResetResponseEnum.OPERATE_FAILED_DISABLE_STATEEXEC_ERROR.getMessage());
            return ResponseData2;
        }
        if (performState == 3) {
            ResponseData2.setCode(MbrIntegralResetResponseEnum.OPERATE_FAILED_DISABLE_STATECOMPLETE_ERROR.getCode());
            ResponseData2.setMessage(MbrIntegralResetResponseEnum.OPERATE_FAILED_DISABLE_STATECOMPLETE_ERROR.getMessage());
            return ResponseData2;
        }
        CusUrMbrIntegralResetPO po = new CusUrMbrIntegralResetPO();
        po.setIntegralResetId(integralResetId);
        po.setPerformState(MbrIntegralResetConstants.PERFORM_STATE_PROHIBIT);
        po.setPerformStateName("\u5df2\u7981\u7528");
        po.setModifiedDate(new Date());
        po.setModifiedUserId(loginUser.getSysAccountId());
        po.setModifiedUserName(loginUser.getName());
        po.setValid(Boolean.valueOf(false));
        int i = this.cusUrMbrIntegralResetPOMapper.updateByPrimaryKeySelective(po);
        if (i != 1) {
            ResponseData2.setCode(200);
        } else {
            CusUrMbrIntegralResetPO cusUrMbrIntegralResetPo = this.cusUrMbrIntegralResetPOMapper.selectByPrimaryKey(integralResetId);
            DisableIntegralResetAboutExpireModel disableIntegralModel = new DisableIntegralResetAboutExpireModel();
            disableIntegralModel.setCompanyId(cusUrMbrIntegralResetPo.getSysCompanyId());
            disableIntegralModel.setBrandId(cusUrMbrIntegralResetPo.getSysBrandId());
            disableIntegralModel.setLevel(cusUrMbrIntegralResetPo.getLevel());
            disableIntegralModel.setKeepDate(cusUrMbrIntegralResetPo.getKeepDate());
            Destination destination = new Destination();
            destination.setTopic("DISABLE_INTEGRAL_RESET_ABOUT_EXPIRE");
            log.info("DisableIntegralResetAboutExpire send RocketMqMessage :destination:{},disableIntegralModel:{}", (Object)JacksonUtil.bean2Json((Object)destination), (Object)JacksonUtil.bean2Json((Object)disableIntegralModel));
            this.rocketMQTemplate.asyncSend(destination, (Object)JacksonUtil.bean2Json((Object)disableIntegralModel));
        }
        ResponseData2.setData((Object)new PageInfo());
        return ResponseData2;
    }

    private static String dateFormat(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        return DateUtil.format((Date)DateUtil.parse((String)str, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS+0800");
    }

    private boolean isAllowAddByLevelAndPerformStateCount(Long sysCompanyId, Long sysBrandId, String level) {
        List performStateList = this.cusUrMbrIntegralResetPOMapper.selectByLevel(sysCompanyId, sysBrandId, level);
        for (Long performState : performStateList) {
            if (performState != 1L && performState != 2L) continue;
            return false;
        }
        return true;
    }
}

