/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.service.impl;

import com.alibaba.fastjson.JSON;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.customized.common.constants.SysConstants;
import com.bizvane.customized.common.constants.SysResponseEnum;
import com.bizvane.customized.common.utils.Assert;
import com.bizvane.customized.common.utils.ExportExcelUtil;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.NumberUtil;
import com.bizvane.customized.common.utils.StreamingExportExcelUtil;
import com.bizvane.customized.common.utils.UUIDGenerator;
import com.bizvane.customized.company.ur.members.service.EvaluationQuestionnaireService;
import com.bizvane.customized.company.ur.members.service.StorageCardService;
import com.bizvane.customized.facade.enums.QuestionnaireTemplateTypeEnum;
import com.bizvane.customized.facade.enums.ur.members.MbrQuestionnaireTemplateDraftStatusEnum;
import com.bizvane.customized.facade.enums.ur.members.QuestionnaireTempCheckStatusEnum;
import com.bizvane.customized.facade.exception.CustomizedException;
import com.bizvane.customized.facade.models.po.CusUrMbrEvaluationConfigPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderDetailPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePOExample;
import com.bizvane.customized.facade.models.vo.CusUrMbrEvalConfigVO;
import com.bizvane.customized.facade.models.vo.CusUrMbrQuestionnaireTemplateVO;
import com.bizvane.customized.facade.models.vo.EvaluationSaveTempRequestVO;
import com.bizvane.customized.facade.models.vo.questionnaire.ComponentModuleVO;
import com.bizvane.customized.facade.models.vo.questionnaire.ComponentOptionAnalysisVO;
import com.bizvane.customized.facade.models.vo.questionnaire.ComponentOptionVO;
import com.bizvane.customized.facade.models.vo.questionnaire.QuestionnaireAnalysisRequestVO;
import com.bizvane.customized.facade.models.vo.questionnaire.QuestionnaireAnalysisVO;
import com.bizvane.customized.facade.models.vo.questionnaire.QuestionnaireTempRequestVO;
import com.bizvane.customized.facade.models.vo.questionnaire.SurveyQuestionnaireVO;
import com.bizvane.customized.mappers.CusUrMbrEvaluationConfigPOMapper;
import com.bizvane.customized.mappers.CusUrMbrQuestionnaireOrderDetailPOMapper;
import com.bizvane.customized.mappers.CusUrMbrQuestionnaireOrderPOMapper;
import com.bizvane.customized.mappers.CusUrMbrQuestionnaireTemplatePOMapper;
import com.bizvane.members.facade.utils.DesensitizeUtil;
import com.bizvane.mktcenterservice.rpc.TaskQuestionnaireServiceRpc;
import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.wechatfacade.interfaces.QRCodeServiceFeign;
import com.bizvane.wechatfacade.models.vo.CreateMiniprgmQRCodeRequestVO;
import com.github.pagehelper.PageHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EvaluationQuestionnaireServiceImpl
implements EvaluationQuestionnaireService {
    private static final Logger log = LoggerFactory.getLogger(EvaluationQuestionnaireServiceImpl.class);
    @Autowired
    private CusUrMbrEvaluationConfigPOMapper cusUrMbrEvaluationConfigPOMapper;
    @Autowired
    private CusUrMbrQuestionnaireTemplatePOMapper cusUrMbrQuestionnaireTemplatePOMapper;
    @Autowired
    private CusUrMbrQuestionnaireOrderPOMapper cusUrMbrQuestionnaireOrderPOMapper;
    @Autowired
    private QRCodeServiceFeign qrCodeServiceFeign;
    @Autowired
    private CusUrMbrQuestionnaireOrderDetailPOMapper cusUrMbrQuestionnaireOrderDetailPOMapper;
    @Autowired
    private TaskQuestionnaireServiceRpc taskQuestionnaireServiceRpc;
    @Autowired
    private StorageCardService storageCardService;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;

    public ResponseData<CusUrMbrEvaluationConfigPO> addAndUpdateEvalConfig(CusUrMbrEvalConfigVO vo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        List poList = vo.getPoList();
        poList.forEach(po -> {
            if (po.getEvaluationConfigId() == null) {
                CusUrMbrEvaluationConfigPO cusUrMbrEvaluationConfigPO = new CusUrMbrEvaluationConfigPO();
                cusUrMbrEvaluationConfigPO.setSysCompanyId(vo.getSysCompanyId());
                cusUrMbrEvaluationConfigPO.setSysBrandId(vo.getSysBrandId());
                cusUrMbrEvaluationConfigPO.setOrderType(po.getOrderType());
                cusUrMbrEvaluationConfigPO.setEvaluationType(po.getEvaluationType());
                if (po.getEvaluationType().booleanValue()) {
                    cusUrMbrEvaluationConfigPO.setTemplateCode(po.getTemplateCode());
                    cusUrMbrEvaluationConfigPO.setTemplateName(po.getTemplateName());
                }
                cusUrMbrEvaluationConfigPO.setCreateDate(new Date());
                cusUrMbrEvaluationConfigPO.setCreateUserId(vo.getCreateUserId());
                cusUrMbrEvaluationConfigPO.setCreateUserName(vo.getCreateUserName());
                cusUrMbrEvaluationConfigPO.setValid(Boolean.valueOf(true));
                this.cusUrMbrEvaluationConfigPOMapper.insertSelective(cusUrMbrEvaluationConfigPO);
            } else {
                CusUrMbrEvaluationConfigPO cusUrMbrEvaluationConfigPO = new CusUrMbrEvaluationConfigPO();
                cusUrMbrEvaluationConfigPO.setEvaluationConfigId(po.getEvaluationConfigId());
                cusUrMbrEvaluationConfigPO.setSysCompanyId(vo.getSysCompanyId());
                cusUrMbrEvaluationConfigPO.setSysBrandId(vo.getSysBrandId());
                cusUrMbrEvaluationConfigPO.setOrderType(po.getOrderType());
                cusUrMbrEvaluationConfigPO.setEvaluationType(po.getEvaluationType());
                if (!po.getEvaluationType().booleanValue()) {
                    cusUrMbrEvaluationConfigPO.setTemplateCode("");
                    cusUrMbrEvaluationConfigPO.setTemplateName("");
                } else {
                    cusUrMbrEvaluationConfigPO.setTemplateCode(po.getTemplateCode());
                    cusUrMbrEvaluationConfigPO.setTemplateName(po.getTemplateName());
                }
                cusUrMbrEvaluationConfigPO.setModifiedDate(new Date());
                cusUrMbrEvaluationConfigPO.setModifiedUserId(vo.getCreateUserId());
                cusUrMbrEvaluationConfigPO.setModifiedUserName(vo.getCreateUserName());
                this.cusUrMbrEvaluationConfigPOMapper.updateByPrimaryKeySelective(cusUrMbrEvaluationConfigPO);
            }
        });
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<PageInfo<CusUrMbrEvaluationConfigPO>> getEvalConfig(CusUrMbrEvalConfigVO vo) {
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        List list = this.cusUrMbrEvaluationConfigPOMapper.selectByBrandIdAndCompanyId(vo);
        PageInfo pageInfo = new PageInfo(list);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<List<CusUrMbrQuestionnaireTemplatePO>> getQuestionnaireTemplate(CusUrMbrQuestionnaireTemplateVO vo) {
        ResponseData responseData = new ResponseData();
        List list = this.cusUrMbrQuestionnaireTemplatePOMapper.getQuestionnaireTemplate(vo);
        responseData.setData((Object)list);
        return responseData;
    }

    public ResponseData<CusUrMbrQuestionnaireTemplatePO> getQuestionnaireTemplateByCode(CusUrMbrQuestionnaireTemplateVO vo) {
        ResponseData responseData = new ResponseData();
        CusUrMbrQuestionnaireTemplatePO cusUrMbrQuestionnaireTemplatePO = this.cusUrMbrQuestionnaireTemplatePOMapper.getQuestionnaireTemplateByCode(vo);
        responseData.setData((Object)cusUrMbrQuestionnaireTemplatePO);
        return responseData;
    }

    public ResponseData<PageInfo<CusUrMbrQuestionnaireTemplatePO>> getQuestionnaireTemplateList(CusUrMbrQuestionnaireTemplateVO vo) {
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        List list = this.cusUrMbrQuestionnaireTemplatePOMapper.selectByVo(vo);
        PageInfo pageInfo = new PageInfo(list);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<String> saveTemplate(EvaluationSaveTempRequestVO vo, SysAccountPO sysAccountPO) {
        ResponseData responseData = new ResponseData();
        CusUrMbrQuestionnaireTemplatePO po = new CusUrMbrQuestionnaireTemplatePO();
        po.setTemplateJson(JacksonUtil.bean2Json((Object)vo));
        po.setSysCompanyId(sysAccountPO.getSysCompanyId());
        po.setSysBrandId(sysAccountPO.getBrandId());
        po.setAnswerTotal(Integer.valueOf(0));
        po.setTemplateCode(UUIDGenerator.getDatetime18());
        for (CusUrMbrQuestionnaireOrderDetailPO tempvo : vo.getTemplateList()) {
            if (!"5".equals(tempvo.getTempType().toString())) continue;
            CusUrMbrQuestionnaireTemplatePOExample example = new CusUrMbrQuestionnaireTemplatePOExample();
            example.createCriteria().andTemplateNameEqualTo(tempvo.getTempTitle()).andSysCompanyIdEqualTo(sysAccountPO.getSysCompanyId()).andSysBrandIdEqualTo(sysAccountPO.getBrandId()).andValidEqualTo(SysConstants.TABLE_VALID_EFFECTIVE);
            List list = this.cusUrMbrQuestionnaireTemplatePOMapper.selectByExampleWithBLOBs(example);
            if (list != null && list.size() > 0) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u95ee\u5238\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\uff01");
                return responseData;
            }
            po.setTemplateName(tempvo.getTempTitle());
        }
        po.setDraftStatus(MbrQuestionnaireTemplateDraftStatusEnum.DRAFT.getCode());
        po.setCreateUserId(sysAccountPO.getSysAccountId());
        po.setCreateUserName(sysAccountPO.getName());
        po.setCreateDate(new Date());
        po.setValid(Boolean.valueOf(true));
        int i = this.cusUrMbrQuestionnaireTemplatePOMapper.insertSelective(po);
        if (i != 1) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return responseData;
    }

    public int editTemplate(EvaluationSaveTempRequestVO vo, SysAccountPO currentUser) {
        CusUrMbrQuestionnaireTemplatePO po = this.getTemplateByCode(vo.getTemplateCode(), currentUser);
        Assert.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{po}), (String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u6a21\u677f");
        Assert.isTrue((MbrQuestionnaireTemplateDraftStatusEnum.DRAFT.getCode() == po.getDraftStatus() ? 1 : 0) != 0, (String)"\u8be5\u6a21\u677f\u5df2\u6295\u653e");
        CusUrMbrQuestionnaireTemplatePO poUpdate = new CusUrMbrQuestionnaireTemplatePO();
        for (CusUrMbrQuestionnaireOrderDetailPO tempvo : vo.getTemplateList()) {
            if (!"5".equals(tempvo.getTempType().toString())) continue;
            CusUrMbrQuestionnaireTemplatePOExample example = new CusUrMbrQuestionnaireTemplatePOExample();
            example.createCriteria().andQuestionnaireTemplateIdNotEqualTo(po.getQuestionnaireTemplateId()).andTemplateNameEqualTo(tempvo.getTempTitle()).andSysCompanyIdEqualTo(currentUser.getSysCompanyId()).andSysBrandIdEqualTo(currentUser.getBrandId()).andValidEqualTo(SysConstants.TABLE_VALID_EFFECTIVE);
            long count = this.cusUrMbrQuestionnaireTemplatePOMapper.countByExample(example);
            Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u95ee\u5238\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\uff01");
            poUpdate.setTemplateName(tempvo.getTempTitle());
        }
        poUpdate.setQuestionnaireTemplateId(po.getQuestionnaireTemplateId());
        poUpdate.setTemplateJson(JacksonUtil.bean2Json((Object)vo));
        poUpdate.setModifiedUserId(currentUser.getSysAccountId());
        poUpdate.setModifiedUserName(currentUser.getName());
        poUpdate.setModifiedDate(new Date());
        int result = this.cusUrMbrQuestionnaireTemplatePOMapper.updateByPrimaryKeySelective(poUpdate);
        return result;
    }

    public int deleteTemplate(CusUrMbrQuestionnaireTemplatePO vo, SysAccountPO currentUser) {
        CusUrMbrQuestionnaireTemplatePO po = this.getTemplateByCode(vo.getTemplateCode(), currentUser);
        Assert.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{po}), (String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u6a21\u677f");
        if (this.haveReferenced(currentUser.getSysCompanyId(), currentUser.getBrandId(), po.getTemplateCode())) {
            throw new CustomizedException("\u8c03\u67e5\u95ee\u5377\u6a21\u677f\u5f15\u7528\u4e2d\uff0c\u5220\u9664\u5931\u8d25");
        }
        CusUrMbrQuestionnaireTemplatePO poUpdate = new CusUrMbrQuestionnaireTemplatePO();
        poUpdate.setQuestionnaireTemplateId(po.getQuestionnaireTemplateId());
        poUpdate.setValid(SysConstants.TABLE_VALID_INVALID);
        poUpdate.setModifiedUserId(currentUser.getSysAccountId());
        poUpdate.setModifiedUserName(currentUser.getName());
        poUpdate.setModifiedDate(new Date());
        int result = this.cusUrMbrQuestionnaireTemplatePOMapper.updateByPrimaryKeySelective(poUpdate);
        return result;
    }

    public int releaseTemplate(CusUrMbrQuestionnaireTemplatePO vo, SysAccountPO currentUser) {
        CusUrMbrQuestionnaireTemplatePO po = this.getTemplateByCode(vo.getTemplateCode(), currentUser);
        Assert.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{po}), (String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u6a21\u677f");
        Assert.isTrue((MbrQuestionnaireTemplateDraftStatusEnum.DRAFT.getCode() == po.getDraftStatus() ? 1 : 0) != 0, (String)"\u8be5\u6a21\u677f\u5df2\u6295\u653e");
        CusUrMbrQuestionnaireTemplatePO poUpdate = new CusUrMbrQuestionnaireTemplatePO();
        poUpdate.setQuestionnaireTemplateId(po.getQuestionnaireTemplateId());
        poUpdate.setDraftStatus(MbrQuestionnaireTemplateDraftStatusEnum.RELEASED.getCode());
        poUpdate.setModifiedUserId(currentUser.getSysAccountId());
        poUpdate.setModifiedUserName(currentUser.getName());
        poUpdate.setModifiedDate(new Date());
        int result = this.cusUrMbrQuestionnaireTemplatePOMapper.updateByPrimaryKeySelective(poUpdate);
        return result;
    }

    public CusUrMbrQuestionnaireTemplatePO getTemplateByCode(String templateCode, SysAccountPO currentUser) {
        CusUrMbrQuestionnaireTemplatePOExample example = new CusUrMbrQuestionnaireTemplatePOExample();
        example.createCriteria().andSysCompanyIdEqualTo(currentUser.getSysCompanyId()).andSysBrandIdEqualTo(currentUser.getBrandId()).andTemplateCodeEqualTo(templateCode).andValidEqualTo(SysConstants.TABLE_VALID_EFFECTIVE);
        List list = this.cusUrMbrQuestionnaireTemplatePOMapper.selectByExampleWithBLOBs(example);
        return CollectionUtils.isEmpty((Collection)list) ? null : (CusUrMbrQuestionnaireTemplatePO)list.get(0);
    }

    public ResponseData<CusUrMbrQuestionnaireOrderPO> queryAnswerOrderByTaskId(CusUrMbrQuestionnaireTemplateVO vo) {
        ResponseData responseData = new ResponseData();
        CusUrMbrQuestionnaireOrderPO cusUrMbrQuestionnaireOrderPO = this.cusUrMbrQuestionnaireOrderPOMapper.queryAnswerOrderByTaskId(vo);
        responseData.setData((Object)cusUrMbrQuestionnaireOrderPO);
        return responseData;
    }

    public ResponseData<String> addQuestionnaireTemplate(SurveyQuestionnaireVO requestVO, SysAccountPO sysAccountPO) {
        log.info("addQuestionnaireTemplate#requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        if (null == requestVO) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8c03\u67e5\u95ee\u5377\u4fe1\u606f\u4e3a\u7a7a");
            return responseData;
        }
        String templateName = requestVO.getSurveyTitle();
        if (StringUtils.isBlank((CharSequence)templateName)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8c03\u67e5\u95ee\u5377\u6807\u9898\u4e3a\u7a7a");
            return responseData;
        }
        CusUrMbrQuestionnaireTemplatePO po = new CusUrMbrQuestionnaireTemplatePO();
        po.setSysCompanyId(sysAccountPO.getSysCompanyId());
        po.setSysBrandId(sysAccountPO.getBrandId());
        po.setTemplateType(Integer.valueOf(QuestionnaireTemplateTypeEnum.NEW.getTemplateType()));
        po.setTemplateCode("TC" + UUIDGenerator.getDatetime18());
        po.setTemplateName(templateName);
        po.setTemplateJson(JacksonUtil.bean2Json((Object)requestVO));
        po.setAnswerTotal(Integer.valueOf(0));
        po.setDraftStatus(MbrQuestionnaireTemplateDraftStatusEnum.DRAFT.getCode());
        po.setCreateUserId(sysAccountPO.getSysAccountId());
        po.setCreateUserName(sysAccountPO.getName());
        po.setCreateDate(new Date());
        CusUrMbrQuestionnaireTemplatePOExample example = new CusUrMbrQuestionnaireTemplatePOExample();
        example.createCriteria().andTemplateNameEqualTo(templateName).andSysCompanyIdEqualTo(sysAccountPO.getSysCompanyId()).andSysBrandIdEqualTo(sysAccountPO.getBrandId()).andValidEqualTo(SysConstants.TABLE_VALID_EFFECTIVE);
        List list = this.cusUrMbrQuestionnaireTemplatePOMapper.selectByExampleWithBLOBs(example);
        if (list != null && list.size() > 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u95ee\u5238\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\uff01");
            return responseData;
        }
        int i = this.cusUrMbrQuestionnaireTemplatePOMapper.insertSelective(po);
        if (i > 0) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)po.getTemplateCode());
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return responseData;
    }

    public ResponseData<CusUrMbrQuestionnaireTemplatePO> getQuestionnaireTemplateDetail(CusUrMbrQuestionnaireTemplateVO vo, SysAccountPO sysAccountPO) {
        log.info("getQuestionnaireTemplateDetail#vo:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        if (null == vo || StringUtils.isBlank((CharSequence)vo.getTemplateCode())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u95ee\u5377\u6a21\u677fcode\u4e3a\u7a7a");
            return responseData;
        }
        CusUrMbrQuestionnaireTemplatePO po = this.getTemplateByCode(vo.getTemplateCode(), sysAccountPO);
        responseData.setData((Object)po);
        return responseData;
    }

    public ResponseData<String> editQuestionnaireTemplate(SurveyQuestionnaireVO requestVO, SysAccountPO sysAccountPO) {
        log.info("editQuestionnaireTemplate#requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        if (null == requestVO || StringUtils.isBlank((CharSequence)requestVO.getTemplateCode())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8c03\u67e5\u95ee\u5377\u4fe1\u606f\u4e3a\u7a7a");
            return responseData;
        }
        String templateName = requestVO.getSurveyTitle();
        if (StringUtils.isBlank((CharSequence)templateName)) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8c03\u67e5\u95ee\u5377\u6807\u9898\u4e3a\u7a7a");
            return responseData;
        }
        CusUrMbrQuestionnaireTemplatePO templatePO = this.getTemplateByCode(requestVO.getTemplateCode(), sysAccountPO);
        if (null == templatePO) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u8c03\u67e5\u95ee\u5377\u4e0d\u5b58\u5728");
            return responseData;
        }
        CusUrMbrQuestionnaireTemplatePOExample example = new CusUrMbrQuestionnaireTemplatePOExample();
        example.createCriteria().andSysCompanyIdEqualTo(sysAccountPO.getSysCompanyId()).andSysBrandIdEqualTo(sysAccountPO.getBrandId()).andValidEqualTo(SysConstants.TABLE_VALID_EFFECTIVE).andTemplateNameEqualTo(templateName).andQuestionnaireTemplateIdNotEqualTo(templatePO.getQuestionnaireTemplateId());
        List list = this.cusUrMbrQuestionnaireTemplatePOMapper.selectByExampleWithBLOBs(example);
        if (list != null && list.size() > 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u95ee\u5238\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\uff01");
            return responseData;
        }
        CusUrMbrQuestionnaireTemplatePO updatePO = new CusUrMbrQuestionnaireTemplatePO();
        updatePO.setQuestionnaireTemplateId(templatePO.getQuestionnaireTemplateId());
        updatePO.setTemplateName(templateName);
        updatePO.setTemplateJson(JacksonUtil.bean2Json((Object)requestVO));
        updatePO.setModifiedUserId(sysAccountPO.getSysAccountId());
        updatePO.setModifiedUserName(sysAccountPO.getName());
        updatePO.setModifiedDate(new Date());
        int i = this.cusUrMbrQuestionnaireTemplatePOMapper.updateByPrimaryKeySelective(updatePO);
        if (i > 0) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)templatePO.getTemplateCode());
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<Boolean> enableQuestionnaireTemplate(CusUrMbrQuestionnaireTemplateVO vo, SysAccountPO sysAccountPO) {
        log.info("enableQuestionnaireTemplate#vo:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        CusUrMbrQuestionnaireTemplatePO po = this.getTemplateByCode(vo.getTemplateCode(), sysAccountPO);
        Assert.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{po}), (String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u6a21\u677f");
        Assert.isTrue((boolean)MbrQuestionnaireTemplateDraftStatusEnum.DRAFT.getCode().equals(po.getDraftStatus()), (String)"\u6a21\u677f\u72b6\u6001\u975e\u5f85\u542f\u7528");
        ResponseData responseData = new ResponseData();
        String miniProgramCodeUrl = "";
        if (po.getTemplateType().intValue() == QuestionnaireTemplateTypeEnum.NEW.getTemplateType()) {
            try {
                String path = "pages/subPages/evaluationQuestionnaire/main";
                miniProgramCodeUrl = this.getWxUrl(sysAccountPO.getBrandId(), vo.getTemplateCode(), path);
            }
            catch (CustomizedException e) {
                log.error("\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5f02\u5e38\uff1a{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            if (StringUtils.isBlank((CharSequence)miniProgramCodeUrl)) {
                throw new CustomizedException("\u751f\u6210\u5c0f\u7a0b\u5e8f\u7801\u5931\u8d25");
            }
        }
        CusUrMbrQuestionnaireTemplatePO enableTemplatePO = new CusUrMbrQuestionnaireTemplatePO();
        enableTemplatePO.setQuestionnaireTemplateId(po.getQuestionnaireTemplateId());
        enableTemplatePO.setDraftStatus(MbrQuestionnaireTemplateDraftStatusEnum.RELEASED.getCode());
        enableTemplatePO.setMiniProgramCodeUrl(miniProgramCodeUrl);
        enableTemplatePO.setModifiedUserId(sysAccountPO.getSysAccountId());
        enableTemplatePO.setModifiedUserName(sysAccountPO.getName());
        enableTemplatePO.setModifiedDate(new Date());
        int result = this.cusUrMbrQuestionnaireTemplatePOMapper.updateByPrimaryKeySelective(enableTemplatePO);
        if (result > 0) {
            responseData.setData((Object)Boolean.TRUE);
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u542f\u7528\u95ee\u5377\u6a21\u677f\u5931\u8d25");
            responseData.setData((Object)Boolean.FALSE);
        }
        return responseData;
    }

    public ResponseData<Boolean> disableQuestionnaireTemplate(CusUrMbrQuestionnaireTemplateVO vo, SysAccountPO sysAccountPO) {
        log.info("disableQuestionnaireTemplate#vo:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        CusUrMbrQuestionnaireTemplatePO po = this.getTemplateByCode(vo.getTemplateCode(), sysAccountPO);
        Assert.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{po}), (String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u6a21\u677f");
        ResponseData responseData = new ResponseData();
        if (this.haveReferenced(sysAccountPO.getSysCompanyId(), sysAccountPO.getBrandId(), po.getTemplateCode())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u95ee\u5377\u6a21\u677f\u88ab\u5f15\u7528\u4e2d\uff0c\u7981\u7528\u5931\u8d25");
            return responseData;
        }
        CusUrMbrQuestionnaireTemplatePO disableTemplatePO = new CusUrMbrQuestionnaireTemplatePO();
        disableTemplatePO.setQuestionnaireTemplateId(po.getQuestionnaireTemplateId());
        disableTemplatePO.setDraftStatus(MbrQuestionnaireTemplateDraftStatusEnum.DISABLE.getCode());
        disableTemplatePO.setModifiedUserId(sysAccountPO.getSysAccountId());
        disableTemplatePO.setModifiedUserName(sysAccountPO.getName());
        disableTemplatePO.setModifiedDate(new Date());
        int result = this.cusUrMbrQuestionnaireTemplatePOMapper.updateByPrimaryKeySelective(disableTemplatePO);
        if (result > 0) {
            responseData.setData((Object)Boolean.TRUE);
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u7981\u7528\u95ee\u5377\u6a21\u677f\u5931\u8d25");
            responseData.setData((Object)Boolean.FALSE);
        }
        return responseData;
    }

    public ResponseData<List<QuestionnaireAnalysisVO>> getQuestionnaireTempAnalysis(QuestionnaireAnalysisRequestVO requestVO, SysAccountPO sysAccountPO) {
        log.info("getQuestionnaireTempAnalysis#requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        if (null == requestVO || StringUtils.isBlank((CharSequence)requestVO.getTemplateCode())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u6a21\u677fcode\u4e3a\u7a7a");
            return responseData;
        }
        CusUrMbrQuestionnaireTemplatePO templatePO = this.getTemplateByCode(requestVO.getTemplateCode(), sysAccountPO);
        if (null == templatePO) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u95ee\u5377\u6a21\u677f\u4e0d\u5b58\u5728");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)templatePO.getTemplateJson())) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u95ee\u5377\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a");
            return responseData;
        }
        SurveyQuestionnaireVO surveyQuestionnaireVO = (SurveyQuestionnaireVO)JSON.parseObject((String)templatePO.getTemplateJson(), SurveyQuestionnaireVO.class);
        log.info("surveyQuestionnaireVO:{}", (Object)JacksonUtil.bean2Json((Object)surveyQuestionnaireVO));
        if (null == surveyQuestionnaireVO) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u95ee\u5377\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a");
            return responseData;
        }
        long questionnaireCommitTimes = this.cusUrMbrQuestionnaireOrderPOMapper.countCommitTimes(sysAccountPO.getSysCompanyId(), sysAccountPO.getBrandId(), requestVO.getTemplateCode());
        List componentList = surveyQuestionnaireVO.getComponentList();
        ArrayList<QuestionnaireAnalysisVO> questionnaireAnalysisVOList = new ArrayList<QuestionnaireAnalysisVO>();
        for (ComponentModuleVO componentModuleVO : componentList) {
            List optionList;
            ArrayList<ComponentOptionAnalysisVO> componentOptionAnalysisVOList;
            if (!this.needAnalysis(componentModuleVO)) continue;
            QuestionnaireAnalysisVO questionnaireAnalysisVO = new QuestionnaireAnalysisVO();
            questionnaireAnalysisVO.setComponentType(componentModuleVO.getComponentType());
            questionnaireAnalysisVO.setComponentTitle(componentModuleVO.getComponentTitle());
            questionnaireAnalysisVO.setComponentRequired(componentModuleVO.getComponentRequired());
            long currentComponentFillTimes = this.cusUrMbrQuestionnaireOrderDetailPOMapper.countComponentFillTimesByParams(requestVO.getTemplateCode(), componentModuleVO.getComponentType(), componentModuleVO.getComponentTitle());
            questionnaireAnalysisVO.setAnswerPeopleTimes(currentComponentFillTimes);
            if (3 == componentModuleVO.getComponentType()) {
                questionnaireAnalysisVO.setRadioType(componentModuleVO.getRadioType());
                componentOptionAnalysisVOList = new ArrayList<ComponentOptionAnalysisVO>();
                optionList = componentModuleVO.getOptionList();
                for (ComponentOptionVO optionVO : optionList) {
                    ComponentOptionAnalysisVO optionAnalysisVO = new ComponentOptionAnalysisVO();
                    optionAnalysisVO.setOptionTitle(optionVO.getOptionTitle());
                    optionAnalysisVO.setOptionValue(optionVO.getOptionValue());
                    optionAnalysisVO.setCustomSwitch(optionVO.getCustomSwitch());
                    if (2 == componentModuleVO.getOptionsType()) {
                        optionAnalysisVO.setOptionImageUrl(optionVO.getOptionImageUrl());
                    }
                    if (BooleanUtils.isTrue((Boolean)componentModuleVO.getLabelSwitch())) {
                        optionAnalysisVO.setOptionLabels(optionVO.getOptionLabels());
                    }
                    long commitTimes = this.cusUrMbrQuestionnaireOrderDetailPOMapper.countOptionCommitTimesByParams(requestVO.getTemplateCode(), componentModuleVO.getComponentType(), componentModuleVO.getComponentTitle(), optionVO.getOptionTitle());
                    optionAnalysisVO.setCommitPeopleTimes(commitTimes);
                    optionAnalysisVO.setCommitPercentage(NumberUtil.getPercentageForTwo((long)commitTimes, (long)currentComponentFillTimes));
                    componentOptionAnalysisVOList.add(optionAnalysisVO);
                }
                questionnaireAnalysisVO.setOptionList(componentOptionAnalysisVOList);
            } else if (5 == componentModuleVO.getComponentType()) {
                questionnaireAnalysisVO.setScoreType(componentModuleVO.getScoreType());
                componentOptionAnalysisVOList = new ArrayList();
                optionList = componentModuleVO.getOptionList();
                log.info("optionList:{}", (Object)JacksonUtil.bean2Json((Object)optionList));
                long totalScore = 0L;
                long totalTimes = 0L;
                for (ComponentOptionVO optionVO : optionList) {
                    ComponentOptionAnalysisVO optionAnalysisVO = new ComponentOptionAnalysisVO();
                    optionAnalysisVO.setOptionTitle(optionVO.getOptionTitle());
                    optionAnalysisVO.setOptionValue(optionVO.getOptionValue());
                    long commitTimes = this.cusUrMbrQuestionnaireOrderDetailPOMapper.countOptionCommitTimesByParams(requestVO.getTemplateCode(), componentModuleVO.getComponentType(), componentModuleVO.getComponentTitle(), optionVO.getOptionTitle());
                    optionAnalysisVO.setCommitPeopleTimes(commitTimes);
                    optionAnalysisVO.setCommitPercentage(NumberUtil.getPercentageForTwo((long)commitTimes, (long)currentComponentFillTimes));
                    componentOptionAnalysisVOList.add(optionAnalysisVO);
                    if (optionVO.getOptionValue() != null) {
                        totalScore += (long)optionVO.getOptionValue().intValue() * commitTimes;
                    }
                    totalTimes += commitTimes;
                }
                log.info("getQuestionnaireTempAnalysis#totalScore:{},totalTimes:{}", (Object)totalScore, (Object)totalTimes);
                questionnaireAnalysisVO.setAvgScore(NumberUtil.getProportionForTwo((long)totalScore, (long)totalTimes));
                questionnaireAnalysisVO.setOptionList(componentOptionAnalysisVOList);
            } else if (componentModuleVO.getComponentType() == 4 || componentModuleVO.getComponentType() == 6) {
                componentOptionAnalysisVOList = new ArrayList();
                ComponentOptionAnalysisVO optionAnalysisVO = new ComponentOptionAnalysisVO();
                optionAnalysisVO.setOptionTitle("\u4f1a\u5458\u6570\u636e");
                componentOptionAnalysisVOList.add(optionAnalysisVO);
                questionnaireAnalysisVO.setOptionList(componentOptionAnalysisVOList);
            }
            questionnaireAnalysisVO.setAnswerPercentage(NumberUtil.getPercentageForTwo((long)currentComponentFillTimes, (long)questionnaireCommitTimes));
            questionnaireAnalysisVOList.add(questionnaireAnalysisVO);
        }
        responseData.setData(questionnaireAnalysisVOList);
        return responseData;
    }

    public ResponseData<PageInfo<CusUrMbrQuestionnaireOrderPO>> getQuestionnaireTempAnswerList(QuestionnaireAnalysisRequestVO requestVO, SysAccountPO sysAccountPO) {
        log.info("getQuestionnaireTempAnswerList#requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)requestVO.getPageNum(), (int)requestVO.getPageSize());
        List list = this.cusUrMbrQuestionnaireOrderPOMapper.getQuestionnaireTempAnswerList(requestVO, Long.valueOf(1L), Long.valueOf(1L));
        Boolean isDesensitize = this.storageCardService.getMemberDataDesensitizeByAccountConfig(sysAccountPO.getSysAccountId());
        if (isDesensitize.booleanValue() && CollectionUtils.isNotEmpty((Collection)list)) {
            for (CusUrMbrQuestionnaireOrderPO po : list) {
                po.setMemberPhone(DesensitizeUtil.encrypt((String)po.getMemberPhone()));
            }
        }
        PageInfo pageInfo = new PageInfo(list);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<Boolean> memberAnswerDetailDataExport(QuestionnaireAnalysisRequestVO requestVO, SysAccountPO sysAccountPO) {
        log.info("memberAnswerDetailDataExport#requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        try {
            ResponseData findFileTaskNumResponseData = this.fileTaskServiceRpc.findFileTaskNum(sysAccountPO.getSysAccountId());
            if (findFileTaskNumResponseData.getCode() > 0) {
                responseData.setCode(findFileTaskNumResponseData.getCode());
                responseData.setMessage(findFileTaskNumResponseData.getMessage());
                return responseData;
            }
            List cusUrMbrGiftCardVOS = this.cusUrMbrQuestionnaireOrderPOMapper.getQuestionnaireTempAnswerList(requestVO, Long.valueOf(1L), Long.valueOf(1L));
            long sum = cusUrMbrGiftCardVOS.size();
            if (sum == 0L) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage(SysResponseEnum.OPERATE_FAILED_DATA_NOT_EXISTS.getMessage());
                return responseData;
            }
            if (sum > 100000L) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u5bfc\u51fa\u5931\u8d25\uff0c\u6570\u91cf\u6700\u591a\u4e3a10\u4e07\u6761");
                return responseData;
            }
            CusUrMbrQuestionnaireTemplateVO cusUrMbrQuestionnaireTemplateVO = new CusUrMbrQuestionnaireTemplateVO();
            cusUrMbrQuestionnaireTemplateVO.setTemplateCode(requestVO.getTemplateCode());
            cusUrMbrQuestionnaireTemplateVO.setSysBrandId(requestVO.getSysBrandId());
            CusUrMbrQuestionnaireTemplatePO templatePO = this.cusUrMbrQuestionnaireTemplatePOMapper.getQuestionnaireTemplateByCode(cusUrMbrQuestionnaireTemplateVO);
            if (null == templatePO) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u95ee\u5377\u6a21\u677f\u4e0d\u5b58\u5728");
                return responseData;
            }
            SurveyQuestionnaireVO surveyQuestionnaireVO = (SurveyQuestionnaireVO)JSON.parseObject((String)templatePO.getTemplateJson(), SurveyQuestionnaireVO.class);
            if (null == surveyQuestionnaireVO) {
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u95ee\u5377\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a");
                return responseData;
            }
            List componentList = surveyQuestionnaireVO.getComponentList();
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = new FileTaskPo();
            fileTaskPo.setTaskId(taskId);
            fileTaskPo.setFileId(String.valueOf(taskId));
            fileTaskPo.setTaskTypeCode(sum + "\u6761");
            fileTaskPo.setTaskName("\u8c03\u67e5\u95ee\u5377\u4f1a\u5458\u660e\u7ec6\u5bfc\u51fa");
            fileTaskPo.setSysBrandId(sysAccountPO.getBrandId());
            fileTaskPo.setCreateUserId(sysAccountPO.getSysAccountId());
            fileTaskPo.setCreateUserName(sysAccountPO.getName());
            fileTaskPo.setFileStatus(Long.valueOf(0L));
            fileTaskPo.setFileType("EXPORT");
            fileTaskPo.setValid(Boolean.valueOf(true));
            this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(sum));
            Boolean isDesensitize = this.storageCardService.getMemberDataDesensitizeByAccountConfig(sysAccountPO.getSysAccountId());
            new Thread(() -> {
                try {
                    exportExcelUtil.setExportProcessId((Object)taskId);
                    Method method = this.cusUrMbrQuestionnaireOrderPOMapper.getClass().getMethod("getQuestionnaireTempAnswerList", QuestionnaireAnalysisRequestVO.class, Long.class, Long.class);
                    exportExcelUtil.read("cusUrMbrQuestionnaireOrderPOMapper", method, (model, row) -> {
                        if (isDesensitize.booleanValue() && null != model) {
                            model.setMemberPhone(DesensitizeUtil.encrypt((String)model.getMemberPhone()));
                        }
                        if (row.getRowNum() == 0) {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue("\u4f1a\u5458\u59d3\u540d");
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue("\u4f1a\u5458\u5361\u53f7");
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue("\u4f1a\u5458\u624b\u673a\u53f7");
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue("\u8bc4\u4ef7\u8ba2\u5355");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue("\u8bc4\u4ef7\u95e8\u5e97");
                            Cell cell7 = row.createCell(5);
                            cell7.setCellValue("\u63d0\u4ea4\u65f6\u95f4");
                            int i = 5;
                            for (ComponentModuleVO componentModuleVO : componentList) {
                                if (!this.needAnalysis(componentModuleVO)) continue;
                                Cell cell = row.createCell(++i);
                                cell.setCellValue(componentModuleVO.getComponentTitle());
                            }
                        } else {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue(model.getMemberName());
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue(model.getMemberCardNo());
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue(model.getMemberPhone());
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue(null != model.getQuestionnaireType() && model.getQuestionnaireType() == 1 ? model.getOrderNo() : "-");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue(model.getStoreName());
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue(DateUtils.dateFormatTime((Date)model.getCreateDate()));
                            SurveyQuestionnaireVO answerQuestionnaireVO = (SurveyQuestionnaireVO)JSON.parseObject((String)model.getTemplateJsonOrder(), SurveyQuestionnaireVO.class);
                            List answerComponentList = new ArrayList();
                            if (null != answerQuestionnaireVO) {
                                answerComponentList = answerQuestionnaireVO.getComponentList();
                            }
                            int i = 5;
                            for (ComponentModuleVO answerComponentModule : answerComponentList) {
                                if (!this.needAnalysis(answerComponentModule)) continue;
                                i = this.handleAnswerComponent(row, i, answerComponentModule);
                            }
                        }
                    }, new Object[]{requestVO});
                }
                catch (Exception e) {
                    log.error("\u5bfc\u51fa\u4f1a\u5458\u95ee\u5377\u660e\u7ec6\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }).start();
            new Thread(() -> ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"\u8c03\u67e5\u95ee\u5377\u4f1a\u5458\u660e\u7ec6\u5bfc\u51fa_")).start();
        }
        catch (Exception e) {
            log.error("memberAnswerDetailDataExport#error:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)Boolean.TRUE);
        responseData.setMessage("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f!");
        return responseData;
    }

    public ResponseData<Integer> checkQuestionnaireTempValid(QuestionnaireTempRequestVO vo) {
        log.info("checkQuestionnaireTempValid#vo:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        CusUrMbrQuestionnaireTemplatePOExample example = new CusUrMbrQuestionnaireTemplatePOExample();
        example.createCriteria().andSysCompanyIdEqualTo(vo.getSysCompanyId()).andSysBrandIdEqualTo(vo.getSysBrandId()).andTemplateCodeEqualTo(vo.getTemplateCode()).andValidEqualTo(SysConstants.TABLE_VALID_EFFECTIVE);
        List templateList = this.cusUrMbrQuestionnaireTemplatePOMapper.selectByExample(example);
        CusUrMbrQuestionnaireTemplatePO templatePO = null;
        if (templateList != null && templateList.size() > 0) {
            templatePO = (CusUrMbrQuestionnaireTemplatePO)templateList.get(0);
        }
        if (templatePO == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u6a21\u677f\u4e0d\u5b58\u5728");
            responseData.setData((Object)QuestionnaireTempCheckStatusEnum.NOT_EXIST.getCode());
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        if (MbrQuestionnaireTemplateDraftStatusEnum.DRAFT.getCode().equals(templatePO.getDraftStatus())) {
            responseData.setData((Object)QuestionnaireTempCheckStatusEnum.NOT_ENABLED.getCode());
        } else if (MbrQuestionnaireTemplateDraftStatusEnum.RELEASED.getCode().equals(templatePO.getDraftStatus())) {
            responseData.setData((Object)QuestionnaireTempCheckStatusEnum.COMMON.getCode());
        } else if (MbrQuestionnaireTemplateDraftStatusEnum.DISABLE.getCode().equals(templatePO.getDraftStatus())) {
            responseData.setData((Object)QuestionnaireTempCheckStatusEnum.EXPIRED.getCode());
        } else {
            responseData.setData((Object)QuestionnaireTempCheckStatusEnum.NOT_ENABLED.getCode());
        }
        return responseData;
    }

    public ResponseData<CusUrMbrQuestionnaireTemplatePO> getTemplateByOrder(CusUrMbrEvalConfigVO vo) {
        CusUrMbrEvaluationConfigPO cusUrMbrEvaluationConfigPO;
        ResponseData responseData = new ResponseData();
        ResponseData configResponseData = this.getEvalConfig(vo);
        if (((PageInfo)configResponseData.getData()).getTotal() > 0L && (cusUrMbrEvaluationConfigPO = (CusUrMbrEvaluationConfigPO)((PageInfo)configResponseData.getData()).getList().get(0)).getEvaluationType().booleanValue()) {
            CusUrMbrQuestionnaireTemplateVO cusUrMbrQuestionnaireTemplateVO = new CusUrMbrQuestionnaireTemplateVO();
            cusUrMbrQuestionnaireTemplateVO.setSysBrandId(vo.getSysBrandId());
            cusUrMbrQuestionnaireTemplateVO.setTemplateCode(cusUrMbrEvaluationConfigPO.getTemplateCode());
            responseData = this.getQuestionnaireTemplateByCode(cusUrMbrQuestionnaireTemplateVO);
        }
        return responseData;
    }

    private String getWxUrl(Long brandId, String templateCode, String wxPath) {
        CreateMiniprgmQRCodeRequestVO createParam = new CreateMiniprgmQRCodeRequestVO();
        createParam.setSysBrandId(brandId);
        createParam.setMiniProgramType("10");
        createParam.setPath(wxPath);
        createParam.setScene(templateCode);
        log.info("enableTemplate#weiXin#createParam:" + JSON.toJSONString((Object)createParam));
        ResponseData qrCodeResponseData = this.qrCodeServiceFeign.createMiniprgmQRCode(createParam);
        log.info("enableTemplate#weiXin#result:" + JSON.toJSONString((Object)qrCodeResponseData));
        return (String)qrCodeResponseData.getData();
    }

    private boolean haveReferenced(Long sysCompanyId, Long sysBrandId, String templateCode) {
        log.info("haveReferenced#templateCode:{}", (Object)templateCode);
        long configCount = this.cusUrMbrEvaluationConfigPOMapper.countReferenceConfigNumByCode(sysBrandId, templateCode);
        if (configCount > 0L) {
            return Boolean.TRUE;
        }
        ResponseData responseData = this.taskQuestionnaireServiceRpc.taskHaveReferenceTemplate(sysBrandId, templateCode);
        log.info("haveReferenced#responseData:{}", (Object)JacksonUtil.bean2Json((Object)responseData));
        if (null != responseData && BooleanUtils.isTrue((Boolean)((Boolean)responseData.getData()))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean needAnalysis(ComponentModuleVO componentModuleVO) {
        if (null == componentModuleVO) {
            return Boolean.FALSE;
        }
        if (3 == componentModuleVO.getComponentType() || 4 == componentModuleVO.getComponentType() || 5 == componentModuleVO.getComponentType() || 6 == componentModuleVO.getComponentType()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Integer handleAnswerComponent(Row row, int i, ComponentModuleVO answerComponentModule) {
        Cell cell = row.createCell(++i);
        if (null == answerComponentModule) {
            return i;
        }
        boolean tempSelect = false;
        if (null != answerComponentModule.getRadioType() && answerComponentModule.getRadioType() == 2) {
            tempSelect = true;
        }
        String cellValue = "";
        List optionList = answerComponentModule.getOptionList();
        if (answerComponentModule.getComponentType() == 3) {
            List checkedOptionList = optionList.stream().filter(item -> BooleanUtils.isTrue((Boolean)item.getChecked())).collect(Collectors.toList());
            log.info("checkedOptionList:{}", (Object)JacksonUtil.bean2Json(checkedOptionList));
            if (CollectionUtils.isNotEmpty(checkedOptionList)) {
                cellValue = this.getOptionChooseValue(checkedOptionList, tempSelect);
            }
        } else if (answerComponentModule.getComponentType() == 5) {
            cellValue = this.getOptionCheckedValue(optionList, answerComponentModule.getScoreType());
        } else if (answerComponentModule.getComponentType() == 4) {
            ComponentOptionVO dataOptionVO = (ComponentOptionVO)optionList.get(0);
            cellValue = dataOptionVO.getSelectedDate();
        } else if (answerComponentModule.getComponentType() == 6) {
            ComponentOptionVO textOptionVO = (ComponentOptionVO)optionList.get(0);
            cellValue = textOptionVO.getTextValue();
        }
        cell.setCellValue(cellValue);
        return i;
    }

    private String getOptionChooseValue(List<ComponentOptionVO> checkedOptionList, boolean tempSelect) {
        StringBuilder value = new StringBuilder();
        if (CollectionUtils.isEmpty(checkedOptionList)) {
            return value.toString();
        }
        if (!tempSelect) {
            ComponentOptionVO optionVO = checkedOptionList.get(0);
            value.append(optionVO.getOptionTitle());
            if (BooleanUtils.isTrue((Boolean)optionVO.getCustomSwitch())) {
                value.append(":").append(optionVO.getTextValue());
            }
            return value.toString();
        }
        for (ComponentOptionVO optionVO : checkedOptionList) {
            if (BooleanUtils.isTrue((Boolean)optionVO.getCustomSwitch())) {
                value.append(optionVO.getOptionTitle()).append(":").append(optionVO.getTextValue()).append("\u3001");
                continue;
            }
            value.append(optionVO.getOptionTitle()).append("\u3001");
        }
        log.info("getOptionChooseValue#value:{}", (Object)value);
        if (value.toString().endsWith("\u3001")) {
            return value.substring(0, value.toString().length() - 1);
        }
        return value.toString();
    }

    private String getOptionCheckedValue(List<ComponentOptionVO> optionList, Integer scoreType) {
        int checkedNum = 0;
        String checkedShowStr = "";
        String typeShowStr = null != scoreType && scoreType == 1 ? "\u661f" : "\u5206";
        for (ComponentOptionVO optionVO : optionList) {
            if (!BooleanUtils.isTrue((Boolean)optionVO.getChecked()) || null == optionVO.getOptionValue() || optionVO.getOptionValue() <= checkedNum) continue;
            checkedNum = optionVO.getOptionValue();
            checkedShowStr = optionVO.getOptionTitle() + "(" + checkedNum + "" + typeShowStr + ")";
        }
        return checkedShowStr;
    }
}

