/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.service.impl;

import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.customized.common.constants.SysConstants;
import com.bizvane.customized.common.system.RedisManager;
import com.bizvane.customized.common.utils.ExportExcelUtil;
import com.bizvane.customized.common.utils.StreamingExportExcelUtil;
import com.bizvane.customized.company.ur.members.service.EvaluationOrderService;
import com.bizvane.customized.company.ur.members.service.StorageCardService;
import com.bizvane.customized.facade.enums.QuestionnaireTemplateTypeEnum;
import com.bizvane.customized.facade.enums.QuestionnaireTypeEnum;
import com.bizvane.customized.facade.enums.ur.members.MbrQuestionnaireTemplateDraftStatusEnum;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderDetailPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderPO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireOrderPOExample;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePOExample;
import com.bizvane.customized.facade.models.po.CusUrQuestionnaireOrderDetailRectanglePO;
import com.bizvane.customized.facade.models.po.CusUrQuestionnaireOrderDetailRectanglePOExample;
import com.bizvane.customized.facade.models.vo.CusUrMbrQuestionnaireTemplateVO;
import com.bizvane.customized.facade.models.vo.EvaluationOrderListRequestVO;
import com.bizvane.customized.facade.models.vo.EvaluationOrderRequestVO;
import com.bizvane.customized.facade.models.vo.EvaluationRectangleListVO;
import com.bizvane.customized.facade.models.vo.EvaluationRectangleVO;
import com.bizvane.customized.facade.models.vo.EvaluationSaveTempRequestVO;
import com.bizvane.customized.facade.models.vo.EvaluationSumChoolListVO;
import com.bizvane.customized.facade.models.vo.EvaluationSumChoolVO;
import com.bizvane.customized.facade.models.vo.EvaluationSumRectangleVO;
import com.bizvane.customized.facade.models.vo.EvaluationSumVO;
import com.bizvane.customized.facade.models.vo.questionnaire.ComponentModuleVO;
import com.bizvane.customized.facade.models.vo.questionnaire.ComponentOptionVO;
import com.bizvane.customized.facade.models.vo.questionnaire.LabelVO;
import com.bizvane.customized.facade.models.vo.questionnaire.QuestionnaireTempRequestVO;
import com.bizvane.customized.facade.models.vo.questionnaire.QuestionnaireTempVO;
import com.bizvane.customized.facade.models.vo.questionnaire.SaveQuestionnaireRequestVO;
import com.bizvane.customized.facade.models.vo.questionnaire.SurveyQuestionnaireVO;
import com.bizvane.customized.mappers.CusUrMbrEvaluationConfigPOMapper;
import com.bizvane.customized.mappers.CusUrMbrQuestionnaireOrderDetailPOMapper;
import com.bizvane.customized.mappers.CusUrMbrQuestionnaireOrderPOMapper;
import com.bizvane.customized.mappers.CusUrMbrQuestionnaireTemplatePOMapper;
import com.bizvane.customized.mappers.CusUrQuestionnaireOrderDetailRectanglePOMapper;
import com.bizvane.members.facade.enums.EvaluateStatusEnum;
import com.bizvane.members.facade.service.qywxapi.MemberLabelApiService;
import com.bizvane.members.facade.service.ur.UrOrderApiService;
import com.bizvane.members.facade.ur.vo.UrOrderUpdateVo;
import com.bizvane.members.facade.utils.DesensitizeUtil;
import com.bizvane.members.facade.vo.qywx.UpdateMemberLabelVo;
import com.bizvane.mktcenterservice.models.bo.TaskAwardBO;
import com.bizvane.mktcenterservice.rpc.TaskQuestionnaireServiceRpc;
import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageHelper;
import io.searchbox.strings.StringUtils;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EvaluationOrderServiceImpl
implements EvaluationOrderService {
    private static final Logger log = LoggerFactory.getLogger(EvaluationOrderServiceImpl.class);
    @Autowired
    private CusUrMbrEvaluationConfigPOMapper cusUrMbrEvaluationConfigPOMapper;
    @Autowired
    private CusUrMbrQuestionnaireTemplatePOMapper cusUrMbrQuestionnaireTemplatePOMapper;
    @Autowired
    private CusUrMbrQuestionnaireOrderPOMapper cusUrMbrQuestionnaireOrderPOMapper;
    @Autowired
    private CusUrMbrQuestionnaireOrderDetailPOMapper cusUrMbrQuestionnaireOrderDetailPOMapper;
    @Autowired
    private CusUrQuestionnaireOrderDetailRectanglePOMapper cusUrQuestionnaireOrderDetailRectanglePOMapper;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Autowired
    private UrOrderApiService urOrderApiService;
    @Autowired
    private TaskQuestionnaireServiceRpc taskQuestionnaireServiceRpc;
    @Autowired
    private StorageCardService storageCardService;
    @Autowired
    private MemberLabelApiService memberLabelApiService;

    public ResponseData<String> save(EvaluationSaveTempRequestVO vo) {
        ResponseData responseData = new ResponseData();
        RedisClient redisClient = RedisManager.getInstince();
        boolean exists = redisClient.exists("EVALUATIONORDER" + vo.getOrderNo());
        if (exists) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.REPEAT_FAILED.getCode());
            responseData.setMessage("\u5df2\u5728\u4fdd\u5b58\u4e2d");
            return responseData;
        }
        redisClient.set("EVALUATIONORDER" + vo.getOrderNo(), (Object)"Y", Long.valueOf(300L));
        this.saveCommon(vo);
        UrOrderUpdateVo urOrderUpdateVo = new UrOrderUpdateVo();
        urOrderUpdateVo.setSysCompanyId(vo.getSysCompanyId());
        urOrderUpdateVo.setBrandId(vo.getSysBrandId());
        urOrderUpdateVo.setOrderNo(vo.getOrderNo());
        urOrderUpdateVo.setEvaluateStatusEnum(EvaluateStatusEnum.ALREADY_EVALUATE);
        this.urOrderApiService.updateOrderEvaluate(urOrderUpdateVo);
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData saveByTask(EvaluationSaveTempRequestVO vo) {
        ResponseData responseData = new ResponseData();
        RedisClient redisClient = RedisManager.getInstince();
        boolean exists = redisClient.exists("EVALUATIONTASK" + vo.getMktTaskId() + vo.getMemberCode());
        if (exists) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.REPEAT_FAILED.getCode());
            responseData.setMessage("\u5df2\u5728\u63d0\u4ea4\u4e2d");
            return responseData;
        }
        redisClient.set("EVALUATIONTASK" + vo.getMktTaskId() + vo.getMemberCode(), (Object)"Y", Long.valueOf(300L));
        this.saveCommon(vo);
        TaskAwardBO taskAwardBO = new TaskAwardBO();
        taskAwardBO.setSysCompanyId(vo.getSysCompanyId());
        taskAwardBO.setSysBrandId(vo.getSysBrandId());
        taskAwardBO.setPropertyCode(vo.getMemberCode());
        taskAwardBO.setMktTaskId(vo.getMktTaskId());
        return this.taskQuestionnaireServiceRpc.doTaskQuestionnaire(taskAwardBO);
    }

    private void saveCommonChildren(CusUrMbrQuestionnaireOrderPO orderPO, String tempSkipValueJson) throws JSONException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tempSkipValueJson)) {
            return;
        }
        com.alibaba.fastjson.JSONArray tempSkipValueArr = com.alibaba.fastjson.JSONArray.parseArray((String)tempSkipValueJson);
        if (tempSkipValueArr == null) {
            return;
        }
        for (int i = 0; i < tempSkipValueArr.size(); ++i) {
            String tempSkipValueStr = tempSkipValueArr.getString(i);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tempSkipValueStr) || "{}".equals(tempSkipValueStr) || com.alibaba.fastjson.JSONObject.parseObject((String)tempSkipValueStr).size() <= 0) {
                return;
            }
            CusUrMbrQuestionnaireOrderDetailPO detailChildrenPO = (CusUrMbrQuestionnaireOrderDetailPO)com.alibaba.fastjson.JSONObject.parseObject((String)tempSkipValueStr, CusUrMbrQuestionnaireOrderDetailPO.class);
            detailChildrenPO.setCreateDate(new Date());
            detailChildrenPO.setSysCompanyId(orderPO.getSysCompanyId());
            detailChildrenPO.setSysBrandId(orderPO.getSysBrandId());
            detailChildrenPO.setTemplateCode(orderPO.getTemplateCode());
            detailChildrenPO.setTemplateName(orderPO.getTemplateName());
            detailChildrenPO.setOrderNo(orderPO.getOrderNo());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailChildrenPO.getTempContent())) {
                JSONArray arr = new JSONArray(detailChildrenPO.getTempContent());
                for (int j = 0; j < arr.length(); ++j) {
                    JSONObject jsonObject = arr.getJSONObject(j);
                    Iterator it = jsonObject.keys();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        detailChildrenPO.setTempName(key);
                        detailChildrenPO.setTempContent(jsonObject.getString(key));
                    }
                    this.cusUrMbrQuestionnaireOrderDetailPOMapper.insertSelective(detailChildrenPO);
                }
            }
            this.saveCommonChildren(orderPO, detailChildrenPO.getTempSkipValueJson());
        }
    }

    private void saveCommon(EvaluationSaveTempRequestVO vo) {
        CusUrMbrQuestionnaireOrderPO po = (CusUrMbrQuestionnaireOrderPO)JacksonUtil.json2Objs((String)com.alibaba.fastjson.JSONObject.toJSONString((Object)vo), CusUrMbrQuestionnaireOrderPO.class);
        po.setCreateDate(new Date());
        this.cusUrMbrQuestionnaireOrderPOMapper.insertSelective(po);
        for (CusUrMbrQuestionnaireOrderDetailPO detailPO : vo.getTemplateList()) {
            detailPO.setCreateDate(new Date());
            detailPO.setSysCompanyId(po.getSysCompanyId());
            detailPO.setSysBrandId(po.getSysBrandId());
            detailPO.setTemplateCode(po.getTemplateCode());
            detailPO.setTemplateName(po.getTemplateName());
            detailPO.setOrderNo(po.getOrderNo());
            if (detailPO.getTempType() == 1) {
                try {
                    JSONArray arr = new JSONArray(detailPO.getTempContent());
                    for (int i = 0; i < arr.length(); ++i) {
                        JSONObject jsonObject = arr.getJSONObject(i);
                        Iterator it = jsonObject.keys();
                        while (it.hasNext()) {
                            String key = (String)it.next();
                            detailPO.setTempName(key);
                            detailPO.setTempContent(jsonObject.getString(key));
                        }
                        this.cusUrMbrQuestionnaireOrderDetailPOMapper.insertSelective(detailPO);
                    }
                    this.saveCommonChildren(po, detailPO.getTempSkipValueJson());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (detailPO.getTempType() == 7) {
                try {
                    String[] split;
                    String tempContent;
                    CusUrQuestionnaireOrderDetailRectanglePO rectangPO;
                    String key;
                    Iterator it;
                    JSONObject jsonObject;
                    int i;
                    Boolean isSave = false;
                    CusUrQuestionnaireOrderDetailRectanglePOExample example = new CusUrQuestionnaireOrderDetailRectanglePOExample();
                    example.createCriteria().andTemplateCodeEqualTo(detailPO.getTemplateCode()).andSysBrandIdEqualTo(detailPO.getSysBrandId()).andSysCompanyIdEqualTo(detailPO.getSysCompanyId()).andTempSerialEqualTo(detailPO.getTempSerial());
                    List rectanglePOList = this.cusUrQuestionnaireOrderDetailRectanglePOMapper.selectByExample(example);
                    if (rectanglePOList != null && rectanglePOList.size() > 0) {
                        isSave = true;
                    }
                    JSONArray row = new JSONArray(detailPO.getTempName());
                    JSONArray arr = new JSONArray(detailPO.getTempContent());
                    for (i = 0; i < row.length(); ++i) {
                        jsonObject = row.getJSONObject(i);
                        it = jsonObject.keys();
                        if (it.hasNext()) {
                            key = (String)it.next();
                            rectangPO = new CusUrQuestionnaireOrderDetailRectanglePO();
                            rectangPO.setColName(key);
                            rectangPO.setColSerial(Integer.valueOf(i + 1));
                            rectangPO.setTemplateCode(detailPO.getTemplateCode());
                            rectangPO.setTemplateName(detailPO.getTemplateName());
                            rectangPO.setTempSerial(detailPO.getTempSerial());
                            rectangPO.setSysCompanyId(detailPO.getSysCompanyId());
                            rectangPO.setSysBrandId(detailPO.getSysBrandId());
                            rectangPO.setTempTitle(detailPO.getTempTitle());
                            rectangPO.setTempDetail(detailPO.getTempDetail());
                            rectangPO.setTempStyle(detailPO.getTempStyle());
                            rectangPO.setValid(Boolean.valueOf(true));
                            tempContent = jsonObject.getString(key);
                            if (StringUtils.isNotBlank((CharSequence)tempContent) && tempContent.contains(",")) {
                                tempContent = tempContent.substring(1, tempContent.length() - 1);
                                split = tempContent.split(",");
                                for (int l = 0; l < split.length; ++l) {
                                    rectangPO.setLineSerial(Integer.valueOf(l + 1));
                                    Integer content = Integer.parseInt(split[l]);
                                    if (content > 0 && isSave.booleanValue()) {
                                        rectangPO.setCheckNumber(Integer.valueOf(1));
                                        rectangPO.setModifiedDate(new Date());
                                        this.cusUrQuestionnaireOrderDetailRectanglePOMapper.updateCheckNumber(rectangPO);
                                        continue;
                                    }
                                    if (isSave.booleanValue()) continue;
                                    if (content > 0) {
                                        rectangPO.setCheckNumber(Integer.valueOf(1));
                                    } else {
                                        rectangPO.setCheckNumber(Integer.valueOf(0));
                                    }
                                    rectangPO.setOrderNo(detailPO.getOrderNo());
                                    rectangPO.setCreateDate(new Date());
                                    this.cusUrQuestionnaireOrderDetailRectanglePOMapper.insertSelective(rectangPO);
                                }
                                continue;
                            }
                            log.error("temp order answer line is error! columnName:{},orderNo:{},templateCode:{}", new Object[]{key, detailPO.getOrderNo(), detailPO.getTemplateCode()});
                            continue;
                        }
                        log.error("temp order answer column is error! orderNo:{},templateCode:{}", (Object)detailPO.getOrderNo(), (Object)detailPO.getTemplateCode());
                    }
                    if (isSave.booleanValue()) continue;
                    for (i = 0; i < arr.length(); ++i) {
                        jsonObject = arr.getJSONObject(i);
                        it = jsonObject.keys();
                        if (it.hasNext()) {
                            key = (String)it.next();
                            rectangPO = new CusUrQuestionnaireOrderDetailRectanglePO();
                            rectangPO.setSysCompanyId(detailPO.getSysCompanyId());
                            rectangPO.setSysBrandId(detailPO.getSysBrandId());
                            rectangPO.setOrderNo(detailPO.getOrderNo());
                            rectangPO.setTemplateCode(detailPO.getTemplateCode());
                            rectangPO.setTempSerial(detailPO.getTempSerial());
                            rectangPO.setLineSerial(Integer.valueOf(i + 1));
                            rectangPO.setLineName(key);
                            tempContent = jsonObject.getString(key);
                            if (StringUtils.isNotBlank((CharSequence)tempContent) && tempContent.contains(",")) {
                                tempContent = tempContent.substring(1, tempContent.length() - 1);
                                split = tempContent.split(",");
                                for (int c = 0; c < split.length; ++c) {
                                    rectangPO.setColSerial(Integer.valueOf(c + 1));
                                    this.cusUrQuestionnaireOrderDetailRectanglePOMapper.updateLineNameBySerial(rectangPO);
                                }
                                continue;
                            }
                            log.error("temp order answer line is error! LineName:{},orderNo:{},templateCode:{}", new Object[]{key, detailPO.getOrderNo(), detailPO.getTemplateCode()});
                            continue;
                        }
                        log.error("temp order answer line is error! orderNo:{},templateCode:{}", (Object)detailPO.getOrderNo(), (Object)detailPO.getTemplateCode());
                    }
                    continue;
                }
                catch (JSONException e) {
                    log.error("error:" + (Object)((Object)e));
                    e.printStackTrace();
                    continue;
                }
            }
            this.cusUrMbrQuestionnaireOrderDetailPOMapper.insertSelective(detailPO);
        }
        CusUrMbrQuestionnaireTemplatePO cusUrMbrQuestionnaireTemplatePo = new CusUrMbrQuestionnaireTemplatePO();
        cusUrMbrQuestionnaireTemplatePo.setSysCompanyId(vo.getSysCompanyId());
        cusUrMbrQuestionnaireTemplatePo.setSysBrandId(vo.getSysBrandId());
        cusUrMbrQuestionnaireTemplatePo.setTemplateCode(vo.getTemplateCode());
        this.cusUrMbrQuestionnaireTemplatePOMapper.updateAnswerByTemplateCode(cusUrMbrQuestionnaireTemplatePo);
    }

    public ResponseData<CusUrMbrQuestionnaireOrderPO> getAnswerOrderDetail(EvaluationOrderRequestVO vo) {
        log.info("enter EvaluationOrderServiceImpl getAnswerOrderDetail param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        CusUrMbrQuestionnaireOrderPOExample example = new CusUrMbrQuestionnaireOrderPOExample();
        example.createCriteria().andSysCompanyIdEqualTo(vo.getSysCompanyId()).andSysBrandIdEqualTo(vo.getSysBrandId()).andOrderNoEqualTo(vo.getOrderNo());
        List selectByExample = this.cusUrMbrQuestionnaireOrderPOMapper.selectByExample(example);
        if (selectByExample != null && selectByExample.size() > 0) {
            responseData.setData(selectByExample.get(0));
        } else {
            responseData.setData(null);
        }
        return responseData;
    }

    public ResponseData<PageInfo<CusUrMbrQuestionnaireOrderPO>> getAnswerOrderListExport(EvaluationOrderListRequestVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        try {
            ResponseData findFileTaskNumResponseData = this.fileTaskServiceRpc.findFileTaskNum(sysAccountPO.getSysAccountId());
            if (findFileTaskNumResponseData.getCode() > 0) {
                responseData.setCode(findFileTaskNumResponseData.getCode());
                responseData.setMessage(findFileTaskNumResponseData.getMessage());
                return responseData;
            }
            CusUrMbrQuestionnaireTemplateVO cusUrMbrQuestionnaireTemplateVO = new CusUrMbrQuestionnaireTemplateVO();
            cusUrMbrQuestionnaireTemplateVO.setTemplateCode(vo.getTemplateCode());
            cusUrMbrQuestionnaireTemplateVO.setSysBrandId(vo.getSysBrandId());
            CusUrMbrQuestionnaireTemplatePO cusUrMbrQuestionnaireTemplatePO = this.cusUrMbrQuestionnaireTemplatePOMapper.getQuestionnaireTemplateByCode(cusUrMbrQuestionnaireTemplateVO);
            com.alibaba.fastjson.JSONObject templateListJson = com.alibaba.fastjson.JSONObject.parseObject((String)cusUrMbrQuestionnaireTemplatePO.getTemplateJson());
            List templateList = com.alibaba.fastjson.JSONObject.parseArray((String)templateListJson.get((Object)"templateList").toString(), CusUrMbrQuestionnaireOrderDetailPO.class);
            List cusUrMbrGiftCardVOS = this.cusUrMbrQuestionnaireOrderPOMapper.getAnswerOrderList(vo, Long.valueOf(1L), Long.valueOf(1L));
            long sum = cusUrMbrGiftCardVOS.size();
            if (sum > 100000L) {
                responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u5bfc\u51fa\u5931\u8d25\uff0c\u6570\u91cf\u6700\u591a\u4e3a10\u4e07\u6761");
                return responseData;
            }
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = new FileTaskPo();
            fileTaskPo.setTaskId(taskId);
            fileTaskPo.setFileId(String.valueOf(taskId));
            fileTaskPo.setTaskTypeCode(sum + "\u6761");
            fileTaskPo.setTaskName("\u95ee\u5238\u8ba2\u5355\u8bc4\u4ef7\u4fe1\u606f");
            if (sysAccountPO != null) {
                fileTaskPo.setSysBrandId(sysAccountPO.getBrandId());
                fileTaskPo.setCreateUserId(sysAccountPO.getSysAccountId());
                fileTaskPo.setCreateUserName(sysAccountPO.getName());
            }
            fileTaskPo.setFileStatus(Long.valueOf(0L));
            fileTaskPo.setFileType("EXPORT");
            fileTaskPo.setValid(Boolean.valueOf(true));
            this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(sum));
            Boolean isDesensitize = this.storageCardService.getMemberDataDesensitizeByAccountConfig(sysAccountPO.getSysAccountId());
            new Thread(() -> {
                try {
                    exportExcelUtil.setExportProcessId((Object)taskId);
                    Method method = this.cusUrMbrQuestionnaireOrderPOMapper.getClass().getMethod("getAnswerOrderList", EvaluationOrderListRequestVO.class, Long.class, Long.class);
                    exportExcelUtil.read("cusUrMbrQuestionnaireOrderPOMapper", method, (model, row) -> {
                        if (isDesensitize.booleanValue() && null != model) {
                            model.setMemberPhone(DesensitizeUtil.encrypt((String)model.getMemberPhone()));
                        }
                        if (row.getRowNum() == 0) {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue("\u4f1a\u5458\u59d3\u540d");
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue("\u4f1a\u5458\u5361\u53f7");
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue("\u4f1a\u5458\u624b\u673a\u53f7");
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue("\u8bc4\u4ef7\u8ba2\u5355");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue("\u8bc4\u4ef7\u95e8\u5e97");
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue("\u8bc4\u4ef7\u5bfc\u8d2d");
                            Cell cell6 = row.createCell(6);
                            cell6.setCellValue("\u5bfc\u8d2d\u7f16\u53f7");
                            Cell cell7 = row.createCell(7);
                            cell7.setCellValue("\u63d0\u4ea4\u65f6\u95f4");
                            int i = 7;
                            for (CusUrMbrQuestionnaireOrderDetailPO orderDetail : templateList) {
                                if ("1".equals(orderDetail.getTempType().toString())) {
                                    try {
                                        i = this.handleTemplateChoiceQuestion(row, i, orderDetail, Boolean.valueOf(true));
                                    }
                                    catch (Exception e) {
                                        log.error("method handleTemplateChoiceQuestion error:" + e.getMessage());
                                        e.printStackTrace();
                                    }
                                    continue;
                                }
                                if ("7".equals(orderDetail.getTempType().toString())) {
                                    try {
                                        i = this.handleTemplateContentQuestion(row, i, orderDetail, Boolean.valueOf(true));
                                    }
                                    catch (Exception e) {
                                        log.error("method handleTemplateContentQuestion title error:" + ExceptionUtils.getStackTrace((Throwable)e));
                                    }
                                    continue;
                                }
                                if (!"235".contains(orderDetail.getTempType().toString())) continue;
                                Cell cell = row.createCell(++i);
                                cell.setCellValue(orderDetail.getTempTitle());
                            }
                        } else {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue(model.getMemberName());
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue(model.getMemberCode());
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue(model.getMemberPhone());
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue(model.getOrderNo());
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue(model.getStoreName());
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue(model.getShopGuideName());
                            Cell cell6 = row.createCell(6);
                            cell6.setCellValue(model.getShopGuideCode());
                            Cell cell7 = row.createCell(7);
                            cell7.setCellValue(DateUtils.dateFormatTime((Date)model.getCreateDate()));
                            com.alibaba.fastjson.JSONObject templateListJs = com.alibaba.fastjson.JSONObject.parseObject((String)model.getTemplateJsonOrder());
                            List list = com.alibaba.fastjson.JSONObject.parseArray((String)templateListJs.get((Object)"templateList").toString(), CusUrMbrQuestionnaireOrderDetailPO.class);
                            int i = 7;
                            for (CusUrMbrQuestionnaireOrderDetailPO orderDetail : list) {
                                if ("1".equals(orderDetail.getTempType().toString())) {
                                    try {
                                        i = this.handleTemplateChoiceQuestion(row, i, orderDetail, Boolean.valueOf(false));
                                    }
                                    catch (Exception e) {
                                        log.error("method handleTemplateChoiceQuestion error:" + e.getMessage());
                                        e.printStackTrace();
                                    }
                                    continue;
                                }
                                if ("7".equals(orderDetail.getTempType().toString())) {
                                    try {
                                        i = this.handleTemplateContentQuestion(row, i, orderDetail, Boolean.valueOf(false));
                                    }
                                    catch (Exception e) {
                                        log.error("method handleTemplateContentQuestion value error:" + ExceptionUtils.getStackTrace((Throwable)e));
                                    }
                                    continue;
                                }
                                if (!"235".contains(orderDetail.getTempType().toString())) continue;
                                Cell cell = row.createCell(++i);
                                if (orderDetail.getTempType() == 5) continue;
                                cell.setCellValue(orderDetail.getTempContent());
                            }
                        }
                    }, new Object[]{vo});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
            new Thread(() -> ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"\u95ee\u5238\u8ba2\u5355\u8bc4\u4ef7\u5bfc\u51fa_")).start();
        }
        catch (Exception e) {
            log.error("method getAnswerOrderListExport error:" + e.getMessage());
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f!");
        return responseData;
    }

    public ResponseData<PageInfo<CusUrMbrQuestionnaireOrderPO>> getAnswerOrderList(EvaluationOrderListRequestVO vo, SysAccountPO sysAccountPO) {
        ResponseData responseData = new ResponseData();
        PageHelper.startPage((int)vo.getPageNum(), (int)vo.getPageSize());
        List list = this.cusUrMbrQuestionnaireOrderPOMapper.getAnswerOrderList(vo, Long.valueOf(1L), Long.valueOf(1L));
        Boolean isDesensitize = this.storageCardService.getMemberDataDesensitizeByAccountConfig(sysAccountPO.getSysAccountId());
        if (isDesensitize.booleanValue() && CollectionUtils.isNotEmpty((Collection)list)) {
            for (CusUrMbrQuestionnaireOrderPO po : list) {
                po.setMemberPhone(DesensitizeUtil.encrypt((String)po.getMemberPhone()));
            }
        }
        PageInfo pageInfo = new PageInfo(list);
        responseData.setData((Object)pageInfo);
        return responseData;
    }

    public ResponseData<EvaluationSumVO> getAnswerSum(@Valid EvaluationOrderListRequestVO vo) {
        CusUrMbrQuestionnaireOrderDetailPO po2;
        EvaluationSumVO evaluationSumVO = new EvaluationSumVO();
        ResponseData responseData = new ResponseData();
        List list = this.cusUrMbrQuestionnaireOrderPOMapper.getAnswerSum(vo);
        ArrayList<EvaluationSumChoolListVO> allList = new ArrayList<EvaluationSumChoolListVO>();
        ArrayList<EvaluationSumChoolVO> choolList = new ArrayList<EvaluationSumChoolVO>();
        ArrayList<EvaluationRectangleListVO> rectangList = new ArrayList<EvaluationRectangleListVO>();
        CusUrMbrQuestionnaireTemplatePOExample templatePOExample = new CusUrMbrQuestionnaireTemplatePOExample();
        templatePOExample.createCriteria().andSysCompanyIdEqualTo(vo.getSysCompanyId()).andSysBrandIdEqualTo(vo.getSysBrandId()).andTemplateCodeEqualTo(vo.getTemplateCode());
        List cusUrMbrQuestionnaireTemplatePOList = this.cusUrMbrQuestionnaireTemplatePOMapper.selectByExample(templatePOExample);
        CusUrMbrQuestionnaireTemplatePO cusUrMbrQuestionnaireTemplatePO = (CusUrMbrQuestionnaireTemplatePO)cusUrMbrQuestionnaireTemplatePOList.get(0);
        Integer allNum = cusUrMbrQuestionnaireTemplatePO.getAnswerTotal();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(2);
        numberFormat.setMaximumFractionDigits(2);
        String serialNo = "";
        if (list.size() > 0) {
            serialNo = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)((CusUrMbrQuestionnaireOrderDetailPO)list.get(0)).getTempSerialParent(), (CharSequence)"") + ((CusUrMbrQuestionnaireOrderDetailPO)list.get(0)).getTempSerial();
        }
        String chooseTempDetail = null;
        String chooseTempTitle = null;
        Boolean tempSelect = false;
        for (CusUrMbrQuestionnaireOrderDetailPO po2 : list) {
            String serialNoCurr = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)po2.getTempSerialParent(), (CharSequence)"") + po2.getTempSerial();
            if (!serialNo.equals(serialNoCurr)) {
                EvaluationSumChoolListVO bigvo = new EvaluationSumChoolListVO();
                bigvo.setTempDetail(chooseTempDetail);
                bigvo.setTempTitle(chooseTempTitle);
                bigvo.setAllsum(allNum);
                bigvo.setTempSelect(tempSelect);
                ArrayList choolnew = new ArrayList(choolList);
                bigvo.setList(choolnew);
                allList.add(bigvo);
                choolList.clear();
            }
            serialNo = serialNoCurr;
            EvaluationSumChoolVO voChool = new EvaluationSumChoolVO();
            voChool.setTempTitle(po2.getTempTitle());
            voChool.setTempDetail(po2.getTempDetail());
            voChool.setTempName(po2.getTempName());
            Integer chooseNumber = Integer.parseInt(po2.getTempContent());
            voChool.setChooseNumber(chooseNumber);
            voChool.setPercentage(numberFormat.format((float)chooseNumber.intValue() / (float)allNum.intValue() * 100.0f) + "%");
            choolList.add(voChool);
            chooseTempTitle = po2.getTempTitle();
            chooseTempDetail = po2.getTempDetail();
            tempSelect = po2.getTempSelect();
        }
        if (list.size() > 1) {
            EvaluationSumChoolListVO bigvo = new EvaluationSumChoolListVO();
            bigvo.setTempDetail(chooseTempDetail);
            bigvo.setTempTitle(chooseTempTitle);
            bigvo.setTempSelect(tempSelect);
            bigvo.setAllsum(allNum);
            bigvo.setList(choolList);
            allList.add(bigvo);
        }
        List listsCore = this.cusUrMbrQuestionnaireOrderPOMapper.getAnswerSumCore(vo);
        listsCore.forEach(core -> {
            core.setAcontentSumPer(numberFormat.format(Float.parseFloat(core.getAcontentSum()) / Float.parseFloat(core.getAllsum()) * 100.0f) + "%");
            core.setBcontentSumPer(numberFormat.format(Float.parseFloat(core.getBcontentSum()) / Float.parseFloat(core.getAllsum()) * 100.0f) + "%");
            core.setCcontentSumPer(numberFormat.format(Float.parseFloat(core.getCcontentSum()) / Float.parseFloat(core.getAllsum()) * 100.0f) + "%");
            core.setDcontentSumPer(numberFormat.format(Float.parseFloat(core.getDcontentSum()) / Float.parseFloat(core.getAllsum()) * 100.0f) + "%");
            core.setEcontentSumPer(numberFormat.format(Float.parseFloat(core.getEcontentSum()) / Float.parseFloat(core.getAllsum()) * 100.0f) + "%");
        });
        po2 = new CusUrQuestionnaireOrderDetailRectanglePO();
        po2.setSysCompanyId(vo.getSysCompanyId());
        po2.setSysBrandId(vo.getSysBrandId());
        po2.setTemplateCode(vo.getTemplateCode());
        List tempSerials = this.cusUrQuestionnaireOrderDetailRectanglePOMapper.getTempSerialByTempCode((CusUrQuestionnaireOrderDetailRectanglePO)po2);
        if (tempSerials != null && tempSerials.size() > 0) {
            numberFormat.setMinimumFractionDigits(0);
            numberFormat.setMaximumFractionDigits(0);
            for (Byte tempSerial : tempSerials) {
                po2.setTempSerial(tempSerial);
                EvaluationRectangleListVO rectangleListVO = new EvaluationRectangleListVO();
                ArrayList<EvaluationRectangleVO> evaluationRectangleVOList = new ArrayList<EvaluationRectangleVO>();
                List colNames = this.cusUrQuestionnaireOrderDetailRectanglePOMapper.getColNameByTempCode((CusUrQuestionnaireOrderDetailRectanglePO)po2);
                rectangleListVO.setColNameList(colNames);
                List lineNames = this.cusUrQuestionnaireOrderDetailRectanglePOMapper.getLineNameByTempCode((CusUrQuestionnaireOrderDetailRectanglePO)po2);
                rectangleListVO.setLineNameList(lineNames);
                List squareAnswerSumList = this.cusUrQuestionnaireOrderDetailRectanglePOMapper.getColAndLineData((CusUrQuestionnaireOrderDetailRectanglePO)po2);
                rectangleListVO.setTempTitle(((CusUrQuestionnaireOrderDetailRectanglePO)squareAnswerSumList.get(0)).getTempTitle());
                rectangleListVO.setTempDetail(((CusUrQuestionnaireOrderDetailRectanglePO)squareAnswerSumList.get(0)).getTempDetail());
                List colSumList = this.cusUrQuestionnaireOrderDetailRectanglePOMapper.getColSumByTempCode((CusUrQuestionnaireOrderDetailRectanglePO)po2);
                Map<Integer, Integer> colMap = colSumList.stream().collect(Collectors.toMap(EvaluationSumRectangleVO::getColSerial, EvaluationSumRectangleVO::getColSum));
                List lineSumList = this.cusUrQuestionnaireOrderDetailRectanglePOMapper.getLineSumByTempCOde((CusUrQuestionnaireOrderDetailRectanglePO)po2);
                Map<Integer, Integer> lineMap = lineSumList.stream().collect(Collectors.toMap(EvaluationSumRectangleVO::getLineSerial, EvaluationSumRectangleVO::getLineSum));
                for (CusUrQuestionnaireOrderDetailRectanglePO rectanglePO : squareAnswerSumList) {
                    String lineNumber;
                    EvaluationRectangleVO rectangleVO = new EvaluationRectangleVO();
                    rectangleVO.setTempTitle(rectanglePO.getTempTitle());
                    rectangleVO.setTempDetail(rectanglePO.getTempDetail());
                    rectangleVO.setColSerial(rectanglePO.getColSerial());
                    rectangleVO.setColName(rectanglePO.getColName());
                    rectangleVO.setLineSerial(rectanglePO.getLineSerial());
                    rectangleVO.setLineName(rectanglePO.getLineName());
                    rectangleVO.setCheckNumber(rectanglePO.getCheckNumber());
                    String checkNumber = StringUtil.valueOf((Object)rectanglePO.getCheckNumber());
                    if (rectanglePO.getTempStyle() == 1) {
                        lineNumber = StringUtil.valueOf((Object)lineMap.get(rectanglePO.getLineSerial()));
                        String linePercentage = "0%";
                        if (!"0".equals(lineNumber)) {
                            linePercentage = numberFormat.format(Float.parseFloat(checkNumber) / Float.parseFloat(lineNumber) * 100.0f) + "%";
                        }
                        rectangleVO.setPercentage(linePercentage);
                    } else if (rectanglePO.getTempStyle() == 2) {
                        String colNumber = StringUtil.valueOf((Object)colMap.get(rectanglePO.getColSerial()));
                        String colPercentage = "0%";
                        if (!"0".equals(colNumber)) {
                            colPercentage = numberFormat.format(Float.parseFloat(checkNumber) / Float.parseFloat(colNumber) * 100.0f) + "%";
                        }
                        rectangleVO.setPercentage(colPercentage);
                    } else {
                        lineNumber = StringUtil.valueOf((Object)lineMap.get(rectanglePO.getLineSerial()));
                        String colNumber = StringUtil.valueOf((Object)colMap.get(rectanglePO.getColSerial()));
                        String linePercentage = "0%";
                        String colPercentage = "0%";
                        if (!"0".equals(lineNumber)) {
                            linePercentage = numberFormat.format(Float.parseFloat(checkNumber) / Float.parseFloat(lineNumber) * 100.0f) + "%";
                        }
                        if (!"0".equals(colNumber)) {
                            colPercentage = numberFormat.format(Float.parseFloat(checkNumber) / Float.parseFloat(colNumber) * 100.0f) + "%";
                        }
                        rectangleVO.setPercentage(linePercentage + "/" + colPercentage);
                    }
                    evaluationRectangleVOList.add(rectangleVO);
                }
                rectangleListVO.setEvaluationRectangleVOList(evaluationRectangleVOList);
                rectangList.add(rectangleListVO);
            }
        }
        evaluationSumVO.setEvaluationSumChoolList(allList);
        evaluationSumVO.setEvaluationSumChoolCoreList(listsCore);
        evaluationSumVO.setEvaluationRectangleListVOList(rectangList);
        responseData.setData((Object)evaluationSumVO);
        return responseData;
    }

    public ResponseData<String> saveCommonQuestionnaire(SaveQuestionnaireRequestVO vo) {
        log.info("saveCommonQuestionnaire#vo:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        CusUrMbrQuestionnaireOrderPOExample example = new CusUrMbrQuestionnaireOrderPOExample();
        example.createCriteria().andSysCompanyIdEqualTo(vo.getSysCompanyId()).andSysBrandIdEqualTo(vo.getSysBrandId()).andTemplateCodeEqualTo(vo.getTemplateCode()).andQuestionnaireTypeEqualTo(Integer.valueOf(QuestionnaireTypeEnum.QUESTIONNAIRE_TEMP.getType())).andMemberCodeEqualTo(vo.getMemberCode()).andValidEqualTo(Boolean.TRUE);
        long count = this.cusUrMbrQuestionnaireOrderPOMapper.countByExample(example);
        if (count > 0L) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5df2\u7ecf\u586b\u5199\u8fc7\u8be5\u95ee\u5377");
            return responseData;
        }
        ResponseData checkResponseData = this.checkQuestionnaireTempValid(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getTemplateCode());
        if (com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode() != checkResponseData.getCode()) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(checkResponseData.getMessage());
            return responseData;
        }
        List labelVOList = this.saveCommonQuestionnaire(vo, QuestionnaireTypeEnum.QUESTIONNAIRE_TEMP);
        if (CollectionUtils.isNotEmpty((Collection)labelVOList)) {
            this.handleMemberLabels(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getMemberCode(), labelVOList);
        }
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData<String> saveOrderQuestionnaire(SaveQuestionnaireRequestVO vo) {
        log.info("saveOrderQuestionnaire#vo:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        RedisClient redisClient = RedisManager.getInstince();
        boolean exists = redisClient.exists("EVALUATIONORDER" + vo.getOrderNo());
        if (exists) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.REPEAT_FAILED.getCode());
            responseData.setMessage("\u5df2\u5728\u4fdd\u5b58\u4e2d");
            return responseData;
        }
        ResponseData checkResponseData = this.checkQuestionnaireTempValid(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getTemplateCode());
        if (com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode() != checkResponseData.getCode()) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(checkResponseData.getMessage());
            return responseData;
        }
        redisClient.set("EVALUATIONORDER" + vo.getOrderNo(), (Object)"Y", Long.valueOf(300L));
        List labelVOList = this.saveCommonQuestionnaire(vo, QuestionnaireTypeEnum.ORDER);
        if (CollectionUtils.isNotEmpty((Collection)labelVOList)) {
            this.handleMemberLabels(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getMemberCode(), labelVOList);
        }
        UrOrderUpdateVo urOrderUpdateVo = new UrOrderUpdateVo();
        urOrderUpdateVo.setSysCompanyId(vo.getSysCompanyId());
        urOrderUpdateVo.setBrandId(vo.getSysBrandId());
        urOrderUpdateVo.setOrderNo(vo.getOrderNo());
        urOrderUpdateVo.setEvaluateStatusEnum(EvaluateStatusEnum.ALREADY_EVALUATE);
        this.urOrderApiService.updateOrderEvaluate(urOrderUpdateVo);
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData<String> saveTaskQuestionnaire(SaveQuestionnaireRequestVO vo) {
        log.info("saveTaskQuestionnaire#vo:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        RedisClient redisClient = RedisManager.getInstince();
        boolean exists = redisClient.exists("EVALUATIONTASK" + vo.getMktTaskId() + vo.getMemberCode());
        if (exists) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.REPEAT_FAILED.getCode());
            responseData.setMessage("\u5df2\u5728\u63d0\u4ea4\u4e2d");
            return responseData;
        }
        ResponseData checkResponseData = this.checkQuestionnaireTempValid(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getTemplateCode());
        if (com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode() != checkResponseData.getCode()) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage(checkResponseData.getMessage());
            return responseData;
        }
        redisClient.set("EVALUATIONTASK" + vo.getMktTaskId() + vo.getMemberCode(), (Object)"Y", Long.valueOf(300L));
        List labelVOList = this.saveCommonQuestionnaire(vo, QuestionnaireTypeEnum.TASK);
        if (CollectionUtils.isNotEmpty((Collection)labelVOList)) {
            this.handleMemberLabels(vo.getSysCompanyId(), vo.getSysBrandId(), vo.getMemberCode(), labelVOList);
        }
        TaskAwardBO taskAwardBO = new TaskAwardBO();
        taskAwardBO.setSysCompanyId(vo.getSysCompanyId());
        taskAwardBO.setSysBrandId(vo.getSysBrandId());
        taskAwardBO.setPropertyCode(vo.getMemberCode());
        taskAwardBO.setMktTaskId(vo.getMktTaskId());
        return this.taskQuestionnaireServiceRpc.doTaskQuestionnaire(taskAwardBO);
    }

    public ResponseData<QuestionnaireTempVO> queryQuestionnaireTemp(QuestionnaireTempRequestVO requestVO) {
        log.info("queryQuestionnaireTemp#requestVO:{}", (Object)JacksonUtil.bean2Json((Object)requestVO));
        ResponseData responseData = new ResponseData();
        if (null == requestVO || requestVO.getSysBrandId() == null) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u53c2\u6570\u4e3a\u7a7a");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)requestVO.getMemberCode())) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u4f1a\u5458\u7f16\u53f7\u4e3a\u7a7a");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)requestVO.getTemplateCode())) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u95ee\u5377\u6a21\u677f\u7f16\u53f7\u4e3a\u7a7a");
            return responseData;
        }
        if (requestVO.getQuestionnaireType() == null) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u95ee\u5377\u7c7b\u578b\u4e3a\u7a7a");
            return responseData;
        }
        CusUrMbrQuestionnaireOrderPOExample orderPOExample = new CusUrMbrQuestionnaireOrderPOExample();
        CusUrMbrQuestionnaireOrderPOExample.Criteria criteria = orderPOExample.createCriteria();
        criteria.andValidEqualTo(Boolean.TRUE).andSysBrandIdEqualTo(requestVO.getSysBrandId()).andTemplateCodeEqualTo(requestVO.getTemplateCode()).andMemberCodeEqualTo(requestVO.getMemberCode());
        if (QuestionnaireTypeEnum.ORDER.getType() == requestVO.getQuestionnaireType().intValue()) {
            if (StringUtils.isBlank((CharSequence)requestVO.getOrderNo())) {
                responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u8ba2\u5355\u53f7\u4e3a\u7a7a");
                return responseData;
            }
            criteria.andOrderNoEqualTo(requestVO.getOrderNo()).andQuestionnaireTypeEqualTo(requestVO.getQuestionnaireType());
        } else if (QuestionnaireTypeEnum.TASK.getType() == requestVO.getQuestionnaireType().intValue()) {
            if (null == requestVO.getMktTaskId()) {
                responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u4efb\u52a1ID\u4e3a\u7a7a");
                return responseData;
            }
            criteria.andMktTaskIdEqualTo(requestVO.getMktTaskId()).andQuestionnaireTypeEqualTo(requestVO.getQuestionnaireType());
        } else if (QuestionnaireTypeEnum.QUESTIONNAIRE_TEMP.getType() == requestVO.getQuestionnaireType().intValue()) {
            criteria.andQuestionnaireTypeEqualTo(requestVO.getQuestionnaireType());
        } else {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u95ee\u5377\u7c7b\u578b\u9519\u8bef");
            return responseData;
        }
        List cusUrMbrQuestionnaireOrderPOS = this.cusUrMbrQuestionnaireOrderPOMapper.selectByExampleWithBLOBs(orderPOExample);
        QuestionnaireTempVO questionnaireTempVO = new QuestionnaireTempVO();
        if (CollectionUtils.isNotEmpty((Collection)cusUrMbrQuestionnaireOrderPOS)) {
            log.info("\u5df2\u63d0\u4ea4\u6a21\u677f");
            CusUrMbrQuestionnaireOrderPO orderPO = (CusUrMbrQuestionnaireOrderPO)cusUrMbrQuestionnaireOrderPOS.get(0);
            questionnaireTempVO.setHaveFillIn(Boolean.TRUE);
            questionnaireTempVO.setSysBrandId(requestVO.getSysBrandId());
            questionnaireTempVO.setTemplateName(orderPO.getTemplateName());
            questionnaireTempVO.setTemplateCode(requestVO.getTemplateCode());
            questionnaireTempVO.setTemplateJson(orderPO.getTemplateJsonOrder());
        } else {
            log.info("\u672a\u63d0\u4ea4\u6a21\u677f");
            questionnaireTempVO.setHaveFillIn(Boolean.FALSE);
            questionnaireTempVO.setSysBrandId(requestVO.getSysBrandId());
            questionnaireTempVO.setTemplateCode(requestVO.getTemplateCode());
            CusUrMbrQuestionnaireTemplatePOExample templatePOExample = new CusUrMbrQuestionnaireTemplatePOExample();
            templatePOExample.createCriteria().andSysBrandIdEqualTo(requestVO.getSysBrandId()).andValidEqualTo(Boolean.TRUE).andTemplateTypeEqualTo(Integer.valueOf(QuestionnaireTemplateTypeEnum.NEW.getTemplateType())).andTemplateCodeEqualTo(requestVO.getTemplateCode());
            List templatePOList = this.cusUrMbrQuestionnaireTemplatePOMapper.selectByExampleWithBLOBs(templatePOExample);
            if (CollectionUtils.isNotEmpty((Collection)templatePOList)) {
                CusUrMbrQuestionnaireTemplatePO templatePO = (CusUrMbrQuestionnaireTemplatePO)templatePOList.get(0);
                questionnaireTempVO.setTemplateName(templatePO.getTemplateName());
                questionnaireTempVO.setTemplateJson(templatePO.getTemplateJson());
            } else {
                responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
                responseData.setMessage("\u95ee\u5377\u6a21\u677f\u4e0d\u5b58\u5728");
                return responseData;
            }
        }
        log.info("queryQuestionnaireTemp#questionnaireTempVO:{}", (Object)JacksonUtil.bean2Json((Object)questionnaireTempVO));
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setData((Object)questionnaireTempVO);
        return responseData;
    }

    private Integer handleTemplateChoiceQuestion(Row row, int i, CusUrMbrQuestionnaireOrderDetailPO orderDetail, Boolean isTableHead) throws Exception {
        Cell cell8 = row.createCell(++i);
        if (isTableHead.booleanValue()) {
            cell8.setCellValue(orderDetail.getTempTitle());
        }
        int activeIndex = 0;
        JSONArray arr = new JSONArray(orderDetail.getTempContent());
        for (int j = 0; j < arr.length(); ++j) {
            JSONObject jsonObject = arr.getJSONObject(j);
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Cell cell9 = row.createCell(++i);
                if (isTableHead.booleanValue()) {
                    if ("custom_other".equals(key)) {
                        cell9.setCellValue("\u4ee5\u4e0a\u9009\u62e9\u90fd\u4e0d\u7b26\u5408\uff0c\u9700\u81ea\u5b9a\u4e49");
                        continue;
                    }
                    cell9.setCellValue(key);
                    continue;
                }
                if ("1".equals(StringUtil.valueOf((Object)jsonObject.get(key)))) {
                    cell9.setCellValue("\u221a");
                    activeIndex = j;
                    continue;
                }
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)StringUtil.valueOf((Object)jsonObject.get(key)))) continue;
                cell9.setCellValue("\u221a " + jsonObject.get(key));
                activeIndex = j;
            }
        }
        if (isTableHead.booleanValue()) {
            String tempSkipSubjectJson = orderDetail.getTempSkipSubjectJson();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tempSkipSubjectJson)) {
                return i;
            }
            JSONArray tempSkipSubjectArr = new JSONArray(tempSkipSubjectJson);
            if (tempSkipSubjectArr == null) {
                tempSkipSubjectArr = new JSONArray();
            }
            for (int m = 0; m < tempSkipSubjectArr.length(); ++m) {
                String tempSkipValueStr = tempSkipSubjectArr.getString(m);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tempSkipValueStr) || "{}".equals(tempSkipValueStr) || com.alibaba.fastjson.JSONObject.parseObject((String)tempSkipValueStr).size() <= 0) {
                    return i;
                }
                JSONObject jsonObject = tempSkipSubjectArr.getJSONObject(m);
                Cell cell10 = row.createCell(++i);
                cell10.setCellValue(jsonObject.getString("title"));
                JSONArray options = jsonObject.getJSONArray("options");
                for (int n = 0; n < options.length(); ++n) {
                    JSONObject item = options.getJSONObject(n);
                    String key = item.getString("value");
                    Cell cell9 = row.createCell(++i);
                    cell9.setCellValue(key);
                }
            }
        } else {
            JSONArray activeJsonArr;
            String tempSkipSubjectJson = orderDetail.getTempSkipSubjectJson();
            String tempSkipOptionsKeyJson = orderDetail.getTempSkipOptionsKeyJson();
            String tempSkipValueJson = orderDetail.getTempSkipValueJson();
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tempSkipSubjectJson) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tempSkipOptionsKeyJson) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tempSkipValueJson)) {
                return i;
            }
            JSONArray tempSkipSubjectArr = new JSONArray(tempSkipSubjectJson);
            JSONArray tempSkipOptionsKeyArr = new JSONArray(tempSkipOptionsKeyJson);
            JSONArray tempSkipValueArr = new JSONArray(tempSkipValueJson);
            if (tempSkipSubjectArr == null) {
                tempSkipSubjectArr = new JSONArray();
            }
            if (tempSkipOptionsKeyArr == null) {
                tempSkipOptionsKeyArr = new JSONArray();
            }
            if (tempSkipValueArr == null) {
                tempSkipValueArr = new JSONArray();
            }
            if ((activeJsonArr = tempSkipOptionsKeyArr.getJSONArray(activeIndex)) == null) {
                activeJsonArr = new JSONArray();
            }
            ArrayList<Integer> activeList = new ArrayList<Integer>();
            for (int l = 0; l < activeJsonArr.length(); ++l) {
                String activeJsonStr = activeJsonArr.getString(l);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)activeJsonStr) || "{}".equals(activeJsonStr)) continue;
                try {
                    activeList.add(activeJsonArr.getInt(l));
                    continue;
                }
                catch (Exception e) {
                    log.error("\u8c03\u67e5\u95ee\u5377\u89e3\u6790tempSkipOptionsKeyJson\u53c2\u6570\u51fa\u9519\uff0c\u8df3\u8fc7\u6b64\u6b65\u9aa4", (Throwable)e);
                }
            }
            int answerIndex = 0;
            for (int m = 0; m < tempSkipSubjectArr.length(); ++m) {
                String tempSkipSubjectStr = tempSkipSubjectArr.getString(m);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tempSkipSubjectStr) || "{}".equals(tempSkipSubjectStr) || com.alibaba.fastjson.JSONObject.parseObject((String)tempSkipSubjectStr).size() <= 0) {
                    return i;
                }
                if (activeList.contains(m + 1)) {
                    String tempSkipValueStr = tempSkipValueArr.getString(answerIndex);
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tempSkipValueStr) || "{}".equals(tempSkipValueStr) || com.alibaba.fastjson.JSONObject.parseObject((String)tempSkipValueStr).size() <= 0) continue;
                    CusUrMbrQuestionnaireOrderDetailPO detailChildrenPO = (CusUrMbrQuestionnaireOrderDetailPO)com.alibaba.fastjson.JSONObject.parseObject((String)tempSkipValueStr, CusUrMbrQuestionnaireOrderDetailPO.class);
                    JSONArray childrenArr = new JSONArray(detailChildrenPO.getTempContent());
                    ++i;
                    for (int k = 0; k < childrenArr.length(); ++k) {
                        JSONObject children = childrenArr.getJSONObject(k);
                        Iterator it = children.keys();
                        while (it.hasNext()) {
                            String key = (String)it.next();
                            Cell cell9 = row.createCell(++i);
                            if (!"1".equals(StringUtil.valueOf((Object)children.get(key)))) continue;
                            cell9.setCellValue("\u221a");
                        }
                    }
                    ++answerIndex;
                    continue;
                }
                JSONObject jsonObject = tempSkipSubjectArr.getJSONObject(m);
                ++i;
                JSONArray options = jsonObject.getJSONArray("options");
                for (int n = 0; n < options.length(); ++n) {
                    ++i;
                }
            }
        }
        return i;
    }

    private Integer handleTemplateContentQuestion(Row row, int i, CusUrMbrQuestionnaireOrderDetailPO orderDetail, Boolean isTableHead) throws Exception {
        Cell cellTitle = row.createCell(++i);
        if (isTableHead.booleanValue()) {
            cellTitle.setCellValue(orderDetail.getTempTitle());
        }
        JSONArray arr = new JSONArray(orderDetail.getTempContent());
        for (int j = 0; j < arr.length(); ++j) {
            JSONObject jsonObject = arr.getJSONObject(j);
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Cell cellOption = row.createCell(++i);
                if (isTableHead.booleanValue()) {
                    cellOption.setCellValue(key);
                    continue;
                }
                JSONArray option = new JSONArray();
                JSONArray temp = new JSONArray(orderDetail.getTempName());
                for (int k = 0; k < temp.length(); ++k) {
                    JSONObject optionObject = temp.getJSONObject(k);
                    Iterator optionIt = optionObject.keys();
                    while (optionIt.hasNext()) {
                        option.put(optionIt.next());
                    }
                }
                JSONArray ansArray = jsonObject.getJSONArray(key);
                for (int m = 0; m < ansArray.length(); ++m) {
                    if (!"1".equals(ansArray.getString(m))) continue;
                    cellOption.setCellValue(String.valueOf(option.get(m)));
                }
            }
        }
        return i;
    }

    private List<LabelVO> saveCommonQuestionnaire(SaveQuestionnaireRequestVO vo, QuestionnaireTypeEnum questionnaireTypeEnum) {
        SurveyQuestionnaireVO surveyQuestionnaireVO = vo.getSurveyQuestionnaireVO();
        log.info("surveyQuestionnaireVO:{}", (Object)JacksonUtil.bean2Json((Object)surveyQuestionnaireVO));
        ArrayList<LabelVO> labelVOList = new ArrayList<LabelVO>();
        CusUrMbrQuestionnaireOrderPO questionnaireOrderPO = new CusUrMbrQuestionnaireOrderPO();
        questionnaireOrderPO.setSysCompanyId(vo.getSysCompanyId());
        questionnaireOrderPO.setSysBrandId(vo.getSysBrandId());
        questionnaireOrderPO.setTemplateCode(vo.getTemplateCode());
        questionnaireOrderPO.setTemplateName(surveyQuestionnaireVO.getSurveyTitle());
        questionnaireOrderPO.setQuestionnaireType(null != questionnaireTypeEnum ? Integer.valueOf(questionnaireTypeEnum.getType()) : null);
        questionnaireOrderPO.setMemberCode(vo.getMemberCode());
        questionnaireOrderPO.setMemberCardNo(vo.getMemberCardNo());
        questionnaireOrderPO.setMemberName(vo.getMemberName());
        questionnaireOrderPO.setMemberPhone(vo.getMemberPhone());
        questionnaireOrderPO.setStoreName(vo.getStoreName());
        questionnaireOrderPO.setShopGuideCode(vo.getShopGuideCode());
        questionnaireOrderPO.setShopGuideName(vo.getShopGuideName());
        questionnaireOrderPO.setTemplateJsonOrder(JacksonUtil.bean2Json((Object)surveyQuestionnaireVO));
        questionnaireOrderPO.setCreateDate(new Date());
        questionnaireOrderPO.setOrderNo(vo.getOrderNo());
        questionnaireOrderPO.setMktTaskId(vo.getMktTaskId());
        this.cusUrMbrQuestionnaireOrderPOMapper.insertSelective(questionnaireOrderPO);
        if (BooleanUtils.isTrue((Boolean)surveyQuestionnaireVO.getCommitLabelType()) && CollectionUtils.isNotEmpty((Collection)surveyQuestionnaireVO.getCommitLabelList())) {
            labelVOList.addAll(surveyQuestionnaireVO.getCommitLabelList());
        }
        CusUrMbrQuestionnaireOrderDetailPO questionnaireOrderDetailPO = null;
        for (ComponentModuleVO componentModuleVO : surveyQuestionnaireVO.getComponentList()) {
            if (1 == componentModuleVO.getComponentType() || 2 == componentModuleVO.getComponentType()) continue;
            questionnaireOrderDetailPO = new CusUrMbrQuestionnaireOrderDetailPO();
            questionnaireOrderDetailPO.setQuestionnaireOrderId(questionnaireOrderPO.getQuestionnaireOrderId());
            questionnaireOrderDetailPO.setCreateDate(new Date());
            questionnaireOrderDetailPO.setSysCompanyId(vo.getSysCompanyId());
            questionnaireOrderDetailPO.setSysBrandId(vo.getSysBrandId());
            questionnaireOrderDetailPO.setTemplateCode(vo.getTemplateCode());
            questionnaireOrderDetailPO.setTemplateName(surveyQuestionnaireVO.getSurveyTitle());
            questionnaireOrderDetailPO.setOrderNo(vo.getOrderNo());
            questionnaireOrderDetailPO.setTempType(Byte.valueOf((byte)componentModuleVO.getComponentType()));
            questionnaireOrderDetailPO.setTempSerial(Byte.valueOf((byte)componentModuleVO.getComponentSerial()));
            questionnaireOrderDetailPO.setTempTitle(componentModuleVO.getComponentTitle());
            questionnaireOrderDetailPO.setTempDetail(componentModuleVO.getComponentDesc());
            boolean tempSelect = false;
            if (null != componentModuleVO.getRadioType() && componentModuleVO.getRadioType() == 2) {
                tempSelect = true;
            }
            questionnaireOrderDetailPO.setTempSelect(Boolean.valueOf(tempSelect));
            questionnaireOrderDetailPO.setTempMandatory(componentModuleVO.getComponentRequired());
            questionnaireOrderDetailPO.setTempStyle(componentModuleVO.getScoreType());
            List optionList = componentModuleVO.getOptionList();
            if (componentModuleVO.getComponentType() == 3) {
                try {
                    for (ComponentOptionVO optionVO : optionList) {
                        questionnaireOrderDetailPO.setTempName(optionVO.getOptionTitle());
                        if (BooleanUtils.isTrue((Boolean)optionVO.getChecked())) {
                            questionnaireOrderDetailPO.setTempContent("true");
                            questionnaireOrderDetailPO.setTempFillIn(Boolean.TRUE);
                            if (BooleanUtils.isTrue((Boolean)componentModuleVO.getLabelSwitch()) && CollectionUtils.isNotEmpty((Collection)optionVO.getOptionLabels())) {
                                labelVOList.addAll(optionVO.getOptionLabels());
                            }
                        } else {
                            questionnaireOrderDetailPO.setTempContent("");
                            questionnaireOrderDetailPO.setTempFillIn(Boolean.FALSE);
                        }
                        this.cusUrMbrQuestionnaireOrderDetailPOMapper.insertSelective(questionnaireOrderDetailPO);
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error("\u9009\u62e9\u5904\u7406\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    continue;
                }
            }
            if (componentModuleVO.getComponentType() == 5) {
                try {
                    int checkValue = this.getOptionCheckedValue(optionList);
                    log.info("optionCheckedValue:{}", (Object)checkValue);
                    for (ComponentOptionVO optionVO : optionList) {
                        if (BooleanUtils.isTrue((Boolean)componentModuleVO.getLabelSwitch()) && CollectionUtils.isNotEmpty((Collection)optionVO.getOptionLabels())) {
                            labelVOList.addAll(optionVO.getOptionLabels());
                        }
                        questionnaireOrderDetailPO.setTempName(optionVO.getOptionTitle());
                        if (BooleanUtils.isTrue((Boolean)optionVO.getChecked()) && optionVO.getOptionValue() == checkValue) {
                            questionnaireOrderDetailPO.setTempFillIn(Boolean.TRUE);
                            questionnaireOrderDetailPO.setTempContent(optionVO.getOptionValue() + "");
                        } else {
                            questionnaireOrderDetailPO.setTempFillIn(Boolean.FALSE);
                            questionnaireOrderDetailPO.setTempContent("");
                        }
                        this.cusUrMbrQuestionnaireOrderDetailPOMapper.insertSelective(questionnaireOrderDetailPO);
                    }
                    continue;
                }
                catch (Exception e) {
                    log.error("\u8bc4\u5206\u5904\u7406\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    continue;
                }
            }
            if (componentModuleVO.getComponentType() == 4) {
                ComponentOptionVO dataOptionVO = (ComponentOptionVO)optionList.get(0);
                if (null != dataOptionVO && StringUtils.isNotBlank((CharSequence)dataOptionVO.getSelectedDate())) {
                    questionnaireOrderDetailPO.setTempContent(dataOptionVO.getSelectedDate());
                    questionnaireOrderDetailPO.setTempFillIn(Boolean.TRUE);
                }
                this.cusUrMbrQuestionnaireOrderDetailPOMapper.insertSelective(questionnaireOrderDetailPO);
                continue;
            }
            if (componentModuleVO.getComponentType() != 6) continue;
            ComponentOptionVO textOptionVO = (ComponentOptionVO)optionList.get(0);
            if (null != textOptionVO && StringUtils.isNotBlank((CharSequence)textOptionVO.getTextValue())) {
                questionnaireOrderDetailPO.setTempContent(textOptionVO.getTextValue());
                questionnaireOrderDetailPO.setTempFillIn(Boolean.TRUE);
            }
            this.cusUrMbrQuestionnaireOrderDetailPOMapper.insertSelective(questionnaireOrderDetailPO);
        }
        CusUrMbrQuestionnaireTemplatePO cusUrMbrQuestionnaireTemplatePo = new CusUrMbrQuestionnaireTemplatePO();
        cusUrMbrQuestionnaireTemplatePo.setSysCompanyId(vo.getSysCompanyId());
        cusUrMbrQuestionnaireTemplatePo.setSysBrandId(vo.getSysBrandId());
        cusUrMbrQuestionnaireTemplatePo.setTemplateCode(vo.getTemplateCode());
        this.cusUrMbrQuestionnaireTemplatePOMapper.updateAnswerByTemplateCode(cusUrMbrQuestionnaireTemplatePo);
        return labelVOList;
    }

    private void handleMemberLabels(Long sysCompanyId, Long sysBrandId, String memberCode, List<LabelVO> labelVOList) {
        log.info("\u63d0\u4ea4\u95ee\u5377\u6253\u6807\u7b7e");
        if (CollectionUtils.isEmpty(labelVOList)) {
            log.info("\u6807\u7b7e\u96c6\u5408\u4e3a\u7a7a");
            return;
        }
        if (null == sysCompanyId || null == sysBrandId || StringUtils.isBlank((CharSequence)memberCode)) {
            log.info("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7");
            return;
        }
        List mbrLabelIdList = labelVOList.stream().map(item -> item.getMbrLabelDefId().toString()).collect(Collectors.toList());
        log.info("handleMemberLabels#mbrLabelIdList:{}", (Object)JacksonUtil.bean2Json(mbrLabelIdList));
        UpdateMemberLabelVo updateMemberLabelVo = new UpdateMemberLabelVo();
        updateMemberLabelVo.setMemberCode(memberCode);
        updateMemberLabelVo.setLabelIds(mbrLabelIdList);
        updateMemberLabelVo.setSysCompanyId(sysCompanyId);
        updateMemberLabelVo.setBrandId(sysBrandId);
        updateMemberLabelVo.setSysAccountId(Long.valueOf(0L));
        updateMemberLabelVo.setSysStoreId(Long.valueOf(0L));
        updateMemberLabelVo.setGuideCode("");
        updateMemberLabelVo.setActionType(Integer.valueOf(1));
        updateMemberLabelVo.setSyncedWxqy(Integer.valueOf(2));
        updateMemberLabelVo.setName("\u8c03\u67e5\u95ee\u5377");
        ResponseData updateMemberLabelResult = this.memberLabelApiService.addMemberLabel(updateMemberLabelVo);
        log.info("handleMemberLabels#updateMemberLabelResult:{}", (Object)JacksonUtil.bean2Json((Object)updateMemberLabelResult));
        if (SysResponseEnum.SUCCESS.getCode() == updateMemberLabelResult.getCode()) {
            log.info("\u6807\u7b7e\u5904\u7406\u6210\u529f");
        } else {
            log.info("\u6807\u7b7e\u5904\u7406\u5931\u8d25");
        }
    }

    private int getOptionCheckedValue(List<ComponentOptionVO> optionList) {
        int checkedNum = 0;
        for (ComponentOptionVO optionVO : optionList) {
            if (!BooleanUtils.isTrue((Boolean)optionVO.getChecked()) || optionVO.getOptionValue() <= checkedNum) continue;
            checkedNum = optionVO.getOptionValue();
        }
        return checkedNum;
    }

    private ResponseData<Boolean> checkQuestionnaireTempValid(Long sysCompanyId, Long sysBrandId, String templateCode) {
        log.info("checkQuestionnaireTempValid#templateCode:{}", (Object)templateCode);
        ResponseData responseData = new ResponseData();
        CusUrMbrQuestionnaireTemplatePOExample example = new CusUrMbrQuestionnaireTemplatePOExample();
        example.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andSysBrandIdEqualTo(sysBrandId).andTemplateCodeEqualTo(templateCode).andValidEqualTo(SysConstants.TABLE_VALID_EFFECTIVE);
        List templateList = this.cusUrMbrQuestionnaireTemplatePOMapper.selectByExample(example);
        CusUrMbrQuestionnaireTemplatePO templatePO = null;
        if (templateList != null && templateList.size() > 0) {
            templatePO = (CusUrMbrQuestionnaireTemplatePO)templateList.get(0);
        }
        if (templatePO == null) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u95ee\u5377\u4e0d\u5b58\u5728");
            responseData.setData((Object)Boolean.FALSE);
            return responseData;
        }
        if (MbrQuestionnaireTemplateDraftStatusEnum.DRAFT.getCode().equals(templatePO.getDraftStatus())) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setData((Object)Boolean.FALSE);
            responseData.setMessage("\u95ee\u5377\u672a\u542f\u7528");
        } else if (MbrQuestionnaireTemplateDraftStatusEnum.RELEASED.getCode().equals(templatePO.getDraftStatus())) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
            responseData.setData((Object)Boolean.TRUE);
        } else if (MbrQuestionnaireTemplateDraftStatusEnum.DISABLE.getCode().equals(templatePO.getDraftStatus())) {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setData((Object)Boolean.FALSE);
            responseData.setMessage("\u95ee\u5377\u5df2\u5931\u6548");
        } else {
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
            responseData.setData((Object)Boolean.FALSE);
            responseData.setMessage("\u95ee\u5377\u672a\u542f\u7528");
        }
        return responseData;
    }
}

