/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.service.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.auth0.jwt.internal.org.apache.commons.lang3.StringUtils;
import com.bizvane.couponfacade.interfaces.UtilsServiceFeign;
import com.bizvane.customized.common.utils.Aes32;
import com.bizvane.customized.company.ur.members.service.CusUrMbrStorageCardService;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardPO;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardPOExample;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardRecordPOExample;
import com.bizvane.customized.facade.models.vo.ChangePasswordRequestVo;
import com.bizvane.customized.facade.models.vo.MiniQueryStorageResponseVo;
import com.bizvane.customized.facade.models.vo.QueryRecordListRequestVo;
import com.bizvane.customized.mappers.CusUrMbrStorageCardPOMapper;
import com.bizvane.customized.mappers.CusUrMbrStorageCardRecordPOMapper;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CusUrMbrStorageCardServiceImpl
implements CusUrMbrStorageCardService {
    private static final Logger log = LoggerFactory.getLogger(CusUrMbrStorageCardServiceImpl.class);
    @Autowired
    private CusUrMbrStorageCardPOMapper cusUrMbrStorageCardPOMapper;
    @Autowired
    private CusUrMbrStorageCardRecordPOMapper cusUrMbrStorageCardRecordPOMapper;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private UtilsServiceFeign utilsServiceFeign;

    public ResponseData<MiniQueryStorageResponseVo> queryStorageCard(String memberCode) {
        ResponseData result = new ResponseData();
        CusUrMbrStorageCardPOExample example = new CusUrMbrStorageCardPOExample();
        example.createCriteria().andMemberCodeEqualTo(memberCode).andValidEqualTo(Boolean.valueOf(true));
        List resultList = this.cusUrMbrStorageCardPOMapper.selectByExample(example);
        if (resultList.size() > 0) {
            log.info("\u83b7\u53d6\u4f1a\u5458\u4fe1\u606f memberCode={}", (Object)memberCode);
            MemberInfoModel infoModel = new MemberInfoModel();
            infoModel.setMemberCode(memberCode);
            ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(infoModel);
            log.info("\u50a8\u503c\u5361\u6570\u636e={}", resultList.get(0));
            CusUrMbrStorageCardPO cusUrMbrStorageCardPO = (CusUrMbrStorageCardPO)resultList.get(0);
            if (singleMemberModel.getData() != null) {
                if (StringUtils.isBlank((CharSequence)cusUrMbrStorageCardPO.getCardNoBarCode())) {
                    ResponseData cardNoBarcode = this.utilsServiceFeign.getBarcode(cusUrMbrStorageCardPO.getStorageCardNo());
                    ResponseData passwordBarcode = this.utilsServiceFeign.getBarcode(cusUrMbrStorageCardPO.getPassword());
                    log.info("\u8c03\u7528\u751f\u6210\u6761\u5f62\u7801\u63a5\u53e3 \u51fa\u53c2 cardNoBarcode\uff1a{} passwordBarcode\uff1a{}", (Object)cardNoBarcode, (Object)passwordBarcode);
                    cusUrMbrStorageCardPO.setCardNoBarCode((String)cardNoBarcode.getData());
                    cusUrMbrStorageCardPO.setPasswordBarCode((String)passwordBarcode.getData());
                    this.cusUrMbrStorageCardPOMapper.updateByExample(cusUrMbrStorageCardPO, example);
                }
                MiniQueryStorageResponseVo resultVO = new MiniQueryStorageResponseVo();
                BeanUtils.copyProperties((Object)cusUrMbrStorageCardPO, (Object)resultVO);
                resultVO.setVipName(((MemberInfoModel)singleMemberModel.getData()).getName());
                resultVO.setPassword(Aes32.Decrypt((String)cusUrMbrStorageCardPO.getPassword()));
                result.setData((Object)resultVO);
            } else {
                result.setCode(SysResponseEnum.FAILED.getCode());
                result.setMessage("\u672a\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f");
            }
            result.setCode(SysResponseEnum.SUCCESS.getCode());
            result.setMessage(SysResponseEnum.SUCCESS.getMessage());
            return result;
        }
        result.setCode(SysResponseEnum.SUCCESS.getCode());
        result.setMessage("\u6682\u65e0\u50a8\u503c\u5361\u4fe1\u606f");
        return result;
    }

    public ResponseData changePassword(ChangePasswordRequestVo changePasswordRequestVo) {
        ResponseData result = new ResponseData();
        if (!changePasswordRequestVo.getNewPassword().equals(changePasswordRequestVo.getConfirmNewPassword())) {
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage("\u4e24\u6b21\u65b0\u5bc6\u7801\u4e0d\u4e00\u81f4");
            return result;
        }
        CusUrMbrStorageCardPOExample example = new CusUrMbrStorageCardPOExample();
        example.createCriteria().andMemberCodeEqualTo(changePasswordRequestVo.getMemberCode());
        List resultList = this.cusUrMbrStorageCardPOMapper.selectByExample(example);
        log.info("\u83b7\u53d6\u50a8\u503c\u5361\u6570\u636e\uff1a{}", (Object)resultList);
        CusUrMbrStorageCardPO cusUrMbrStorageCardPO = (CusUrMbrStorageCardPO)resultList.get(0);
        String pwd = Aes32.Decrypt((String)cusUrMbrStorageCardPO.getPassword());
        if (!changePasswordRequestVo.getOldPassword().equals(pwd)) {
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage("\u65e7\u5bc6\u7801\u9519\u8bef");
            return result;
        }
        if (changePasswordRequestVo.getNewPassword().equals(pwd)) {
            result.setCode(SysResponseEnum.FAILED.getCode());
            result.setMessage("\u65b0\u65e7\u5bc6\u7801\u4e00\u81f4\u65e0\u9700\u4fee\u6539");
            return result;
        }
        CusUrMbrStorageCardPO updatePo = CusUrMbrStorageCardPO.builder().build();
        updatePo.setPassword(Aes32.Encrypt((String)changePasswordRequestVo.getNewPassword()));
        CusUrMbrStorageCardPOExample example1 = new CusUrMbrStorageCardPOExample();
        example1.createCriteria().andMemberCodeEqualTo(changePasswordRequestVo.getMemberCode());
        ResponseData cardNoBarcode = this.utilsServiceFeign.getBarcode(changePasswordRequestVo.getNewPassword());
        updatePo.setPasswordBarCode((String)cardNoBarcode.getData());
        this.cusUrMbrStorageCardPOMapper.updateByExampleSelective(updatePo, example1);
        return result;
    }

    public ResponseData queryRecordList(QueryRecordListRequestVo queryRecordListRequestVo) {
        CusUrMbrStorageCardRecordPOExample example = new CusUrMbrStorageCardRecordPOExample();
        CusUrMbrStorageCardRecordPOExample.Criteria criteria = example.createCriteria();
        MemberInfoModel infoModel = new MemberInfoModel();
        infoModel.setMemberCode(queryRecordListRequestVo.getMemberCode());
        ResponseData singleMemberModel = this.memberInfoApiService.getSingleMemberModel(infoModel);
        log.info("\u50a8\u503c\u8bb0\u5f55\u8c03\u7528\u4f1a\u5458\u8fd4\u56de\u6570\u636e={}", (Object)JSON.toJSONString((Object)singleMemberModel));
        criteria.andMbrCardNoEqualTo(((MemberInfoModel)singleMemberModel.getData()).getCardNo());
        criteria.andSysCompanyIdEqualTo(queryRecordListRequestVo.getSysCompanyId());
        criteria.andBrandIdEqualTo(queryRecordListRequestVo.getBrandId()).andValidEqualTo(Boolean.valueOf(true));
        switch (queryRecordListRequestVo.getType()) {
            case 2: {
                criteria.andOpTypeEqualTo(Integer.valueOf(5));
                break;
            }
            case 3: {
                criteria.andOpTypeEqualTo(Integer.valueOf(3));
                break;
            }
        }
        example.setOrderByClause("create_date desc");
        log.info("queryRecordListRequestVo={}", (Object)JSON.toJSONString((Object)queryRecordListRequestVo));
        PageHelper.startPage((int)queryRecordListRequestVo.getPageNum(), (int)queryRecordListRequestVo.getPageSize());
        List cusUrMbrStorageCardRecordPOS = this.cusUrMbrStorageCardRecordPOMapper.selectByExample(example);
        ResponseData result = new ResponseData();
        PageInfo data = new PageInfo(cusUrMbrStorageCardRecordPOS);
        result.setData((Object)data);
        return result;
    }
}

