/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.service.impl;

import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.po.SysCheckConfigPo;
import com.bizvane.centerstageservice.models.po.SysCheckPo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCheckConfigServiceRpc;
import com.bizvane.centerstageservice.rpc.SysCheckServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.common.GiftCardListRequestVO;
import com.bizvane.connectorservice.entity.common.GiftCardRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.ConnectorServiceFeign;
import com.bizvane.customized.common.system.RedisManager;
import com.bizvane.customized.common.thread.ThreadPool;
import com.bizvane.customized.common.utils.BeanUtils;
import com.bizvane.customized.common.utils.CommonExportExcelUtil;
import com.bizvane.customized.common.utils.DownLoadFileUtil;
import com.bizvane.customized.common.utils.ExportExcelUtil;
import com.bizvane.customized.common.utils.QiNiuConfig;
import com.bizvane.customized.common.utils.QiNiuUtil;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.common.utils.StreamingExportExcelUtil;
import com.bizvane.customized.common.utils.UUIDGenerator;
import com.bizvane.customized.company.ur.members.service.CusUrMbrGiftCardService;
import com.bizvane.customized.facade.enums.GiftCardStatusEnum;
import com.bizvane.customized.facade.exception.CustomizedException;
import com.bizvane.customized.facade.models.po.CusUrMbrGiftCardDetailPO;
import com.bizvane.customized.facade.models.po.CusUrMbrGiftCardPO;
import com.bizvane.customized.facade.models.po.CusUrMbrGiftCardPOExample;
import com.bizvane.customized.facade.models.po.CusUrMbrGiftCardTaskDetailPO;
import com.bizvane.customized.facade.models.po.CusUrMbrGiftCardTaskDetailPOExample;
import com.bizvane.customized.facade.models.po.CusUrMbrGiftCardTaskPO;
import com.bizvane.customized.facade.models.po.CusUrMbrGiftCardTaskPOExample;
import com.bizvane.customized.facade.models.vo.CusUrMbrGiftCardDetailVO;
import com.bizvane.customized.facade.models.vo.CusUrMbrGiftCardTaskDetailVO;
import com.bizvane.customized.facade.models.vo.CusUrMbrGiftCardTaskVO;
import com.bizvane.customized.facade.models.vo.CusUrMbrGiftCardVO;
import com.bizvane.customized.facade.models.vo.GiftCardToExamineVO;
import com.bizvane.customized.mappers.CusUrMbrGiftCardDetailPOMapper;
import com.bizvane.customized.mappers.CusUrMbrGiftCardPOMapper;
import com.bizvane.customized.mappers.CusUrMbrGiftCardTaskDetailPOMapper;
import com.bizvane.customized.mappers.CusUrMbrGiftCardTaskPOMapper;
import com.bizvane.members.facade.service.api.CardGenerateApiService;
import com.bizvane.members.facade.vo.CardGenerateVO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.redisutils.RedisClient;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CusUrMbrGiftCardServiceImpl
implements CusUrMbrGiftCardService {
    private static final Logger log = LoggerFactory.getLogger(CusUrMbrGiftCardServiceImpl.class);
    private static Integer MAX_NUMBER = 100000;
    @Autowired
    private CusUrMbrGiftCardPOMapper cusUrMbrGiftCardPOMapper;
    @Autowired
    private CusUrMbrGiftCardDetailPOMapper cusUrMbrGiftCardDetailPOMapper;
    @Autowired
    private CusUrMbrGiftCardTaskPOMapper cusUrMbrGiftCardTaskPOMapper;
    @Autowired
    private CusUrMbrGiftCardTaskDetailPOMapper cusUrMbrGiftCardTaskDetailPOMapper;
    @Autowired
    private QiNiuConfig qiNiuConfig;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Autowired
    private SysCheckConfigServiceRpc sysCheckConfigServiceRpc;
    @Autowired
    private SysCheckServiceRpc sysCheckServiceRpc;
    @Autowired
    private ConnectorServiceFeign connectorServiceFeign;
    @Autowired
    private CardGenerateApiService cardGenerateApiService;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String cardPropertyCode = "urGiftCardNo";
    private static final String GIFT_CARD_STATUS_NOT_ACTIVE = "1";
    private static final String GIFT_CARD_STATUS_ACTIVED = "2";
    private static final String GIFT_CARD_STATUS_ABORT = "3";

    public ResponseData addGiftCardList(CusUrMbrGiftCardVO vo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getCardNo()) || vo.getCardNo().length() != 3) {
            responseData.setMessage("\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e3a3\u4f4d\u524d\u7f00!");
            return responseData;
        }
        if (vo.getBalance() == null || vo.getBalance().compareTo(BigDecimal.ZERO) == -1 || vo.getBalance().compareTo(BigDecimal.ZERO) == 0) {
            responseData.setMessage("\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u59270!");
            return responseData;
        }
        if (vo.getNumber() == null || vo.getNumber() <= 0 || vo.getNumber() > MAX_NUMBER) {
            responseData.setMessage("\u793c\u54c1\u5361\u751f\u6210\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5927\u4e8e0,\u5c0f\u4e8e10W!");
            return responseData;
        }
        String cardNo = vo.getCardNo();
        CusUrMbrGiftCardVO cusUrMbrGiftCardVO = new CusUrMbrGiftCardVO();
        cusUrMbrGiftCardVO.setSysCompanyId(vo.getSysCompanyId());
        cusUrMbrGiftCardVO.setSysBrandId(vo.getSysBrandId());
        cusUrMbrGiftCardVO.setCardNo(cardNo);
        Long count = this.cusUrMbrGiftCardPOMapper.selectCountGiftNoByPrefix(cusUrMbrGiftCardVO);
        if (count > 0L) {
            responseData.setMessage("\u793c\u54c1\u5361\u53f7\u524d\u7f00\u4e0d\u80fd\u91cd\u590d");
            return responseData;
        }
        String taskBatchCode = this.generateTaskBatchCode();
        String taskBatchName = "\u793c\u54c1\u5361\u65b0\u589e";
        CusUrMbrGiftCardDetailPO cusUrMbrGiftCardDetailPO = new CusUrMbrGiftCardDetailPO();
        cusUrMbrGiftCardDetailPO.setSysCompanyId(vo.getSysCompanyId());
        cusUrMbrGiftCardDetailPO.setSysBrandId(vo.getSysBrandId());
        cusUrMbrGiftCardDetailPO.setType(GIFT_CARD_STATUS_NOT_ACTIVE);
        cusUrMbrGiftCardDetailPO.setUpdatebalance(vo.getBalance());
        cusUrMbrGiftCardDetailPO.setBalance(vo.getBalance());
        cusUrMbrGiftCardDetailPO.setUpdateGiveBalance(vo.getGiveBalance());
        cusUrMbrGiftCardDetailPO.setGiveBalance(vo.getGiveBalance());
        cusUrMbrGiftCardDetailPO.setCreatedDate(SDF.format(new Date()));
        cusUrMbrGiftCardDetailPO.setTaskBatchCode(taskBatchCode);
        cusUrMbrGiftCardDetailPO.setTaskFileName(taskBatchName);
        cusUrMbrGiftCardDetailPO.setCreater(vo.getCreater());
        CusUrMbrGiftCardTaskPO cusUrMbrGiftCardTaskPO = new CusUrMbrGiftCardTaskPO();
        cusUrMbrGiftCardTaskPO.setSysCompanyId(vo.getSysCompanyId());
        cusUrMbrGiftCardTaskPO.setSysBrandId(vo.getSysBrandId());
        cusUrMbrGiftCardTaskPO.setTaskBatchCode(taskBatchCode);
        cusUrMbrGiftCardTaskPO.setTaskFileName(taskBatchName);
        cusUrMbrGiftCardTaskPO.setCardCount(vo.getNumber());
        cusUrMbrGiftCardTaskPO.setSendTime(new Date());
        cusUrMbrGiftCardTaskPO.setSendType(Byte.valueOf((byte)1));
        cusUrMbrGiftCardTaskPO.setCreateDate(new Date());
        cusUrMbrGiftCardTaskPO.setCreateUserName(vo.getCreater());
        this.cusUrMbrGiftCardTaskPOMapper.insertSelective(cusUrMbrGiftCardTaskPO);
        CusUrMbrGiftCardTaskDetailPO cusUrMbrGiftCardTaskDetailPO = new CusUrMbrGiftCardTaskDetailPO();
        cusUrMbrGiftCardTaskDetailPO.setSysCompanyId(vo.getSysCompanyId());
        cusUrMbrGiftCardTaskDetailPO.setSysBrandId(vo.getSysBrandId());
        cusUrMbrGiftCardTaskDetailPO.setTaskBatchCode(taskBatchCode);
        cusUrMbrGiftCardTaskDetailPO.setTaskFileName(taskBatchName);
        cusUrMbrGiftCardTaskDetailPO.setBalance(vo.getBalance());
        cusUrMbrGiftCardTaskDetailPO.setGiveBalance(vo.getGiveBalance());
        cusUrMbrGiftCardTaskDetailPO.setType(GIFT_CARD_STATUS_NOT_ACTIVE);
        cusUrMbrGiftCardTaskDetailPO.setAuditeStatus(GIFT_CARD_STATUS_NOT_ACTIVE);
        cusUrMbrGiftCardTaskDetailPO.setCreatedDate(SDF.format(new Date()));
        cusUrMbrGiftCardTaskDetailPO.setCreater(vo.getCreater());
        vo.setStatus(GIFT_CARD_STATUS_NOT_ACTIVE);
        vo.setType(GIFT_CARD_STATUS_NOT_ACTIVE);
        vo.setCreatedDate(SDF.format(new Date()));
        vo.setTaskBatchCode(taskBatchCode);
        vo.setTaskFileName(taskBatchName);
        ArrayList<GiftCardRequestVO> giftCardRequestVOList = new ArrayList<GiftCardRequestVO>();
        for (int i = 0; i < vo.getNumber(); ++i) {
            String password = this.generateRandomPassword();
            vo.setPassword(password);
            cusUrMbrGiftCardTaskDetailPO.setPassword(password);
            try {
                String number = this.getcardGenerateGiftNo(cardNo, vo.getSysCompanyId(), vo.getSysBrandId());
                vo.setCardNo(number);
                this.cusUrMbrGiftCardPOMapper.insertSelective((CusUrMbrGiftCardPO)vo);
                cusUrMbrGiftCardDetailPO.setCardNo(number);
                this.cusUrMbrGiftCardDetailPOMapper.insertSelective(cusUrMbrGiftCardDetailPO);
                cusUrMbrGiftCardTaskDetailPO.setCardNo(number);
                this.cusUrMbrGiftCardTaskDetailPOMapper.insertSelective(cusUrMbrGiftCardTaskDetailPO);
            }
            catch (Exception e) {
                return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
            }
            GiftCardRequestVO giftCardRequestVO = new GiftCardRequestVO();
            giftCardRequestVO.setCardNo(vo.getCardNo());
            giftCardRequestVO.setBalance(vo.getBalance());
            giftCardRequestVO.setUpdateBalance(vo.getBalance());
            giftCardRequestVO.setGiveBalance(vo.getGiveBalance());
            giftCardRequestVO.setUpdateGiveBalance(vo.getGiveBalance());
            giftCardRequestVO.setCreater(vo.getCreater());
            giftCardRequestVO.setCreatedDate(SDF.format(new Date()));
            giftCardRequestVO.setPassword(password);
            giftCardRequestVO.setBrandId(vo.getSysBrandId());
            giftCardRequestVO.setType(GIFT_CARD_STATUS_NOT_ACTIVE);
            giftCardRequestVO.setStatus(GIFT_CARD_STATUS_NOT_ACTIVE);
            giftCardRequestVOList.add(giftCardRequestVO);
        }
        GiftCardListRequestVO giftCardListRequestVO = new GiftCardListRequestVO();
        giftCardListRequestVO.setBrandId(vo.getSysBrandId());
        giftCardListRequestVO.setList(giftCardRequestVOList);
        log.info("addGiftCardList connector batchSaveGiftCardDetail!");
        Result result = this.connectorServiceFeign.batchSaveGiftCardDetail(giftCardListRequestVO);
        if (!"0".equals(result.getCode())) {
            log.error("connectorServiceFeign batchSaveGiftCardDetail error " + result.getMessage());
        }
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResponseData modifyGiftCard(CusUrMbrGiftCardVO vo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getCardNo())) {
            responseData.setMessage("\u793c\u54c1\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getStatus())) {
            responseData.setMessage("\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (GIFT_CARD_STATUS_ACTIVED.equals(vo.getStatus()) && StringUtils.isBlank((CharSequence)vo.getValidityTime())) {
            responseData.setMessage("\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (!GIFT_CARD_STATUS_ABORT.equals(vo.getStatus()) && vo.getOperationAmountType() == null) {
            responseData.setMessage("\u64cd\u4f5c\u91d1\u989d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (!GIFT_CARD_STATUS_ABORT.equals(vo.getStatus()) && StringUtils.isBlank((CharSequence)vo.getOpeType())) {
            responseData.setMessage("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (!GIFT_CARD_STATUS_ABORT.equals(vo.getStatus()) && Integer.valueOf(1).equals(vo.getOperationAmountType())) {
            if (vo.getChangeBlance() == null) {
                responseData.setMessage("\u64cd\u4f5c\u672c\u91d1\u53d8\u52a8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
                return responseData;
            }
            if (vo.getChangeBlance().compareTo(BigDecimal.ZERO) == -1) {
                responseData.setMessage("\u64cd\u4f5c\u672c\u91d1\u53d8\u52a8\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f!");
                return responseData;
            }
            if (GIFT_CARD_STATUS_NOT_ACTIVE.equals(vo.getStatus()) && BigDecimal.ZERO.equals(vo.getChangeBlance())) {
                responseData.setMessage("\u5f53\u524d\u72b6\u6001\u4e0b,\u64cd\u4f5c\u672c\u91d1\u53d8\u52a8\u91d1\u989d\u4e0d\u80fd\u4e3a0!");
                return responseData;
            }
            vo.setChangeGiveBlance(null);
        } else if (!GIFT_CARD_STATUS_ABORT.equals(vo.getStatus()) && Integer.valueOf(2).equals(vo.getOperationAmountType())) {
            if (vo.getChangeGiveBlance() == null) {
                responseData.setMessage("\u64cd\u4f5c\u8d60\u9001\u53d8\u52a8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
                return responseData;
            }
            if (vo.getChangeGiveBlance().compareTo(BigDecimal.ZERO) == -1) {
                responseData.setMessage("\u64cd\u4f5c\u8d60\u9001\u53d8\u52a8\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f!");
                return responseData;
            }
            if (GIFT_CARD_STATUS_NOT_ACTIVE.equals(vo.getStatus()) && BigDecimal.ZERO.equals(vo.getChangeGiveBlance())) {
                responseData.setMessage("\u5f53\u524d\u72b6\u6001\u4e0b,\u64cd\u4f5c\u8d60\u9001\u53d8\u52a8\u91d1\u989d\u4e0d\u80fd\u4e3a0!");
                return responseData;
            }
            vo.setChangeBlance(null);
        }
        CusUrMbrGiftCardPOExample example = new CusUrMbrGiftCardPOExample();
        example.createCriteria().andSysCompanyIdEqualTo(vo.getSysCompanyId()).andSysBrandIdEqualTo(vo.getSysBrandId()).andCardNoEqualTo(vo.getCardNo()).andValidEqualTo(Boolean.valueOf(true));
        List cusUrMbrGiftCardPOList = this.cusUrMbrGiftCardPOMapper.selectByExample(example);
        if (cusUrMbrGiftCardPOList.size() == 0) {
            responseData.setMessage("\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u7684\u793c\u54c1\u5361\u4fe1\u606f!");
            return responseData;
        }
        CusUrMbrGiftCardPO cusUrMbrGiftCardPO = (CusUrMbrGiftCardPO)cusUrMbrGiftCardPOList.get(0);
        String status = cusUrMbrGiftCardPO.getStatus();
        if (GIFT_CARD_STATUS_ABORT.equals(status)) {
            responseData.setMessage("\u4f5c\u5e9f\u7684\u793c\u54c1\u5361\u4e0d\u53ef\u7f16\u8f91!");
            return responseData;
        }
        if (GIFT_CARD_STATUS_ACTIVED.equals(status) && GIFT_CARD_STATUS_NOT_ACTIVE.equals(vo.getStatus())) {
            responseData.setMessage("\u5df2\u6fc0\u6d3b\u7684\u793c\u54c1\u5361,\u4e0d\u80fd\u53d8\u4e3a\u672a\u6fc0\u6d3b\u72b6\u6001!");
            return responseData;
        }
        String taskBatchCode = this.generateTaskBatchCode();
        String taskBatchName = "\u793c\u54c1\u5361\u7f16\u8f91";
        vo.setTaskBatchCode(taskBatchCode);
        vo.setTaskFileName(taskBatchName);
        CusUrMbrGiftCardDetailPO cusUrMbrGiftCardDetailPO = new CusUrMbrGiftCardDetailPO();
        cusUrMbrGiftCardDetailPO.setSysCompanyId(vo.getSysCompanyId());
        cusUrMbrGiftCardDetailPO.setSysBrandId(vo.getSysBrandId());
        cusUrMbrGiftCardDetailPO.setUpdatebalance(vo.getChangeBlance());
        cusUrMbrGiftCardDetailPO.setBalance(vo.getBalance());
        cusUrMbrGiftCardDetailPO.setUpdateGiveBalance(vo.getChangeGiveBlance());
        cusUrMbrGiftCardDetailPO.setGiveBalance(vo.getGiveBalance());
        cusUrMbrGiftCardDetailPO.setCreatedDate(SDF.format(new Date()));
        cusUrMbrGiftCardDetailPO.setTaskBatchCode(taskBatchCode);
        cusUrMbrGiftCardDetailPO.setTaskFileName(taskBatchName);
        cusUrMbrGiftCardDetailPO.setCardNo(vo.getCardNo());
        cusUrMbrGiftCardDetailPO.setCreater(vo.getModifiedUserName());
        cusUrMbrGiftCardDetailPO.setModifiedUserId(vo.getModifiedUserId());
        cusUrMbrGiftCardDetailPO.setModifiedUserName(vo.getModifiedUserName());
        cusUrMbrGiftCardDetailPO.setModifiedDate(vo.getModifiedDate());
        if (GIFT_CARD_STATUS_ABORT.equals(vo.getStatus())) {
            vo.setBalance(null);
            vo.setGiveBalance(null);
            this.cusUrMbrGiftCardPOMapper.updateByExampleSelective((CusUrMbrGiftCardPO)vo, example);
            cusUrMbrGiftCardDetailPO.setUpdatebalance(null);
            cusUrMbrGiftCardDetailPO.setUpdateGiveBalance(null);
            cusUrMbrGiftCardDetailPO.setType("11");
            cusUrMbrGiftCardDetailPO.setBalance(cusUrMbrGiftCardPO.getBalance());
            cusUrMbrGiftCardDetailPO.setGiveBalance(cusUrMbrGiftCardPO.getGiveBalance());
            this.cusUrMbrGiftCardDetailPOMapper.insertSelective(cusUrMbrGiftCardDetailPO);
            GiftCardListRequestVO giftCardListRequestVO = new GiftCardListRequestVO();
            giftCardListRequestVO.setBrandId(vo.getSysBrandId());
            ArrayList<GiftCardRequestVO> giftCardRequestVOList = new ArrayList<GiftCardRequestVO>();
            giftCardRequestVOList.add(this.buildGiftCardRequestVOByDetailPo(vo, cusUrMbrGiftCardDetailPO));
            giftCardListRequestVO.setList(giftCardRequestVOList);
            log.info("modifyGiftCard connector batchSaveGiftCardDetail!");
            Result result = this.connectorServiceFeign.batchSaveGiftCardDetail(giftCardListRequestVO);
            if (!"0".equals(result.getCode())) {
                log.error("connectorServiceFeign batchSaveGiftCardDetail error " + result.getMessage());
            }
            responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        if (GIFT_CARD_STATUS_ACTIVED.equals(vo.getStatus())) {
            cusUrMbrGiftCardDetailPO.setType("10");
            if (StringUtils.isBlank((CharSequence)vo.getValidityTime())) {
                responseData.setMessage("\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
                return responseData;
            }
        }
        if (Integer.valueOf(1).equals(vo.getOperationAmountType())) {
            if (cusUrMbrGiftCardPO.getBalance() == null) {
                cusUrMbrGiftCardPO.setBalance(new BigDecimal(0));
            }
            if (GIFT_CARD_STATUS_NOT_ACTIVE.equals(vo.getOpeType())) {
                vo.setBalance(cusUrMbrGiftCardPO.getBalance().add(vo.getChangeBlance()));
                cusUrMbrGiftCardDetailPO.setType(GIFT_CARD_STATUS_ACTIVED);
            } else if (GIFT_CARD_STATUS_ACTIVED.equals(vo.getOpeType())) {
                cusUrMbrGiftCardDetailPO.setType(GIFT_CARD_STATUS_ABORT);
                if (vo.getChangeBlance().compareTo(cusUrMbrGiftCardPO.getBalance()) == 1) {
                    responseData.setMessage("\u51cf\u5c11\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u793c\u54c1\u5361\u4f59\u989d!");
                    return responseData;
                }
                vo.setBalance(cusUrMbrGiftCardPO.getBalance().subtract(vo.getChangeBlance()));
            }
        } else if (Integer.valueOf(2).equals(vo.getOperationAmountType())) {
            if (cusUrMbrGiftCardPO.getGiveBalance() == null) {
                cusUrMbrGiftCardPO.setGiveBalance(new BigDecimal(0));
            }
            if (GIFT_CARD_STATUS_NOT_ACTIVE.equals(vo.getOpeType())) {
                vo.setGiveBalance(cusUrMbrGiftCardPO.getGiveBalance().add(vo.getChangeGiveBlance()));
                cusUrMbrGiftCardDetailPO.setType(GIFT_CARD_STATUS_ACTIVED);
            } else if (GIFT_CARD_STATUS_ACTIVED.equals(vo.getOpeType())) {
                cusUrMbrGiftCardDetailPO.setType(GIFT_CARD_STATUS_ABORT);
                if (vo.getChangeGiveBlance().compareTo(cusUrMbrGiftCardPO.getGiveBalance()) == 1) {
                    responseData.setMessage("\u51cf\u5c11\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u793c\u54c1\u5361\u8d60\u9001\u7684\u4f59\u989d!");
                    return responseData;
                }
                vo.setGiveBalance(cusUrMbrGiftCardPO.getGiveBalance().subtract(vo.getChangeGiveBlance()));
            }
        }
        this.cusUrMbrGiftCardPOMapper.updateByExampleSelective((CusUrMbrGiftCardPO)vo, example);
        ArrayList<GiftCardRequestVO> giftCardRequestVOList = new ArrayList<GiftCardRequestVO>();
        if (GIFT_CARD_STATUS_NOT_ACTIVE.equals(status) && GIFT_CARD_STATUS_ACTIVED.equals(vo.getStatus())) {
            CusUrMbrGiftCardDetailPO cusUrMbrGiftCardActivationRecord = new CusUrMbrGiftCardDetailPO();
            BeanUtils.copyProperties((Object)cusUrMbrGiftCardDetailPO, (Object)cusUrMbrGiftCardActivationRecord);
            cusUrMbrGiftCardActivationRecord.setType("10");
            cusUrMbrGiftCardActivationRecord.setBalance(cusUrMbrGiftCardPO.getBalance());
            cusUrMbrGiftCardActivationRecord.setGiveBalance(cusUrMbrGiftCardPO.getGiveBalance());
            cusUrMbrGiftCardActivationRecord.setUpdatebalance(null);
            cusUrMbrGiftCardActivationRecord.setUpdateGiveBalance(null);
            this.cusUrMbrGiftCardDetailPOMapper.insertSelective(cusUrMbrGiftCardActivationRecord);
            giftCardRequestVOList.add(this.buildGiftCardRequestVOByDetailPo(vo, cusUrMbrGiftCardActivationRecord));
        }
        if (!"10".equals(cusUrMbrGiftCardDetailPO.getType())) {
            cusUrMbrGiftCardDetailPO.setBalance(vo.getBalance());
            cusUrMbrGiftCardDetailPO.setUpdatebalance(vo.getChangeBlance());
            cusUrMbrGiftCardDetailPO.setGiveBalance(vo.getGiveBalance());
            cusUrMbrGiftCardDetailPO.setUpdateGiveBalance(vo.getChangeGiveBlance());
            this.cusUrMbrGiftCardDetailPOMapper.insertSelective(cusUrMbrGiftCardDetailPO);
            giftCardRequestVOList.add(this.buildGiftCardRequestVOByDetailPo(vo, cusUrMbrGiftCardDetailPO));
        }
        if (CollectionUtils.isEmpty(giftCardRequestVOList)) {
            log.info("connectorServiceFeign before giftCardRequestVOList isEmpty");
            responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
            return responseData;
        }
        GiftCardListRequestVO giftCardListRequestVO = new GiftCardListRequestVO();
        giftCardListRequestVO.setBrandId(vo.getSysBrandId());
        giftCardListRequestVO.setList(giftCardRequestVOList);
        log.info("modifyGiftCard connector batchSaveGiftCardDetail!");
        Result result = this.connectorServiceFeign.batchSaveGiftCardDetail(giftCardListRequestVO);
        if (!"0".equals(result.getCode())) {
            log.error("connectorServiceFeign batchSaveGiftCardDetail error " + result.getMessage());
        }
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    private GiftCardRequestVO buildGiftCardRequestVOByDetailPo(CusUrMbrGiftCardVO vo, CusUrMbrGiftCardDetailPO cusUrMbrGiftCardDetailPO) {
        GiftCardRequestVO giftCardRequestVO = new GiftCardRequestVO();
        giftCardRequestVO.setCardNo(cusUrMbrGiftCardDetailPO.getCardNo());
        giftCardRequestVO.setBalance(cusUrMbrGiftCardDetailPO.getBalance());
        giftCardRequestVO.setUpdateBalance(cusUrMbrGiftCardDetailPO.getUpdatebalance());
        giftCardRequestVO.setGiveBalance(cusUrMbrGiftCardDetailPO.getGiveBalance());
        giftCardRequestVO.setUpdateGiveBalance(cusUrMbrGiftCardDetailPO.getUpdateGiveBalance());
        giftCardRequestVO.setCreater(cusUrMbrGiftCardDetailPO.getCreater());
        giftCardRequestVO.setCreatedDate(cusUrMbrGiftCardDetailPO.getCreatedDate());
        giftCardRequestVO.setBrandId(cusUrMbrGiftCardDetailPO.getSysBrandId());
        giftCardRequestVO.setStatus(vo.getStatus());
        if (GIFT_CARD_STATUS_ACTIVED.equals(vo.getStatus())) {
            giftCardRequestVO.setValidityTime(vo.getValidityTime());
        }
        giftCardRequestVO.setType(cusUrMbrGiftCardDetailPO.getType());
        return giftCardRequestVO;
    }

    public ResponseData batchActivationGiftCard(CusUrMbrGiftCardVO vo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getCardNoList() == null || vo.getCardNoList().size() == 0) {
            responseData.setMessage("\u793c\u54c1\u5361\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getValidityTime())) {
            responseData.setMessage("\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        String taskBatchCode = this.generateTaskBatchCode();
        String taskBatchName = "\u793c\u54c1\u5361\u6fc0\u6d3b";
        vo.setTaskBatchCode(taskBatchCode);
        vo.setTaskFileName(taskBatchName);
        vo.setStatus(GIFT_CARD_STATUS_ACTIVED);
        CusUrMbrGiftCardDetailPO cusUrMbrGiftCardDetailPO = new CusUrMbrGiftCardDetailPO();
        cusUrMbrGiftCardDetailPO.setSysCompanyId(vo.getSysCompanyId());
        cusUrMbrGiftCardDetailPO.setSysBrandId(vo.getSysBrandId());
        cusUrMbrGiftCardDetailPO.setType("10");
        cusUrMbrGiftCardDetailPO.setCreatedDate(SDF.format(new Date()));
        cusUrMbrGiftCardDetailPO.setTaskBatchCode(taskBatchCode);
        cusUrMbrGiftCardDetailPO.setTaskFileName(taskBatchName);
        cusUrMbrGiftCardDetailPO.setValidityTime(vo.getValidityTime());
        cusUrMbrGiftCardDetailPO.setCreater(vo.getModifiedUserName());
        cusUrMbrGiftCardDetailPO.setModifiedUserId(vo.getModifiedUserId());
        cusUrMbrGiftCardDetailPO.setModifiedUserName(vo.getModifiedUserName());
        cusUrMbrGiftCardDetailPO.setModifiedDate(vo.getModifiedDate());
        CusUrMbrGiftCardPOExample example = new CusUrMbrGiftCardPOExample();
        example.createCriteria().andSysCompanyIdEqualTo(vo.getSysCompanyId()).andSysBrandIdEqualTo(vo.getSysBrandId()).andCardNoIn(vo.getCardNoList()).andValidEqualTo(Boolean.valueOf(true));
        List cusUrMbrGiftCardPOList = this.cusUrMbrGiftCardPOMapper.selectByExample(example);
        Integer activation = 0;
        Integer notActive = 0;
        if (cusUrMbrGiftCardPOList.size() > 0) {
            for (int i = 0; i < cusUrMbrGiftCardPOList.size(); ++i) {
                CusUrMbrGiftCardPO cusUrMbrGiftCardPO = (CusUrMbrGiftCardPO)cusUrMbrGiftCardPOList.get(i);
                if (GIFT_CARD_STATUS_ACTIVED.equals(cusUrMbrGiftCardPO.getStatus()) || GIFT_CARD_STATUS_ABORT.equals(cusUrMbrGiftCardPO.getStatus())) {
                    Integer n = activation;
                    Integer n2 = activation = Integer.valueOf(activation + 1);
                    continue;
                }
                vo.setCardNo(cusUrMbrGiftCardPO.getCardNo());
                CusUrMbrGiftCardPOExample examplepo = new CusUrMbrGiftCardPOExample();
                examplepo.createCriteria().andSysCompanyIdEqualTo(vo.getSysCompanyId()).andSysBrandIdEqualTo(vo.getSysBrandId()).andCardNoEqualTo(vo.getCardNo()).andValidEqualTo(Boolean.valueOf(true));
                this.cusUrMbrGiftCardPOMapper.updateByExampleSelective((CusUrMbrGiftCardPO)vo, examplepo);
                cusUrMbrGiftCardDetailPO.setBalance(cusUrMbrGiftCardPO.getBalance());
                cusUrMbrGiftCardDetailPO.setGiveBalance(cusUrMbrGiftCardPO.getGiveBalance());
                cusUrMbrGiftCardDetailPO.setCardNo(cusUrMbrGiftCardPO.getCardNo());
                this.cusUrMbrGiftCardDetailPOMapper.insertSelective(cusUrMbrGiftCardDetailPO);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                GiftCardListRequestVO giftCardListRequestVO = new GiftCardListRequestVO();
                giftCardListRequestVO.setBrandId(vo.getSysBrandId());
                ArrayList<GiftCardRequestVO> giftCardRequestVOList = new ArrayList<GiftCardRequestVO>();
                GiftCardRequestVO giftCardRequestVO = new GiftCardRequestVO();
                giftCardRequestVO.setCardNo(vo.getCardNo());
                giftCardRequestVO.setBalance(cusUrMbrGiftCardDetailPO.getBalance());
                giftCardRequestVO.setUpdateBalance(cusUrMbrGiftCardDetailPO.getUpdatebalance());
                giftCardRequestVO.setGiveBalance(cusUrMbrGiftCardDetailPO.getGiveBalance());
                giftCardRequestVO.setUpdateGiveBalance(cusUrMbrGiftCardDetailPO.getUpdateGiveBalance());
                giftCardRequestVO.setCreater(vo.getModifiedUserName());
                giftCardRequestVO.setCreatedDate(SDF.format(new Date()));
                giftCardRequestVO.setBrandId(vo.getSysBrandId());
                if (GIFT_CARD_STATUS_ACTIVED.equals(vo.getStatus())) {
                    giftCardRequestVO.setStatus(GIFT_CARD_STATUS_ACTIVED);
                    giftCardRequestVO.setValidityTime(vo.getValidityTime());
                }
                giftCardRequestVO.setType(cusUrMbrGiftCardDetailPO.getType());
                giftCardRequestVOList.add(giftCardRequestVO);
                giftCardListRequestVO.setList(giftCardRequestVOList);
                log.info("batchActivationGiftCard connector batchSaveGiftCardDetail!");
                Result result = this.connectorServiceFeign.batchSaveGiftCardDetail(giftCardListRequestVO);
                if (!"0".equals(result.getCode())) {
                    log.error("connectorServiceFeign batchSaveGiftCardDetail error " + result.getMessage());
                }
                Integer n = notActive;
                Integer n3 = notActive = Integer.valueOf(notActive + 1);
            }
        }
        responseData.setMessage("\u6fc0\u6d3b\u6210\u529f" + notActive + "\u4e2a,\u6fc0\u6d3b\u5931\u8d25" + activation + "\u4e2a");
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData getGiftCardList(CusUrMbrGiftCardVO vo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        List cusUrMbrGiftCardPOList = this.cusUrMbrGiftCardPOMapper.selectGiftCardList(vo);
        PageInfo pageInfo = new PageInfo(cusUrMbrGiftCardPOList);
        responseData.setData((Object)pageInfo);
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData getGiftCard(CusUrMbrGiftCardPO po) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        if (po.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (po.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)po.getCardNo())) {
            responseData.setMessage("\u793c\u54c1\u5361\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        CusUrMbrGiftCardPOExample example = new CusUrMbrGiftCardPOExample();
        example.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysCompanyIdEqualTo(po.getSysCompanyId()).andSysBrandIdEqualTo(po.getSysBrandId()).andCardNoEqualTo(po.getCardNo());
        List cusUrMbrGiftCardPOList = this.cusUrMbrGiftCardPOMapper.selectByExample(example);
        if (cusUrMbrGiftCardPOList.size() > 0) {
            CusUrMbrGiftCardPO cusUrMbrGiftCardPO = (CusUrMbrGiftCardPO)cusUrMbrGiftCardPOList.get(0);
            responseData.setData((Object)cusUrMbrGiftCardPO);
        }
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    public ResponseData importGiftCardExcel(String url, SysAccountPO po) {
        ResponseData responseData = new ResponseData();
        ResponseData findFileTaskNumResponseData = this.fileTaskServiceRpc.findFileTaskNum(po.getSysAccountId());
        if (findFileTaskNumResponseData.getCode() > 0) {
            return findFileTaskNumResponseData;
        }
        ArrayList codeList = new ArrayList();
        List cusUrMbrGiftCardPOList = Collections.synchronizedList(new ArrayList());
        ArrayList repeatList = new ArrayList();
        CusUrMbrGiftCardTaskPO cusUrMbrGiftCardTaskPO = new CusUrMbrGiftCardTaskPO();
        cusUrMbrGiftCardTaskPO.setSysCompanyId(po.getSysCompanyId());
        cusUrMbrGiftCardTaskPO.setSysBrandId(po.getBrandId());
        String taskBatchCode = this.generateTaskBatchCode();
        String taskBatchName = "\u793c\u54c1\u5361\u5bfc\u5165";
        cusUrMbrGiftCardTaskPO.setTaskBatchCode(taskBatchCode);
        cusUrMbrGiftCardTaskPO.setTaskFileName(taskBatchName);
        cusUrMbrGiftCardTaskPO.setTaskFileUrl(url);
        cusUrMbrGiftCardTaskPO.setSendType(Byte.valueOf((byte)2));
        cusUrMbrGiftCardTaskPO.setCreateUserId(po.getSysAccountId());
        cusUrMbrGiftCardTaskPO.setCreateUserName(po.getName());
        cusUrMbrGiftCardTaskPO.setCreateDate(new Date());
        cusUrMbrGiftCardTaskPO.setRemark("\u793c\u54c1\u5361\u5bfc\u5165");
        CusUrMbrGiftCardTaskDetailPO cusUrMbrGiftCardTaskDetailFailPO = new CusUrMbrGiftCardTaskDetailPO();
        cusUrMbrGiftCardTaskDetailFailPO.setSysCompanyId(po.getSysCompanyId());
        cusUrMbrGiftCardTaskDetailFailPO.setSysBrandId(po.getBrandId());
        cusUrMbrGiftCardTaskDetailFailPO.setTaskBatchCode(taskBatchCode);
        cusUrMbrGiftCardTaskDetailFailPO.setTaskFileName(taskBatchName);
        cusUrMbrGiftCardTaskDetailFailPO.setType(GIFT_CARD_STATUS_ACTIVED);
        cusUrMbrGiftCardTaskDetailFailPO.setCreater(po.getName());
        cusUrMbrGiftCardTaskDetailFailPO.setCreatedDate(SDF.format(new Date()));
        CommonExportExcelUtil re = null;
        AtomicBoolean flag = new AtomicBoolean(false);
        Integer num = 0;
        try {
            re = DownLoadFileUtil.urlToExcel((String)QiNiuUtil.httpUrlCompatible((String)(this.qiNiuConfig.getDomain() + "/"), (String)url));
            num = re.getLastRowNum();
            if (num > 50000) {
                responseData.setMessage("\u5bfc\u5165\u5931\u8d25\uff0c\u6570\u91cf\u6700\u591a\u4e3a5\u4e07\u6761");
                responseData.setCode(SysResponseEnum.FAILED.getCode());
                cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)0));
                cusUrMbrGiftCardTaskPO.setCardCount(Integer.valueOf(0));
                this.cusUrMbrGiftCardTaskPOMapper.insertSelective(cusUrMbrGiftCardTaskPO);
                cusUrMbrGiftCardTaskDetailFailPO.setAuditeStatus(GIFT_CARD_STATUS_ACTIVED);
                cusUrMbrGiftCardTaskDetailFailPO.setRemark("\u5bfc\u5165\u6570\u91cf\u6700\u591a\u4e3a5\u4e07\u6761");
                this.cusUrMbrGiftCardTaskDetailPOMapper.insertSelective(cusUrMbrGiftCardTaskDetailFailPO);
                return responseData;
            }
            RedisClient redisClient = RedisManager.getInstince();
            for (int i = 0; i < 1; ++i) {
                AtomicInteger a = new AtomicInteger();
                re.read(0, 0, 3, i, row -> {
                    if (a.compareAndSet(0, 0)) {
                        String col1 = (String)row[0];
                        if (!"\u793c\u54c1\u5361\u53f7".equals(col1)) {
                            flag.set(true);
                            return;
                        }
                        a.incrementAndGet();
                        return;
                    }
                    String cardNo = (String)row[0];
                    String paramPwd = (String)row[1];
                    BigDecimal paramBalance = null;
                    BigDecimal paramGiveBalance = null;
                    if (StringUtil.isEmpty((String)cardNo)) {
                        return;
                    }
                    codeList.add(cardNo);
                    try {
                        paramBalance = this.getBig(row[2]);
                        if (paramBalance == null) {
                            throw new Exception("\u672c\u91d1\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                    }
                    catch (Exception e) {
                        cusUrMbrGiftCardTaskDetailFailPO.setAuditeStatus(GIFT_CARD_STATUS_ACTIVED);
                        cusUrMbrGiftCardTaskDetailFailPO.setRemark("\u672c\u91d1\u4f59\u989d\u53ea\u80fd\u4e3a\u6570\u5b57");
                        cusUrMbrGiftCardTaskDetailFailPO.setCardNo(cardNo);
                        cusUrMbrGiftCardTaskDetailFailPO.setPassword(paramPwd);
                        cusUrMbrGiftCardTaskDetailFailPO.setCreatedDate(SDF.format(new Date()));
                        this.cusUrMbrGiftCardTaskDetailPOMapper.insertSelective(cusUrMbrGiftCardTaskDetailFailPO);
                        return;
                    }
                    try {
                        paramGiveBalance = this.getBig(row[3]);
                    }
                    catch (Exception e) {
                        log.info("\u8d60\u9001\u4f59\u989d\u53ea\u80fd\u4e3a\u6570\u5b57:{}", row[3]);
                        cusUrMbrGiftCardTaskDetailFailPO.setAuditeStatus(GIFT_CARD_STATUS_ACTIVED);
                        cusUrMbrGiftCardTaskDetailFailPO.setRemark("\u8d60\u9001\u4f59\u989d\u53ea\u80fd\u4e3a\u6570\u5b57");
                        cusUrMbrGiftCardTaskDetailFailPO.setCardNo(cardNo);
                        cusUrMbrGiftCardTaskDetailFailPO.setPassword(paramPwd);
                        cusUrMbrGiftCardTaskDetailFailPO.setCreatedDate(SDF.format(new Date()));
                        this.cusUrMbrGiftCardTaskDetailPOMapper.insertSelective(cusUrMbrGiftCardTaskDetailFailPO);
                        return;
                    }
                    String card = null;
                    try {
                        card = this.validateGiftCard(redisClient, cardNo, paramPwd, paramBalance, paramGiveBalance, cusUrMbrGiftCardTaskDetailFailPO);
                    }
                    catch (Exception e) {
                        return;
                    }
                    if (card != null) {
                        repeatList.add(card);
                        return;
                    }
                    CusUrMbrGiftCardPO cusUrMbrGiftCardPO = new CusUrMbrGiftCardPO();
                    cusUrMbrGiftCardPO.setCardNo(cardNo);
                    cusUrMbrGiftCardPO.setPassword(paramPwd);
                    cusUrMbrGiftCardPO.setBalance(paramBalance);
                    cusUrMbrGiftCardPO.setGiveBalance(paramGiveBalance);
                    cusUrMbrGiftCardPOList.add(cusUrMbrGiftCardPO);
                });
            }
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("excel\u6587\u4ef6url\u89e3\u6790\u51fa\u9519!");
            log.error("\u793c\u54c1\u5361\u5bfc\u5165\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)0));
            cusUrMbrGiftCardTaskPO.setCardCount(Integer.valueOf(0));
            this.cusUrMbrGiftCardTaskPOMapper.insertSelective(cusUrMbrGiftCardTaskPO);
            cusUrMbrGiftCardTaskDetailFailPO.setAuditeStatus(GIFT_CARD_STATUS_ACTIVED);
            cusUrMbrGiftCardTaskDetailFailPO.setRemark("excel\u6587\u4ef6url\u89e3\u6790\u51fa\u9519!");
            this.cusUrMbrGiftCardTaskDetailPOMapper.insertSelective(cusUrMbrGiftCardTaskDetailFailPO);
            return responseData;
        }
        if (flag.get()) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("\u5bfc\u5165excel\u6587\u4ef6\u548c\u6a21\u677f\u6587\u4ef6\u4e0d\u540c!");
            cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)0));
            cusUrMbrGiftCardTaskPO.setCardCount(Integer.valueOf(0));
            this.cusUrMbrGiftCardTaskPOMapper.insertSelective(cusUrMbrGiftCardTaskPO);
            cusUrMbrGiftCardTaskDetailFailPO.setAuditeStatus(GIFT_CARD_STATUS_ACTIVED);
            cusUrMbrGiftCardTaskDetailFailPO.setRemark("\u5bfc\u5165excel\u6587\u4ef6\u548c\u6a21\u677f\u6587\u4ef6\u4e0d\u540c!");
            this.cusUrMbrGiftCardTaskDetailPOMapper.insertSelective(cusUrMbrGiftCardTaskDetailFailPO);
            return responseData;
        }
        if (CollectionUtils.isNotEmpty(codeList)) {
            cusUrMbrGiftCardTaskPO.setCardCount(Integer.valueOf(codeList.size()));
            Map cusUrMbrGiftCardPOMap = cusUrMbrGiftCardPOList.stream().collect(Collectors.toMap(CusUrMbrGiftCardPO::getCardNo, Function.identity(), (key1, key2) -> key1));
            for (String repeat : repeatList) {
                CusUrMbrGiftCardPO cusUrMbrGiftCardPO = (CusUrMbrGiftCardPO)cusUrMbrGiftCardPOMap.get(repeat);
                if (cusUrMbrGiftCardPO == null) continue;
                cusUrMbrGiftCardPOList.remove(cusUrMbrGiftCardPO);
                cusUrMbrGiftCardTaskDetailFailPO.setAuditeStatus(GIFT_CARD_STATUS_ACTIVED);
                cusUrMbrGiftCardTaskDetailFailPO.setRemark("\u5bfc\u5165\u6587\u4ef6\u4e2d\u6709\u91cd\u590d\u5361\u53f7");
                cusUrMbrGiftCardTaskDetailFailPO.setCardNo(cusUrMbrGiftCardPO.getCardNo());
                cusUrMbrGiftCardTaskDetailFailPO.setPassword(cusUrMbrGiftCardPO.getPassword());
                cusUrMbrGiftCardTaskDetailFailPO.setBalance(cusUrMbrGiftCardPO.getBalance());
                cusUrMbrGiftCardTaskDetailFailPO.setGiveBalance(cusUrMbrGiftCardPO.getGiveBalance());
                cusUrMbrGiftCardTaskDetailFailPO.setCreatedDate(SDF.format(new Date()));
                this.cusUrMbrGiftCardTaskDetailPOMapper.insertSelective(cusUrMbrGiftCardTaskDetailFailPO);
            }
            responseData = this.asynchronousInsertValidte(cusUrMbrGiftCardPOList, po, cusUrMbrGiftCardTaskPO);
            if (responseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                return responseData;
            }
        } else {
            responseData.setMessage("\u5bfc\u5165\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)0));
            cusUrMbrGiftCardTaskPO.setCardCount(Integer.valueOf(0));
            this.cusUrMbrGiftCardTaskPOMapper.insertSelective(cusUrMbrGiftCardTaskPO);
            cusUrMbrGiftCardTaskDetailFailPO.setAuditeStatus(GIFT_CARD_STATUS_ACTIVED);
            cusUrMbrGiftCardTaskDetailFailPO.setRemark("\u672a\u586b\u5165\u5361\u53f7\u6216\u4e0d\u7b26\u5408\u6821\u9a8c");
            this.cusUrMbrGiftCardTaskDetailPOMapper.insertSelective(cusUrMbrGiftCardTaskDetailFailPO);
            return responseData;
        }
        responseData.setMessage("\u5bfc\u5165\u6210\u529f " + cusUrMbrGiftCardPOList.size() + " \u6761\u3002 \u5931\u8d25 " + (num - cusUrMbrGiftCardPOList.size()) + " \u6761");
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData giftCardToExamine(GiftCardToExamineVO vo) {
        CusUrMbrGiftCardTaskPOExample cusUrMbrGiftCardTaskPOExample;
        CusUrMbrGiftCardTaskPO cusUrMbrGiftCardTaskPO;
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getState())) {
            responseData.setMessage("\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getTaskBatchCode())) {
            responseData.setMessage("\u4efb\u52a1\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getGiftCardTaskId() == null) {
            responseData.setMessage("\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        CusUrMbrGiftCardTaskDetailPOExample example = new CusUrMbrGiftCardTaskDetailPOExample();
        example.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysCompanyIdEqualTo(vo.getSysCompanyId()).andSysBrandIdEqualTo(vo.getSysBrandId()).andTaskBatchCodeEqualTo(vo.getTaskBatchCode()).andAuditeStatusEqualTo("4");
        List cusUrMbrGiftCardTaskDetailPOList = this.cusUrMbrGiftCardTaskDetailPOMapper.selectByExample(example);
        if (cusUrMbrGiftCardTaskDetailPOList.size() > 0) {
            cusUrMbrGiftCardTaskPO = new CusUrMbrGiftCardTaskPO();
            cusUrMbrGiftCardTaskPOExample = new CusUrMbrGiftCardTaskPOExample();
            cusUrMbrGiftCardTaskPOExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSysCompanyIdEqualTo(vo.getSysCompanyId()).andSysBrandIdEqualTo(vo.getSysBrandId()).andTaskBatchCodeEqualTo(vo.getTaskBatchCode());
            GiftCardListRequestVO giftCardListRequestVO = new GiftCardListRequestVO();
            giftCardListRequestVO.setBrandId(vo.getSysBrandId());
            if (GIFT_CARD_STATUS_NOT_ACTIVE.equals(vo.getState())) {
                ArrayList<CusUrMbrGiftCardPO> cusUrMbrGiftCardPOList = new ArrayList<CusUrMbrGiftCardPO>();
                ArrayList<CusUrMbrGiftCardDetailPO> cusUrMbrGiftCardDetailPOList = new ArrayList<CusUrMbrGiftCardDetailPO>();
                ArrayList<GiftCardRequestVO> giftCardRequestVOList = new ArrayList<GiftCardRequestVO>();
                for (int i = 0; i < cusUrMbrGiftCardTaskDetailPOList.size(); ++i) {
                    CusUrMbrGiftCardTaskDetailPO po = (CusUrMbrGiftCardTaskDetailPO)cusUrMbrGiftCardTaskDetailPOList.get(i);
                    CusUrMbrGiftCardPO cusUrMbrGiftCardPO = new CusUrMbrGiftCardPO();
                    cusUrMbrGiftCardPO.setSysCompanyId(vo.getSysCompanyId());
                    cusUrMbrGiftCardPO.setSysBrandId(vo.getSysBrandId());
                    cusUrMbrGiftCardPO.setCardNo(po.getCardNo());
                    cusUrMbrGiftCardPO.setPassword(po.getPassword());
                    cusUrMbrGiftCardPO.setBalance(po.getBalance());
                    cusUrMbrGiftCardPO.setCreater(po.getCreater());
                    cusUrMbrGiftCardPO.setStatus(GIFT_CARD_STATUS_NOT_ACTIVE);
                    cusUrMbrGiftCardPO.setType(GIFT_CARD_STATUS_ACTIVED);
                    cusUrMbrGiftCardPO.setTaskBatchCode(po.getTaskBatchCode());
                    cusUrMbrGiftCardPO.setTaskFileName(po.getTaskFileName());
                    cusUrMbrGiftCardPO.setCreatedDate(SDF.format(new Date()));
                    cusUrMbrGiftCardPO.setValid(Boolean.valueOf(true));
                    cusUrMbrGiftCardPOList.add(cusUrMbrGiftCardPO);
                    CusUrMbrGiftCardDetailPO cusUrMbrGiftCardDetailPO = new CusUrMbrGiftCardDetailPO();
                    cusUrMbrGiftCardDetailPO.setSysCompanyId(po.getSysCompanyId());
                    cusUrMbrGiftCardDetailPO.setSysBrandId(vo.getSysBrandId());
                    cusUrMbrGiftCardDetailPO.setTaskBatchCode(po.getTaskBatchCode());
                    cusUrMbrGiftCardDetailPO.setTaskFileName(po.getTaskFileName());
                    cusUrMbrGiftCardDetailPO.setCardNo(po.getCardNo());
                    cusUrMbrGiftCardDetailPO.setType(GIFT_CARD_STATUS_NOT_ACTIVE);
                    cusUrMbrGiftCardDetailPO.setCreatedDate(SDF.format(new Date()));
                    cusUrMbrGiftCardDetailPO.setBalance(po.getBalance());
                    cusUrMbrGiftCardDetailPO.setCreater(po.getCreater());
                    cusUrMbrGiftCardDetailPO.setUpdatebalance(po.getBalance());
                    cusUrMbrGiftCardDetailPO.setValid(Boolean.valueOf(true));
                    cusUrMbrGiftCardDetailPOList.add(cusUrMbrGiftCardDetailPO);
                    GiftCardRequestVO giftCardRequestVO = new GiftCardRequestVO();
                    giftCardRequestVO.setCardNo(po.getCardNo());
                    giftCardRequestVO.setBalance(po.getBalance());
                    giftCardRequestVO.setUpdateBalance(po.getBalance());
                    giftCardRequestVO.setCreater(po.getCreater());
                    giftCardRequestVO.setCreatedDate(SDF.format(new Date()));
                    giftCardRequestVO.setBrandId(vo.getSysBrandId());
                    giftCardRequestVO.setType(GIFT_CARD_STATUS_NOT_ACTIVE);
                    giftCardRequestVO.setStatus(GIFT_CARD_STATUS_NOT_ACTIVE);
                    giftCardRequestVO.setPassword(po.getPassword());
                    giftCardRequestVOList.add(giftCardRequestVO);
                    if (cusUrMbrGiftCardPOList.size() != 500) continue;
                    this.cusUrMbrGiftCardPOMapper.insertBatch(cusUrMbrGiftCardPOList);
                    cusUrMbrGiftCardPOList.clear();
                    this.cusUrMbrGiftCardDetailPOMapper.insertBatch(cusUrMbrGiftCardDetailPOList);
                    cusUrMbrGiftCardDetailPOList.clear();
                    giftCardListRequestVO.setList(giftCardRequestVOList);
                    Result result = this.connectorServiceFeign.batchSaveGiftCardDetail(giftCardListRequestVO);
                    if (!"0".equals(result.getCode())) {
                        log.error("connectorServiceFeign batchSaveGiftCardDetail error " + result.getMessage());
                    }
                    giftCardRequestVOList.clear();
                }
                if (cusUrMbrGiftCardPOList.size() > 0) {
                    this.cusUrMbrGiftCardPOMapper.insertBatch(cusUrMbrGiftCardPOList);
                    this.cusUrMbrGiftCardDetailPOMapper.insertBatch(cusUrMbrGiftCardDetailPOList);
                    giftCardListRequestVO.setList(giftCardRequestVOList);
                    Result result = this.connectorServiceFeign.batchSaveGiftCardDetail(giftCardListRequestVO);
                    if (!"0".equals(result.getCode())) {
                        log.error("connectorServiceFeign batchSaveGiftCardDetail error " + result.getMessage());
                    }
                }
                CusUrMbrGiftCardTaskDetailPO taskDetailPO = new CusUrMbrGiftCardTaskDetailPO();
                taskDetailPO.setAuditeStatus(GIFT_CARD_STATUS_NOT_ACTIVE);
                taskDetailPO.setSysCompanyId(vo.getSysCompanyId());
                taskDetailPO.setSysBrandId(vo.getSysBrandId());
                taskDetailPO.setTaskBatchCode(vo.getTaskBatchCode());
                this.cusUrMbrGiftCardTaskDetailPOMapper.updateByExampleSelective(taskDetailPO, example);
                cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)2));
                SysCheckPo sysCheckPo = new SysCheckPo();
                sysCheckPo.setFunctionCode("C0005");
                sysCheckPo.setBusinessId(vo.getGiftCardTaskId());
                sysCheckPo.setCheckStatus(Integer.valueOf(3));
                sysCheckPo.setRemark(vo.getRemark());
                this.sysCheckServiceRpc.updateCheck(sysCheckPo);
            } else if ("0".equals(vo.getState())) {
                CusUrMbrGiftCardTaskDetailPO po = new CusUrMbrGiftCardTaskDetailPO();
                po.setAuditeStatus(GIFT_CARD_STATUS_ABORT);
                this.cusUrMbrGiftCardTaskDetailPOMapper.updateByExampleSelective(po, example);
                SysCheckPo sysCheckPo = new SysCheckPo();
                sysCheckPo.setFunctionCode("C0005");
                sysCheckPo.setBusinessId(vo.getGiftCardTaskId());
                sysCheckPo.setCheckStatus(Integer.valueOf(4));
                this.sysCheckServiceRpc.updateCheck(sysCheckPo);
                cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)4));
            }
        } else {
            responseData.setMessage("\u4efb\u52a1\u6279\u6b21\u4e2d\u65e0\u5f85\u5ba1\u6838\u6570\u636e");
            return responseData;
        }
        this.cusUrMbrGiftCardTaskPOMapper.updateByExampleSelective(cusUrMbrGiftCardTaskPO, cusUrMbrGiftCardTaskPOExample);
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData<String> exportGiftCardExcel(CusUrMbrGiftCardVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        try {
            List cusUrMbrGiftCardVOS = this.cusUrMbrGiftCardPOMapper.selectGiftCardListTask(vo, null, null);
            long sum = cusUrMbrGiftCardVOS.size();
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = new FileTaskPo();
            fileTaskPo.setTaskId(taskId);
            fileTaskPo.setFileId(String.valueOf(taskId));
            fileTaskPo.setTaskTypeCode(sum + "\u6761");
            fileTaskPo.setTaskName("\u5bfc\u51fa\u793c\u54c1\u5361\u4fe1\u606f");
            if (sysAccountPO != null) {
                fileTaskPo.setSysBrandId(sysAccountPO.getBrandId());
                fileTaskPo.setCreateUserId(sysAccountPO.getSysAccountId());
                fileTaskPo.setCreateUserName(sysAccountPO.getName());
            }
            fileTaskPo.setFileStatus(Long.valueOf(0L));
            fileTaskPo.setFileType("EXPORT");
            fileTaskPo.setValid(Boolean.valueOf(true));
            this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(sum));
            new Thread(() -> {
                try {
                    exportExcelUtil.setExportProcessId((Object)taskId);
                    Method method = this.cusUrMbrGiftCardPOMapper.getClass().getMethod("selectGiftCardListTask", CusUrMbrGiftCardVO.class, Long.class, Long.class);
                    exportExcelUtil.read("cusUrMbrGiftCardPOMapper", method, (model, row) -> {
                        if (row.getRowNum() == 0) {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue("\u793c\u54c1\u5361\u53f7");
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue("\u5bc6\u7801");
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue("\u672c\u91d1\u4f59\u989d");
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue("\u8d60\u9001\u91d1\u4f59\u989d");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue("\u6fc0\u6d3b\u72b6\u6001");
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue("\u6709\u6548\u671f");
                            Cell cell6 = row.createCell(6);
                            cell6.setCellValue("\u521b\u5efa\u4eba");
                            Cell cell7 = row.createCell(7);
                            cell7.setCellValue("\u521b\u5efa\u65e5\u671f");
                        } else {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue(model.getCardNo());
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue(model.getPassword());
                            Cell cell2 = row.createCell(2);
                            if (model.getBalance() == null) {
                                cell2.setCellValue("");
                            } else {
                                cell2.setCellValue(model.getBalance().toString());
                            }
                            Cell cell3 = row.createCell(3);
                            if (model.getGiveBalance() == null) {
                                cell3.setCellValue("");
                            } else {
                                cell3.setCellValue(model.getGiveBalance().toString());
                            }
                            Cell cell4 = row.createCell(4);
                            if (GiftCardStatusEnum.NOT_ACTIVE.getCode().equals(model.getStatus())) {
                                cell4.setCellValue(GiftCardStatusEnum.NOT_ACTIVE.getName());
                            } else if (GiftCardStatusEnum.ACTIVATED.getCode().equals(model.getStatus())) {
                                cell4.setCellValue(GiftCardStatusEnum.ACTIVATED.getName());
                            } else if (GiftCardStatusEnum.ABORTED.getCode().equals(model.getStatus())) {
                                cell4.setCellValue(GiftCardStatusEnum.ABORTED.getName());
                            }
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue(model.getValidityTime());
                            Cell cell6 = row.createCell(6);
                            cell6.setCellValue(model.getCreater());
                            Cell cell7 = row.createCell(7);
                            cell7.setCellValue(model.getCreatedDate());
                        }
                    }, new Object[]{vo});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
            new Thread(() -> {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"\u793c\u54c1\u5361\u4fe1\u606f\u5bfc\u51fa_");
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f!");
        return responseData;
    }

    public ResponseData getImportGiftCardList(CusUrMbrGiftCardTaskVO vo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        List cusUrMbrGiftCardTaskVOList = this.cusUrMbrGiftCardTaskPOMapper.selectImportGiftCardList(vo);
        PageInfo pageInfo = new PageInfo(cusUrMbrGiftCardTaskVOList);
        responseData.setData((Object)pageInfo);
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData getImportGiftCardDetailsList(CusUrMbrGiftCardTaskDetailVO vo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getTaskBatchCode())) {
            responseData.setMessage("\u4efb\u52a1\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        List cusUrMbrGiftCardTaskDetailVOList = this.cusUrMbrGiftCardTaskDetailPOMapper.selectImportGiftCardDetailsList(vo);
        PageInfo pageInfo = new PageInfo(cusUrMbrGiftCardTaskDetailVOList);
        responseData.setData((Object)pageInfo);
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData getGiftCardDetailList(CusUrMbrGiftCardDetailVO vo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        List cusUrMbrGiftCardDetailVOList = this.cusUrMbrGiftCardDetailPOMapper.selectGiftDetailList(vo);
        PageInfo pageInfo = new PageInfo(cusUrMbrGiftCardDetailVOList);
        responseData.setData((Object)pageInfo);
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData getGiftCardDetailByCardNoList(CusUrMbrGiftCardDetailVO vo) {
        ResponseData responseData = new ResponseData();
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (vo.getSysBrandId() == null) {
            responseData.setMessage("\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        if (StringUtils.isBlank((CharSequence)vo.getCardNo())) {
            responseData.setMessage("\u793c\u54c1\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            return responseData;
        }
        PageHelper.startPage((int)vo.getPageNumber(), (int)vo.getPageSize());
        List cusUrMbrGiftCardDetailVOList = this.cusUrMbrGiftCardDetailPOMapper.selectGiftDetailList(vo);
        PageInfo pageInfo = new PageInfo(cusUrMbrGiftCardDetailVOList);
        responseData.setData((Object)pageInfo);
        responseData.setMessage(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getMessage());
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    public ResponseData<String> exportGiftCardDetailExcel(CusUrMbrGiftCardDetailVO vo, HttpServletRequest request) {
        ResponseData responseData = new ResponseData();
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        responseData.setCode(com.bizvane.customized.common.constants.SysResponseEnum.FAILED.getCode());
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        if (vo.getSysCompanyId() == null) {
            responseData.setMessage("\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        try {
            List cusUrMbrGiftCardDetailVOList = this.cusUrMbrGiftCardDetailPOMapper.selectGiftDetailListTask(vo, Long.valueOf(1L), Long.valueOf(1L));
            long sum = cusUrMbrGiftCardDetailVOList.size();
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = new FileTaskPo();
            fileTaskPo.setTaskId(taskId);
            fileTaskPo.setFileId(String.valueOf(taskId));
            fileTaskPo.setTaskTypeCode(sum + "\u6761");
            fileTaskPo.setTaskName("\u5bfc\u51fa\u793c\u54c1\u5361\u65e5\u5fd7\u4fe1\u606f");
            if (sysAccountPO != null) {
                fileTaskPo.setSysBrandId(sysAccountPO.getBrandId());
                fileTaskPo.setCreateUserId(sysAccountPO.getSysAccountId());
                fileTaskPo.setCreateUserName(sysAccountPO.getName());
            }
            fileTaskPo.setFileStatus(Long.valueOf(0L));
            fileTaskPo.setFileType("EXPORT");
            fileTaskPo.setValid(Boolean.valueOf(true));
            this.fileTaskServiceRpc.addFileTask(fileTaskPo);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(sum));
            new Thread(() -> {
                try {
                    exportExcelUtil.setExportProcessId((Object)taskId);
                    Method method = this.cusUrMbrGiftCardDetailPOMapper.getClass().getMethod("selectGiftDetailListTask", CusUrMbrGiftCardDetailVO.class, Long.class, Long.class);
                    exportExcelUtil.read("cusUrMbrGiftCardDetailPOMapper", method, (model, row) -> {
                        if (row.getRowNum() == 0) {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue("\u793c\u54c1\u5361\u53f7");
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue("\u64cd\u4f5c\u7c7b\u578b");
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue("\u53d8\u66f4\u672c\u91d1\u91d1\u989d");
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue("\u53d8\u66f4\u8d60\u9001\u91d1\u989d");
                            Cell cell4 = row.createCell(4);
                            cell4.setCellValue("\u5355\u636e\u7f16\u53f7");
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue("\u64cd\u4f5c\u4eba");
                            Cell cell6 = row.createCell(6);
                            cell6.setCellValue("\u521b\u5efa\u65e5\u671f");
                        } else {
                            Cell cell0 = row.createCell(0);
                            cell0.setCellValue(model.getCardNo());
                            Cell cell1 = row.createCell(1);
                            cell1.setCellValue(model.getTypeName());
                            Cell cell2 = row.createCell(2);
                            cell2.setCellValue(((Serializable)ObjectUtils.defaultIfNull((Object)model.getUpdatebalance(), (Object)"")).toString());
                            Cell cell3 = row.createCell(3);
                            cell3.setCellValue(((Serializable)ObjectUtils.defaultIfNull((Object)model.getUpdateGiveBalance(), (Object)"")).toString());
                            Cell cell4 = row.createCell(4);
                            if (StringUtils.isBlank((CharSequence)model.getTaskBatchCode())) {
                                cell4.setCellValue(model.getOrderNo());
                            } else {
                                cell4.setCellValue(model.getTaskBatchCode());
                            }
                            Cell cell5 = row.createCell(5);
                            cell5.setCellValue(model.getCreater());
                            Cell cell6 = row.createCell(6);
                            cell6.setCellValue(model.getCreatedDate());
                        }
                    }, new Object[]{vo});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
            new Thread(() -> {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"\u793c\u54c1\u5361\u65e5\u5fd7\u4fe1\u606f\u5bfc\u51fa_");
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f!");
        return responseData;
    }

    private String generateRandomNumber() {
        Integer randomNumber = (int)((Math.random() * 9.0 + 1.0) * 1.0E7);
        return String.valueOf(randomNumber);
    }

    private String generateRandomPassword() {
        Integer randomNumber = (int)((Math.random() * 9.0 + 1.0) * 100000.0);
        return String.valueOf(randomNumber);
    }

    private BigDecimal getBig(Object value) {
        BigDecimal ret = null;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal)value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String)value);
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger)value);
            } else if (value instanceof Number) {
                ret = new BigDecimal(((Number)value).doubleValue());
            } else {
                throw new ClassCastException("Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }

    private String generateTaskBatchCode() {
        Integer randomNumber = (int)((Math.random() * 9.0 + 1.0) * 1.0E7);
        return "LPK" + UUIDGenerator.getLocalTrmSeqNum();
    }

    private String validateGiftCard(RedisClient redisClient, String cardNo, String paramPwd, BigDecimal paramBalance, BigDecimal paramGiveBalance, CusUrMbrGiftCardTaskDetailPO cusUrMbrGiftCardTaskDetailFailPO) throws Exception {
        boolean exists = redisClient.exists("IMPORT_GIFT_CARD_EXCEL_KEY" + cardNo);
        if (exists) {
            cusUrMbrGiftCardTaskDetailFailPO.setAuditeStatus(GIFT_CARD_STATUS_ACTIVED);
            cusUrMbrGiftCardTaskDetailFailPO.setRemark("\u5bfc\u5165\u6587\u4ef6\u4e2d\u6709\u91cd\u590d\u5361\u53f7");
            cusUrMbrGiftCardTaskDetailFailPO.setCardNo(cardNo);
            cusUrMbrGiftCardTaskDetailFailPO.setPassword(paramPwd);
            cusUrMbrGiftCardTaskDetailFailPO.setBalance(paramBalance);
            cusUrMbrGiftCardTaskDetailFailPO.setGiveBalance(paramGiveBalance);
            cusUrMbrGiftCardTaskDetailFailPO.setCreatedDate(SDF.format(new Date()));
            this.cusUrMbrGiftCardTaskDetailPOMapper.insertSelective(cusUrMbrGiftCardTaskDetailFailPO);
            return cardNo;
        }
        redisClient.set("IMPORT_GIFT_CARD_EXCEL_KEY" + cardNo, (Object)"Y", Long.valueOf(1800L));
        return null;
    }

    private ResponseData asynchronousInsertValidte(List<CusUrMbrGiftCardPO> cusUrMbrGiftCardPOList, SysAccountPO po, CusUrMbrGiftCardTaskPO cusUrMbrGiftCardTaskPO) {
        ResponseData responseData = new ResponseData();
        AtomicInteger count = new AtomicInteger(0);
        AtomicInteger isExamineCount = new AtomicInteger(0);
        CountDownLatch cd = new CountDownLatch(cusUrMbrGiftCardPOList.size());
        if (cusUrMbrGiftCardPOList.size() > 0) {
            SysCheckConfigPo sysCheckConfigPo = new SysCheckConfigPo();
            sysCheckConfigPo.setSysBrandId(po.getBrandId());
            sysCheckConfigPo.setFunctionCode("C0005");
            Integer isExamine = (Integer)this.sysCheckConfigServiceRpc.ifCheckConfig(sysCheckConfigPo).getData();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            cusUrMbrGiftCardPOList.forEach(cusUrMbrGiftCardPO -> {
                Runnable runnable = () -> {
                    CusUrMbrGiftCardTaskDetailPO cusUrMbrGiftCardTaskDetailPO = new CusUrMbrGiftCardTaskDetailPO();
                    cusUrMbrGiftCardTaskDetailPO.setSysCompanyId(po.getSysCompanyId());
                    cusUrMbrGiftCardTaskDetailPO.setSysBrandId(po.getBrandId());
                    cusUrMbrGiftCardTaskDetailPO.setTaskBatchCode(cusUrMbrGiftCardTaskPO.getTaskBatchCode());
                    cusUrMbrGiftCardTaskDetailPO.setTaskFileName(cusUrMbrGiftCardTaskPO.getTaskFileName());
                    cusUrMbrGiftCardTaskDetailPO.setCardNo(cusUrMbrGiftCardPO.getCardNo());
                    cusUrMbrGiftCardTaskDetailPO.setPassword(cusUrMbrGiftCardPO.getPassword());
                    cusUrMbrGiftCardTaskDetailPO.setBalance(cusUrMbrGiftCardPO.getBalance());
                    cusUrMbrGiftCardTaskDetailPO.setGiveBalance(cusUrMbrGiftCardPO.getGiveBalance());
                    cusUrMbrGiftCardTaskDetailPO.setType(GIFT_CARD_STATUS_ACTIVED);
                    cusUrMbrGiftCardTaskDetailPO.setCreater(po.getName());
                    cusUrMbrGiftCardTaskDetailPO.setCreatedDate(SDF.format(new Date()));
                    cusUrMbrGiftCardTaskDetailPO.setValid(Boolean.valueOf(true));
                    CusUrMbrGiftCardPOExample example = new CusUrMbrGiftCardPOExample();
                    example.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andCardNoEqualTo(cusUrMbrGiftCardPO.getCardNo());
                    List cusUrMbrGiftCardPOs = this.cusUrMbrGiftCardPOMapper.selectByExample(example);
                    CusUrMbrGiftCardTaskDetailPOExample taskexample = new CusUrMbrGiftCardTaskDetailPOExample();
                    taskexample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andCardNoEqualTo(cusUrMbrGiftCardPO.getCardNo()).andAuditeStatusEqualTo("4");
                    List cusUrMbrGiftCardTaskDetailPOs = this.cusUrMbrGiftCardTaskDetailPOMapper.selectByExample(taskexample);
                    String regex = "^[A-Za-z0-9]+$";
                    if (cusUrMbrGiftCardPOs.size() > 0) {
                        cusUrMbrGiftCardTaskDetailPO.setAuditeStatus(GIFT_CARD_STATUS_ACTIVED);
                        cusUrMbrGiftCardTaskDetailPO.setRemark("\u6709\u91cd\u590d\u5361\u53f7\u5b58\u5728");
                    } else if (cusUrMbrGiftCardTaskDetailPOs.size() > 0) {
                        cusUrMbrGiftCardTaskDetailPO.setAuditeStatus(GIFT_CARD_STATUS_ACTIVED);
                        cusUrMbrGiftCardTaskDetailPO.setRemark("\u6709\u91cd\u590d\u5361\u53f7\u5728\u5f85\u5ba1\u6838\u72b6\u6001");
                    } else if (StringUtils.isBlank((CharSequence)cusUrMbrGiftCardPO.getPassword()) || !cusUrMbrGiftCardPO.getCardNo().matches(regex) || !cusUrMbrGiftCardPO.getPassword().matches(regex) || cusUrMbrGiftCardPO.getBalance().signum() == -1) {
                        cusUrMbrGiftCardTaskDetailPO.setAuditeStatus(GIFT_CARD_STATUS_ACTIVED);
                        cusUrMbrGiftCardTaskDetailPO.setRemark("\u5b57\u6bb5\u4e0d\u7b26\u5408\u6821\u9a8c");
                    } else if (isExamine == 1) {
                        count.getAndIncrement();
                        cusUrMbrGiftCardTaskDetailPO.setAuditeStatus("4");
                        isExamineCount.getAndIncrement();
                    } else {
                        count.getAndIncrement();
                        cusUrMbrGiftCardTaskDetailPO.setAuditeStatus(GIFT_CARD_STATUS_NOT_ACTIVE);
                        cusUrMbrGiftCardPO.setSysCompanyId(po.getSysCompanyId());
                        cusUrMbrGiftCardPO.setSysBrandId(po.getBrandId());
                        cusUrMbrGiftCardPO.setCreater(po.getName());
                        cusUrMbrGiftCardPO.setStatus(GIFT_CARD_STATUS_NOT_ACTIVE);
                        cusUrMbrGiftCardPO.setType(GIFT_CARD_STATUS_ACTIVED);
                        cusUrMbrGiftCardPO.setValid(Boolean.valueOf(true));
                        cusUrMbrGiftCardPO.setTaskBatchCode(cusUrMbrGiftCardTaskPO.getTaskBatchCode());
                        cusUrMbrGiftCardPO.setTaskFileName(cusUrMbrGiftCardTaskPO.getTaskFileName());
                        cusUrMbrGiftCardPO.setCreatedDate(sdf.format(new Date()));
                        cusUrMbrGiftCardPO.setValid(Boolean.valueOf(true));
                        this.cusUrMbrGiftCardPOMapper.insertSelective(cusUrMbrGiftCardPO);
                        CusUrMbrGiftCardDetailPO cusUrMbrGiftCardDetailPO = new CusUrMbrGiftCardDetailPO();
                        cusUrMbrGiftCardDetailPO.setSysCompanyId(po.getSysCompanyId());
                        cusUrMbrGiftCardDetailPO.setSysBrandId(po.getBrandId());
                        cusUrMbrGiftCardDetailPO.setCardNo(cusUrMbrGiftCardPO.getCardNo());
                        cusUrMbrGiftCardDetailPO.setType(GIFT_CARD_STATUS_NOT_ACTIVE);
                        cusUrMbrGiftCardDetailPO.setCreatedDate(SDF.format(new Date()));
                        cusUrMbrGiftCardDetailPO.setTaskBatchCode(cusUrMbrGiftCardTaskPO.getTaskBatchCode());
                        cusUrMbrGiftCardDetailPO.setTaskFileName(cusUrMbrGiftCardTaskPO.getTaskFileName());
                        cusUrMbrGiftCardDetailPO.setBalance(cusUrMbrGiftCardPO.getBalance());
                        cusUrMbrGiftCardDetailPO.setGiveBalance(cusUrMbrGiftCardPO.getGiveBalance());
                        cusUrMbrGiftCardDetailPO.setCreater(po.getName());
                        cusUrMbrGiftCardDetailPO.setUpdatebalance(cusUrMbrGiftCardPO.getBalance());
                        cusUrMbrGiftCardDetailPO.setUpdateGiveBalance(cusUrMbrGiftCardPO.getGiveBalance());
                        cusUrMbrGiftCardDetailPO.setValid(Boolean.valueOf(true));
                        this.cusUrMbrGiftCardDetailPOMapper.insertSelective(cusUrMbrGiftCardDetailPO);
                        GiftCardListRequestVO giftCardListRequestVO = new GiftCardListRequestVO();
                        giftCardListRequestVO.setBrandId(po.getBrandId());
                        ArrayList<GiftCardRequestVO> giftCardRequestVOList = new ArrayList<GiftCardRequestVO>();
                        GiftCardRequestVO giftCardRequestVO = new GiftCardRequestVO();
                        giftCardRequestVO.setCardNo(cusUrMbrGiftCardPO.getCardNo());
                        giftCardRequestVO.setBalance(cusUrMbrGiftCardPO.getBalance());
                        giftCardRequestVO.setUpdateBalance(cusUrMbrGiftCardPO.getBalance());
                        giftCardRequestVO.setGiveBalance(cusUrMbrGiftCardPO.getGiveBalance());
                        giftCardRequestVO.setUpdateGiveBalance(cusUrMbrGiftCardPO.getGiveBalance());
                        giftCardRequestVO.setCreater(po.getName());
                        giftCardRequestVO.setCreatedDate(SDF.format(new Date()));
                        giftCardRequestVO.setBrandId(po.getBrandId());
                        giftCardRequestVO.setType(GIFT_CARD_STATUS_NOT_ACTIVE);
                        giftCardRequestVO.setStatus(GIFT_CARD_STATUS_NOT_ACTIVE);
                        giftCardRequestVO.setPassword(cusUrMbrGiftCardPO.getPassword());
                        giftCardRequestVOList.add(giftCardRequestVO);
                        giftCardListRequestVO.setList(giftCardRequestVOList);
                        Result result = this.connectorServiceFeign.batchSaveGiftCardDetail(giftCardListRequestVO);
                        if (!"0".equals(result.getCode())) {
                            log.error("connectorServiceFeign batchSaveGiftCardDetail error " + result.getMessage());
                        }
                    }
                    this.cusUrMbrGiftCardTaskDetailPOMapper.insertSelective(cusUrMbrGiftCardTaskDetailPO);
                    cd.countDown();
                };
                ThreadPool.run((Runnable)runnable);
            });
            try {
                cd.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (count.get() == 0) {
                cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)0));
            } else if (isExamine == 1) {
                cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)1));
            } else {
                cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)3));
            }
            this.cusUrMbrGiftCardTaskPOMapper.insertSelective(cusUrMbrGiftCardTaskPO);
            if (isExamine == 1 && isExamineCount.get() > 0) {
                SysCheckPo sysCheckPo = new SysCheckPo();
                sysCheckPo.setSysCompanyId(po.getSysCompanyId());
                sysCheckPo.setSysBrandId(po.getBrandId());
                sysCheckPo.setFunctionCode("C0005");
                sysCheckPo.setBusinessId(cusUrMbrGiftCardTaskPO.getGiftCardTaskId());
                sysCheckPo.setBusinessCode(cusUrMbrGiftCardTaskPO.getTaskBatchCode());
                sysCheckPo.setBusinessName("\u793c\u54c1\u5361\u6279\u91cf\u5bfc\u5165");
                sysCheckPo.setBizName("\u793c\u54c1\u5361\u6279\u91cf\u5bfc\u5165");
                sysCheckPo.setCheckStatus(Integer.valueOf(1));
                sysCheckPo.setCreateDate(new Date());
                sysCheckPo.setModifiedDate(new Date());
                this.sysCheckServiceRpc.addCheck(sysCheckPo);
            }
        } else {
            responseData.setMessage("\u5bfc\u5165\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)0));
            this.cusUrMbrGiftCardTaskPOMapper.insertSelective(cusUrMbrGiftCardTaskPO);
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    private ResponseData insertBatchGiftCard(List<CusUrMbrGiftCardPO> cusUrMbrGiftCardPOList, SysAccountPO po, CusUrMbrGiftCardTaskPO cusUrMbrGiftCardTaskPO) {
        ResponseData responseData = new ResponseData();
        if (cusUrMbrGiftCardPOList.size() > 0) {
            SysCheckConfigPo sysCheckConfigPo = new SysCheckConfigPo();
            sysCheckConfigPo.setSysBrandId(po.getBrandId());
            sysCheckConfigPo.setFunctionCode("C0005");
            Integer isExamine = (Integer)this.sysCheckConfigServiceRpc.ifCheckConfig(sysCheckConfigPo).getData();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (isExamine == 1) {
                cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)1));
            } else {
                cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)3));
            }
            this.cusUrMbrGiftCardTaskPOMapper.insertSelective(cusUrMbrGiftCardTaskPO);
            if (isExamine == 1) {
                SysCheckPo sysCheckPo = new SysCheckPo();
                sysCheckPo.setSysCompanyId(po.getSysCompanyId());
                sysCheckPo.setSysBrandId(po.getBrandId());
                sysCheckPo.setFunctionCode("C0005");
                sysCheckPo.setBusinessId(cusUrMbrGiftCardTaskPO.getGiftCardTaskId());
                sysCheckPo.setBusinessCode(cusUrMbrGiftCardTaskPO.getTaskBatchCode());
                sysCheckPo.setBusinessName("\u793c\u54c1\u5361\u6279\u91cf\u5bfc\u5165");
                sysCheckPo.setBizName("\u793c\u54c1\u5361\u6279\u91cf\u5bfc\u5165");
                sysCheckPo.setCheckStatus(Integer.valueOf(1));
                sysCheckPo.setCreateDate(new Date());
                sysCheckPo.setModifiedDate(new Date());
                this.sysCheckServiceRpc.addCheck(sysCheckPo);
            }
            ArrayList<CusUrMbrGiftCardTaskDetailPO> cusUrMbrGiftCardTaskDetailPOs = new ArrayList<CusUrMbrGiftCardTaskDetailPO>();
            ArrayList<CusUrMbrGiftCardPO> cusUrMbrGiftCardPOs = new ArrayList<CusUrMbrGiftCardPO>();
            ArrayList<CusUrMbrGiftCardDetailPO> cusUrMbrGiftCardDetailPOs = new ArrayList<CusUrMbrGiftCardDetailPO>();
            for (int i = 0; i < cusUrMbrGiftCardPOList.size(); ++i) {
                CusUrMbrGiftCardPO cusUrMbrGiftCardPO = cusUrMbrGiftCardPOList.get(i);
                CusUrMbrGiftCardTaskDetailPO cusUrMbrGiftCardTaskDetailPO = new CusUrMbrGiftCardTaskDetailPO();
                cusUrMbrGiftCardTaskDetailPO.setSysCompanyId(po.getSysCompanyId());
                cusUrMbrGiftCardTaskDetailPO.setSysBrandId(po.getBrandId());
                cusUrMbrGiftCardTaskDetailPO.setTaskBatchCode(cusUrMbrGiftCardTaskPO.getTaskBatchCode());
                cusUrMbrGiftCardTaskDetailPO.setTaskFileName(cusUrMbrGiftCardTaskPO.getTaskFileName());
                cusUrMbrGiftCardTaskDetailPO.setCardNo(cusUrMbrGiftCardPO.getCardNo());
                cusUrMbrGiftCardTaskDetailPO.setPassword(cusUrMbrGiftCardPO.getPassword());
                cusUrMbrGiftCardTaskDetailPO.setBalance(cusUrMbrGiftCardPO.getBalance());
                cusUrMbrGiftCardTaskDetailPO.setType(GIFT_CARD_STATUS_ACTIVED);
                cusUrMbrGiftCardTaskDetailPO.setCreater(po.getName());
                cusUrMbrGiftCardTaskDetailPO.setCreatedDate(SDF.format(new Date()));
                cusUrMbrGiftCardTaskDetailPO.setValid(Boolean.valueOf(true));
                if (isExamine == 1) {
                    cusUrMbrGiftCardTaskDetailPO.setAuditeStatus("4");
                } else {
                    cusUrMbrGiftCardTaskDetailPO.setAuditeStatus(GIFT_CARD_STATUS_NOT_ACTIVE);
                    cusUrMbrGiftCardPO.setSysCompanyId(po.getSysCompanyId());
                    cusUrMbrGiftCardPO.setSysBrandId(po.getBrandId());
                    cusUrMbrGiftCardPO.setCreater(po.getName());
                    cusUrMbrGiftCardPO.setStatus(GIFT_CARD_STATUS_NOT_ACTIVE);
                    cusUrMbrGiftCardPO.setType(GIFT_CARD_STATUS_ACTIVED);
                    cusUrMbrGiftCardPO.setValid(Boolean.valueOf(true));
                    cusUrMbrGiftCardPO.setTaskBatchCode(cusUrMbrGiftCardTaskPO.getTaskBatchCode());
                    cusUrMbrGiftCardPO.setTaskFileName(cusUrMbrGiftCardTaskPO.getTaskFileName());
                    cusUrMbrGiftCardPO.setCreatedDate(sdf.format(new Date()));
                    cusUrMbrGiftCardPO.setValid(Boolean.valueOf(true));
                    cusUrMbrGiftCardPOs.add(cusUrMbrGiftCardPO);
                    CusUrMbrGiftCardDetailPO cusUrMbrGiftCardDetailPO = new CusUrMbrGiftCardDetailPO();
                    cusUrMbrGiftCardDetailPO.setSysCompanyId(po.getSysCompanyId());
                    cusUrMbrGiftCardDetailPO.setSysBrandId(po.getBrandId());
                    cusUrMbrGiftCardDetailPO.setCardNo(cusUrMbrGiftCardPO.getCardNo());
                    cusUrMbrGiftCardDetailPO.setType(GIFT_CARD_STATUS_NOT_ACTIVE);
                    cusUrMbrGiftCardDetailPO.setCreatedDate(SDF.format(new Date()));
                    cusUrMbrGiftCardDetailPO.setTaskBatchCode(cusUrMbrGiftCardTaskPO.getTaskBatchCode());
                    cusUrMbrGiftCardDetailPO.setTaskFileName(cusUrMbrGiftCardTaskPO.getTaskFileName());
                    cusUrMbrGiftCardDetailPO.setBalance(cusUrMbrGiftCardPO.getBalance());
                    cusUrMbrGiftCardDetailPO.setCreater(po.getName());
                    cusUrMbrGiftCardDetailPO.setUpdatebalance(cusUrMbrGiftCardPO.getBalance());
                    cusUrMbrGiftCardDetailPO.setValid(Boolean.valueOf(true));
                    cusUrMbrGiftCardDetailPOs.add(cusUrMbrGiftCardDetailPO);
                    if (cusUrMbrGiftCardPOs.size() == 500) {
                        this.cusUrMbrGiftCardPOMapper.insertBatch(cusUrMbrGiftCardPOs);
                        cusUrMbrGiftCardPOs.clear();
                        this.cusUrMbrGiftCardDetailPOMapper.insertBatch(cusUrMbrGiftCardDetailPOs);
                        cusUrMbrGiftCardDetailPOs.clear();
                    }
                }
                cusUrMbrGiftCardTaskDetailPOs.add(cusUrMbrGiftCardTaskDetailPO);
                if (cusUrMbrGiftCardTaskDetailPOs.size() != 500) continue;
                this.cusUrMbrGiftCardTaskDetailPOMapper.insertBatch(cusUrMbrGiftCardTaskDetailPOs);
                cusUrMbrGiftCardTaskDetailPOs.clear();
            }
            if (cusUrMbrGiftCardTaskDetailPOs.size() > 0) {
                this.cusUrMbrGiftCardTaskDetailPOMapper.insertBatch(cusUrMbrGiftCardTaskDetailPOs);
            }
            if (cusUrMbrGiftCardPOs.size() > 0) {
                this.cusUrMbrGiftCardPOMapper.insertBatch(cusUrMbrGiftCardPOs);
                this.cusUrMbrGiftCardDetailPOMapper.insertBatch(cusUrMbrGiftCardDetailPOs);
            }
        } else {
            responseData.setMessage("\u5bfc\u5165\u5931\u8d25");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            cusUrMbrGiftCardTaskPO.setTaskStatus(Byte.valueOf((byte)0));
            this.cusUrMbrGiftCardTaskPOMapper.insertSelective(cusUrMbrGiftCardTaskPO);
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        return responseData;
    }

    private String getcardGenerateGiftNo(String cardNo, Long sysCompanyId, Long sysBrandId) throws CustomizedException {
        CardGenerateVO cardGenerateVO = new CardGenerateVO();
        cardGenerateVO.setSysCompanyId(sysCompanyId);
        cardGenerateVO.setBrandId(sysBrandId);
        cardGenerateVO.setCode("urGiftCardNo");
        cardGenerateVO.setPrecision(Long.valueOf(7L));
        ResponseData cardRes = this.cardGenerateApiService.generateCardNo(cardGenerateVO);
        if (cardRes.getData() == null || cardRes.getCode() == SysResponseEnum.FAILED.getCode()) {
            throw new CustomizedException("\u751f\u6210\u5361\u53f7\u5931\u8d25");
        }
        String number = cardNo + (String)((List)cardRes.getData()).get(0);
        CusUrMbrGiftCardVO cardNoVo = new CusUrMbrGiftCardVO();
        cardNoVo.setSysCompanyId(sysCompanyId);
        cardNoVo.setSysBrandId(sysBrandId);
        cardNoVo.setCardNo(number);
        List cusUrMbrGiftCardPOS = this.cusUrMbrGiftCardPOMapper.selectGiftByCardNo(cardNoVo);
        if (CollectionUtils.isNotEmpty((Collection)cusUrMbrGiftCardPOS)) {
            number = this.getcardGenerateGiftNo(cardNo, sysCompanyId, sysBrandId);
        }
        return number;
    }
}

