/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.connectorservice.entity.common.RechargeRecordRequestVO;
import com.bizvane.customized.company.ur.members.service.RechargeCardService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;

@RocketMQMessageListener(topic="UR_RECHARGE_BACK")
public class URRechargeCallBackConsumer
implements RocketMQListener<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(URRechargeCallBackConsumer.class);
    @Autowired
    private RechargeCardService rechargeCardService;
    @Resource
    private RedisTemplate<String, Integer> redisTemplate;

    public void onMessage(ConsumerMessage<JSONObject> message) {
        log.info("URRechargeCallBackConsumer\u89e3\u6790\u6210\u529f\uff1a" + message.getMessage());
        JSONObject body = (JSONObject)message.getMessage();
        RechargeRecordRequestVO rechargeRecordRequestVo = (RechargeRecordRequestVO)JacksonUtil.json2Objs((String)body.toJSONString(), RechargeRecordRequestVO.class);
        String redisKey = "UR_RECHARGE_BACK:" + rechargeRecordRequestVo.getSysCompanyId() + "_" + rechargeRecordRequestVo.getSerialNumber();
        if (this.redisTemplate.opsForValue().get((Object)redisKey) != null) {
            log.info("URRechargeCallBackConsumer topic:UR_RECHARGE_BACK, memberCode:{}, \u6d41\u6c34\u53f7:{}, \u6d88\u606f\u8bb0\u5f55\u5b58\u5728", (Object)rechargeRecordRequestVo.getMemberCode(), (Object)rechargeRecordRequestVo.getSerialNumber());
            throw new RuntimeException("\u6d88\u606f\u8bb0\u5f55\u5b58\u5728\uff0c\u9700\u91cd\u8bd5\u6d88\u8d39");
        }
        this.redisTemplate.opsForValue().set((Object)redisKey, (Object)1, 1L, TimeUnit.MINUTES);
        try {
            this.rechargeCardService.addDebitCardRechargeCallBack(rechargeRecordRequestVo);
        }
        catch (Exception e) {
            log.info("URRechargeCallBackConsumer topic:UR_RECHARGE_BACK, memberCode:{}, \u6d41\u6c34\u53f7:{}, Mq\u6d88\u8d39\u6267\u884c\u5f02\u5e38,\u9700\u91cd\u8bd5mq,exception:{} ", new Object[]{rechargeRecordRequestVo.getMemberCode(), rechargeRecordRequestVo.getSerialNumber(), ExceptionUtils.getStackTrace((Throwable)e)});
            this.redisTemplate.opsForValue().getOperations().delete((Object)redisKey);
            throw new RuntimeException(e.getMessage());
        }
    }
}

