/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.mq;

import cn.bizvane.rocketmq.spring.annotation.RocketMQMessageListener;
import cn.bizvane.rocketmq.spring.core.consumer.ConsumerMessage;
import cn.bizvane.rocketmq.spring.core.consumer.RocketMQListener;
import com.alibaba.fastjson.JSON;
import com.bizvane.customized.common.constants.SysConstants;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePO;
import com.bizvane.customized.facade.models.po.CusUrMbrQuestionnaireTemplatePOExample;
import com.bizvane.customized.facade.models.vo.questionnaire.EnterQuestionnaireVO;
import com.bizvane.customized.facade.models.vo.questionnaire.LabelVO;
import com.bizvane.customized.facade.models.vo.questionnaire.SurveyQuestionnaireVO;
import com.bizvane.customized.mappers.CusUrMbrQuestionnaireTemplatePOMapper;
import com.bizvane.members.facade.service.qywxapi.MemberLabelApiService;
import com.bizvane.members.facade.vo.qywx.UpdateMemberLabelVo;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import io.searchbox.strings.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@RocketMQMessageListener(topic="ENTER_QUESTIONNAIRE")
public class EnterQuestionnaireConsumer
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(EnterQuestionnaireConsumer.class);
    @Autowired
    private CusUrMbrQuestionnaireTemplatePOMapper cusUrMbrQuestionnaireTemplatePOMapper;
    @Autowired
    private MemberLabelApiService memberLabelApiService;

    public void onMessage(ConsumerMessage<String> message) {
        String enterQuestionnaireMsg = (String)message.getMessage();
        log.info("enterQuestionnaireMsg:{}", (Object)enterQuestionnaireMsg);
        EnterQuestionnaireVO enterQuestionnaireVO = (EnterQuestionnaireVO)JSON.parseObject((String)enterQuestionnaireMsg, EnterQuestionnaireVO.class);
        Assert.notNull((Object)enterQuestionnaireVO, (String)"object is required");
        log.info("enterQuestionnaireVO:{}", (Object)JacksonUtil.bean2Json((Object)enterQuestionnaireVO));
        Assert.notNull((Object)enterQuestionnaireVO.getSysCompanyId(), (String)"sysCompanyId is required");
        Assert.notNull((Object)enterQuestionnaireVO.getSysBrandId(), (String)"sysBrandId is required");
        Assert.notNull((Object)enterQuestionnaireVO.getMemberCode(), (String)"memberCode is required");
        Assert.notNull((Object)enterQuestionnaireVO.getTemplateCode(), (String)"templateCode is required");
        CusUrMbrQuestionnaireTemplatePOExample example = new CusUrMbrQuestionnaireTemplatePOExample();
        example.createCriteria().andSysCompanyIdEqualTo(enterQuestionnaireVO.getSysCompanyId()).andSysBrandIdEqualTo(enterQuestionnaireVO.getSysBrandId()).andTemplateCodeEqualTo(enterQuestionnaireVO.getTemplateCode()).andValidEqualTo(SysConstants.TABLE_VALID_EFFECTIVE);
        List list = this.cusUrMbrQuestionnaireTemplatePOMapper.selectByExampleWithBLOBs(example);
        CusUrMbrQuestionnaireTemplatePO templatePO = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            templatePO = (CusUrMbrQuestionnaireTemplatePO)list.get(0);
        }
        if (null == templatePO) {
            log.info("\u95ee\u5377\u6a21\u677f\u4e3a\u7a7a");
            return;
        }
        String templateJson = templatePO.getTemplateJson();
        try {
            SurveyQuestionnaireVO surveyQuestionnaireVO = (SurveyQuestionnaireVO)JSON.parseObject((String)templateJson, SurveyQuestionnaireVO.class);
            log.info("loaded#surveyQuestionnaireVO:{}", (Object)JacksonUtil.bean2Json((Object)surveyQuestionnaireVO));
            if (null != surveyQuestionnaireVO && BooleanUtils.isTrue((Boolean)surveyQuestionnaireVO.getLoadedLabelType())) {
                this.handleMemberLabels(enterQuestionnaireVO.getSysCompanyId(), enterQuestionnaireVO.getSysBrandId(), enterQuestionnaireVO.getMemberCode(), surveyQuestionnaireVO.getLoadedLabelList());
            }
        }
        catch (Exception e) {
            log.info("\u89e3\u6790\u95ee\u5377\u6a21\u677fjson\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void handleMemberLabels(Long sysCompanyId, Long sysBrandId, String memberCode, List<LabelVO> labelVOList) {
        log.info("\u8fdb\u5165\u95ee\u5377\u6253\u6807\u7b7e");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(labelVOList)) {
            log.info("\u6807\u7b7e\u96c6\u5408\u4e3a\u7a7a");
            return;
        }
        if (null == sysCompanyId || null == sysBrandId || StringUtils.isBlank((CharSequence)memberCode)) {
            log.info("\u53c2\u6570\u6821\u9a8c\u4e0d\u901a\u8fc7");
            return;
        }
        List mbrLabelIdList = labelVOList.stream().map(item -> item.getMbrLabelDefId().toString()).collect(Collectors.toList());
        log.info("handleMemberLabels#mbrLabelIdList:{}", (Object)JacksonUtil.bean2Json(mbrLabelIdList));
        UpdateMemberLabelVo updateMemberLabelVo = new UpdateMemberLabelVo();
        updateMemberLabelVo.setMemberCode(memberCode);
        updateMemberLabelVo.setLabelIds(mbrLabelIdList);
        updateMemberLabelVo.setSysCompanyId(sysCompanyId);
        updateMemberLabelVo.setBrandId(sysBrandId);
        updateMemberLabelVo.setSysAccountId(Long.valueOf(0L));
        updateMemberLabelVo.setSysStoreId(Long.valueOf(0L));
        updateMemberLabelVo.setGuideCode("");
        updateMemberLabelVo.setActionType(Integer.valueOf(1));
        updateMemberLabelVo.setSyncedWxqy(Integer.valueOf(2));
        updateMemberLabelVo.setName("\u8c03\u67e5\u95ee\u5377");
        ResponseData updateMemberLabelResult = this.memberLabelApiService.addMemberLabel(updateMemberLabelVo);
        log.info("handleMemberLabels#updateMemberLabelResult:{}", (Object)JacksonUtil.bean2Json((Object)updateMemberLabelResult));
        if (SysResponseEnum.SUCCESS.getCode() == updateMemberLabelResult.getCode()) {
            log.info("\u8fdb\u5165\u95ee\u5377\u6807\u7b7e\u5904\u7406\u6210\u529f");
        } else {
            log.info("\u8fdb\u5165\u95ee\u5377\u6807\u7b7e\u5904\u7406\u5931\u8d25");
        }
    }
}

