/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.controller.rpc;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.connectorservice.entity.common.RechargeRecordRequestVO;
import com.bizvane.customized.common.constants.SysResponseEnum;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.PolicyException;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.company.ur.members.service.RechargeCardService;
import com.bizvane.customized.facade.enums.RechargeCardErrorEunm;
import com.bizvane.customized.facade.exception.CustomizedException;
import com.bizvane.customized.facade.models.bo.CardPasswordBO;
import com.bizvane.customized.facade.models.bo.CardResponseBo;
import com.bizvane.customized.facade.models.bo.CusUrCardRefundRecordBO;
import com.bizvane.customized.facade.models.bo.RechargeCardBO;
import com.bizvane.customized.facade.models.po.CusUrCardRefundRecordPO;
import com.bizvane.customized.facade.models.po.CusUrRechargeCardPO;
import com.bizvane.customized.facade.models.po.CusUrRechargeCardRecordPO;
import com.bizvane.customized.facade.models.vo.BaseCompanyBrandVO;
import com.bizvane.customized.facade.models.vo.CusUrMyRechargeCardPwdVO;
import com.bizvane.customized.facade.models.vo.CusUrMyRechargeCardVO;
import com.bizvane.customized.facade.models.vo.CusUrReceiveTransferPageVo;
import com.bizvane.customized.facade.models.vo.CusUrReceiveTransferVo;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardPassVo;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardPwdVO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardRechargeVO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardSmsPwdVo;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardStatisticReqVo;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardStyleVO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardVO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeConfigVO;
import com.bizvane.customized.facade.models.vo.CusUrTransferPageReqVo;
import com.bizvane.customized.facade.models.vo.CusUrTransferPageVo;
import com.bizvane.customized.facade.models.vo.CusUrTransferVo;
import com.bizvane.customized.facade.models.vo.RechargeCardConsumeVO;
import com.bizvane.customized.facade.models.vo.RechargeCardModifyVO;
import com.bizvane.customized.facade.models.vo.RechargeCardOrderNoRequestVo;
import com.bizvane.customized.facade.models.vo.RechargeCardStatusRequestVo;
import com.bizvane.customized.facade.models.vo.RefundRechargeCardRequestVo;
import com.bizvane.customized.facade.models.vo.SendSmsAuthCodeVo;
import com.bizvane.customized.facade.models.vo.UrRechargeCardVo;
import com.bizvane.customized.facade.models.vo.ur.ChargeAddRecordListReqVo;
import com.bizvane.customized.facade.models.vo.ur.ChargeAddRecordListRspVo;
import com.bizvane.customized.facade.models.vo.ur.ChargeAddRecordQueryRspVo;
import com.bizvane.customized.facade.models.vo.ur.ChargeAddRecordRefundedRspVo;
import com.bizvane.customized.facade.models.vo.ur.ChargeAddRecordReqVo;
import com.bizvane.customized.facade.models.vo.ur.ChargeAddRecordRspVo;
import com.bizvane.customized.facade.models.vo.ur.ChargeVerifyReqVo;
import com.bizvane.customized.facade.models.vo.ur.ChargeVerifyRspVo;
import com.bizvane.customized.facade.models.vo.ur.StatisticsMbrRechargeCardRecordReqVo;
import com.bizvane.customized.facade.models.vo.ur.StatisticsMbrRechargeCardRecordVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"UR\u5145\u503c\u5361 \u5c0f\u7a0b\u5e8f\u63a5\u53e3"}, description="\u5c0f\u7a0b\u5e8f\u5bf9\u50a8\u503c\u5361\u64cd\u4f5c")
@RestController
@RequestMapping(value={"/ur/rechargeCardRpc"})
public class RechargeCardRpcController {
    private static final Logger log = LoggerFactory.getLogger(RechargeCardRpcController.class);
    @Autowired
    private RechargeCardService rechargeCardService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private RedissonTemplate redissonTemplate;
    @Value(value="${ur.benlaiBrandId}")
    private Long benlaiBrandId;
    @Value(value="${ur.urBrandId}")
    private Long urBrandId;
    @Autowired
    private MemberInfoApiService memberInfoApiService;

    @PostMapping(value={"/getRechargeConfig"})
    public ResponseData<CusUrRechargeConfigVO> getRechargeConfig(@RequestParam(value="sysCompanyId") Long sysCompanyId, @RequestParam(value="sysBrandId") Long sysBrandId) {
        log.info("RechargeCardRpcController getRechargeConfigRpc sysCompanyId:{},sysBrandId:{} !", (Object)sysCompanyId, (Object)sysBrandId);
        return this.rechargeCardService.getRechargeConfig(sysCompanyId, sysBrandId);
    }

    @PostMapping(value={"/addDebitCardRechargeRecord"})
    public ResponseData addDebitCardRechargeRecord(@RequestBody UrRechargeCardVo vo) {
        log.info("enter addDebitCardRechargeRecord param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.addDebitCardRechargeRecord(vo);
    }

    @PostMapping(value={"/queryDebitCardInfo"})
    public ResponseData<List<CusUrRechargeCardPO>> queryDebitCardInfo(@RequestBody CusUrRechargeCardPO po) {
        log.info("enter queryDebitCardInfo param:{}", (Object)JacksonUtil.bean2Json((Object)po));
        return this.rechargeCardService.queryDebitCardInfo(po);
    }

    @PostMapping(value={"/addDebitCardRechargeCallBack"})
    public ResponseData addDebitCardRechargeCallBack(@RequestBody RechargeRecordRequestVO po) {
        log.info("enter addDebitCardRechargeCallBack param:{}", (Object)JacksonUtil.bean2Json((Object)po));
        return this.rechargeCardService.addDebitCardRechargeCallBack(po);
    }

    @PostMapping(value={"/getRechargeCardOne"})
    public ResponseData<CusUrMyRechargeCardVO> getRechargeCardOne(@RequestBody CusUrRechargeCardVO vo) {
        log.info("enter getRechargeCardOne param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.getRechargeCardOne(vo);
    }

    @PostMapping(value={"/getRechargeCardPassword"})
    public ResponseData<CusUrMyRechargeCardPwdVO> getRechargeCardPassword(@RequestBody CusUrRechargeCardVO vo) {
        log.info("enter getRechargeCardPassword param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.getRechargeCardPassword(vo);
    }

    @PostMapping(value={"/getRechargeCardRecharge"})
    public ResponseData<CusUrRechargeCardRechargeVO> getRechargeCardRecharge(@RequestBody CusUrRechargeCardVO vo) {
        log.info("enter getRechargeCardRecharge param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.getRechargeCardRecharge(vo);
    }

    @PostMapping(value={"/queryRechargeCard"})
    public ResponseData<RechargeCardBO> queryRechargeCard(@RequestParam(value="rechargeCardCode", required=false) String rechargeCardCode, @RequestParam(value="cardCode", required=false) String cardCode, @RequestParam(value="brandId") Long brandId, @RequestParam(value="companyId") Long companyId) {
        ResponseData responseData = new ResponseData();
        try {
            RechargeCardBO rechargeCardBO = this.rechargeCardService.queryRechargeCard(rechargeCardCode, cardCode, brandId, companyId);
            responseData.setData((Object)rechargeCardBO);
        }
        catch (PolicyException e) {
            log.error("queryRechargeCard PolicyException:" + (Object)((Object)e));
            responseData.setCode(e.getCode().intValue());
            responseData.setMessage(e.getMessage());
        }
        catch (Exception e) {
            log.error("queryRechargeCard Exception:" + e);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
        }
        return responseData;
    }

    @PostMapping(value={"/rechargeCardConsume"})
    public ResponseData<CardResponseBo> rechargeCardConsume(@RequestBody RechargeCardConsumeVO vo) throws Exception {
        log.info("enter rechargeCardConsume param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        if (this.benlaiBrandId.equals(vo.getBrandId())) {
            vo.setBrandId(this.urBrandId);
        }
        ResponseData responseData = new ResponseData();
        CusUrRechargeCardVO cardVO = CusUrRechargeCardVO.builder().sysCompanyId(vo.getCompanyId()).sysBrandId(vo.getBrandId()).cardNo(vo.getRechargeCardNo()).cardFreeze(Integer.valueOf(0)).lastFreezeOrderNo(vo.getOrderNo()).build();
        try {
            CusUrRechargeCardPO po = this.rechargeCardService.getRechargeCardByCardNo(cardVO);
            if (po == null) {
                responseData.setCode(RechargeCardErrorEunm.NO_EXIST_ERROR.getCode().intValue());
                responseData.setMessage(RechargeCardErrorEunm.NO_EXIST_ERROR.getMsg());
                return responseData;
            }
            if (po.getCardRefundStatus() == 0) {
                responseData.setCode(RechargeCardErrorEunm.CARD_IS_USE_REFUND.getCode().intValue());
                responseData.setMessage(RechargeCardErrorEunm.CARD_IS_USE_REFUND.getMsg());
                return responseData;
            }
            if (po.getCardFreeze() == 0) {
                responseData.setCode(RechargeCardErrorEunm.CARD_NO_USE_FREEZE.getCode().intValue());
                responseData.setMessage(RechargeCardErrorEunm.CARD_NO_USE_FREEZE.getMsg());
                return responseData;
            }
            this.rechargeCardService.freezeRechargeCard(cardVO);
            StringBuilder cardKey = new StringBuilder().append("rechargeCardConsume").append(vo.getRechargeCardNo()).append(vo.getCompanyId()).append(vo.getBrandId());
            Boolean bool_card_num = this.redisTemplate.opsForValue().setIfAbsent((Object)cardKey.toString(), (Object)"1");
            log.info("rechargeCardConsume cardNo redis key\u503c" + cardKey.toString());
            if (!bool_card_num.booleanValue()) {
                throw new PolicyException(RechargeCardErrorEunm.CARD_IS_USING.getCode(), RechargeCardErrorEunm.CARD_IS_USING.getMsg());
            }
            this.redisTemplate.expire((Object)cardKey.toString(), 1L, TimeUnit.MINUTES);
            StringBuilder orderKey = new StringBuilder().append("rechargeCardConsume").append(vo.getOrderNo());
            Boolean bool_order_num = this.redisTemplate.opsForValue().setIfAbsent((Object)orderKey.toString(), (Object)"1");
            if (!bool_order_num.booleanValue()) {
                throw new PolicyException(RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getCode(), RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getMsg());
            }
            this.redisTemplate.expire((Object)orderKey.toString(), 3L, TimeUnit.MINUTES);
            Boolean bool_verifyId = this.redisTemplate.opsForValue().setIfAbsent((Object)("rechargeCardConsume" + vo.getOrderNo() + vo.getVerifyId()), (Object)"1");
            if (!bool_verifyId.booleanValue()) {
                throw new PolicyException(RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getCode(), RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getMsg());
            }
            CardResponseBo cardResponseBo = this.rechargeCardService.rechargeCardConsume(vo);
            this.redisTemplate.delete((Object)cardKey.toString());
            responseData.setData((Object)cardResponseBo);
            cardVO.setCardFreeze(Integer.valueOf(1));
            this.rechargeCardService.freezeRechargeCard(cardVO);
        }
        catch (PolicyException e) {
            log.error("rechargeCardConsume PolicyException:" + ExceptionUtils.getStackTrace((Throwable)e));
            responseData.setCode(e.getCode().intValue());
            responseData.setMessage(e.getMessage());
            cardVO.setCardFreeze(Integer.valueOf(1));
            this.rechargeCardService.freezeRechargeCard(cardVO);
        }
        catch (Exception e) {
            log.error("rechargeCardConsume \u5361\u4ecd\u5728\u51bb\u7ed3\u4e2d Exception:" + ExceptionUtils.getStackTrace((Throwable)e));
            this.redisTemplate.delete((Object)("rechargeCardConsume" + vo.getRechargeCardNo() + vo.getCompanyId() + vo.getBrandId()));
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
        }
        if (!Integer.valueOf(0).equals(responseData.getCode()) && !Integer.valueOf(101).equals(responseData.getCode())) {
            this.redisTemplate.delete((Object)("rechargeCardConsume" + vo.getOrderNo()));
            this.redisTemplate.delete((Object)("rechargeCardConsume" + vo.getOrderNo() + vo.getVerifyId()));
            log.info("rechargeCardConsume redis key\u503c" + ("rechargeCardConsume" + vo.getOrderNo() + vo.getVerifyId()));
        }
        return responseData;
    }

    @PostMapping(value={"/rechargeCardOrderReturns"})
    public ResponseData<CardResponseBo> rechargeCardOrderReturns(@RequestBody RechargeCardModifyVO vo) throws Exception {
        if (this.benlaiBrandId.equals(vo.getBrandId())) {
            vo.setBrandId(this.urBrandId);
        }
        ResponseData responseData = new ResponseData();
        CusUrRechargeCardVO cardVO = CusUrRechargeCardVO.builder().sysCompanyId(vo.getCompanyId()).sysBrandId(vo.getBrandId()).cardNo(vo.getRechargeCardNo()).build();
        try {
            CusUrRechargeCardPO po = this.rechargeCardService.getRechargeCardByCardNo(cardVO);
            if (po == null) {
                responseData.setCode(RechargeCardErrorEunm.NO_EXIST_ERROR.getCode().intValue());
                responseData.setMessage(RechargeCardErrorEunm.NO_EXIST_ERROR.getMsg());
                return responseData;
            }
            if (po.getCardRefundStatus() == 0) {
                responseData.setCode(RechargeCardErrorEunm.CARD_IS_USE_REFUND.getCode().intValue());
                responseData.setMessage(RechargeCardErrorEunm.CARD_IS_USE_REFUND.getMsg());
                return responseData;
            }
            if (po.getCardStatus() == 0) {
                responseData.setCode(RechargeCardErrorEunm.CARD_NO_USE.getCode().intValue());
                responseData.setMessage(RechargeCardErrorEunm.CARD_NO_USE.getMsg());
                return responseData;
            }
            StringBuilder orderKey = new StringBuilder().append("rechargeCardOrderReturns").append(vo.getOrderNo());
            Boolean bool_order_num = this.redisTemplate.opsForValue().setIfAbsent((Object)orderKey.toString(), (Object)"1");
            if (!bool_order_num.booleanValue()) {
                throw new PolicyException(RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getCode(), RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getMsg());
            }
            this.redisTemplate.expire((Object)orderKey.toString(), 5L, TimeUnit.MINUTES);
            Boolean bool_verifyId = this.redisTemplate.opsForValue().setIfAbsent((Object)("rechargeCardOrderReturns" + vo.getOrderNo() + vo.getVerifyId()), (Object)"1");
            if (!bool_verifyId.booleanValue()) {
                throw new PolicyException(RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getCode(), RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getMsg());
            }
            CardResponseBo cardResponseBo = this.rechargeCardService.rechargeCardOrderReturns(vo);
            this.redisTemplate.delete((Object)orderKey.toString());
            responseData.setData((Object)cardResponseBo);
        }
        catch (PolicyException e) {
            responseData.setCode(e.getCode().intValue());
            responseData.setMessage(e.getMessage());
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            this.redisTemplate.delete((Object)("rechargeCardOrderReturns" + vo.getRechargeCardNo() + vo.getCompanyId() + vo.getBrandId()));
        }
        if (!Integer.valueOf(0).equals(responseData.getCode()) && !Integer.valueOf(101).equals(responseData.getCode())) {
            this.redisTemplate.delete((Object)("rechargeCardOrderReturns" + vo.getOrderNo()));
            this.redisTemplate.delete((Object)("rechargeCardOrderReturns" + vo.getOrderNo() + vo.getVerifyId()));
            log.info("rechargeCardOrderReturns redis key\u503c" + ("rechargeCardOrderReturns" + vo.getOrderNo() + vo.getVerifyId() + vo.getOriginalOrderNo()));
        }
        return responseData;
    }

    @PostMapping(value={"/rechargeCardPassword"})
    public ResponseData<CardPasswordBO> rechargeCardPassword(@RequestParam(value="rechargeCardNo") String rechargeCardNo, @RequestParam(value="cardCode") String cardCode, @RequestParam(value="password") String password, @RequestParam(value="brandId") Long brandId, @RequestParam(value="companyId") Long companyId) {
        ResponseData responseData = new ResponseData();
        try {
            CardPasswordBO cardPasswordBO = this.rechargeCardService.rechargeCardPassword(rechargeCardNo, cardCode, password, brandId, companyId);
            responseData.setData((Object)cardPasswordBO);
        }
        catch (PolicyException e) {
            responseData.setCode(e.getCode().intValue());
            responseData.setMessage(e.getMessage());
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
        }
        return responseData;
    }

    @PostMapping(value={"/sendRechargeCardPasswordSms"})
    public ResponseData<CardPasswordBO> sendRechargeCardPasswordSms(@RequestBody CusUrRechargeCardSmsPwdVo cusUrRechargeCardSmsPwdVo) {
        return this.rechargeCardService.sendRechargeCardPasswordSms(cusUrRechargeCardSmsPwdVo);
    }

    @PostMapping(value={"queryUrMemberRechargeRecord"})
    public ResponseData<PageInfo<CusUrRechargeCardRecordPO>> queryUrMemberRechargeRecord(@RequestParam(value="memberCode") @NonNull String memberCode, @RequestParam(value="pageNumber") @NonNull Integer pageNumber, @RequestParam(value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(value="type", defaultValue="2") Integer type) {
        if (memberCode == null) {
            throw new NullPointerException("memberCode");
        }
        if (pageNumber == null) {
            throw new NullPointerException("pageNumber");
        }
        log.info("queryUrMemberRechargeRecord memberCode:{},type:{}", (Object)memberCode, (Object)type);
        return this.rechargeCardService.queryUrMemberRechargeRecord(memberCode, pageNumber, pageSize, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u50a8\u503c\u5361\u8f6c\u589e\u63a5\u53e3")
    @PostMapping(value={"/transfer"})
    public ResponseData<Long> transfer(@RequestBody @Validated CusUrTransferVo vo) {
        log.info("enter RechargeCardController transfer param:{}", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData responseData = null;
        this.redissonTemplate.getRLock(vo.getMemberCode() + vo.getSysCompanyId() + "transfer", 30L, TimeUnit.SECONDS);
        try {
            responseData = this.rechargeCardService.transfer(vo);
        }
        catch (CustomizedException e) {
            ResponseData responseData2 = ResponseDataUtil.getFailedData(null, (String)e.getMessage());
            return responseData2;
        }
        finally {
            this.redissonTemplate.getRUnLook(vo.getMemberCode() + vo.getSysCompanyId() + "transfer");
        }
        return responseData;
    }

    @ApiOperation(value="\u50a8\u503c\u5361\u8f6c\u589e\u9886\u53d6\u9875\u9762\u67e5\u8be2")
    @PostMapping(value={"/getReceiveTransferPageInfo"})
    public ResponseData<CusUrReceiveTransferPageVo> getReceiveTransferPageInfo(@RequestParam(value="rechargeRecordId") Long rechargeRecordId) {
        log.info("enter RechargeCardController getReceiveTransferPageInfo param:{}", (Object)rechargeRecordId);
        ResponseData responseData = null;
        try {
            responseData = this.rechargeCardService.getReceiveTransferPageInfo(rechargeRecordId);
        }
        catch (CustomizedException e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return responseData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u50a8\u503c\u5361\u9886\u53d6\u8f6c\u589e")
    @PostMapping(value={"/receiveTransfer"})
    public ResponseData<String> receiveTransfer(@RequestBody @Validated CusUrReceiveTransferVo vo) {
        log.info("enter RechargeCardController receiveTransferPage param:{}", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData responseData = null;
        this.redissonTemplate.getRLock(String.valueOf(vo.getTransferRecordId()), 30L, TimeUnit.SECONDS);
        try {
            responseData = this.rechargeCardService.receiveTransfer(vo);
        }
        catch (CustomizedException e) {
            ResponseData responseData2 = ResponseDataUtil.getFailedData(null, (String)e.getMessage());
            return responseData2;
        }
        finally {
            this.redissonTemplate.getRUnLook(String.valueOf(vo.getTransferRecordId()));
        }
        return responseData;
    }

    @ApiOperation(value="\u50a8\u503c\u5361\u8f6c\u589e\u9875\u9762\u6570\u636e")
    @PostMapping(value={"/getTransferPageInfo"})
    public ResponseData<CusUrTransferPageVo> getTransferPageInfo(@RequestBody @Validated CusUrTransferPageReqVo vo) {
        log.info("enter RechargeCardController getTransferPageInfo param:{}", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData responseData = null;
        try {
            responseData = this.rechargeCardService.getTransferPageInfo(vo);
        }
        catch (CustomizedException e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return responseData;
    }

    @ApiOperation(value="\u53d1\u9001\u4fee\u6539\u50a8\u503c\u5361\u5bc6\u7801\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/sendSmsAuthCode"})
    public ResponseData sendSmsAuthCode(@RequestBody @Validated SendSmsAuthCodeVo vo) {
        log.info("enter RechargeCardController sendSmsAuthCode param:{}", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData responseData = null;
        try {
            responseData = this.rechargeCardService.sendSmsAuthCode(vo);
        }
        catch (CustomizedException e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return responseData;
    }

    @ApiOperation(value="\u67e5\u8be2\u50a8\u503c\u5361\u5bc6\u7801")
    @PostMapping(value={"/queryRechargeCardPass"})
    public ResponseData<CusUrRechargeCardPassVo> queryRechargeCardPass(@RequestBody @Validated CusUrRechargeCardPassVo vo) {
        log.info("enter RechargeCardController queryRechargeCardPass param:{}", (Object)JSONObject.toJSONString((Object)vo));
        ResponseData responseData = null;
        try {
            responseData = this.rechargeCardService.queryRechargeCardPass(vo);
        }
        catch (CustomizedException e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return responseData;
    }

    @ApiOperation(value="\u67e5\u8be2\u50a8\u503c\u5361\u6d88\u8d39\u8bb0\u5f55\u6839\u636e\u8ba2\u5355\u53f7 \u4f1a\u5458\u6d88\u8d39\u8be6\u60c5\u4f7f\u7528")
    @PostMapping(value={"/getRechargeCardPayRecord"})
    public ResponseData<CusUrRechargeCardRecordPO> getRechargeCardPayRecord(@RequestParam(value="orderNo") @NonNull String orderNo, @RequestParam(value="sysCompanyId") @NonNull Long sysCompanyId, @RequestParam(value="sysBrandId") @NonNull Long sysBrandId) {
        if (orderNo == null) {
            throw new NullPointerException("orderNo");
        }
        if (sysCompanyId == null) {
            throw new NullPointerException("sysCompanyId");
        }
        if (sysBrandId == null) {
            throw new NullPointerException("sysBrandId");
        }
        log.info("enter RechargeCardController getRechargeCardPayRecord orderNo:{}", (Object)orderNo);
        ResponseData responseData = null;
        try {
            responseData = this.rechargeCardService.getRechargeCardPayRecord(orderNo, sysCompanyId, sysBrandId);
        }
        catch (CustomizedException e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return responseData;
    }

    @ApiOperation(value="\u66f4\u6362\u5361\u9762\u9875\u9762\u5c55\u793a")
    @PostMapping(value={"/queryRechargeCardStyle"})
    public ResponseData<List<CusUrRechargeCardStyleVO>> queryRechargeCardStyle(@RequestBody CusUrRechargeCardVO vo) {
        return this.rechargeCardService.queryRechargeCardStyle(vo);
    }

    @ApiOperation(value="\u66f4\u6362\u5361\u9762")
    @PostMapping(value={"/changeRechargeCardStyle"})
    public ResponseData changeRechargeCardStyle(@RequestBody CusUrMyRechargeCardVO vo) {
        return this.rechargeCardService.changeRechargeCardStyle(vo);
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @PostMapping(value={"/updateRechargeCardPassword"})
    public ResponseData updateRechargeCardPassword(@RequestBody CusUrRechargeCardPwdVO vo) {
        return this.rechargeCardService.updateRechargeCardPassword(vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e00\u6b21\u6027\u9a8c\u7b7e")
    @PostMapping(value={"/getSign"})
    public ResponseData getSign() {
        return this.rechargeCardService.getSign();
    }

    @ApiOperation(value="\u50a8\u503c\u5361\u8f6c\u589e\u8bb0\u5f55\u53d6\u6d88")
    @PostMapping(value={"/cancelTransfer"})
    public ResponseData cancelTransfer(@NotNull @RequestParam(value="rechargeRecordId") Long rechargeRecordId) {
        log.info("enter RechargeCardController cancelTransfer rechargeRecordId:{}", (Object)rechargeRecordId);
        ResponseData responseData = null;
        try {
            responseData = this.rechargeCardService.cancelTransfer(rechargeRecordId);
        }
        catch (CustomizedException e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        return responseData;
    }

    @PostMapping(value={"/queryUrCardRefundRecord"})
    public ResponseData<List<CusUrCardRefundRecordPO>> queryUrCardRefundRecord(@RequestBody CusUrCardRefundRecordBO bo) {
        log.info("enter RechargeCardController queryUrCardRefundRecord params:{}", (Object)JacksonUtil.bean2Json((Object)bo));
        return this.rechargeCardService.queryUrCardRefundRecord(bo);
    }

    @PostMapping(value={"/adjustRechargeCard"})
    public ResponseData<CardResponseBo> adjustRechargeCard(@RequestBody RechargeCardModifyVO vo) throws Exception {
        ResponseData responseData = new ResponseData();
        try {
            StringBuilder cardKey = new StringBuilder().append("adjustRechargeCard").append(vo.getRechargeCardNo()).append(vo.getCompanyId()).append(vo.getBrandId());
            Boolean bool_card_num = this.redisTemplate.opsForValue().setIfAbsent((Object)cardKey.toString(), (Object)"1");
            log.info("adjustRechargeCard cardNo redis key\u503c" + cardKey.toString());
            if (!bool_card_num.booleanValue()) {
                throw new PolicyException(RechargeCardErrorEunm.CARD_IS_USING.getCode(), RechargeCardErrorEunm.CARD_IS_USING.getMsg());
            }
            this.redisTemplate.expire((Object)cardKey.toString(), 1L, TimeUnit.MINUTES);
            Boolean bool_verifyId = this.redisTemplate.opsForValue().setIfAbsent((Object)("adjustRechargeCard" + vo.getVerifyId()), (Object)"1");
            if (!bool_verifyId.booleanValue()) {
                throw new PolicyException(RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getCode(), RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getMsg());
            }
            StringBuilder orderKey = new StringBuilder().append("adjustRechargeCard").append(vo.getOrderNo()).append(vo.getType());
            Boolean bool_order_num = this.redisTemplate.opsForValue().setIfAbsent((Object)orderKey.toString(), (Object)"1");
            log.info("adjustRechargeCard redis key\u503c" + orderKey.toString());
            if (!bool_order_num.booleanValue()) {
                throw new PolicyException(RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getCode(), RechargeCardErrorEunm.SUBMIT_AGAIN_ERROR.getMsg());
            }
            this.redisTemplate.expire((Object)orderKey.toString(), 5L, TimeUnit.MINUTES);
            CardResponseBo cardResponseBo = this.rechargeCardService.adjustRechargeCard(vo);
            this.redisTemplate.delete((Object)cardKey.toString());
            responseData.setData((Object)cardResponseBo);
        }
        catch (PolicyException e) {
            responseData.setCode(e.getCode().intValue());
            responseData.setMessage(e.getMessage());
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            this.redisTemplate.delete((Object)("adjustRechargeCard" + vo.getRechargeCardNo() + vo.getCompanyId() + vo.getBrandId()));
        }
        if (!Integer.valueOf(0).equals(responseData.getCode()) && !Integer.valueOf(101).equals(responseData.getCode())) {
            this.redisTemplate.delete((Object)("adjustRechargeCard" + vo.getVerifyId()));
            this.redisTemplate.delete((Object)("adjustRechargeCard" + vo.getOrderNo() + vo.getType()));
        }
        return responseData;
    }

    @PostMapping(value={"/modifyRefundStatus"})
    public ResponseData modifyRefundStatus(@RequestBody RechargeCardStatusRequestVo requestVo) throws Exception {
        ResponseData responseData = new ResponseData();
        try {
            responseData = this.rechargeCardService.modifyRefundStatus(requestVo);
        }
        catch (PolicyException e) {
            responseData.setCode(e.getCode().intValue());
            responseData.setMessage(e.getMessage());
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
        }
        return responseData;
    }

    @PostMapping(value={"/refundRechargeCard"})
    public ResponseData refundRechargeCard(@RequestBody RefundRechargeCardRequestVo requestVo) throws Exception {
        ResponseData responseData = new ResponseData();
        CusUrRechargeCardVO cardVO = CusUrRechargeCardVO.builder().sysCompanyId(requestVo.getSysCompanyId()).sysBrandId(requestVo.getBrandId()).cardNo(requestVo.getRechargeCardNo()).build();
        try {
            CusUrRechargeCardPO rechargeCardPO = this.rechargeCardService.getRechargeCardByCardNo(cardVO);
            if (rechargeCardPO == null) {
                responseData.setCode(RechargeCardErrorEunm.NO_EXIST_ERROR.getCode().intValue());
                responseData.setMessage(RechargeCardErrorEunm.NO_EXIST_ERROR.getMsg());
                return responseData;
            }
            if (rechargeCardPO.getCardRefundStatus() == 1) {
                responseData.setCode(RechargeCardErrorEunm.CARD_NO_USE_REFUND.getCode().intValue());
                responseData.setMessage(RechargeCardErrorEunm.CARD_NO_USE_REFUND.getMsg());
                return responseData;
            }
            if (rechargeCardPO.getCardExpired() == 0) {
                responseData.setCode(RechargeCardErrorEunm.CARD_NO_USE_EXPIRED.getCode().intValue());
                responseData.setMessage(RechargeCardErrorEunm.CARD_NO_USE_EXPIRED.getMsg());
                return responseData;
            }
            if (rechargeCardPO.getRechargeBalanceTotal().compareTo(BigDecimal.ZERO) == 0) {
                responseData.setCode(RechargeCardErrorEunm.CARD_NO_REFUND_ZERO.getCode().intValue());
                responseData.setMessage(RechargeCardErrorEunm.CARD_NO_REFUND_ZERO.getMsg());
                return responseData;
            }
            responseData = this.rechargeCardService.refundRechargeCard(requestVo, rechargeCardPO);
        }
        catch (PolicyException e) {
            responseData.setCode(e.getCode().intValue());
            responseData.setMessage(e.getMessage());
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
        }
        return responseData;
    }

    @PostMapping(value={"/modifyRechargeCardOrderNo"})
    public ResponseData modifyRechargeCardOrderNo(@RequestBody RechargeCardOrderNoRequestVo requestVo) throws Exception {
        ResponseData responseData = new ResponseData();
        try {
            responseData = this.rechargeCardService.modifyRechargeCardOrderNo(requestVo);
        }
        catch (PolicyException e) {
            responseData.setCode(e.getCode().intValue());
            responseData.setMessage(e.getMessage());
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
        }
        return responseData;
    }

    @PostMapping(value={"/statisticsUrMemberRecharge"})
    ResponseData<StatisticsMbrRechargeCardRecordVo> statisticsUrMemberRecharge(@RequestBody StatisticsMbrRechargeCardRecordReqVo reqVo) {
        return this.rechargeCardService.statisticsUrMemberRecharge(reqVo);
    }

    @PostMapping(value={"/chargeRuleQuery"})
    public ResponseData chargeRuleQuery(@RequestBody BaseCompanyBrandVO vo) {
        log.info("enter chargeRuleQuery param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.chargeRuleQuery(vo);
    }

    @PostMapping(value={"/chargeRuleStoreQuery"})
    public ResponseData chargeRuleStoreQuery(@RequestBody BaseCompanyBrandVO vo) {
        log.info("enter chargeRuleStoreQuery param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.chargeRuleStoreQuery(vo);
    }

    @PostMapping(value={"/chargeVerify"})
    public ResponseData<ChargeVerifyRspVo> chargeVerify(@RequestBody ChargeVerifyReqVo vo) {
        log.info("enter chargeVerify param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.chargeVerify(vo);
    }

    @PostMapping(value={"/chargeRecordAdd"})
    public ResponseData<ChargeAddRecordRspVo> chargeRecordAdd(@RequestBody ChargeAddRecordReqVo vo) {
        log.info("enter chargeRecordAdd param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.chargeRecordAdd(vo);
    }

    @PostMapping(value={"/chargeRecordStatusQuery"})
    public ResponseData<ChargeAddRecordQueryRspVo> chargeRecordStatusQuery(@RequestBody ChargeAddRecordReqVo vo) {
        log.info("enter chargeRecordStatusQuery param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.chargeRecordStatusQuery(vo);
    }

    @PostMapping(value={"/chargeRecordRefunded"})
    public ResponseData<ChargeAddRecordRefundedRspVo> chargeRecordRefunded(@RequestBody ChargeAddRecordReqVo vo) {
        log.info("enter chargeRecordRefunded param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.chargeRecordRefunded(vo);
    }

    @PostMapping(value={"/chargeRecordListQuery"})
    public ResponseData<PageInfo<ChargeAddRecordListRspVo>> chargeRecordListQuery(@RequestBody ChargeAddRecordListReqVo vo) {
        log.info("enter chargeRecordListQuery param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.chargeRecordListQuery(vo);
    }

    @PostMapping(value={"/addRechargeRecordToOffline"})
    public ResponseData<Boolean> addRechargeRecordToOffline(@RequestBody CusUrRechargeCardStatisticReqVo requestVO) {
        SysAccountPO sysAccountPO = new SysAccountPO();
        sysAccountPO.setSysCompanyId(requestVO.getSysCompanyId());
        sysAccountPO.setBrandId(requestVO.getSysBrandId());
        Optional<SysAccountPO> optional = Optional.ofNullable(sysAccountPO);
        PageRequest pageable = PageRequest.of((int)requestVO.getPageNumber(), (int)requestVO.getPageSize());
        PageInfo pageInfoResponseData = this.rechargeCardService.queryUrRechargeDetail(requestVO, optional, (Pageable)pageable);
        log.info("RechargeCardRpcController-addRechargeRecordToOffline-info,pageInfoResponseData:{}", (Object)JSONObject.toJSONString((Object)pageInfoResponseData));
        if (pageInfoResponseData != null && CollectionUtils.isNotEmpty((Collection)pageInfoResponseData.getList())) {
            pageInfoResponseData.getList().forEach(item -> {
                UrRechargeCardVo rechargeCardVo = new UrRechargeCardVo();
                rechargeCardVo.setSysCompanyId(requestVO.getSysCompanyId());
                rechargeCardVo.setSysBrandId(requestVO.getSysBrandId());
                rechargeCardVo.setMerchantNo(item.getMerchantNo());
                rechargeCardVo.setAmount(new BigDecimal(item.getRechargeMoney()));
                rechargeCardVo.setGiveAmount(new BigDecimal(item.getGiveMoney()));
                rechargeCardVo.setMemberCode(item.getMemberCode());
                rechargeCardVo.setBizTradeNo(item.getBizTradeNo());
                RechargeRecordRequestVO rechargeRecordRequestVO = new RechargeRecordRequestVO();
                DateTime threeYearsLater = DateUtil.offset((Date)item.getCreateDate(), (DateField)DateField.YEAR, (int)3);
                rechargeRecordRequestVO.setPetCard(item.getMemberRechargeCardNo());
                rechargeRecordRequestVO.setBalance(Double.valueOf(item.getRechargeCardBalance().doubleValue()));
                rechargeRecordRequestVO.setValidDate((Date)threeYearsLater);
                rechargeRecordRequestVO.setIsNotCallBackCustomized(Integer.valueOf(1));
                ResponseData memberInfoRes = this.memberInfoApiService.queryOfflineMemberInfo(requestVO.getSysCompanyId(), requestVO.getSysBrandId(), item.getMemberCode());
                if (memberInfoRes != null && memberInfoRes.getCode() == SysResponseEnum.SUCCESS.getCode() && memberInfoRes.getData() != null) {
                    this.rechargeCardService.addRechargeRecordToOffline(rechargeCardVo, item.getRecordNo(), rechargeRecordRequestVO, (MemberInfoModel)memberInfoRes.getData());
                }
            });
        }
        return new ResponseData((Object)true);
    }
}

