/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.controller;

import com.bizvane.centerstageservice.models.po.FileImportTempPo;
import com.bizvane.customized.common.thread.ThreadPool;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.company.ur.members.models.storage.Model.StorageCardModel;
import com.bizvane.customized.company.ur.members.models.storage.vo.AddStorageRequestVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.AuditAddBatchVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryRecordResponseVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryStorageCardRecordVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryStorageRequestVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryStorageResponseVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryTaskDetailVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.QueryTaskVo;
import com.bizvane.customized.company.ur.members.models.storage.vo.UpdateStorageRequestVo;
import com.bizvane.customized.company.ur.members.service.StorageCardService;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardRecordPO;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardTASKDETAILPO;
import com.bizvane.customized.facade.models.po.CusUrMbrStorageCardTASKPO;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u50a8\u503c\u5361one"}, description="\u4e2d\u53f0\u5bf9\u50a8\u503c\u5361\u64cd\u4f5c\uff0c\u4e0d\u5305\u542b\u5916\u90e8\u8c03\u7528")
@RestController
@RequestMapping(value={"/ur/storageCard"})
public class StorageCardController {
    private static final Logger log = LoggerFactory.getLogger(StorageCardController.class);
    @Autowired
    private StorageCardService storageCardService;

    @ApiOperation(value="\u67e5\u8be2\u50a8\u503c\u5361(\u5206\u9875)", notes="\u9650\u5b9acookie\u4e2d\u53d6\u516c\u53f8\u3001\u54c1\u724c", produces="application/json", position=0)
    @PostMapping(value={"/queryStorageList"})
    public ResponseData<PageInfo<QueryStorageResponseVo>> queryStorageList(QueryStorageRequestVo queryStorageRequestVo, HttpServletRequest request) {
        log.info("enter StorageCardController queryStorageList param {}:", (Object)JacksonUtil.bean2Json((Object)queryStorageRequestVo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        ResponseData pageInfoResponseDataRes = new ResponseData();
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        if (!optional.isPresent()) {
            pageInfoResponseDataRes.setCode(SysResponseEnum.FAILED.getCode());
            pageInfoResponseDataRes.setMessage(SysResponseEnum.FAILED.getMessage());
            return pageInfoResponseDataRes;
        }
        PageRequest pageable = PageRequest.of((int)queryStorageRequestVo.getPageNum(), (int)queryStorageRequestVo.getPageSize());
        try {
            PageInfo pageInfoResponseData = this.storageCardService.queryStorageCardList(queryStorageRequestVo, optional, (Pageable)pageable);
            pageInfoResponseDataRes.setData((Object)pageInfoResponseData);
        }
        catch (Exception e) {
            pageInfoResponseDataRes.setMessage(e.getMessage());
        }
        return pageInfoResponseDataRes;
    }

    @ApiOperation(value="\u65b0\u589e\u50a8\u503c\u5361", notes="\u6839\u636e\u5361\u53f7\u67e5\u8be2\u4f1a\u5458\u8868\u4e0a\u7684\u59d3\u540d\u3001\u6027\u522b\u3001\u624b\u673a\u53f7\uff0c\u4e0d\u662f\u4f1a\u5458\u5219\u4e0d\u5141\u8bb8\u5bfc\u5165\uff0c  \u4ececookie\u4e2d\u53d6\u516c\u53f8\u3001\u54c1\u724c\u3001\u521b\u5efa\u4eba\u4fe1\u606f", produces="application/json", position=0)
    @PostMapping(value={"/addStorageCard"})
    public ResponseData<String> addStorageCard(@Valid AddStorageRequestVo addStorageRequestVo, HttpServletRequest request) {
        log.info("StorageCard addStorageCard param {} ", (Object)JacksonUtil.bean2Json((Object)addStorageRequestVo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return new ResponseData((Object)"\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f!");
        }
        StorageCardModel storageCardPo = new StorageCardModel();
        storageCardPo.setSysCompanyId(currentUser.getSysCompanyId());
        storageCardPo.setBrandId(currentUser.getBrandId());
        storageCardPo.setCreateUserId(currentUser.getSysAccountId());
        storageCardPo.setCreateUserName(currentUser.getName());
        storageCardPo.setVipCardNo(addStorageRequestVo.getVipCardNo());
        storageCardPo.setBalance(addStorageRequestVo.getBalance());
        storageCardPo.setRemark("1");
        return this.storageCardService.addStorageCard(storageCardPo);
    }

    @ApiOperation(value="\u7f16\u8f91\u50a8\u503c\u5361(\u8c03\u6574\u4f59\u989d)", notes="\u4f59\u989d\u8d70\u7edf\u4e00\u63a5\u53e3\uff0cupdate table set balance=balance+50 where vip_card_no=001001001", produces="application/json", position=1)
    @PostMapping(value={"/updateStorageCard"})
    public ResponseData<String> updateStorageCard(@Valid UpdateStorageRequestVo updateStorageRequestVo, HttpServletRequest request) {
        log.info("StorageCardController updateStorageCard param {}", (Object)JacksonUtil.bean2Json((Object)updateStorageRequestVo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return new ResponseData((Object)"\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f!");
        }
        updateStorageRequestVo.setSysCompanyId(currentUser.getSysCompanyId());
        updateStorageRequestVo.setBrandId(currentUser.getBrandId());
        updateStorageRequestVo.setName(currentUser.getName());
        ResponseData stringResponseData = this.storageCardService.updateStorageCard(updateStorageRequestVo);
        return stringResponseData;
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u50a8\u503c\u5361", notes="\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u4f1a\u5458\u5361\u53f7\u548c\u50a8\u503c\u5361\u53f7\uff0c\u4ea7\u54c1\u786e\u8ba4\u5bfc\u5165\u7684\u50a8\u503c\u5361\u53f7\u89c4\u5219\u4e0d\u4f1a\u548c\u73b0\u6709\u50a8\u503c\u5361\u53f7\u89c4\u5219\u4e00\u6837\uff0c\u4e0d\u662f\u4f1a\u5458\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002\u5bfc\u5165\u8981\u5bfc\u5165\u4e2d\u95f4\u8868\uff0c\u53ef\u67e5\u5bfc\u5165\u72b6\u6001\uff0c\u9700\u8981\u5ba1\u6838\u3002", produces="application/json", position=2)
    @PostMapping(value={"/importStorageCard"})
    public ResponseData<String> importStorageCard(@ApiParam(name="excelUrl", value="\u4e03\u725bexcel\u5730\u5740", example="http://xxx/xxx.xlsx", required=true) String excelUrl, HttpServletRequest request) {
        log.info("enter StorageCardController importStorageCard param {}", (Object)excelUrl);
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return new ResponseData((Object)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        Runnable runnable = () -> this.storageCardService.importStorageCardExcel(excelUrl, optional);
        ThreadPool.run((Runnable)runnable);
        ResponseData responseData = new ResponseData();
        responseData.setMessage("\u5bfc\u5165\u4e2d");
        return responseData;
    }

    @ApiOperation(value="\u6279\u91cf\u5145\u503c", notes="\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u50a8\u503c\u5361\u53f7\u548c\u91d1\u989d+\u3002\uff08\u5982\u679c\u6ca1\u6709\u627e\u5230\u5361\u53f7\uff0c\u5219\u81ea\u52a8\u65b0\u589e\u3002\uff09\u89c4\u5219\u786e\u8ba4\u53bb\u6389\uff0c\u4f59\u989d\u8d70\u7edf\u4e00\u63a5\u53e3\uff0cupdate table set balance=balance+50 where vip_card_no=001001001\u3002\u5bfc\u5165\u8981\u5bfc\u5165\u4e2d\u95f4\u8868\uff0c\u53ef\u67e5\u5bfc\u5165\u72b6\u6001\uff0c\u9700\u8981\u5ba1\u6838\u3002", produces="application/json", position=2)
    @PostMapping(value={"/importStorageCardPay"})
    public ResponseData<String> importStorageCardPay(@ApiParam(name="excelUrl", value="\u4e03\u725bexcel\u5730\u5740", example="http://xxx/xxx.xlsx", required=true) String excelUrl, HttpServletRequest request) {
        log.info("enter StorageCardController importStorageCardPay param {}", (Object)excelUrl);
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return new ResponseData((Object)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        Runnable runnable = () -> this.storageCardService.importStorageCardPay(excelUrl, optional);
        ThreadPool.run((Runnable)runnable);
        ResponseData responseData = new ResponseData();
        responseData.setMessage("\u5bfc\u5165\u4e2d");
        return responseData;
    }

    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u50a8\u503c\u5361\uff0c\u6279\u91cf\u5145\u503c \u5ba1\u6838\u64cd\u4f5c", produces="application/json", position=2)
    @PostMapping(value={"/auditAddBatchStorageCard"})
    public ResponseData<String> auditAddBatchStorageCard(@Valid AuditAddBatchVo addBatchVo, HttpServletRequest request) {
        log.info("enter StorageCardController auditAddBatchStorageCard param {}", (Object)JacksonUtil.bean2Json((Object)addBatchVo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        return this.storageCardService.auditAddBatchStorageCard(addBatchVo, optional);
    }

    @ApiOperation(value="\u6839\u636e\u50a8\u503c\u5361\u53f7\u67e5\u8be2\u50a8\u503c\u5361\u4f7f\u7528\u6d41\u6c34", produces="application/json", position=2)
    @PostMapping(value={"/queryStorageCardRecord"})
    public ResponseData<PageInfo<CusUrMbrStorageCardRecordPO>> queryStorageCardRecord(@Valid QueryStorageCardRecordVo queryStorageCardRecordVo, HttpServletRequest request) {
        log.info("enter StorageCardController queryStorageCardRecord param {}", (Object)JacksonUtil.bean2Json((Object)queryStorageCardRecordVo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        return this.storageCardService.queryStorageCardRecord(queryStorageCardRecordVo, optional);
    }

    @ApiOperation(value="\u50a8\u503c\u5361\u4f7f\u7528\u6d41\u6c34\u5bfc\u51fa", produces="application/json")
    @PostMapping(value={"/storageCardRecordExport"})
    public ResponseData<PageInfo<CusUrMbrStorageCardRecordPO>> storageCardRecordExport(QueryStorageCardRecordVo queryStorageCardRecordVo, HttpServletRequest request) {
        log.info("\u50a8\u503c\u5361\u4f7f\u7528\u6d41\u6c34\u5bfc\u51fa\u5165\u53c2: {}", (Object)JacksonUtil.bean2Json((Object)queryStorageCardRecordVo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        return this.storageCardService.storageCardRecordExport(queryStorageCardRecordVo, optional);
    }

    @ApiOperation(value="\u67e5\u8be2\u50a8\u503c\u5361\u4f7f\u7528\u6d41\u6c34", produces="application/json", position=2)
    @PostMapping(value={"/queryStorageCardRecordList"})
    public ResponseData<PageInfo<QueryRecordResponseVo>> queryStorageCardRecordList(@Valid QueryStorageCardRecordVo queryStorageCardRecordVo, HttpServletRequest request) {
        log.info("enter StorageCardController queryStorageCardRecordList param {}", (Object)JacksonUtil.bean2Json((Object)queryStorageCardRecordVo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        PageRequest pageable = PageRequest.of((int)queryStorageCardRecordVo.getPageNum(), (int)queryStorageCardRecordVo.getPageSize());
        PageInfo pageInfo = this.storageCardService.queryStorageCardRecordList(queryStorageCardRecordVo, optional, (Pageable)pageable);
        return ResponseDataUtil.getSuccessData((Object)pageInfo, (String)SysResponseEnum.SUCCESS.getMessage());
    }

    @ApiOperation(value="\u50a8\u503c\u5361\u5bfc\u51fa", produces="application/json", position=2)
    @PostMapping(value={"/exportStorageCardExcel"})
    public ResponseData<String> exportStorageCardExcel(QueryStorageRequestVo vo, HttpServletRequest request) {
        log.info("enter StorageCardController queryStorageCardRecordList param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        return this.storageCardService.exportStorageCardExcel(vo, optional);
    }

    @ApiOperation(value="\u50a8\u503c\u5361\u65e5\u5fd7\u5bfc\u51fa", produces="application/json", position=2)
    @PostMapping(value={"/exportStorageCardRecordExcel"})
    public ResponseData<String> exportStorageCardRecordExcel(QueryStorageCardRecordVo vo, HttpServletRequest request) {
        log.info("enter StorageCardController exportStorageCardRecordExcel param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        return this.storageCardService.exportStorageCardRecordExcel(vo, optional);
    }

    @ApiOperation(value="\u67e5\u770b\u4efb\u52a1\u5217\u8868", produces="application/json", position=2)
    @PostMapping(value={"/queryTaskList"})
    public ResponseData<PageInfo<CusUrMbrStorageCardTASKPO>> queryTaskList(QueryTaskVo vo, HttpServletRequest request) {
        log.info("enter StorageCardController queryTaskList param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        return this.storageCardService.queryTaskList(vo, optional);
    }

    @ApiOperation(value="\u67e5\u770b\u4efb\u52a1\u8be6\u60c5\uff0c\u5373\u6279\u91cf \u65b0\u589e\u50a8\u503c\u5361.\u6279\u91cf\u5145\u503c \u8be6\u60c5", produces="application/json", position=2)
    @PostMapping(value={"/queryTaskDetail"})
    public ResponseData<PageInfo<CusUrMbrStorageCardTASKDETAILPO>> queryTaskDetail(QueryTaskDetailVo vo, HttpServletRequest request) {
        log.info("enter StorageCardController queryTaskList param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        return this.storageCardService.queryTaskDetail(vo, optional);
    }

    @ApiOperation(value="\u4e0b\u8f7d\u6279\u91cf\u65b0\u589e\u50a8\u503c\u5361\u5bfc\u5165\u6a21\u677f")
    @PostMapping(value={"/downloadStorageCardTemplate"})
    ResponseData<FileImportTempPo> downloadStorageCardTemplate() {
        log.info("enter downloadTemplate label method");
        String fileTemplateType = "ADDBATCH_TEMPLATE";
        return this.storageCardService.downloadTemplate(fileTemplateType);
    }

    @ApiOperation(value="\u4e0b\u8f7d\u6279\u91cf\u5145\u503c\u50a8\u503c\u5361\u5bfc\u5165\u6a21\u677f")
    @PostMapping(value={"/downloadUpdateStorageCardTemplate"})
    ResponseData<FileImportTempPo> downloadUpdateStorageCardTemplate() {
        log.info("enter downloadTemplate label method");
        String fileTemplateType = "UPDATEBATCH_TEMPLATE";
        return this.storageCardService.downloadTemplate(fileTemplateType);
    }
}

