/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.ur.members.controller;

import com.bizvane.customized.common.constants.SysResponseEnum;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.company.ur.members.service.RechargeCardService;
import com.bizvane.customized.facade.exception.CustomizedException;
import com.bizvane.customized.facade.models.vo.CusUrCardRefundRecordVO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardCountRespListVo;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardStatisticReqVo;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardStatisticRespVo;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCardVO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeConfigVO;
import com.bizvane.customized.facade.models.vo.CusUrRechargeCountReqVo;
import com.bizvane.customized.facade.models.vo.CusUrRefundAuditRequestVo;
import com.bizvane.customized.facade.models.vo.CusUrRefundAuditRespVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"UR\u5145\u503c\u5361 \u4e2d\u53f0\u63a5\u53e3"}, description="\u4e2d\u53f0\u5bf9\u50a8\u503c\u5361\u64cd\u4f5c\uff0c\u4e0d\u5305\u542b\u5916\u90e8\u8c03\u7528")
@RestController
@RequestMapping(value={"/ur/rechargeCard"})
public class RechargeCardController {
    private static final Logger log = LoggerFactory.getLogger(RechargeCardController.class);
    @Autowired
    private RechargeCardService rechargeCardService;

    @PostMapping(value={"/addRechargeConfig"})
    public ResponseData addRechargeConfig(CusUrRechargeConfigVO vo, HttpServletRequest request) {
        log.info("RechargeCardController addRechargeConfig params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        vo.setSysBrandId(sysAccountPO.getBrandId());
        vo.setCreateUserId(sysAccountPO.getSysAccountId());
        vo.setCreateUserName(sysAccountPO.getName());
        return this.rechargeCardService.addRechargeConfig(vo);
    }

    @PostMapping(value={"/getRechargeConfig"})
    public ResponseData<CusUrRechargeConfigVO> getRechargeConfig(HttpServletRequest request) {
        log.info("RechargeCardController getRechargeConfig !");
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.rechargeCardService.getRechargeConfig(sysAccountPO.getSysCompanyId(), sysAccountPO.getBrandId());
    }

    @PostMapping(value={"/getCardStyleIsDel"})
    public ResponseData<Boolean> getCardStyleIsDel(HttpServletRequest request, String styleCode) {
        log.info("RechargeCardController getCardStyleIsDel styleCode:{}", (Object)styleCode);
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.rechargeCardService.getCardStyleIsDel(sysAccountPO.getSysCompanyId(), sysAccountPO.getBrandId(), styleCode);
    }

    @PostMapping(value={"/getRechargeCardList"})
    public ResponseData<PageInfo<CusUrRechargeCardVO>> getRechargeCardList(CusUrRechargeCardVO vo) {
        log.info("RechargeCardController getRechargeCardList params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.getRechargeCardList(vo);
    }

    @PostMapping(value={"/getCardRefundList"})
    public ResponseData<List<CusUrCardRefundRecordVO>> getCardRefundList(CusUrCardRefundRecordVO vo) {
        log.info("RechargeCardController getCardRefundList params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.rechargeCardService.getCardRefundList(vo);
    }

    @PostMapping(value={"/applyRefund"})
    public ResponseData applyRefund(HttpServletRequest request, CusUrCardRefundRecordVO vo) {
        log.info("RechargeCardController applyRefund params:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        vo.setApplyUserId(sysAccountPO.getSysAccountId());
        vo.setApplyUserName(sysAccountPO.getName());
        ResponseData responseData = new ResponseData();
        try {
            responseData = this.rechargeCardService.applyRefund(vo);
        }
        catch (Exception e) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(e.getMessage());
            log.error("RechargeCardController applyRefund error:" + e);
        }
        return responseData;
    }

    @PostMapping(value={"/queryUrRefundAuditInfo"})
    public ResponseData<CusUrRefundAuditRespVo> queryUrRefundAuditInfo(@RequestParam(value="businessId") @NotEmpty Long businessId) {
        log.info("queryUrRefundAuditInfo param:{}", (Object)businessId);
        return this.rechargeCardService.queryUrRefundAuditInfo(businessId);
    }

    @PostMapping(value={"/urRefundAudit"})
    public ResponseData urRefundAudit(@RequestBody CusUrRefundAuditRequestVo vo, HttpServletRequest request) {
        log.info("RechargeCardController urRefundAudit param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        ResponseData responseData = new ResponseData();
        try {
            SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
            responseData = this.rechargeCardService.urRefundAudit(vo, sysAccountPO);
        }
        catch (CustomizedException e) {
            return ResponseDataUtil.getFailedData(null, (String)e.getMessage());
        }
        catch (Exception e) {
            log.error("urRefundAudit error");
            e.printStackTrace();
        }
        return responseData;
    }

    @ApiOperation(value="\u67e5\u8be2UR\u50a8\u84c4\u5361\u660e\u7ec6", notes="\u9650\u5b9acookie\u4e2d\u53d6\u516c\u53f8\u3001\u54c1\u724c", produces="application/json", position=0)
    @PostMapping(value={"/queryUrRechargeDetail"})
    public ResponseData<PageInfo<CusUrRechargeCardStatisticRespVo>> queryUrRechargeDetail(CusUrRechargeCardStatisticReqVo vo, HttpServletRequest request) {
        log.info("enter RechargeCardController queryUrRechargeDetail param {}:", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        ResponseData pageInfoResponseDataRes = new ResponseData();
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        if (!optional.isPresent()) {
            pageInfoResponseDataRes.setCode(SysResponseEnum.FAILED.getCode());
            pageInfoResponseDataRes.setMessage(SysResponseEnum.FAILED.getMessage());
            return pageInfoResponseDataRes;
        }
        PageRequest pageable = PageRequest.of((int)vo.getPageNumber(), (int)vo.getPageSize());
        try {
            PageInfo pageInfoResponseData = this.rechargeCardService.queryUrRechargeDetail(vo, optional, (Pageable)pageable);
            pageInfoResponseDataRes.setData((Object)pageInfoResponseData);
        }
        catch (Exception e) {
            pageInfoResponseDataRes.setMessage(e.getMessage());
        }
        return pageInfoResponseDataRes;
    }

    @ApiOperation(value="\u660e\u7ec6\u5bfc\u51fa", produces="application/json", position=2)
    @PostMapping(value={"/exportRechargeDetailToExcel"})
    public ResponseData<String> exportRechargeDetailToExcel(CusUrRechargeCardStatisticReqVo vo, HttpServletRequest request) {
        log.info("enter RechargeCardController exportRechargeDetailToExcel param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        return this.rechargeCardService.exportRechargeDetailToExcel(vo, optional);
    }

    @ApiOperation(value="\u67e5\u8be2UR\u6c47\u603b\u8868", notes="\u9650\u5b9acookie\u4e2d\u53d6\u516c\u53f8\u3001\u54c1\u724c", produces="application/json")
    @PostMapping(value={"/queryUrRechargeCount"})
    public ResponseData<PageInfo<CusUrRechargeCardCountRespListVo>> queryUrRechargeCount(CusUrRechargeCountReqVo vo, HttpServletRequest request) {
        log.info("enter RechargeCardController queryUrRechargeCount param {}:", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        ResponseData pageInfoResponseDataRes = new ResponseData();
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        if (!optional.isPresent()) {
            pageInfoResponseDataRes.setCode(SysResponseEnum.FAILED.getCode());
            pageInfoResponseDataRes.setMessage(SysResponseEnum.FAILED.getMessage());
            return pageInfoResponseDataRes;
        }
        PageRequest pageable = PageRequest.of((int)vo.getPageNumber(), (int)vo.getPageSize());
        try {
            PageInfo pageInfoResponseData = this.rechargeCardService.queryUrRechargeCount(vo, optional, (Pageable)pageable);
            pageInfoResponseDataRes.setData((Object)pageInfoResponseData);
        }
        catch (Exception e) {
            pageInfoResponseDataRes.setMessage(e.getMessage());
        }
        return pageInfoResponseDataRes;
    }

    @ApiOperation(value="\u6c47\u603b\u8868\u5bfc\u51fa", produces="application/json", position=2)
    @PostMapping(value={"/exportRechargeCountToExcel"})
    public ResponseData<String> exportRechargeCountToExcel(CusUrRechargeCountReqVo vo, HttpServletRequest request) {
        log.info("enter RechargeCardController exportRechargeCountToExcel param {}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO currentUser = TokenUtils.getStageUser((HttpServletRequest)request);
        if (currentUser == null) {
            return ResponseDataUtil.getFailedData(null, (String)"\u6682\u65e0\u767b\u9646\u4eba\u5458\u4fe1\u606f");
        }
        Optional<SysAccountPO> optional = Optional.ofNullable(currentUser);
        return this.rechargeCardService.exportRechargeCountToExcel(vo, optional);
    }
}

