/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.teddy.service.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.models.po.SysDimSkuPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.SysDimSkuServiceRpc;
import com.bizvane.couponfacade.interfaces.CouponServiceFeign;
import com.bizvane.couponfacade.models.vo.CouponOfflineUseRequestVO;
import com.bizvane.customized.common.constants.SysConstants;
import com.bizvane.customized.common.utils.Assert;
import com.bizvane.customized.common.utils.DateUtil;
import com.bizvane.customized.common.utils.ExportExcelUtil;
import com.bizvane.customized.common.utils.FileNameUtil;
import com.bizvane.customized.common.utils.NumberUtil;
import com.bizvane.customized.common.utils.QiNiuConfig;
import com.bizvane.customized.common.utils.QiNiuUtil;
import com.bizvane.customized.common.utils.QiNiuUtils;
import com.bizvane.customized.common.utils.SpringContextHolder;
import com.bizvane.customized.common.utils.StreamingExportExcelUtil;
import com.bizvane.customized.common.utils.UUIDGenerator;
import com.bizvane.customized.company.teddy.service.CusTeddyGoodsCodeService;
import com.bizvane.customized.facade.enums.teddy.CusTeddyGoodsTaskStatusEnum;
import com.bizvane.customized.facade.enums.teddy.CusTeddyGoodsVerifyStatusEnum;
import com.bizvane.customized.facade.exception.CustomizedException;
import com.bizvane.customized.facade.models.po.CusTeddyGoodsCodeBatchPO;
import com.bizvane.customized.facade.models.po.CusTeddyGoodsCodeDetailPO;
import com.bizvane.customized.facade.models.po.CusTeddyGoodsCodeDetailPOExample;
import com.bizvane.customized.facade.models.po.CusTeddyGoodsVerifyDetailPO;
import com.bizvane.customized.facade.models.vo.QiNiuVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsCodeBatchCodeGenerateConfig;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsCodeBatchQueryVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsCodeDetailQueryVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyGoodsVo;
import com.bizvane.customized.facade.models.vo.teddy.CusTeddyPageQuery;
import com.bizvane.customized.facade.utils.UUIDUtil;
import com.bizvane.customized.mappers.CusTeddyGoodsCodeBatchPOMapper;
import com.bizvane.customized.mappers.CusTeddyGoodsCodeDetailPOMapper;
import com.bizvane.customized.mappers.CusTeddyGoodsVerifyBatchPOMapper;
import com.bizvane.customized.mappers.CusTeddyGoodsVerifyDetailPOMapper;
import com.bizvane.openapifacade.models.vo.CommonOrderApiDetail;
import com.bizvane.openapifacade.models.vo.CommonOrderRequestApiVo;
import com.bizvane.openapifacade.rpc.CommonFeignRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CusTeddyGoodsCodeServiceImpl
implements CusTeddyGoodsCodeService {
    private static final Logger log = LoggerFactory.getLogger(CusTeddyGoodsCodeServiceImpl.class);
    private static final String TEDDY_GOODS_ORDERNO_SEQUENCENUM = "teddyGoodsOrderNoSequenceNum_";
    @Autowired
    private CusTeddyGoodsCodeBatchPOMapper cusTeddyGoodsCodeBatchPOMapper;
    @Autowired
    private CusTeddyGoodsCodeDetailPOMapper cusTeddyGoodsCodeDetailPOMapper;
    @Autowired
    private CusTeddyGoodsVerifyBatchPOMapper cusTeddyGoodsVerifyBatchPOMapper;
    @Autowired
    private CusTeddyGoodsVerifyDetailPOMapper cusTeddyGoodsVerifyDetailPOMapper;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Autowired
    private SysDimSkuServiceRpc sysDimSkuServiceRpc;
    @Autowired
    private CommonFeignRpc commonFeignRpc;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    private CouponServiceFeign couponServiceFeign;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${teddy.goodsVerify.qrcodeUrl}")
    private String qrcodeUrl;

    public PageInfo<CusTeddyGoodsCodeBatchPO> queryBatchPage(CusTeddyGoodsCodeBatchQueryVo queryVo, CusTeddyPageQuery pageQuery, SysAccountPO currentUser) {
        log.info("\u5546\u54c1\u7801\u5e93\u6279\u6b21\u5206\u9875\u67e5\u8be2\u5165\u53c2:{}", JSON.toJSON((Object)queryVo));
        PageHelper.startPage((int)pageQuery.getPageNum(), (int)pageQuery.getPageSize());
        List poList = this.cusTeddyGoodsCodeBatchPOMapper.selectListByVo(queryVo, currentUser);
        PageInfo pageInfo = new PageInfo(poList);
        return pageInfo;
    }

    public void add(CusTeddyGoodsCodeBatchPO batchPO, SysAccountPO currentUser) {
        log.info("\u5546\u54c1\u7801\u521b\u5efa\u5165\u53c2:{}", JSON.toJSON((Object)batchPO));
        Assert.isTrue((batchPO.getSkuCode() != null ? 1 : 0) != 0, (String)"sku\u7f16\u53f7\u80fd\u4e3a\u7a7a");
        Assert.isTrue((batchPO.getCodeCount() != null ? 1 : 0) != 0, (String)"\u751f\u6210\u4e2a\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ResponseData skuPoResponseData = this.sysDimSkuServiceRpc.getSysDimSkuBySkuCode(batchPO.getSkuCode());
        Assert.isTrue((skuPoResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() ? 1 : 0) != 0, (String)("\u83b7\u53d6SKU\u4fe1\u606f\u5931\u8d25 " + skuPoResponseData.getMessage()));
        Assert.isTrue((skuPoResponseData.getData() != null ? 1 : 0) != 0, (String)"\u83b7\u53d6SKU\u4fe1\u606f\u5931\u8d25\uff0c\u6ca1\u6709\u6b64\u5546\u54c1");
        String skuCode = ((SysDimSkuPo)skuPoResponseData.getData()).getSkuCode();
        String productCode = ((SysDimSkuPo)skuPoResponseData.getData()).getProductCode();
        String batchNoPrefix = skuCode + DateUtil.getTodateString();
        String productCodePrefix = productCode.substring(0, 6);
        String skuCodePrefix = skuCode.substring(0, 8);
        int sequenceNum = 1;
        String batchNoMax = this.cusTeddyGoodsCodeBatchPOMapper.getMaxBatchNoBySkuCodeAndBatchNoPrefix(skuCode, batchNoPrefix, currentUser);
        if (!StringUtils.isBlank((CharSequence)batchNoMax)) {
            String sequenceNumStr = batchNoMax.replace(batchNoPrefix, "");
            sequenceNum = Integer.parseInt(sequenceNumStr) + 1;
        }
        int skuNoSequenceNum = 1;
        String skuNoMax = this.cusTeddyGoodsCodeDetailPOMapper.getMaxSkuNoBySkuCodePrefix(skuCodePrefix, currentUser);
        if (!StringUtils.isBlank((CharSequence)skuNoMax)) {
            String skuNoSequenceNumStr = skuNoMax.replace(skuCodePrefix, "");
            skuNoSequenceNum = Integer.parseInt(skuNoSequenceNumStr) + 1;
        }
        CusTeddyGoodsCodeBatchCodeGenerateConfig codeGenerateConfig = CusTeddyGoodsCodeBatchCodeGenerateConfig.builder().genCount(batchPO.getCodeCount()).skuNoSequenceNum(Integer.valueOf(skuNoSequenceNum)).batchNoPrefix(batchNoPrefix).productCode(productCode).productCodePrefix(productCodePrefix).skuCode(skuCode).skuCodePrefix(skuCodePrefix).build();
        String batchNo = batchNoPrefix + UUIDGenerator.addLeftZero((String)Integer.toString(sequenceNum), (int)6);
        batchPO.setBatchNo(batchNo);
        batchPO.setSkuName(((SysDimSkuPo)skuPoResponseData.getData()).getProductName());
        batchPO.setTaskStatus(Byte.valueOf((byte)CusTeddyGoodsTaskStatusEnum.PROCEED.getCode().intValue()));
        batchPO.setTaskExecuteTime(new Date());
        batchPO.setVerifyCount(Integer.valueOf(0));
        batchPO.setCodeGenerateConfig(JSON.toJSONString((Object)codeGenerateConfig));
        batchPO.setSysCompanyId(currentUser.getSysCompanyId());
        batchPO.setSysBrandId(currentUser.getBrandId());
        batchPO.setCreateUserId(currentUser.getSysAccountId());
        batchPO.setCreateUserName(currentUser.getName());
        batchPO.setCreateDate(new Date());
        batchPO.setValid(SysConstants.TABLE_VALID_EFFECTIVE);
        this.cusTeddyGoodsCodeBatchPOMapper.insert(batchPO);
        this.execGenCodeTask(batchPO, currentUser, codeGenerateConfig);
    }

    public void repeat(String batchNo, SysAccountPO currentUser) {
        CusTeddyGoodsCodeBatchPO batchPO = this.cusTeddyGoodsCodeBatchPOMapper.getByBatchNo(batchNo, currentUser);
        Assert.isTrue(((byte)CusTeddyGoodsTaskStatusEnum.FAIL.getCode().intValue() == batchPO.getTaskStatusCalculate() ? 1 : 0) != 0, (String)"\u4efb\u52a1\u72b6\u6001\u5f02\u5e38");
        batchPO.setTaskStatus(Byte.valueOf((byte)CusTeddyGoodsTaskStatusEnum.PROCEED.getCode().intValue()));
        batchPO.setTaskExecuteTime(new Date());
        batchPO.setModifiedUserId(currentUser.getSysAccountId());
        batchPO.setModifiedUserName(currentUser.getName());
        batchPO.setModifiedDate(new Date());
        batchPO.setRemark("");
        this.cusTeddyGoodsCodeBatchPOMapper.updateTaskStatus(batchPO);
        Integer countYet = this.cusTeddyGoodsCodeDetailPOMapper.getCountByBatchNo(batchNo, currentUser);
        Integer countWill = batchPO.getCodeCount() - countYet;
        CusTeddyGoodsCodeBatchCodeGenerateConfig codeGenerateConfig = (CusTeddyGoodsCodeBatchCodeGenerateConfig)JSON.parseObject((String)batchPO.getCodeGenerateConfig(), CusTeddyGoodsCodeBatchCodeGenerateConfig.class);
        codeGenerateConfig.setGenCount(countWill);
        int skuNoSequenceNum = 1;
        String skuNoMax = this.cusTeddyGoodsCodeDetailPOMapper.getMaxSkuNoBySkuCodePrefix(codeGenerateConfig.getSkuCodePrefix(), currentUser);
        if (!StringUtils.isBlank((CharSequence)skuNoMax)) {
            String skuNoSequenceNumStr = skuNoMax.replace(codeGenerateConfig.getSkuCodePrefix(), "");
            skuNoSequenceNum = Integer.parseInt(skuNoSequenceNumStr) + 1;
        }
        codeGenerateConfig.setSkuNoSequenceNum(Integer.valueOf(skuNoSequenceNum));
        this.execGenCodeTask(batchPO, currentUser, codeGenerateConfig);
    }

    public void execGenCodeTask(CusTeddyGoodsCodeBatchPO batchPO, SysAccountPO currentUser, CusTeddyGoodsCodeBatchCodeGenerateConfig codeGenerateConfig) {
        Callable<String> task = () -> {
            try {
                int skuNoSequenceNum = codeGenerateConfig.getSkuNoSequenceNum();
                for (int i = 0; i < codeGenerateConfig.getGenCount(); ++i) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new CustomizedException("thread is timeout");
                    }
                    CusTeddyGoodsCodeDetailPO detail = new CusTeddyGoodsCodeDetailPO();
                    String code = "X" + codeGenerateConfig.getProductCodePrefix() + NumberUtil.random((int)10);
                    String skuNo = codeGenerateConfig.getSkuCodePrefix() + UUIDGenerator.addLeftZero((String)Integer.toString(skuNoSequenceNum++), (int)9);
                    detail.setBatchNo(batchPO.getBatchNo());
                    detail.setSkuCode(batchPO.getSkuCode());
                    detail.setSkuName(batchPO.getSkuName());
                    detail.setSkuNo(skuNo);
                    detail.setCode(code);
                    detail.setVerifyStatus(Byte.valueOf((byte)CusTeddyGoodsVerifyStatusEnum.VERIFY_NOT.getCode().intValue()));
                    detail.setSysCompanyId(currentUser.getSysCompanyId());
                    detail.setSysBrandId(currentUser.getBrandId());
                    detail.setCreateUserId(currentUser.getSysAccountId());
                    detail.setCreateUserName(currentUser.getName());
                    detail.setCreateDate(new Date());
                    detail.setValid(SysConstants.TABLE_VALID_EFFECTIVE);
                    int r = this.cusTeddyGoodsCodeDetailPOMapper.insertWhenCodeNotRepeat(detail);
                    log.info("\u5f53\u524d\u7b2c{}\u4e2a\uff0ccode={}, \u662f\u5426\u5df2\u6709\u6570\u636e={}", new Object[]{i + 1, detail.getCode(), r <= 0 ? "y" : "n"});
                    if (r > 0) continue;
                    --i;
                    --skuNoSequenceNum;
                }
                batchPO.setTaskStatus(Byte.valueOf((byte)CusTeddyGoodsTaskStatusEnum.FINISH.getCode().intValue()));
                batchPO.setTaskExecuteTime(null);
                batchPO.setModifiedUserId(currentUser.getSysAccountId());
                batchPO.setModifiedUserName(currentUser.getName());
                batchPO.setModifiedDate(new Date());
                batchPO.setRemark("");
                this.cusTeddyGoodsCodeBatchPOMapper.updateTaskStatus(batchPO);
            }
            catch (Exception e) {
                log.error("codeDetail insert error", (Throwable)e);
                batchPO.setTaskStatus(Byte.valueOf((byte)CusTeddyGoodsTaskStatusEnum.FAIL.getCode().intValue()));
                batchPO.setTaskExecuteTime(null);
                batchPO.setModifiedUserId(currentUser.getSysAccountId());
                batchPO.setModifiedUserName(currentUser.getName());
                batchPO.setModifiedDate(new Date());
                batchPO.setRemark(e.getMessage());
                this.cusTeddyGoodsCodeBatchPOMapper.updateTaskStatus(batchPO);
            }
            return "success";
        };
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<String> future = executorService.submit(task);
        new Thread(() -> {
            try {
                String result = (String)future.get(2L, TimeUnit.HOURS);
                System.out.println(result);
            }
            catch (TimeoutException e) {
                log.error("CodeBatch insert error, thread is timeout", (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error("CodeBatch insert error", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error("CodeBatch insert error", (Throwable)e);
            }
            finally {
                future.cancel(true);
                executorService.shutdown();
            }
        }).start();
    }

    public void exportCodeDetailTxt(CusTeddyGoodsCodeDetailQueryVo queryVo, SysAccountPO currentUser) {
        log.info("\u5bfc\u51fa\u5546\u54c1\u7801\u4fe1\u606f,\u67e5\u8be2\u6761\u4ef6:{}", (Object)JSONObject.toJSONString((Object)queryVo));
        List poList = this.cusTeddyGoodsCodeDetailPOMapper.selectListByVo(queryVo, currentUser);
        int count = poList.size();
        Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u5185\u5bb9\u4e3a\u7a7a,\u65e0\u9700\u5bfc\u51fa");
        Long taskId = Long.valueOf(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        fileTaskPo.setFileId(taskId.toString());
        fileTaskPo.setTaskTypeCode(count + "\u6761");
        fileTaskPo.setTaskName("\u5bfc\u51fa\u5546\u54c1\u7801\u4fe1\u606f");
        fileTaskPo.setSysCompanyId(currentUser.getSysCompanyId());
        fileTaskPo.setSysBrandId(currentUser.getBrandId());
        fileTaskPo.setCreateUserId(currentUser.getSysAccountId());
        fileTaskPo.setCreateUserName(currentUser.getName());
        fileTaskPo.setFileStatus(Long.valueOf(0L));
        fileTaskPo.setFileType("EXPORT");
        fileTaskPo.setValid(SysConstants.TABLE_VALID_EFFECTIVE);
        this.fileTaskServiceRpc.addFileTask(fileTaskPo);
        StringBuffer text = new StringBuffer();
        for (CusTeddyGoodsCodeDetailPO detail : poList) {
            text.append(detail.getSkuNo());
            text.append(",");
            text.append(this.qrcodeUrl);
            text.append(detail.getCode());
            text.append("\r\n");
        }
        String moduleName = "\u5546\u54c1\u7801\u4fe1\u606f\u5bfc\u51fa_";
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(text.toString().getBytes());
            QiNiuUtils niuUtil = new QiNiuUtils();
            String bucket = ((QiNiuConfig)SpringContextHolder.getApplicationContext().getBean(QiNiuConfig.class)).getBucketNm();
            String fileName = FileNameUtil.getFileName((String)moduleName, (String)DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"), (String)".txt");
            QiNiuVo qiniuUrl = niuUtil.upload(bucket, (InputStream)in, fileName);
            fileTaskPo.setFileStatus(Long.valueOf(100L));
            String domain = ((QiNiuConfig)SpringContextHolder.getApplicationContext().getBean(QiNiuConfig.class)).getDomain();
            fileTaskPo.setFileUnl(QiNiuUtil.httpUrlCompatible((String)(domain + "/"), (String)qiniuUrl.getUrl()));
            log.info("fileTask\u5bfc\u51fa\u5730\u5740\uff1a" + fileTaskPo.getFileUnl());
            this.fileTaskServiceRpc.update(fileTaskPo);
        }
        catch (Exception e) {
            fileTaskPo.setFileStatus(Long.valueOf(-1L));
            this.fileTaskServiceRpc.update(fileTaskPo);
            log.error("gen file error:", (Throwable)e);
        }
    }

    @Deprecated
    public void exportCodeDetailExcel(CusTeddyGoodsCodeDetailQueryVo queryVo, SysAccountPO currentUser) {
        log.info("\u5bfc\u51fa\u5546\u54c1\u7801\u4fe1\u606f,\u67e5\u8be2\u6761\u4ef6:{}", (Object)JSONObject.toJSONString((Object)queryVo));
        CusTeddyGoodsCodeDetailPOExample example = new CusTeddyGoodsCodeDetailPOExample();
        long count = this.cusTeddyGoodsCodeDetailPOMapper.countByExample(example);
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"\u5185\u5bb9\u4e3a\u7a7a,\u65e0\u9700\u5bfc\u51fa");
        Long taskId = Long.valueOf(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        fileTaskPo.setFileId(taskId.toString());
        fileTaskPo.setTaskTypeCode(count + "\u6761");
        fileTaskPo.setTaskName("\u5bfc\u51fa\u5546\u54c1\u7801\u4fe1\u606f");
        fileTaskPo.setSysCompanyId(currentUser.getSysCompanyId());
        fileTaskPo.setSysBrandId(currentUser.getBrandId());
        fileTaskPo.setCreateUserId(currentUser.getSysAccountId());
        fileTaskPo.setCreateUserName(currentUser.getName());
        fileTaskPo.setFileStatus(Long.valueOf(0L));
        fileTaskPo.setFileType("EXPORT");
        fileTaskPo.setValid(SysConstants.TABLE_VALID_EFFECTIVE);
        this.fileTaskServiceRpc.addFileTask(fileTaskPo);
        StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(count));
        new Thread(() -> {
            try {
                exportExcelUtil.setExportProcessId((Object)taskId);
                Method method = this.cusTeddyGoodsCodeDetailPOMapper.getClass().getMethod("selectListByVo", CusTeddyGoodsCodeDetailQueryVo.class, Long.class, Long.class);
                exportExcelUtil.read("cusTeddyGoodsCodeDetailPOMapper", method, (model, row) -> {
                    Cell cell0 = row.createCell(0);
                    Cell cell1 = row.createCell(1);
                    Cell cell2 = row.createCell(2);
                    Cell cell3 = row.createCell(3);
                    Cell cell4 = row.createCell(4);
                    Cell cell5 = row.createCell(5);
                    Cell cell6 = row.createCell(6);
                    Cell cell7 = row.createCell(7);
                    if (row.getRowNum() == 0) {
                        cell0.setCellValue("\u6279\u6b21\u53f7");
                        cell1.setCellValue("SKU\u540d\u79f0");
                        cell2.setCellValue("\u521b\u5efa\u65f6\u95f4");
                        cell3.setCellValue("\u5546\u54c1\u7801");
                        cell4.setCellValue("\u662f\u5426\u6838\u9500");
                        cell5.setCellValue("\u6838\u9500\u65f6\u95f4");
                        cell6.setCellValue("\u6838\u9500\u4eba");
                        cell7.setCellValue("\u6838\u9500\u5bc6\u7801");
                    } else {
                        cell0.setCellValue(model.getBatchNo());
                        cell1.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getSkuName(), (CharSequence)""));
                        cell2.setCellValue(model.getCreateDate() != null ? DateUtil.format((Date)model.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss") : "");
                        cell3.setCellValue(model.getCode());
                        cell4.setCellValue(CusTeddyGoodsVerifyStatusEnum.VERIFY_YET.getCode().equals(model.getVerifyStatus().intValue()) ? "\u662f" : "\u5426");
                        cell5.setCellValue(model.getVerifyTime() != null ? DateUtil.format((Date)model.getVerifyTime(), (String)"yyyy-MM-dd HH:mm:ss") : "");
                        cell6.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getVerifyMemberName(), (CharSequence)""));
                        cell7.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getVerifyCode(), (CharSequence)""));
                    }
                }, new Object[]{queryVo});
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u7801\u4fe1\u606f\u5bfc\u51fa_\u5f02\u5e38,taskId:{},\u5f02\u5e38\u4fe1\u606f{}", (Object)taskId, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }).start();
        new Thread(() -> ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"\u5546\u54c1\u7801\u4fe1\u606f\u5bfc\u51fa_")).start();
    }

    public PageInfo<CusTeddyGoodsCodeDetailPO> queryDetailPage(CusTeddyGoodsCodeDetailQueryVo queryVo, CusTeddyPageQuery pageQuery, SysAccountPO currentUser) {
        log.info("\u5546\u54c1\u7801\u5e93\u660e\u7ec6\u5206\u9875\u67e5\u8be2\u5165\u53c2:{}", JSON.toJSON((Object)queryVo));
        PageHelper.startPage((int)pageQuery.getPageNum(), (int)pageQuery.getPageSize());
        List poList = this.cusTeddyGoodsCodeDetailPOMapper.selectListByVo(queryVo, currentUser);
        PageInfo pageInfo = new PageInfo(poList);
        return pageInfo;
    }

    @Transactional
    public void verify(CusTeddyGoodsVo vo) {
        Assert.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{vo.getCompanyId()}), (String)"\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{vo.getBrandId()}), (String)"\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getMemberCode()), (String)"\u4f1a\u5458code\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getCode()), (String)"\u5546\u54c1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getVerifyCode()), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        CusTeddyGoodsCodeDetailPO codeDetailPO = this.cusTeddyGoodsCodeDetailPOMapper.getByCode(vo);
        Assert.isTrue((codeDetailPO != null ? 1 : 0) != 0, (String)"\u5546\u54c1\u7801\u9519\u8bef");
        Assert.isTrue((boolean)CusTeddyGoodsVerifyStatusEnum.VERIFY_NOT.getCode().equals(codeDetailPO.getVerifyStatus().intValue()), (String)"\u5546\u54c1\u7801\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6");
        CusTeddyGoodsVerifyDetailPO verifyDetailPO = this.cusTeddyGoodsVerifyDetailPOMapper.getByCode(vo);
        Assert.isTrue((verifyDetailPO != null ? 1 : 0) != 0, (String)"\u5bc6\u7801\u9519\u8bef");
        Assert.isTrue((boolean)CusTeddyGoodsVerifyStatusEnum.VERIFY_NOT.getCode().equals(verifyDetailPO.getVerifyStatus().intValue()), (String)"\u5bc6\u7801\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u5546\u5bb6");
        verifyDetailPO.setVerifyStatus(Byte.valueOf((byte)CusTeddyGoodsVerifyStatusEnum.VERIFY_YET.getCode().intValue()));
        verifyDetailPO.setVerifyMemberCode(vo.getMemberCode());
        verifyDetailPO.setVerifyMemberName(vo.getMemberName());
        verifyDetailPO.setVerifyTime(new Date());
        this.cusTeddyGoodsVerifyDetailPOMapper.updateVerifyStatus(verifyDetailPO);
        codeDetailPO.setVerifyCode(vo.getVerifyCode());
        codeDetailPO.setVerifyStatus(Byte.valueOf((byte)CusTeddyGoodsVerifyStatusEnum.VERIFY_YET.getCode().intValue()));
        codeDetailPO.setVerifyMemberCode(vo.getMemberCode());
        codeDetailPO.setVerifyMemberName(vo.getMemberName());
        codeDetailPO.setVerifyTime(new Date());
        this.cusTeddyGoodsCodeDetailPOMapper.updateVerifyStatus(codeDetailPO);
        this.cusTeddyGoodsCodeBatchPOMapper.updateVerifyCountIncrement(codeDetailPO.getBatchNo(), codeDetailPO.getSysCompanyId(), codeDetailPO.getSysBrandId());
        this.cusTeddyGoodsVerifyBatchPOMapper.updateVerifyCountIncrement(verifyDetailPO.getBatchNo(), verifyDetailPO.getSysCompanyId(), verifyDetailPO.getSysBrandId());
        ResponseData brandPoResponseData = this.brandServiceRpc.getBrandByID(vo.getBrandId());
        String brandCode = ((SysBrandPo)brandPoResponseData.getData()).getBrandCode();
        ResponseData skuPoResponseData = this.sysDimSkuServiceRpc.getSysDimSkuBySkuCode(codeDetailPO.getSkuCode());
        Assert.isTrue((skuPoResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() ? 1 : 0) != 0, (String)("\u83b7\u53d6SKU\u4fe1\u606f\u5931\u8d25 " + skuPoResponseData.getMessage()));
        Assert.isTrue((skuPoResponseData.getData() != null ? 1 : 0) != 0, (String)"\u83b7\u53d6SKU\u4fe1\u606f\u5931\u8d25\uff0c\u6ca1\u6709\u6b64\u5546\u54c1");
        SysDimSkuPo sysDimSkuPo = (SysDimSkuPo)skuPoResponseData.getData();
        String orderNoPrefix = vo.getBrandId() + DateUtil.getTodateString();
        String sequenceNumKey = TEDDY_GOODS_ORDERNO_SEQUENCENUM + orderNoPrefix;
        long sequenceNum = this.stringRedisTemplate.opsForValue().increment((Object)sequenceNumKey, 1L);
        if (sequenceNum == 1L) {
            this.stringRedisTemplate.expire((Object)sequenceNumKey, 1L, TimeUnit.DAYS);
        }
        String orderNo = orderNoPrefix + UUIDGenerator.addLeftZero((String)Long.toString(sequenceNum), (int)8);
        CommonOrderRequestApiVo apiVo = new CommonOrderRequestApiVo();
        apiVo.setBrandCode(brandCode);
        apiVo.setOrderFlag(Integer.valueOf(1));
        apiVo.setPhone(vo.getPhone());
        apiVo.setErpId(vo.getErpId());
        apiVo.setStoreCode(vo.getStoreCode());
        apiVo.setStoreName(vo.getStoreName());
        apiVo.setOrderNo(orderNo);
        apiVo.setOrderFrom(Integer.valueOf(1));
        apiVo.setCommodityAmount(BigDecimal.valueOf(sysDimSkuPo.getPriceSug()));
        apiVo.setTradeAmount(BigDecimal.valueOf(sysDimSkuPo.getPriceSug()));
        apiVo.setPayMoney(BigDecimal.valueOf(sysDimSkuPo.getPriceSug()));
        apiVo.setPayTime(new Date());
        apiVo.setPlaceOrderTime(new Date());
        apiVo.setProductCount(Integer.valueOf(1));
        CouponOfflineUseRequestVO useRequestVO = new CouponOfflineUseRequestVO();
        useRequestVO.setBusinessCode(orderNo);
        useRequestVO.setUseMemberCode(vo.getMemberCode());
        Long useResult = 0L;
        try {
            useResult = (Long)this.couponServiceFeign.taiDiIntegralCouponAllUse(useRequestVO).getData();
            if (useResult != null && useResult != 0L) {
                apiVo.setGetIntegral(Integer.valueOf(Math.toIntExact(useResult)));
            }
        }
        catch (Exception e) {
            log.info("CusTeddyGoodsCodeServiceImpl#verify#useCouponException", (Throwable)e);
            throw new CustomizedException("\u79ef\u5206\u5238\u6d88\u8d39\u5f02\u5e38");
        }
        ArrayList<CommonOrderApiDetail> detailList = new ArrayList<CommonOrderApiDetail>();
        CommonOrderApiDetail detail = new CommonOrderApiDetail();
        detail.setOrderDetailNo(UUIDUtil.getUUID16());
        detail.setProductBrandCode(sysDimSkuPo.getProductBrandCode());
        detail.setQuantity("1");
        detail.setProductNo(sysDimSkuPo.getProductCode());
        detail.setProductName(sysDimSkuPo.getProductName());
        detail.setSkuCode(sysDimSkuPo.getSkuCode());
        detail.setTagPrice(sysDimSkuPo.getPriceSug().toString());
        detail.setTradeAmountDetail(sysDimSkuPo.getPriceSug().toString());
        detail.setColor(sysDimSkuPo.getColorPrd());
        detail.setSize(sysDimSkuPo.getSizePrd());
        detailList.add(detail);
        apiVo.setOrderDetail(detailList);
        ResponseData orderResponseData = this.commonFeignRpc.addCommonOrder(apiVo);
        log.info("\u5546\u54c1\u7801\u6821\u9a8c \u8865\u5f55\u4f1a\u5458\u8ba2\u5355={}", (Object)JSON.toJSONString((Object)orderResponseData));
        Assert.isTrue((orderResponseData.getCode() == SysResponseEnum.SUCCESS.getCode() ? 1 : 0) != 0, (String)("\u5546\u54c1\u7801\u6821\u9a8c \u8865\u5f55\u8ba2\u5355\u5931\u8d25 " + orderResponseData.getMessage()));
    }

    public CusTeddyGoodsCodeDetailPO detail(CusTeddyGoodsVo vo) {
        Assert.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{vo.getCompanyId()}), (String)"\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtils.allNotNull((Object[])new Object[]{vo.getBrandId()}), (String)"\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)vo.getCode()), (String)"\u5546\u54c1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        CusTeddyGoodsCodeDetailPO codeDetailPO = this.cusTeddyGoodsCodeDetailPOMapper.getByCode(vo);
        return codeDetailPO;
    }
}

