/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.teddy.controller;

import com.alibaba.fastjson.JSON;
import com.bizvane.couponfacade.models.vo.standard.StandardCouponUseRequestVo;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.openapifacade.rpc.CommonFeignRpc;
import com.bizvane.utils.redisutils.RedissonTemplate;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.TokenSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6cf0\u8fea\u718a\u6838\u9500\u4f18\u60e0\u5238CusTeddyCouponController"})
@RequestMapping(value={"/teddy/coupon"})
@RestController
public class CusTeddyCouponController {
    private static final Logger log = LoggerFactory.getLogger(CusTeddyCouponController.class);
    private static final String LOCK_KEY = "teddyCouponVerify_";
    @Autowired
    private CommonFeignRpc commonFeignRpc;
    @Autowired
    private RedissonTemplate redissonTemplate;
    @Autowired
    private HttpServletRequest request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TokenSupport(sysCompanyId="${teddy.sysCompanyId}")
    @ApiOperation(value="\u4f18\u60e0\u5238\u6821\u9a8c", notes="\u4f18\u60e0\u5238\u6821\u9a8c")
    @PostMapping(value={"verify"})
    public ResponseData verify(@RequestBody StandardCouponUseRequestVo couponUseRequestVo) {
        log.info("\u4f18\u60e0\u5238\u6821\u9a8c.verify-->couponUseRequestVo:{}", (Object)JSON.toJSONString((Object)couponUseRequestVo));
        ResponseData responseData = new ResponseData();
        String key = LOCK_KEY + couponUseRequestVo.getCouponCode();
        this.redissonTemplate.getRLock(key, 60L, TimeUnit.SECONDS);
        log.info("key:{}", (Object)key);
        try {
            responseData = this.commonFeignRpc.couponUse(couponUseRequestVo);
        }
        catch (Exception e) {
            log.error("CusTeddyCouponController verify error", (Throwable)e);
            ResponseData responseData2 = ResponseDataUtil.getFailedData(null, (String)e.getMessage());
            return responseData2;
        }
        finally {
            this.redissonTemplate.getRUnLook(key);
        }
        return responseData;
    }
}

