/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.store361.jobHandler.Cus361SyncWMOrderJobHandler;
import com.bizvane.customized.company.store361.service.MbrOrderService;
import com.bizvane.customized.facade.models.vo.CusSyncWMOrderDetailVo;
import com.bizvane.customized.facade.models.vo.CusSyncWMOrderVo;
import com.bizvane.customized.mappers.CusMbrOrderPoMapper;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.commonutils.AsyncHttpUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MbrOrderServiceImpl
implements MbrOrderService {
    private static final Logger log = LoggerFactory.getLogger(MbrOrderServiceImpl.class);
    private static final Integer syncDataSize = 40;
    private static final String syncWMOrderUrl = "http://vipop.361sport.com:28088/api/SyncMemberConsume";
    private static final String zero = "0";
    private static final String retryMessage = "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6!";
    private static final Integer retryMax = 10;
    private static final Logger logger = LoggerFactory.getLogger(MbrOrderServiceImpl.class);
    private static final String sycnTypeErrorRetryMax = "ErrorRetryMax";
    private static final String sycnTypeErrorRpc = "ErrorRpc";
    private static final String sycnTypeSuccess = "Success";
    private static final String repeatDataMsg = "record_code-\u5355\u636e\u7f16\u53f7\u5df2\u5b58\u5728";
    @Autowired
    MemberInfoApiService memberInfoApiService;
    @Autowired
    CusMbrOrderPoMapper cusMbrOrderPoMapper;

    public Integer syncWMOrder(String type, String startTime, String endTime, Map<String, String> headerParams) {
        logger.info("MbrOrderServiceImpl syncWMOrder startTime:{}, endTime:{}", (Object)startTime, (Object)endTime);
        List orders = null;
        orders = "2".equals(type) ? this.cusMbrOrderPoMapper.getSyncWMOrder2(startTime, endTime) : ("3".equals(type) ? this.cusMbrOrderPoMapper.getSyncWMOrder3(startTime, endTime) : this.cusMbrOrderPoMapper.getSyncWMOrder(startTime, endTime));
        Integer dataSize = orders.isEmpty() ? 0 : orders.size();
        Integer syncSize = 0;
        if (dataSize > 0) {
            ArrayList<CusSyncWMOrderVo> requestVo = new ArrayList<CusSyncWMOrderVo>();
            for (int i = 0; i < orders.size(); ++i) {
                CusSyncWMOrderVo item = (CusSyncWMOrderVo)orders.get(i);
                logger.info("MbrOrderServiceImpl syncWMOrder item:{}", (Object)item);
                List orderDetails = this.cusMbrOrderPoMapper.getSyncWMOrderDetail(item.getRecordCode());
                logger.info("MbrOrderServiceImpl syncWMOrder orderDetails:{}", (Object)orderDetails);
                if (orderDetails != null && orderDetails.size() > 0) {
                    if (!zero.equals(item.getRebate())) {
                        item.setRebate(this.getOrderRebate(item.getRealMoney(), orderDetails));
                    }
                    item.setCusSyncWMOrderDetailVoList(orderDetails);
                    requestVo.add(item);
                }
                if (requestVo.size() != syncDataSize.intValue() && i != orders.size() - 1) continue;
                String requestJson = JSONObject.toJSONString(requestVo);
                this.call361Api(requestJson, headerParams, Integer.valueOf(1));
                syncSize = syncSize + requestVo.size();
                requestVo.clear();
            }
        }
        return syncSize;
    }

    public Integer syncWMOrderByOrderNo(Map<String, String> headerParams) {
        logger.info("MbrOrderServiceImpl syncWMOrderByOrderNo");
        List orders = this.cusMbrOrderPoMapper.getSyncWMOrderByOrderNo();
        Integer dataSize = orders.isEmpty() ? 0 : orders.size();
        Integer syncSize = 0;
        if (dataSize > 0) {
            ArrayList<CusSyncWMOrderVo> requestVo = new ArrayList<CusSyncWMOrderVo>();
            for (int i = 0; i < orders.size(); ++i) {
                CusSyncWMOrderVo item = (CusSyncWMOrderVo)orders.get(i);
                logger.info("MbrOrderServiceImpl syncWMOrderByOrderNo item:{}", (Object)item);
                List orderDetails = this.cusMbrOrderPoMapper.getSyncWMOrderDetail(item.getRecordCode());
                logger.info("MbrOrderServiceImpl syncWMOrderByOrderNo orderDetails:{}", (Object)orderDetails);
                if (orderDetails != null && orderDetails.size() > 0) {
                    if (!zero.equals(item.getRebate())) {
                        item.setRebate(this.getOrderRebate(item.getRealMoney(), orderDetails));
                    }
                    item.setCusSyncWMOrderDetailVoList(orderDetails);
                    requestVo.add(item);
                }
                if (requestVo.size() != syncDataSize.intValue() && i != orders.size() - 1) continue;
                String requestJson = JSONObject.toJSONString(requestVo);
                this.call361Api(requestJson, headerParams, Integer.valueOf(1));
                syncSize = syncSize + requestVo.size();
                requestVo.clear();
            }
        }
        return syncSize;
    }

    private void call361Api(String requestJson, Map<String, String> headerParams, Integer retryCount) {
        logger.info("MbrOrderServiceImpl call361Api requestJson:{}, headerParams:{}, retryCount:{}", new Object[]{requestJson, headerParams, retryCount});
        String responseMessage = "";
        JSONObject responseJson = null;
        if (retryCount > retryMax) {
            logger.info("MbrOrderServiceImpl call361Api \u91cd\u8bd5\u6b21\u6570\u8d85\u8fc7:{}, \u5ffd\u7565\u672c\u6b21\u540c\u6b65", (Object)retryMax);
            this.saveSyncRecord(sycnTypeErrorRetryMax, requestJson, JSONObject.parseObject((String)"{\"Success\":false,\"Message\":\"Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6!\",\"Records\":0,\"Data\":null}"));
            return;
        }
        if (retryCount - 1 > 0) {
            try {
                Thread.sleep((long)(retryCount - 1) * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String response = AsyncHttpUtil.doPost((String)syncWMOrderUrl, (String)requestJson, null, headerParams);
        logger.info("MbrOrderServiceImpl call361Api response:{}, retryCount:{}", (Object)response, (Object)retryCount);
        if (StringUtils.isBlank((CharSequence)response)) {
            this.saveSyncRecord(sycnTypeErrorRpc, requestJson, JSONObject.parseObject((String)"ICRM\u63a5\u53e3\u65e0\u8fd4\u56de\u503c"));
            return;
        }
        responseJson = JSONObject.parseObject((String)response);
        responseMessage = responseJson.getString("Message");
        Boolean status = responseJson.getBoolean(sycnTypeSuccess);
        if (!Boolean.TRUE.equals(status)) {
            logger.info("MbrOrderServiceImpl call361Api responseMessage fail:{}, retryCount:{}", (Object)responseMessage, (Object)retryCount);
            if (retryMessage.equals(responseMessage)) {
                String token = Cus361SyncWMOrderJobHandler.getSyncFrozenMembersLogsToken();
                headerParams.put("Token", token);
                this.call361Api(requestJson, headerParams, Integer.valueOf(retryCount + 1));
            } else {
                this.saveSyncRecord(sycnTypeSuccess, requestJson, responseJson);
            }
        }
    }

    private void saveSyncRecord(String type, String requestJson, JSONObject responseJson) {
        try {
            if (type.equals(sycnTypeSuccess)) {
                JSONArray dataList = responseJson.getJSONArray("data");
                for (int i = 0; i < dataList.size(); ++i) {
                    JSONObject item = dataList.getJSONObject(i);
                    String success = item.getString("success");
                    String orderNo = item.getString("record_code");
                    String msg = item.getString("msg");
                    if ("true".equals(success) || repeatDataMsg.equals(msg)) continue;
                    this.cusMbrOrderPoMapper.insertSyncWMOrderOrderLogs(type, orderNo, JacksonUtil.bean2Json((Object)item));
                }
            } else {
                this.cusMbrOrderPoMapper.insertSyncWMOrderRequestLogs(type, requestJson);
                JSONArray dataList = JSONArray.parseArray((String)requestJson);
                for (int i = 0; i < dataList.size(); ++i) {
                    JSONObject item = dataList.getJSONObject(i);
                    String orderNo = item.getString("record_code");
                    this.cusMbrOrderPoMapper.insertSyncWMOrderOrderLogs(type, orderNo, JacksonUtil.bean2Json((Object)responseJson));
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u540c\u6b65361icrm\u65e5\u5fd7\u5f02\u5e38:", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private String getOrderRebate(BigDecimal payMoney, List<CusSyncWMOrderDetailVo> orderDetails) {
        BigDecimal orderRebate = BigDecimal.ZERO;
        BigDecimal sumTagPrice = BigDecimal.ZERO;
        try {
            for (CusSyncWMOrderDetailVo item : orderDetails) {
                sumTagPrice = sumTagPrice.add(item.getReferPrice());
            }
            logger.info("MbrOrderServiceImpl getOrderRebate payMoney:{}, sumTagPrice:{}", (Object)payMoney, (Object)sumTagPrice);
            orderRebate = payMoney.divide(sumTagPrice, 2, RoundingMode.HALF_UP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orderRebate.stripTrailingZeros().toString();
    }

    public static void main(String[] args) {
    }
}

