/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.icrm.AddVipRequestVO;
import com.bizvane.connectorservice.interfaces.rpc.IcrmConnectorServiceFeign;
import com.bizvane.customized.common.utils.DateUtil;
import com.bizvane.customized.common.utils.ExportExcelUtil;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.StreamingExportExcelUtil;
import com.bizvane.customized.company.store361.service.MbrFrozenRecordService;
import com.bizvane.customized.facade.constants.MbrFrozenRecordConstants;
import com.bizvane.customized.facade.enums.CrmCardUseStatusEnum;
import com.bizvane.customized.facade.enums.MbrFrozenEnum;
import com.bizvane.customized.facade.enums.MbrFrozenThawEnum;
import com.bizvane.customized.facade.models.po.CusMbrFrozenRecordPo;
import com.bizvane.customized.facade.models.po.CusMbrFrozenRecordPoExample;
import com.bizvane.customized.facade.models.vo.CusMbrFrozenRecordVo;
import com.bizvane.customized.facade.models.vo.CusSyncMemberFreeVo;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.customized.facade.utils.UUIDUtil;
import com.bizvane.customized.mappers.CusMbrFrozenRecordPoMapper;
import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.members.facade.vo.BatchUpdateMemberInfoVo;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.utils.commonutils.AsyncHttpUtil;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MbrFrozenRecordServiceImpl
implements MbrFrozenRecordService {
    private static final Logger log = LoggerFactory.getLogger(MbrFrozenRecordServiceImpl.class);
    private String crmSource = "999";
    private Integer syncFrozenMembersLogsDataSize = 40;
    private String syncFrozenMembersLogsUnName = "SF1";
    private String syncFrozenMembersLogsPasswrd = "3700e6bb36fd4532a6a1810d30215d68";
    private String syncFrozenMembersLogsLoginUrl = "http://vipop.361sport.com:28088/api/login";
    private String syncFrozenMembersLogsBusinessUrl = "http://vipop.361sport.com:28088/api/SyncMemberFree";
    @Autowired
    private IcrmConnectorServiceFeign icrmConnectorServiceFeign;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Autowired
    MemberInfoApiService memberInfoApiService;
    @Autowired
    CusMbrFrozenRecordPoMapper cusMbrFrozenRecordPoMapper;

    public ResponseData<PageInfo<CusMbrFrozenRecordVo>> queryRecordList(CusMbrFrozenRecordVo cusMbrFrozenRecordVo, PageVo pageVo) {
        return new ResponseData((Object)this.getPageInfo(cusMbrFrozenRecordVo, pageVo));
    }

    private PageInfo<CusMbrFrozenRecordVo> getPageInfo(CusMbrFrozenRecordVo cusMbrFrozenRecordVo, PageVo pageVo) {
        Page pageInfo = this.getCusMbrFrozenRecordVos(cusMbrFrozenRecordVo, pageVo);
        return new PageInfo((List)pageInfo);
    }

    private Page<CusMbrFrozenRecordVo> getCusMbrFrozenRecordVos(CusMbrFrozenRecordVo cusMbrFrozenRecordVo, PageVo pageVo) {
        Page page;
        List list;
        if (StringUtils.isNotBlank((CharSequence)cusMbrFrozenRecordVo.getStoreCode())) {
            cusMbrFrozenRecordVo.setStoreCodes(Arrays.asList(cusMbrFrozenRecordVo.getStoreCode().split(",")));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = (page = PageHelper.startPage((int)pageVo.getPageNumber(), (int)pageVo.getPageSize()).doSelectPage(() -> this.cusMbrFrozenRecordPoMapper.findAll(cusMbrFrozenRecordVo))).getResult()))) {
            list.forEach(recordVo -> this.validNull(recordVo));
        }
        return page;
    }

    public ResponseData addWhite(List<CusMbrFrozenRecordVo> list, SysAccountPO sysAccountPO) {
        List primaryList = this.primaryCollection(list);
        for (CusMbrFrozenRecordVo recordVo : primaryList) {
            this.updateWhiteList(recordVo, sysAccountPO);
        }
        return new ResponseData();
    }

    private void updateWhiteList(CusMbrFrozenRecordVo recordVo, SysAccountPO sysAccountPO) {
        try {
            CusMbrFrozenRecordPo recordPo = new CusMbrFrozenRecordPo();
            CusMbrFrozenRecordPoExample example = this.memberCodeExample(recordVo);
            List frozenRecordPos = this.cusMbrFrozenRecordPoMapper.selectByExample(example);
            if (CollectionUtils.isEmpty((Collection)frozenRecordPos)) {
                log.info("\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u4fe1\u606f\uff01");
                return;
            }
            CusMbrFrozenRecordPoExample poExample = this.cardNoExample((CusMbrFrozenRecordPo)frozenRecordPos.get(0), sysAccountPO.getSysCompanyId());
            if (recordVo.getWhiteList().equals(MbrFrozenRecordConstants.WHITELIST_Y)) {
                recordPo.setWhiteList(MbrFrozenRecordConstants.WHITELIST_N);
            } else {
                recordPo.setWhiteList(MbrFrozenRecordConstants.WHITELIST_Y);
            }
            recordPo.setWhiteOperateUserName(sysAccountPO.getName());
            recordPo.setWhiteOperateUserId(sysAccountPO.getSysAccountId());
            recordPo.setWhiteOperateDate(new Date());
            this.cusMbrFrozenRecordPoMapper.updateByExampleSelective(recordPo, poExample);
            recordVo.setCardNo(((CusMbrFrozenRecordPo)frozenRecordPos.get(0)).getCardNo());
            this.addThawRecord(recordVo, sysAccountPO);
        }
        catch (Exception e) {
            log.info("\u66f4\u65b0\u767d\u540d\u5355\u5931\u8d25.\u5f02\u5e38\u4fe1\u606f\uff1a" + e);
        }
    }

    private void addThawRecord(CusMbrFrozenRecordVo recordVo, SysAccountPO sysAccountPO) {
        CusMbrFrozenRecordPoExample cardNoMaxExample = this.cardNoMaxExample(recordVo);
        List recordPos = this.cusMbrFrozenRecordPoMapper.selectByExample(cardNoMaxExample);
        if (((CusMbrFrozenRecordPo)recordPos.get(0)).getStatus().equals(MbrFrozenRecordConstants.STATUS_N)) {
            this.updateMemberStatus(sysAccountPO, (CusMbrFrozenRecordPo)recordPos.get(0));
        }
    }

    private void updateMemberStatus(SysAccountPO sysAccountPO, CusMbrFrozenRecordPo recordPo) {
        ResponseData responseData = new ResponseData();
        try {
            BatchUpdateMemberInfoVo batchUpdateMemberInfoVo = this.fullDate(sysAccountPO, recordPo);
            responseData = this.memberInfoApiService.batchUpdateMemberValid(batchUpdateMemberInfoVo);
        }
        catch (MemberException e) {
            log.error("\u4f1a\u5458\u66f4\u65b0\u72b6\u6001\u5931\u8d25:" + (Object)((Object)e));
        }
        if (SysResponseEnum.SUCCESS.getCode() == responseData.getCode()) {
            log.info("\u64cd\u4f5c\u6210\u529f,\u4f1a\u5458\u72b6\u6001\u5df2\u66f4\u65b0\uff01");
            this.insertRecord(recordPo, sysAccountPO);
        }
    }

    private void insertRecord(CusMbrFrozenRecordPo recordPo, SysAccountPO sysAccountPO) {
        CusMbrFrozenRecordPo cusMbrFrozenRecordPo = new CusMbrFrozenRecordPo();
        BeanUtils.copyProperties((Object)recordPo, (Object)cusMbrFrozenRecordPo);
        cusMbrFrozenRecordPo.setWhiteList(MbrFrozenRecordConstants.WHITELIST_Y);
        cusMbrFrozenRecordPo.setStatus(MbrFrozenThawEnum.THAW.getCode());
        cusMbrFrozenRecordPo.setWhiteOperateDate(new Date());
        cusMbrFrozenRecordPo.setWhiteOperateUserId(sysAccountPO.getSysAccountId());
        cusMbrFrozenRecordPo.setWhiteOperateUserName(sysAccountPO.getName());
        this.nowTime(cusMbrFrozenRecordPo);
        cusMbrFrozenRecordPo.setFrozenRecord(UUIDUtil.getUUID16());
        cusMbrFrozenRecordPo.setFrozenReason("\u52a0\u5165\u767d\u540d\u5355");
        cusMbrFrozenRecordPo.setFrozenDetail(null);
        cusMbrFrozenRecordPo.setModifiedUserId(null);
        cusMbrFrozenRecordPo.setCreateUserId(null);
        cusMbrFrozenRecordPo.setCreateUserId(sysAccountPO.getSysAccountId());
        cusMbrFrozenRecordPo.setCreateUserName(sysAccountPO.getName());
        cusMbrFrozenRecordPo.setFrozenType(Integer.valueOf(0));
        this.insert(cusMbrFrozenRecordPo);
    }

    private void nowTime(CusMbrFrozenRecordPo cusMbrFrozenRecordPo) {
        Date date = new Date();
        cusMbrFrozenRecordPo.setFrozenDate(date);
        cusMbrFrozenRecordPo.setModifiedDate(date);
        cusMbrFrozenRecordPo.setCreateDate(date);
    }

    private ResponseData insert(CusMbrFrozenRecordPo cusMbrFrozenRecordPo) {
        try {
            int id = this.cusMbrFrozenRecordPoMapper.insertSelective(cusMbrFrozenRecordPo);
            if (id == 1) {
                log.info("\u6d41\u6c34\u6dfb\u52a0\u6210\u529f!");
                return new ResponseData((Object)id);
            }
        }
        catch (Exception e) {
            log.info("\u89e3\u51bb\u6d41\u6c34\u6dfb\u52a0\u5931\u8d25:" + e);
        }
        return ResponseUtils.getFailedData((String)"\u89e3\u51bb\u6d41\u6c34\u6dfb\u52a0\u5931\u8d25!");
    }

    private BatchUpdateMemberInfoVo fullDate(SysAccountPO sysAccountPO, CusMbrFrozenRecordPo recordPo) {
        BatchUpdateMemberInfoVo batchUpdateMemberInfoVo = new BatchUpdateMemberInfoVo();
        batchUpdateMemberInfoVo.setModifiedUserId(sysAccountPO.getSysAccountId());
        batchUpdateMemberInfoVo.setModifiedUserName(sysAccountPO.getName());
        batchUpdateMemberInfoVo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        ArrayList<MemberInfoModel> list = new ArrayList<MemberInfoModel>();
        MemberInfoModel model = new MemberInfoModel();
        model.setSysCompanyId(sysAccountPO.getSysCompanyId());
        model.setMemberCode(recordPo.getMemberCode());
        model.setPhone(recordPo.getPhone());
        model.setCardNo(recordPo.getCardNo());
        model.setCardUseStatus(Integer.valueOf(4));
        list.add(model);
        batchUpdateMemberInfoVo.setList(list);
        return batchUpdateMemberInfoVo;
    }

    private List<CusMbrFrozenRecordVo> primaryCollection(List<CusMbrFrozenRecordVo> list) {
        return list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CusMbrFrozenRecordVo>(Comparator.comparing(s -> s.getMemberCode()))), ArrayList::new));
    }

    private CusMbrFrozenRecordPoExample memberCodeExample(CusMbrFrozenRecordVo recordVo) {
        CusMbrFrozenRecordPoExample example = new CusMbrFrozenRecordPoExample();
        example.createCriteria().andSysCompanyIdEqualTo(recordVo.getSysCompanyId()).andValidEqualTo(Boolean.TRUE).andMemberCodeEqualTo(recordVo.getMemberCode());
        return example;
    }

    private CusMbrFrozenRecordPoExample cardNoExample(CusMbrFrozenRecordPo recordPo, Long sysCompanyId) {
        CusMbrFrozenRecordPoExample example = new CusMbrFrozenRecordPoExample();
        example.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andValidEqualTo(Boolean.TRUE).andCardNoEqualTo(recordPo.getCardNo());
        return example;
    }

    private CusMbrFrozenRecordPoExample cardNoMaxExample(CusMbrFrozenRecordVo recordVo) {
        CusMbrFrozenRecordPoExample example = new CusMbrFrozenRecordPoExample();
        example.createCriteria().andSysCompanyIdEqualTo(recordVo.getSysCompanyId()).andValidEqualTo(Boolean.TRUE).andCardNoEqualTo(recordVo.getCardNo());
        example.setOrderByClause("frozen_date DESC");
        return example;
    }

    public ResponseData exportExcel(CusMbrFrozenRecordVo cusMbrFrozenRecordVo) {
        return this.export(cusMbrFrozenRecordVo);
    }

    public ResponseData<Integer> existWhitelist(CusMbrFrozenRecordVo cusMbrFrozenRecordVo) {
        CusMbrFrozenRecordPoExample example = this.memberCodeExample(cusMbrFrozenRecordVo);
        List recordPos = this.cusMbrFrozenRecordPoMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)recordPos)) {
            log.info("\u6839\u636ememberCode\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u6570\u636e!");
            return new ResponseData((Object)MbrFrozenRecordConstants.WHITELIST_N);
        }
        log.info("\u4f1a\u5458\u767d\u540d\u5355\u4fe1\u606f:{}", (Object)JacksonUtil.bean2Json(recordPos.get(0)));
        if (MbrFrozenRecordConstants.WHITELIST_N.equals(((CusMbrFrozenRecordPo)recordPos.get(0)).getWhiteList())) {
            log.info("\u4f1a\u5458\u4e0d\u5728\u767d\u540d\u5355!");
            return new ResponseData((Object)MbrFrozenRecordConstants.WHITELIST_N);
        }
        return new ResponseData((Object)MbrFrozenRecordConstants.WHITELIST_Y);
    }

    public ResponseData<Integer> isFrozen(CusMbrFrozenRecordVo cusMbrFrozenRecordVo) {
        CusMbrFrozenRecordPoExample example = new CusMbrFrozenRecordPoExample();
        example.createCriteria().andSysCompanyIdEqualTo(cusMbrFrozenRecordVo.getSysCompanyId()).andValidEqualTo(Boolean.TRUE).andCardNoEqualTo(cusMbrFrozenRecordVo.getCardNo());
        example.setOrderByClause("frozen_date DESC");
        List recordPos = this.cusMbrFrozenRecordPoMapper.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)recordPos)) {
            log.info("\u6839\u636ememberCode\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u6570\u636e!");
            return ResponseUtils.getFailedData((String)"\u6839\u636ememberCode\u672a\u67e5\u8be2\u5230\u4f1a\u5458\u6570\u636e!");
        }
        log.info("\u4f1a\u5458\u4fe1\u606f:{}", (Object)JacksonUtil.bean2Json(recordPos.get(0)));
        if (MbrFrozenRecordConstants.STATUS_N.equals(((CusMbrFrozenRecordPo)recordPos.get(0)).getStatus())) {
            log.info("\u4f1a\u5458\u5df2\u88ab\u51bb\u7ed3!");
            return new ResponseData((Object)MbrFrozenRecordConstants.STATUS_N);
        }
        return new ResponseData((Object)MbrFrozenRecordConstants.STATUS_Y);
    }

    public ResponseData addRecord(CusMbrFrozenRecordVo cusMbrFrozenRecordVo) {
        log.info("361\u65b0\u589e\u51bb\u7ed3\u6d41\u6c34\u4fe1\u606f : {} ", (Object)JacksonUtil.bean2Json((Object)cusMbrFrozenRecordVo));
        CusMbrFrozenRecordPo recordPo = new CusMbrFrozenRecordPo();
        BeanUtils.copyProperties((Object)cusMbrFrozenRecordVo, (Object)recordPo);
        return this.insert(recordPo);
    }

    public ResponseData export(CusMbrFrozenRecordVo cusMbrFrozenRecordVo) {
        log.info("enter MbrFrozenRecordServiceImpl Export method !");
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        try {
            PageInfo pageInfo = this.getPageInfo(cusMbrFrozenRecordVo);
            long sum = pageInfo.getTotal();
            Long taskId = Integer.parseInt(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
            FileTaskPo fileTaskPo = this.getFileTaskPo(cusMbrFrozenRecordVo, sum, taskId);
            StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(sum));
            this.processExcel(cusMbrFrozenRecordVo, taskId, exportExcelUtil);
            this.QNCloudUpLoad(fileTaskPo, exportExcelUtil);
        }
        catch (Exception e) {
            log.error("enter MbrFrozenRecordServiceImpl Export method error:" + e.getMessage());
            responseData.setMessage("\u5bfc\u51fa\u5f02\u5e38");
            return responseData;
        }
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u6dfb\u52a0\u5bfc\u51fa\u4efb\u52a1\u6210\u529f!");
        return responseData;
    }

    private PageInfo getPageInfo(CusMbrFrozenRecordVo cusMbrFrozenRecordVo) {
        PageVo pageVo = new PageVo();
        pageVo.setPageNum(1);
        pageVo.setPageSize(1);
        pageVo.setPageNumber(1);
        return this.getPageInfo(cusMbrFrozenRecordVo, pageVo);
    }

    private FileTaskPo getFileTaskPo(CusMbrFrozenRecordVo cusMbrFrozenRecordVo, long sum, Long taskId) {
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        fileTaskPo.setFileId(String.valueOf(taskId));
        fileTaskPo.setTaskTypeCode(sum + "\u6761");
        fileTaskPo.setTaskName("\u4f1a\u5458\u81ea\u52a8\u51bb\u7ed3\u8bb0\u5f55");
        fileTaskPo.setSysBrandId(cusMbrFrozenRecordVo.getSysCompanyId());
        fileTaskPo.setSysBrandId(cusMbrFrozenRecordVo.getSysBrandId());
        fileTaskPo.setCreateUserName(cusMbrFrozenRecordVo.getCreateUserName());
        fileTaskPo.setCreateUserId(cusMbrFrozenRecordVo.getCreateUserId());
        fileTaskPo.setFileStatus(Long.valueOf(0L));
        fileTaskPo.setFileType("EXPORT");
        fileTaskPo.setValid(Boolean.valueOf(true));
        this.fileTaskServiceRpc.addFileTask(fileTaskPo);
        return fileTaskPo;
    }

    private void processExcel(CusMbrFrozenRecordVo cusMbrFrozenRecordVo, Long taskId, StreamingExportExcelUtil<CusMbrFrozenRecordVo> exportExcelUtil) {
        new Thread(() -> {
            try {
                exportExcelUtil.setExportProcessId((Object)taskId);
                Method method = this.cusMbrFrozenRecordPoMapper.getClass().getMethod("findAllExcel", CusMbrFrozenRecordVo.class, Long.class, Long.class);
                exportExcelUtil.read("cusMbrFrozenRecordPoMapper", method, (model, row) -> {
                    if (row.getRowNum() == 0) {
                        this.setCell(row);
                    } else {
                        this.setCellValue(model, row);
                    }
                }, new Object[]{cusMbrFrozenRecordVo});
            }
            catch (Exception e) {
                log.error("\u5bfc\u51fa\u5f02\u5e38 " + e);
            }
        }).start();
    }

    private void QNCloudUpLoad(FileTaskPo fileTaskPo, StreamingExportExcelUtil<CusMbrFrozenRecordVo> exportExcelUtil) {
        new Thread(() -> ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"\u4f1a\u5458\u81ea\u52a8\u51bb\u7ed3\u8bb0\u5f55_")).start();
    }

    private void setCell(Row row) {
        Cell cell0 = row.createCell(0);
        cell0.setCellValue("\u4f1a\u5458\u59d3\u540d");
        Cell cell1 = row.createCell(1);
        cell1.setCellValue("\u4f1a\u5458\u5361\u53f7");
        Cell cell2 = row.createCell(2);
        cell2.setCellValue("\u4f1a\u5458\u624b\u673a\u53f7");
        Cell cell3 = row.createCell(3);
        cell3.setCellValue("\u670d\u52a1\u5e97\u94fa\u540d\u79f0");
        Cell cell4 = row.createCell(4);
        cell4.setCellValue("\u5361\u540d\u79f0");
        Cell cell5 = row.createCell(5);
        cell5.setCellValue("\u51bb\u7ed3\u72b6\u6001");
        Cell cell6 = row.createCell(6);
        cell6.setCellValue("\u51bb\u7ed3\u6d41\u6c34\u53f7");
        Cell cell7 = row.createCell(7);
        cell7.setCellValue("\u51bb\u7ed3\u7c7b\u578b");
        Cell cell8 = row.createCell(8);
        cell8.setCellValue("\u51bb\u7ed3\u8be6\u60c5");
        Cell cell9 = row.createCell(9);
        cell9.setCellValue("\u51bb\u7ed3\u65f6\u95f4");
        Cell cell10 = row.createCell(10);
        cell10.setCellValue("\u662f\u5426\u767d\u540d\u5355");
        Cell cell11 = row.createCell(11);
        cell11.setCellValue("\u89e3\u51bb\u539f\u56e0");
        Cell cell12 = row.createCell(12);
        cell12.setCellValue("\u51bb\u7ed3/\u89e3\u51bb\u64cd\u4f5c\u4eba");
    }

    private void setCellValue(CusMbrFrozenRecordVo model, Row row) {
        this.validNull(model);
        Cell cell0 = row.createCell(0);
        cell0.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getName(), (Object)""));
        Cell cell1 = row.createCell(1);
        cell1.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getCardNo(), (Object)""));
        Cell cell2 = row.createCell(2);
        cell2.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getPhone(), (Object)""));
        Cell cell3 = row.createCell(3);
        cell3.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getServiceStoreName(), (Object)""));
        Cell cell4 = row.createCell(4);
        cell4.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getLevelName(), (Object)""));
        Cell cell5 = row.createCell(5);
        cell5.setCellValue(model.getStatus() == null ? String.valueOf("") : String.valueOf(model.getStatusName()));
        Cell cell6 = row.createCell(6);
        cell6.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getFrozenRecord(), (Object)""));
        Cell cell7 = row.createCell(7);
        cell7.setCellValue(model.getFrozenType() == null ? String.valueOf("") : String.valueOf(model.getFrozenTypeName()));
        Cell cell8 = row.createCell(8);
        cell8.setCellValue((String)ObjectUtils.defaultIfNull((Object)model.getFrozenDetail(), (Object)""));
        Cell cell9 = row.createCell(9);
        cell9.setCellValue(model.getFrozenDate() != null ? DateUtil.format((Date)model.getFrozenDate(), (String)"yyyy-MM-dd HH:mm:ss") : "");
        Cell cell10 = row.createCell(10);
        cell10.setCellValue(model.getWhiteList() == null ? String.valueOf("") : String.valueOf(model.getWhiteListName()));
        Cell cell11 = row.createCell(11);
        cell11.setCellValue(model.getFrozenReason() == null ? String.valueOf("") : String.valueOf(model.getFrozenReason()));
        Cell cell12 = row.createCell(12);
        cell12.setCellValue(model.getCreateUserName());
    }

    private void validNull(CusMbrFrozenRecordVo recordVo) {
        if (recordVo.getFrozenType() != null) {
            MbrFrozenEnum mbrFrozenEnum = MbrFrozenEnum.getMsg((Integer)recordVo.getFrozenType());
            recordVo.setFrozenTypeName(mbrFrozenEnum != null ? mbrFrozenEnum.getMsg() : "");
        }
        if (recordVo.getStatus() != null) {
            MbrFrozenThawEnum mbrFrozenThawEnum = MbrFrozenThawEnum.getMsg((Integer)recordVo.getStatus());
            recordVo.setStatusName(mbrFrozenThawEnum != null ? mbrFrozenThawEnum.getMsg() : "");
        }
        if (recordVo.getWhiteList() != null) {
            recordVo.setWhiteListName(recordVo.getWhiteList().equals(MbrFrozenRecordConstants.WHITELIST_N) ? "\u5426" : "\u662f");
        }
    }

    public Integer syncFrozenMembers(String cardNo) {
        log.info("MbrFrozenRecordService syncFrozenMembers \u5f00\u59cb\u3002paramCardNo={}", (Object)cardNo);
        Integer execCount = 0;
        String paramCardNo = "";
        String remark = "361\u51bb\u7ed3\u5168\u91cf\u540c\u6b65\uff1a" + new Date().toString();
        List cusMbrFrozenRecordVoList = new ArrayList();
        if (!StringUtil.isEmpty((String)cardNo)) {
            paramCardNo = cardNo;
        }
        log.info("MbrFrozenRecordService syncFrozenMembers getSyncFrozenMembers\u3002");
        cusMbrFrozenRecordVoList = this.cusMbrFrozenRecordPoMapper.getSyncFrozenMembers(paramCardNo);
        if (cusMbrFrozenRecordVoList != null && cusMbrFrozenRecordVoList.size() > 0) {
            for (CusMbrFrozenRecordVo po : cusMbrFrozenRecordVoList) {
                if (po.getCardUseStatus() != CrmCardUseStatusEnum.FROZEN.getCode()) {
                    log.info("MbrFrozenRecordService syncFrozenMembers updateCRMCardUseStatus\u3002CardNo={}", (Object)po.getCardNo());
                    this.cusMbrFrozenRecordPoMapper.udateMemberCardUseStatus(po.getCardNo());
                }
                AddVipRequestVO requestVO = new AddVipRequestVO();
                requestVO.setBrandId(po.getSysBrandId());
                requestVO.setSource(this.crmSource);
                requestVO.setTel(po.getPhone());
                requestVO.setVip_code(po.getCardNo());
                requestVO.setRemark(remark);
                requestVO.setStatus(CrmCardUseStatusEnum.FROZEN.getCode().toString());
                log.info("MbrFrozenRecordService syncFrozenMembers sync361ICRM\u3002RequestVO={}", (Object)JacksonUtil.bean2Json((Object)requestVO));
                Result result = this.icrmConnectorServiceFeign.addVip(requestVO);
                log.info("MbrFrozenRecordService syncFrozenMembers sync361ICRM\u3002result={}", (Object)JacksonUtil.bean2Json((Object)result));
            }
            execCount = cusMbrFrozenRecordVoList.size();
        }
        log.info("MbrFrozenRecordService syncFrozenMembers \u7ed3\u675f\u3002execCount={}", (Object)execCount);
        return execCount;
    }

    public Integer syncFrozenMembersLogs(Date startDate, Date endDate) {
        log.info("MbrFrozenRecordService syncFrozenMembersLogs \u5f00\u59cb\u3002startDate:{},endDate:{}", (Object)startDate, (Object)endDate);
        Integer execCount = 0;
        List cusSyncMemberFreeVoList = new ArrayList();
        log.info("MbrFrozenRecordService syncFrozenMembersLogs getSyncFrozenMembers\u3002");
        cusSyncMemberFreeVoList = this.cusMbrFrozenRecordPoMapper.getSyncFrozenMembersLogs(startDate, endDate);
        String token = this.getSyncFrozenMembersLogsToken();
        log.info("MbrFrozenRecordService syncFrozenMembersLogs request, token={}", (Object)token);
        ArrayList<CusSyncMemberFreeVo> cusSyncMemberFreeVoListClear = new ArrayList<CusSyncMemberFreeVo>();
        if (cusSyncMemberFreeVoList != null && cusSyncMemberFreeVoList.size() > 0) {
            for (int i = 0; i < cusSyncMemberFreeVoList.size(); ++i) {
                Integer intPrev = i - 1;
                CusSyncMemberFreeVo vo = (CusSyncMemberFreeVo)cusSyncMemberFreeVoList.get(i);
                CusSyncMemberFreeVo prevVo = null;
                if (i > 0) {
                    prevVo = (CusSyncMemberFreeVo)cusSyncMemberFreeVoList.get(intPrev);
                }
                if (this.clarCusSyncMemberFreeVo(vo, prevVo).booleanValue()) {
                    cusSyncMemberFreeVoListClear.add(vo);
                }
                if (cusSyncMemberFreeVoListClear.size() != this.syncFrozenMembersLogsDataSize.intValue() && i != cusSyncMemberFreeVoList.size() - 1) continue;
                String jsonStr = JacksonUtil.bean2Json(cusSyncMemberFreeVoListClear);
                log.info("MbrFrozenRecordService syncFrozenMembersLogs request, jsonStr={}", (Object)JacksonUtil.bean2Json(cusSyncMemberFreeVoListClear));
                HashMap<String, String> headerParams = new HashMap<String, String>();
                headerParams.put("Token", token);
                String response = AsyncHttpUtil.doPost((String)this.syncFrozenMembersLogsBusinessUrl, (String)jsonStr, null, headerParams);
                log.info("MbrFrozenRecordService syncFrozenMembersLogs \u7ed3\u675f\u3002execCount={}; response={}", (Object)cusSyncMemberFreeVoListClear.size(), (Object)response);
                execCount = execCount + cusSyncMemberFreeVoListClear.size();
                cusSyncMemberFreeVoListClear.clear();
            }
        }
        return execCount;
    }

    private Boolean clarCusSyncMemberFreeVo(CusSyncMemberFreeVo vo, CusSyncMemberFreeVo prevVo) {
        if (prevVo == null) {
            return true;
        }
        if (vo.getVpCode() != prevVo.getVpCode()) {
            return true;
        }
        if (vo.getStatus() != prevVo.getStatus()) {
            return true;
        }
        if (vo.getTsp() - prevVo.getTsp() > 5) {
            return true;
        }
        if (vo.getHt() == 0 && vo.getTsp() - prevVo.getTsp() > 180) {
            return true;
        }
        return false;
    }

    private String getSyncFrozenMembersLogsToken() {
        HashMap<String, String> postObject = new HashMap<String, String>();
        postObject.put("Uname", this.syncFrozenMembersLogsUnName);
        postObject.put("Passwrd", this.syncFrozenMembersLogsPasswrd);
        String response = AsyncHttpUtil.doPost((String)this.syncFrozenMembersLogsLoginUrl, (String)JacksonUtil.bean2Json(postObject));
        JSONObject tokenJson = JSONObject.parseObject((String)response);
        String token = tokenJson.getJSONArray("data").getJSONObject(0).get((Object)"token").toString();
        return token;
    }
}

