/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.bizvane.customized.company.store361.service.MbrFrozenDefService;
import com.bizvane.customized.facade.models.po.CusMbrFrozenDefPo;
import com.bizvane.customized.facade.models.po.CusMbrFrozenDefPoExample;
import com.bizvane.customized.facade.models.vo.CusMbrFrozenDefVo;
import com.bizvane.customized.mappers.CusMbrFrozenDefPoMapper;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MbrFrozenDefServiceImpl
implements MbrFrozenDefService {
    private static final Logger log = LoggerFactory.getLogger(MbrFrozenDefServiceImpl.class);
    @Autowired
    CusMbrFrozenDefPoMapper cusMbrFrozenDefPoMapper;

    public ResponseData<CusMbrFrozenDefVo> queryDefRule(SysAccountPO sysAccountPO) {
        List cusMbrFrozenDefPos = this.getCusMbrFrozenDefPos(sysAccountPO);
        if (CollectionUtils.isNotEmpty((Collection)cusMbrFrozenDefPos)) {
            return new ResponseData(cusMbrFrozenDefPos.get(0));
        }
        return new ResponseData();
    }

    private List<CusMbrFrozenDefPo> getCusMbrFrozenDefPos(SysAccountPO sysAccountPO) {
        CusMbrFrozenDefPoExample example = new CusMbrFrozenDefPoExample();
        example.createCriteria().andSysCompanyIdEqualTo(sysAccountPO.getSysCompanyId());
        example.setOrderByClause("modified_date desc");
        return this.cusMbrFrozenDefPoMapper.selectByExample(example);
    }

    public ResponseData saveDefRule(CusMbrFrozenDefPo defPo) {
        ResponseData responseData = new ResponseData();
        int status = 0;
        try {
            status = this.mergeDate(defPo);
        }
        catch (Exception e) {
            log.error("saveDefRule fail :" + e);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
        }
        if (status >= 0) {
            log.info("saveDefRule success");
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        }
        return responseData;
    }

    private int mergeDate(CusMbrFrozenDefPo defPo) throws BizException {
        Date nowTime = new Date();
        defPo.setModifiedDate(nowTime);
        if (CollectionUtils.isEmpty((Collection)this.getCusMbrFrozenDefPo(defPo))) {
            defPo.setCreateDate(nowTime);
            return this.cusMbrFrozenDefPoMapper.insertSelective(defPo);
        }
        CusMbrFrozenDefPoExample example = this.getCusMbrFrozenDefPoExample(defPo);
        return this.cusMbrFrozenDefPoMapper.updateByExample(defPo, example);
    }

    private List<CusMbrFrozenDefPo> getCusMbrFrozenDefPo(CusMbrFrozenDefPo cusMbrFrozenDefPo) {
        CusMbrFrozenDefPoExample example = this.getCusMbrFrozenDefPoExample(cusMbrFrozenDefPo);
        return this.cusMbrFrozenDefPoMapper.selectByExample(example);
    }

    private CusMbrFrozenDefPoExample getCusMbrFrozenDefPoExample(CusMbrFrozenDefPo defPo) {
        CusMbrFrozenDefPoExample example = new CusMbrFrozenDefPoExample();
        example.createCriteria().andSysCompanyIdEqualTo(defPo.getSysCompanyId());
        return example;
    }
}

