/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.bizvane.customized.company.store361.service.Cus361StoreGroupService;
import com.bizvane.customized.facade.models.bo.Cus361ChannelDataBo;
import com.bizvane.customized.facade.models.bo.Cus361DistributorDataBo;
import com.bizvane.customized.facade.models.bo.Cus361PrecinctAreaBo;
import com.bizvane.customized.facade.models.bo.Cus361SapAndCorpBo;
import com.bizvane.customized.facade.models.po.Cus361ChannelDataPO;
import com.bizvane.customized.facade.models.po.Cus361ChannelDataPOExample;
import com.bizvane.customized.facade.models.po.Cus361DistributorDataPo;
import com.bizvane.customized.facade.models.po.Cus361DistributorDataPoExample;
import com.bizvane.customized.facade.models.po.Cus361PrecinctAreaPO;
import com.bizvane.customized.facade.models.po.Cus361PrecinctAreaPOExample;
import com.bizvane.customized.mappers.Cus361ChannelDataPOMapper;
import com.bizvane.customized.mappers.Cus361DistributorDataPoMapper;
import com.bizvane.customized.mappers.Cus361PrecinctAreaPOMapper;
import com.bizvane.customized.mappers.Cus361StoreFieldsPOMapper;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Cus361StoreGroupServiceImpl
implements Cus361StoreGroupService {
    private static final Logger log = LoggerFactory.getLogger(Cus361StoreGroupServiceImpl.class);
    @Autowired
    Cus361PrecinctAreaPOMapper cus361PrecinctAreaPOMapper;
    @Autowired
    Cus361ChannelDataPOMapper cus361ChannelDataPOMapper;
    @Autowired
    Cus361DistributorDataPoMapper cus361DistributorDataPoMapper;
    @Autowired
    Cus361StoreFieldsPOMapper cus361StoreFieldsPOMapper;

    public ResponseData<Cus361PrecinctAreaBo> getInfoByAreaCondition(Cus361PrecinctAreaBo areaBbo) {
        ResponseData responseData = this.getFailData();
        PageHelper.startPage((int)areaBbo.getPageNumber(), (int)areaBbo.getPageSize());
        List areaList = this.cus361PrecinctAreaPOMapper.getAreaInfo(areaBbo);
        PageInfo areaPageInfo = new PageInfo(areaList);
        this.setSuccessData(responseData);
        responseData.setData((Object)areaPageInfo);
        return responseData;
    }

    public ResponseData<Cus361ChannelDataBo> getInfoBySapCondition(Cus361ChannelDataBo sapBo) {
        ResponseData responseData = this.getFailData();
        PageHelper.startPage((int)sapBo.getPageNumber(), (int)sapBo.getPageSize());
        List sapList = this.cus361ChannelDataPOMapper.getSapInfo(sapBo);
        PageInfo sapPageInfo = new PageInfo(sapList);
        this.setSuccessData(responseData);
        responseData.setData((Object)sapPageInfo);
        return responseData;
    }

    public ResponseData<Cus361DistributorDataBo> getInfoByCorpCondition(Cus361DistributorDataBo corpBo) {
        ResponseData responseData = this.getFailData();
        PageHelper.startPage((int)corpBo.getPageNumber(), (int)corpBo.getPageSize());
        List corpList = this.cus361DistributorDataPoMapper.getCorpInfo(corpBo);
        PageInfo corpPageInfo = new PageInfo(corpList);
        this.setSuccessData(responseData);
        responseData.setData((Object)corpPageInfo);
        return responseData;
    }

    public ResponseData<Cus361SapAndCorpBo> get361CodeByStoreCode(String storeCode, String originStoreCode) {
        log.info("Cus361CodeServiceImpl get361CodeByStoreOnlineCode param : {},originStoreCode:{}", (Object)storeCode, (Object)originStoreCode);
        ResponseData responseData = this.getFailData();
        if (StringUtils.isBlank((CharSequence)storeCode) && StringUtils.isBlank((CharSequence)originStoreCode)) {
            responseData.setMessage("\u5e97\u94faCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return responseData;
        }
        List codeList = this.cus361StoreFieldsPOMapper.get361CodeByStoreCode(storeCode, originStoreCode);
        if (CollectionUtils.isEmpty((Collection)codeList)) {
            responseData.setData(null);
            return responseData;
        }
        Cus361SapAndCorpBo cus361SapAndCorpBo = (Cus361SapAndCorpBo)codeList.get(0);
        String corpCode = cus361SapAndCorpBo.getCorpCode();
        String sapCustomerCode = cus361SapAndCorpBo.getSapCustomerCode();
        if (StringUtil.isNotBlank((String)corpCode)) {
            cus361SapAndCorpBo.setCorpName(this.cus361DistributorDataPoMapper.getCorpName(corpCode));
        }
        if (StringUtil.isNotBlank((String)sapCustomerCode)) {
            Cus361ChannelDataPO cus361ChannelDataPO = new Cus361ChannelDataPO();
            cus361ChannelDataPO.setCorpCode(corpCode);
            cus361ChannelDataPO.setSapCustomerCode(sapCustomerCode);
            Cus361ChannelDataPO channelDataPo = this.cus361ChannelDataPOMapper.queryCus361ChannelData(cus361ChannelDataPO);
            cus361SapAndCorpBo.setChannelName(channelDataPo != null ? channelDataPo.getChannelName() : null);
        }
        responseData.setData((Object)cus361SapAndCorpBo);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        return responseData;
    }

    private ResponseData getFailData() {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        return responseData;
    }

    private void setSuccessData(ResponseData responseData) {
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
    }

    public ResponseData<Cus361PrecinctAreaPO> getPrecinctArea(String areaCode) {
        ResponseData responseData = new ResponseData();
        Cus361PrecinctAreaPOExample poExample = new Cus361PrecinctAreaPOExample();
        poExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andAreaCodeEqualTo(areaCode);
        List cus361PrecinctAreaPO = this.cus361PrecinctAreaPOMapper.selectByExample(poExample);
        if (CollectionUtils.isNotEmpty((Collection)cus361PrecinctAreaPO)) {
            responseData.setData(cus361PrecinctAreaPO.get(0));
        }
        return responseData;
    }

    public ResponseData<Cus361ChannelDataPO> getSapCode(String sapCode) {
        ResponseData responseData = new ResponseData();
        Cus361ChannelDataPOExample poExample = new Cus361ChannelDataPOExample();
        poExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andSapCustomerCodeEqualTo(sapCode);
        List cus361ChannelDataPO = this.cus361ChannelDataPOMapper.selectByExample(poExample);
        if (CollectionUtils.isNotEmpty((Collection)cus361ChannelDataPO)) {
            responseData.setData(cus361ChannelDataPO.get(0));
        }
        return responseData;
    }

    public ResponseData<Cus361DistributorDataPo> getCorpCode(String corpCode) {
        ResponseData responseData = new ResponseData();
        Cus361DistributorDataPoExample poExample = new Cus361DistributorDataPoExample();
        poExample.createCriteria().andValidEqualTo(Boolean.valueOf(true)).andCorpCodeEqualTo(corpCode);
        List cus361DistributorDataPo = this.cus361DistributorDataPoMapper.selectByExample(poExample);
        if (CollectionUtils.isNotEmpty((Collection)cus361DistributorDataPo)) {
            responseData.setData(cus361DistributorDataPo.get(0));
        }
        return responseData;
    }
}

