/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.connectorservice.entity.icrm.DistributorRequestVO;
import com.bizvane.connectorservice.entity.icrm.DistributorResponseVO;
import com.bizvane.connectorservice.entity.icrm.StoreResponseVO;
import com.bizvane.connectorservice.interfaces.rpc.IcrmConnectorServiceFeign;
import com.bizvane.customized.common.utils.Assert;
import com.bizvane.customized.common.utils.BeanUtils;
import com.bizvane.customized.common.utils.ExportExcelUtil;
import com.bizvane.customized.common.utils.StreamingExportExcelUtil;
import com.bizvane.customized.company.store361.service.Cus361StoreCodeMappingService;
import com.bizvane.customized.facade.models.po.Cus361StoreCodeMappingPO;
import com.bizvane.customized.facade.models.po.Cus361StoreCodeMappingPOExample;
import com.bizvane.customized.facade.models.vo.Cus361StoreCodeMappingVO;
import com.bizvane.customized.mappers.Cus361StoreCodeMappingPOMapper;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class Cus361StoreCodeMappingServiceImpl
implements Cus361StoreCodeMappingService {
    private static final Logger log = LoggerFactory.getLogger(Cus361StoreCodeMappingServiceImpl.class);
    @Autowired
    private IcrmConnectorServiceFeign icrmConnectorServiceFeign;
    @Autowired
    private Cus361StoreCodeMappingPOMapper storeCodeMappingPOMapper;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Value(value="${361staff.brandId}")
    private Long brandId;
    public static final String CODE_PARAM = "distributor_code,zipcode,store_code";

    public void getStoreCodeMappingByIcrm() {
        log.info("Cus361StoreCodeMappingServiceImpl getStoreCodeMappingByIcrm start ");
        DistributorRequestVO vo = new DistributorRequestVO();
        vo.setFields("distributor_code,zipcode,store_code");
        vo.setBrandId(this.brandId);
        String nowDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String dateBefore = Cus361StoreCodeMappingServiceImpl.getPastDate();
        vo.setLastchanged_time_start(dateBefore);
        vo.setLastchanged_time_end(nowDate);
        try {
            log.info("\u8c03Icrm\u63a5\u53e3\u66f4\u65b0\u6620\u5c04\u8868\u4e2dIcrmCode");
            Result result = this.icrmConnectorServiceFeign.getDistributorList(vo);
            if (this.isResultFailed(result)) {
                return;
            }
            StoreResponseVO storeResponseVO = (StoreResponseVO)result.getData();
            Integer count = storeResponseVO.getCount();
            for (int i = 1; i <= count / 100 + 1; ++i) {
                vo = new DistributorRequestVO();
                vo.setFields("distributor_code,zipcode,store_code");
                vo.setNum("100");
                vo.setPageNum(String.valueOf(i));
                vo.setBrandId(this.brandId);
                vo.setLastchanged_time_start(dateBefore);
                vo.setLastchanged_time_end(nowDate);
                Result newResult = this.icrmConnectorServiceFeign.getDistributorList(vo);
                if (this.isResultFailed(newResult)) {
                    return;
                }
                storeResponseVO = (StoreResponseVO)newResult.getData();
                List codeList = storeResponseVO.getDistributorResponseVOList();
                if (codeList.size() == 0) {
                    log.info("Cus361GetAllIcrmCodeServiceImpl getIcrmCode method \u67e5\u4e0d\u5230\u6570\u636e");
                    return;
                }
                for (DistributorResponseVO responseVO : codeList) {
                    String icrmCode = responseVO.getDistributor_code();
                    String zipCode = responseVO.getZipcode();
                    String originStoreCode = responseVO.getStore_code();
                    log.info("Cus361GetAllIcrmCodeServiceImpl getIcrmCode param:{},{},{}", new Object[]{icrmCode, zipCode, originStoreCode});
                    int queryCount = this.storeCodeMappingPOMapper.queryCodeMapping(zipCode, originStoreCode);
                    Cus361StoreCodeMappingPO codeMappingPO = new Cus361StoreCodeMappingPO();
                    if (queryCount == 0) {
                        codeMappingPO.setIcrmCode(icrmCode);
                        codeMappingPO.setZipCode(zipCode);
                        codeMappingPO.setOriginStoreCode(originStoreCode);
                        codeMappingPO.setValid(Boolean.valueOf(true));
                        this.storeCodeMappingPOMapper.insertSelective(codeMappingPO);
                        continue;
                    }
                    int x = this.storeCodeMappingPOMapper.updateIcrmCode(zipCode, originStoreCode, icrmCode);
                    if (x == 0) {
                        log.info("getStoreCodeMappingByIcrm \u66f4\u65b0\u5931\u8d25 param\uff1a{},icrmCode:{},zipCode:{},originStoreCode:{}", new Object[]{new Date(), icrmCode, zipCode, originStoreCode});
                        continue;
                    }
                    log.info("\u66f4\u65b0\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ResponseData save(Cus361StoreCodeMappingPO cus361StoreCodeMappingPO, SysAccountPO stageUser) {
        Assert.isTrue((stageUser != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u7528");
        String sapcode = cus361StoreCodeMappingPO.getSapCode();
        Cus361StoreCodeMappingPOExample cus361StoreCodeMappingPOExample1 = new Cus361StoreCodeMappingPOExample();
        cus361StoreCodeMappingPOExample1.createCriteria().andSysCompanyIdEqualTo(stageUser.getSysCompanyId()).andSapCodeEqualTo(sapcode).andValidEqualTo(Boolean.TRUE);
        long count1 = this.storeCodeMappingPOMapper.countByExample(cus361StoreCodeMappingPOExample1);
        Assert.isTrue((count1 == 0L ? 1 : 0) != 0, (String)"\u4e2d\u53f0\u7f16\u7801\u5df2\u5b58\u5728");
        cus361StoreCodeMappingPO.setSysCompanyId(stageUser.getSysCompanyId());
        cus361StoreCodeMappingPO.setSysBrandId(stageUser.getBrandId());
        cus361StoreCodeMappingPO.setCreateUserId(stageUser.getSysAccountId());
        cus361StoreCodeMappingPO.setCreateUserName(stageUser.getName());
        cus361StoreCodeMappingPO.setCreateDate(new Date());
        cus361StoreCodeMappingPO.setValid(Boolean.TRUE);
        log.info("361\u5b9a\u5236-\u95e8\u5e97\u7f16\u7801\u6620\u5c04\u4fdd\u5b58\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)cus361StoreCodeMappingPO));
        this.storeCodeMappingPOMapper.insert(cus361StoreCodeMappingPO);
        return new ResponseData();
    }

    public ResponseData update(Cus361StoreCodeMappingPO cus361StoreCodeMappingPO, SysAccountPO stageUser) {
        Assert.isTrue((cus361StoreCodeMappingPO.getSysStoreCodeMappingId() != null ? 1 : 0) != 0, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        String sapcode = cus361StoreCodeMappingPO.getSapCode();
        Cus361StoreCodeMappingPO cus361StoreCodeMappingPO1 = this.storeCodeMappingPOMapper.selectByPrimaryKey(cus361StoreCodeMappingPO.getSysStoreCodeMappingId());
        if (cus361StoreCodeMappingPO1.getSapCode().equals(sapcode)) {
            cus361StoreCodeMappingPO.setModifiedDate(new Date());
            cus361StoreCodeMappingPO.setModifiedUserId(stageUser.getSysAccountId());
            cus361StoreCodeMappingPO.setModifiedUserName(stageUser.getName());
            cus361StoreCodeMappingPO.setValid(Boolean.TRUE);
            log.info("361\u5b9a\u5236-\u95e8\u5e97\u7f16\u7801\u6620\u5c04\u4fee\u6539\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)cus361StoreCodeMappingPO));
            this.storeCodeMappingPOMapper.updateByPrimaryKeySelective(cus361StoreCodeMappingPO);
            return new ResponseData();
        }
        Cus361StoreCodeMappingPOExample cus361StoreCodeMappingPOExample1 = new Cus361StoreCodeMappingPOExample();
        cus361StoreCodeMappingPOExample1.createCriteria().andSysCompanyIdEqualTo(stageUser.getSysCompanyId()).andSapCodeEqualTo(sapcode).andValidEqualTo(Boolean.TRUE);
        long count1 = this.storeCodeMappingPOMapper.countByExample(cus361StoreCodeMappingPOExample1);
        Assert.isTrue((count1 == 0L ? 1 : 0) != 0, (String)"\u4e2d\u53f0\u7f16\u7801\u5df2\u5b58\u5728");
        cus361StoreCodeMappingPO.setModifiedDate(new Date());
        cus361StoreCodeMappingPO.setModifiedUserId(stageUser.getSysAccountId());
        cus361StoreCodeMappingPO.setModifiedUserName(stageUser.getName());
        cus361StoreCodeMappingPO.setValid(Boolean.TRUE);
        log.info("361\u5b9a\u5236-\u95e8\u5e97\u7f16\u7801\u6620\u5c04\u4fee\u6539\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)cus361StoreCodeMappingPO));
        this.storeCodeMappingPOMapper.updateByPrimaryKeySelective(cus361StoreCodeMappingPO);
        return new ResponseData();
    }

    public ResponseData<PageInfo<Cus361StoreCodeMappingVO>> pageByVo(Cus361StoreCodeMappingVO cus361StoreCodeMappingVO, SysAccountPO stageUser) {
        Assert.isTrue((stageUser != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u7528");
        Cus361StoreCodeMappingPOExample cus361StoreCodeMappingPOExample = new Cus361StoreCodeMappingPOExample();
        Cus361StoreCodeMappingPOExample.Criteria criteria = cus361StoreCodeMappingPOExample.createCriteria().andSysCompanyIdEqualTo(stageUser.getSysCompanyId()).andValidEqualTo(Boolean.TRUE);
        cus361StoreCodeMappingPOExample.setOrderByClause("create_date desc");
        if (StringUtils.isNotBlank((CharSequence)cus361StoreCodeMappingVO.getOriginStoreCode())) {
            criteria.andOriginStoreCodeLike(cus361StoreCodeMappingVO.getOriginStoreCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)cus361StoreCodeMappingVO.getIcrmCode())) {
            criteria.andIcrmCodeEqualTo(cus361StoreCodeMappingVO.getIcrmCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)cus361StoreCodeMappingVO.getSapCode())) {
            criteria.andSapCodeEqualTo(cus361StoreCodeMappingVO.getSapCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)cus361StoreCodeMappingVO.getZipCode())) {
            criteria.andZipCodeEqualTo(cus361StoreCodeMappingVO.getZipCode());
        }
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)cus361StoreCodeMappingPOExample));
        Page page = PageHelper.startPage((int)cus361StoreCodeMappingVO.getPageNumber(), (int)cus361StoreCodeMappingVO.getPageSize()).doSelectPage(() -> this.storeCodeMappingPOMapper.selectByExample(cus361StoreCodeMappingPOExample));
        List cus361StoreCodeMappingPOS = page.getResult();
        if (CollectionUtils.isEmpty((Collection)cus361StoreCodeMappingPOS)) {
            return new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), (Object)new PageInfo());
        }
        PageInfo pageInfo = new PageInfo((List)page);
        List cus361StoreCodeMappingVOS = (List)BeanUtils.copyProperties((Object)cus361StoreCodeMappingPOS, new ArrayList());
        pageInfo.setList(cus361StoreCodeMappingVOS);
        return new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), (Object)pageInfo);
    }

    public ResponseData deleteById(Long sysStoreCodeMappingId, SysAccountPO stageUser) {
        Assert.isTrue((stageUser != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u7528");
        Cus361StoreCodeMappingPO cus361StoreCodeMappingPO = new Cus361StoreCodeMappingPO();
        cus361StoreCodeMappingPO.setValid(Boolean.FALSE);
        cus361StoreCodeMappingPO.setModifiedDate(new Date());
        cus361StoreCodeMappingPO.setModifiedUserId(stageUser.getSysAccountId());
        cus361StoreCodeMappingPO.setModifiedUserName(stageUser.getName());
        Cus361StoreCodeMappingPOExample cus361StoreCodeMappingPOExample = new Cus361StoreCodeMappingPOExample();
        cus361StoreCodeMappingPOExample.createCriteria().andSysStoreCodeMappingIdEqualTo(sysStoreCodeMappingId).andSysCompanyIdEqualTo(stageUser.getSysCompanyId());
        log.info("361\u5b9a\u5236-\u95e8\u5e97\u7f16\u7801\u6620\u5c04\u5220\u9664\u6570\u636eid:{}", (Object)sysStoreCodeMappingId);
        this.storeCodeMappingPOMapper.updateByExampleSelective(cus361StoreCodeMappingPO, cus361StoreCodeMappingPOExample);
        return new ResponseData();
    }

    public ResponseData exportExcel(Cus361StoreCodeMappingVO cus361StoreCodeMappingVO, SysAccountPO stageUser) {
        Assert.isTrue((stageUser != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u7528");
        Cus361StoreCodeMappingPOExample cus361StoreCodeMappingPOExample = new Cus361StoreCodeMappingPOExample();
        Cus361StoreCodeMappingPOExample.Criteria criteria = cus361StoreCodeMappingPOExample.createCriteria().andSysCompanyIdEqualTo(stageUser.getSysCompanyId()).andValidEqualTo(Boolean.TRUE);
        if (StringUtils.isNotEmpty((CharSequence)cus361StoreCodeMappingVO.getSysStoreCodeMappingIds())) {
            List sysStoreCodeMappingIdList = Arrays.stream(cus361StoreCodeMappingVO.getSysStoreCodeMappingIds().split(",")).map(Long::parseLong).collect(Collectors.toList());
            cus361StoreCodeMappingVO.setSysStoreCodeMappingIdList(sysStoreCodeMappingIdList);
            criteria.andSysStoreCodeMappingIdIn(sysStoreCodeMappingIdList);
        }
        if (StringUtils.isNotBlank((CharSequence)cus361StoreCodeMappingVO.getOriginStoreCode())) {
            criteria.andOriginStoreCodeLike(cus361StoreCodeMappingVO.getOriginStoreCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)cus361StoreCodeMappingVO.getIcrmCode())) {
            criteria.andIcrmCodeEqualTo(cus361StoreCodeMappingVO.getIcrmCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)cus361StoreCodeMappingVO.getSapCode())) {
            criteria.andSapCodeEqualTo(cus361StoreCodeMappingVO.getSapCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)cus361StoreCodeMappingVO.getZipCode())) {
            criteria.andZipCodeEqualTo(cus361StoreCodeMappingVO.getZipCode());
        }
        log.info("\u5bfc\u51fa\u95e8\u5e97\u5bf9\u7167\u8868,\u67e5\u8be2\u6761\u4ef6:{}", (Object)JSONObject.toJSONString((Object)cus361StoreCodeMappingPOExample));
        long count = this.storeCodeMappingPOMapper.countByExample(cus361StoreCodeMappingPOExample);
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"\u5185\u5bb9\u4e3a\u7a7a,\u65e0\u9700\u5bfc\u51fa");
        cus361StoreCodeMappingVO.setSysCompanyId(stageUser.getSysCompanyId());
        cus361StoreCodeMappingVO.setValid(Boolean.TRUE);
        Long taskId = Long.valueOf(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        fileTaskPo.setFileId(taskId.toString());
        fileTaskPo.setTaskTypeCode(count + "\u6761");
        fileTaskPo.setTaskName("\u5bfc\u51fa\u95e8\u5e97\u5bf9\u7167\u8868");
        fileTaskPo.setSysBrandId(stageUser.getBrandId());
        fileTaskPo.setCreateUserId(stageUser.getSysAccountId());
        fileTaskPo.setCreateUserName(stageUser.getName());
        fileTaskPo.setFileStatus(Long.valueOf(0L));
        fileTaskPo.setFileType("EXPORT");
        fileTaskPo.setValid(Boolean.valueOf(true));
        this.fileTaskServiceRpc.addFileTask(fileTaskPo);
        StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(count));
        new Thread(() -> {
            try {
                exportExcelUtil.setExportProcessId((Object)taskId);
                Method selectListByPo = this.storeCodeMappingPOMapper.getClass().getMethod("selectListByPo", Cus361StoreCodeMappingVO.class, Long.class, Long.class);
                exportExcelUtil.read("cus361StoreCodeMappingPOMapper", selectListByPo, (model, row) -> {
                    Cell cell0 = row.createCell(0);
                    Cell cell1 = row.createCell(1);
                    Cell cell2 = row.createCell(2);
                    Cell cell3 = row.createCell(3);
                    if (row.getRowNum() == 0) {
                        cell0.setCellValue("\u4e2d\u53f0\u7f16\u7801");
                        cell1.setCellValue("\u539f\u5e97\u94facode");
                        cell2.setCellValue("\u516c\u53f8code");
                        cell3.setCellValue("\u4e2d\u53f0\u9644\u52a0\u5c5e\u6027icrm\u7f16\u7801");
                    } else {
                        cell0.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getSapCode(), (CharSequence)""));
                        cell1.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getOriginStoreCode(), (CharSequence)""));
                        cell2.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getZipCode(), (CharSequence)""));
                        cell3.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getIcrmCode(), (CharSequence)""));
                    }
                }, new Object[]{cus361StoreCodeMappingVO});
            }
            catch (Exception e) {
                log.info("\u95e8\u5e97\u5bf9\u7167\u8868\u5bfc\u51fa_\u5f02\u5e38,taskId:{},\u5f02\u5e38\u4fe1\u606f{}", (Object)taskId, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }).start();
        new Thread(() -> ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"\u95e8\u5e97\u5bf9\u7167\u8868\u5bfc\u51fa_")).start();
        return new ResponseData();
    }

    private boolean isResultFailed(Result<StoreResponseVO> result) {
        if (result.getCode() == 100) {
            log.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
            return true;
        }
        return false;
    }

    private static String getPastDate() {
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(12, -12);
        Date beforeD = beforeTime.getTime();
        String result = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(beforeD);
        return result;
    }
}

