/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import cn.bizvane.rocketmq.spring.core.producer.Destination;
import cn.bizvane.rocketmq.spring.core.producer.RocketMQTemplate;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.bizvane.centerstageservice.models.po.SysBrandPo;
import com.bizvane.centerstageservice.rpc.BrandServiceRpc;
import com.bizvane.connectorservice.interfaces.rpc.IcrmConnectorServiceFeign;
import com.bizvane.customized.common.constants.Cus361ResponseEnum;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.store361.service.Cus361ResponseFailedDataService;
import com.bizvane.customized.company.store361.service.Cus361Service;
import com.bizvane.customized.company.store361.service.impl.Cus361RpcServiceImpl;
import com.bizvane.customized.facade.models.po.Cus361FailedBatchDataPO;
import com.bizvane.customized.facade.models.vo.Cus361ChannelDataVo;
import com.bizvane.customized.facade.models.vo.Cus361PrecinctAreaVo;
import com.bizvane.customized.facade.models.vo.Cus361StoreFieldsVo;
import com.bizvane.customized.mappers.Cus361FailedBatchDataPOMapper;
import com.bizvane.customized.mappers.Cus361OrderPointsDetailsPOMapper;
import com.bizvane.customized.rocketmq.rocketutils.RocketMQ361Config;
import com.bizvane.utils.commonutils.DateUtils;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.rocketutils.RocketMQClient;
import com.bizvane.wechatenterprise.service.entity.po.WxqyStaffSyncLogPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Cus361RpcServiceImpl
implements Cus361Service {
    private static final Logger log = LoggerFactory.getLogger(Cus361RpcServiceImpl.class);
    @Autowired
    RocketMQClient rocketMQClient;
    @Autowired
    RocketMQ361Config rocketMQ361Config;
    @Autowired
    Cus361FailedBatchDataPOMapper failedBatchDataPOMapper;
    @Autowired
    private Cus361ResponseFailedDataService cus361ResponseFailedDataService;
    @Autowired
    private Cus361OrderPointsDetailsPOMapper cus361OrderPointsDetailsPOMapper;
    @Autowired
    private BrandServiceRpc brandServiceRpc;
    @Autowired
    RocketMQTemplate rocketMQTemplate;
    private static final Logger logger = LoggerFactory.getLogger(Cus361RpcServiceImpl.class);
    Cus361FailedBatchDataPO failedDataPo = new Cus361FailedBatchDataPO();
    @Autowired
    IcrmConnectorServiceFeign icrmConnectorServiceFeign;

    public ResponseData addAndUpdate361ChannelData(String jsonStr, Long corpId) {
        logger.info("Cus361RpcServiceImpl addAndUpdate361ChannelData method {}" + corpId);
        ResponseData responseData = this.getFailData();
        GetMapListJson getMapListJson = new GetMapListJson(this, jsonStr, responseData).invoke();
        if (getMapListJson.is()) {
            return responseData;
        }
        List mapListJson = getMapListJson.getMapListJson();
        String batchNo = getMapListJson.getBatchNo();
        for (int i = 0; i < mapListJson.size(); ++i) {
            String sapCustomerCode;
            Cus361ChannelDataVo vo = new Cus361ChannelDataVo();
            Map map = (Map)mapListJson.get(i);
            String channelName = (String)map.get("channelName");
            String corpCode = (String)map.get("corpCode");
            if (this.isChannelParamBlank(jsonStr, corpId, batchNo, corpCode, sapCustomerCode = (String)map.get("sapCustomerCode"))) continue;
            vo.setChannelName(channelName);
            vo.setCorpCode(corpCode);
            vo.setSapCustomerCode(sapCustomerCode);
            vo.setBatchNo(batchNo);
            vo.setSysCompanyId(corpId);
            vo.setValid(Boolean.valueOf(true));
            this.cus361ChannelDataMessage(vo);
        }
        new Thread(() -> {
            try {
                log.info("Cus361RpcServiceImpl channelCallBack start param:{}", (Object)batchNo);
                this.cus361ResponseFailedDataService.get361ChannelFailedData(batchNo);
            }
            catch (Exception e) {
                log.error("Cus361RpcServiceImpl addAndUpdate361ChannelData error:{}, param:{}", (Object)e, (Object)batchNo);
            }
        }).start();
        responseData.setData((Object)batchNo);
        this.setSuccessData(responseData);
        return responseData;
    }

    private void cus361ChannelDataMessage(Cus361ChannelDataVo vo) {
        String message361ChannelBody = JacksonUtil.bean2Json((Object)vo);
        logger.info("cus361ChannelDataMessage rocketmq message361ChannelBody param:{}", (Object)message361ChannelBody);
        Message message = new Message();
        message.setTopic(this.rocketMQ361Config.cus361ChannelDataTopic);
        message.setBody(message361ChannelBody.getBytes());
        SendResult sendResult = this.rocketMQClient.sendMessage(message);
        logger.info("cus361Channel sendResult : {}", (Object)JacksonUtil.bean2Json((Object)sendResult));
    }

    public ResponseData addAndUpdate361PrecinctArea(String jsonStr, Long corpId) {
        logger.info("Cus361RpcServiceImpl addAndUpdate361PrecinctArea method {}" + corpId);
        ResponseData responseData = this.getFailData();
        GetMapListJson getMapListJson = new GetMapListJson(this, jsonStr, responseData).invoke();
        if (getMapListJson.is()) {
            return responseData;
        }
        List mapListJson = getMapListJson.getMapListJson();
        String batchNo = getMapListJson.getBatchNo();
        for (int i = 0; i < mapListJson.size(); ++i) {
            String areaInfo;
            Cus361PrecinctAreaVo vo = new Cus361PrecinctAreaVo();
            Map map = (Map)mapListJson.get(i);
            String areaCode = (String)map.get("areaCode");
            if (this.isPAreaParamBlank(jsonStr, corpId, batchNo, areaCode, areaInfo = (String)map.get("areaInfo"))) continue;
            vo.setAreaCode(areaCode);
            vo.setAreaInfo(areaInfo);
            vo.setBatchNo(batchNo);
            vo.setSysCompanyId(corpId);
            vo.setValid(Boolean.valueOf(true));
            this.cus361PrecinctAreaMessage(vo);
        }
        new Thread(() -> {
            try {
                log.info("Cus361RpcServiceImpl areaCallBack start param:{}", (Object)batchNo);
                this.cus361ResponseFailedDataService.get361AreaFailedData(batchNo);
            }
            catch (Exception e) {
                log.error("Cus361RpcServiceImpl addAndUpdate361PrecinctArea error:{}, param:{}", (Object)e, (Object)batchNo);
            }
        }).start();
        responseData.setData((Object)batchNo);
        this.setSuccessData(responseData);
        return responseData;
    }

    private void cus361PrecinctAreaMessage(Cus361PrecinctAreaVo vo) {
        String message361PAreaBody = JacksonUtil.bean2Json((Object)vo);
        logger.info("cus361PrecinctAreaMessage rocketmq message361PAreaBody param:{}", (Object)message361PAreaBody);
        Message message = new Message();
        message.setTopic(this.rocketMQ361Config.cus361PrecinctAreaTopic);
        message.setBody(message361PAreaBody.getBytes());
        SendResult sendResult = this.rocketMQClient.sendMessage(message);
        logger.info("cus361PArea sendResult : {}", (Object)JacksonUtil.bean2Json((Object)sendResult));
    }

    public ResponseData addAndUpdateStoreFieldsInfo(String storeJsonStr) {
        logger.info("Cus361RpcServiceImpl addAndUpdateStoreFieldsInfo method:" + storeJsonStr);
        ResponseData responseData = this.getFailData();
        GetMapListJson getMapListJson = new GetMapListJson(this, storeJsonStr, responseData).invoke();
        if (getMapListJson.is()) {
            return responseData;
        }
        List mapListJson = getMapListJson.getMapListJson();
        String batchNo = getMapListJson.getBatchNo();
        Boolean isClose = false;
        for (int i = 0; i < mapListJson.size(); ++i) {
            Integer businessStatus;
            Cus361StoreFieldsVo vo = new Cus361StoreFieldsVo();
            Map map = (Map)mapListJson.get(i);
            String brandCode = (String)map.get("brandCode");
            String storeCode = (String)map.get("storeCode");
            if (this.isStoreFieldsParamBlank(JacksonUtil.bean2Json((Object)map), batchNo, brandCode, storeCode)) continue;
            Integer n = businessStatus = !"".equals(map.get("businessStatus")) ? Integer.valueOf(Integer.parseInt((String)map.get("businessStatus"))) : null;
            if (this.skipExecuteFlag(businessStatus)) {
                isClose = true;
                logger.error("\u4e0d\u652f\u6301\u5173\u5e97\u64cd\u4f5c\uff01");
                this.failedDataPo.setBatchNo(batchNo);
                this.failedDataPo.setBatchDataType("30");
                this.failedDataPo.setErrorPk(storeCode);
                this.failedDataPo.setErrorBody(JacksonUtil.bean2Json((Object)map));
                this.failedDataPo.setErrorReason("\u4e0d\u652f\u6301\u5173\u5e97\u64cd\u4f5c\uff01");
                this.failedDataPo.setCreateDate(new Date());
                this.failedDataPo.setStatus("0");
                this.failedBatchDataPOMapper.insertSelective(this.failedDataPo);
                this.sendStaffSyncLogTopic(map, brandCode, storeCode);
                continue;
            }
            vo.setBrandCode(brandCode);
            vo.setStoreCode(storeCode);
            vo.setBatchNo(batchNo);
            vo.setStoreName((String)map.get("storeName"));
            vo.setStorePhone((String)map.get("storePhone"));
            vo.setStoreOrcode((String)map.get("storeOrcode"));
            vo.setStoreType((String)map.get("storeType"));
            vo.setStoreOwner((String)map.get("storeOwner"));
            vo.setStoreInfo((String)map.get("storeInfo"));
            vo.setProvince((String)map.get("province"));
            vo.setCity((String)map.get("city"));
            vo.setCounty((String)map.get("county"));
            vo.setDetailedAddress(map.get("detailedAddress") != null ? ((String)map.get("detailedAddress")).replace("<br>&nbsp;<br>", "").replace("<br>", "") : null);
            vo.setLng((String)map.get("lat"));
            vo.setLat((String)map.get("lng"));
            vo.setStoreBusinessTime((String)map.get("storeBusinessTime"));
            vo.setModelType(!"".equals(map.get("modelType")) ? Integer.valueOf(Integer.parseInt((String)map.get("modelType"))) : null);
            vo.setBusinessStatus(!"".equals(map.get("businessStatus")) ? Integer.valueOf(Integer.parseInt((String)map.get("businessStatus"))) : null);
            vo.setStoreSize(!"".equals(map.get("storeSize")) ? BigDecimal.valueOf(Double.parseDouble((String)map.get("storeSize"))) : null);
            vo.setAreaCode((String)map.get("areaCode"));
            vo.setSapCustomerCode((String)map.get("sapCustomerCode"));
            vo.setCorpCode((String)map.get("corpCode"));
            vo.setOriginStoreCode((String)map.get("originStoreCode"));
            vo.setBusinessType((String)map.get("businessType"));
            vo.setValid(Boolean.valueOf(true));
            if (StringUtils.isNotBlank((CharSequence)vo.getCorpCode())) {
                vo.setOfflineOrgCode(vo.getCorpCode());
            }
            vo.setStoreBusinessDistrictLevel((String)map.get("storeBusinessDistrictLevel"));
            vo.setStoreTypeOfBusinessDistrict((String)map.get("storeTypeOfBusinessDistrict"));
            vo.setStoreBusinessCircleDescription((String)map.get("storeBusinessCircleDescription"));
            vo.setStoreConsumerDescription((String)map.get("storeConsumerDescription"));
            vo.setStorePriceSensitivity((String)map.get("storePriceSensitivity"));
            vo.setStoreAdultClothesRegion((String)map.get("storeAdultClothesRegion"));
            vo.setStoreOpeningDate(map.get("storeOpeningDate") != null ? DateUtils.StringFormatTime((String)((String)map.get("storeOpeningDate"))) : null);
            vo.setStoreClosingDate(map.get("storeClosingDate") != null ? DateUtils.StringFormatTime((String)((String)map.get("storeClosingDate"))) : null);
            vo.setStoreCashRegisterMethod((String)map.get("storeCashRegisterMethod"));
            vo.setStoreNumberOfShopAssistants(map.get("storeNumberOfShopAssistants") != null ? Integer.valueOf(Integer.parseInt((String)map.get("storeNumberOfShopAssistants"))) : null);
            vo.setStoreAdultClothesSalesLevel((String)map.get("storeAdultClothesSalesLevel"));
            vo.setStoreAdultClothesNewProductLevel((String)map.get("storeAdultClothesNewProductLevel"));
            vo.setStorePackageLevel((String)map.get("storePackageLevel"));
            vo.setStoreFashionAttribute((String)map.get("storeFashionAttribute"));
            vo.setStoreGrouping((String)map.get("storeGrouping"));
            vo.setStoreAdultClothesStoreLevel((String)map.get("storeAdultClothesStoreLevel"));
            vo.setStoreChildrenClothesStoreLevel((String)map.get("storeChildrenClothesStoreLevel"));
            vo.setStoreBrandName((String)map.get("storeBrandName"));
            vo.setStoreAreaName((String)map.get("storeAreaName"));
            vo.setStoreSapCustomerName((String)map.get("storeSapCustomerName"));
            vo.setStoreCorpName((String)map.get("storeCorpName"));
            vo.setStoreOriginStoreName((String)map.get("storeOriginStoreName"));
            this.cus361StoreFieldsMessage(vo);
        }
        new Thread(() -> {
            try {
                Thread.sleep(30000L);
                log.info("Cus361RpcServiceImpl storeCallBack start param:{}", (Object)batchNo);
                this.cus361ResponseFailedDataService.get361StoreFailedData(batchNo);
            }
            catch (Exception e) {
                log.error("Cus361RpcServiceImpl addAndUpdateStoreFieldsInfo error:{}, param:{}", (Object)e, (Object)batchNo);
            }
        }).start();
        if (isClose.booleanValue()) {
            responseData.setData((Object)batchNo);
            responseData.setMessage("\u5b58\u5728\u5173\u5e97\u95e8\u5e97\uff0c\u63a5\u53e3\u4e0d\u4f1a\u5904\u7406\u5173\u5e97\u95e8\u5e97");
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            return responseData;
        }
        responseData.setData((Object)batchNo);
        this.setSuccessData(responseData);
        return responseData;
    }

    private boolean skipExecuteFlag(Integer businessStatus) {
        if (Integer.valueOf(10).equals(businessStatus)) {
            logger.info("\u4e0d\u8df3\u8fc7\u5904\u7406,\u8bf7\u6c42\u72b6\u6001\u4e3a\u5f00\u5e97\u7533\u8bf7");
            return false;
        }
        if (Integer.valueOf(20).equals(businessStatus)) {
            logger.info("\u4e0d\u8df3\u8fc7\u5904\u7406,\u8bf7\u6c42\u72b6\u6001\u4e3a\u5df2\u5f00\u4e1a");
            return false;
        }
        return true;
    }

    private void sendStaffSyncLogTopic(Map<String, String> map, String brandCode, String storeCode) {
        try {
            SysBrandPo brandPO = new SysBrandPo();
            brandPO.setBrandCode(brandCode);
            ResponseData brandResponse = this.brandServiceRpc.getBrandIdAndCompanyIdByCode(brandPO);
            if (brandResponse.getCode() != SysResponseEnum.SUCCESS.getCode() || brandResponse.getData() == null) {
                log.info("[Cus361StoreFieldsListener-addAndUpdateStoreFieldsInfo-info-],\u672a\u627e\u5230\u54c1\u724c:{}", (Object)brandCode);
                return;
            }
            brandPO = (SysBrandPo)brandResponse.getData();
            WxqyStaffSyncLogPO wxqyStaffSyncLogPO = new WxqyStaffSyncLogPO();
            wxqyStaffSyncLogPO.setSysCompanyId(brandPO.getSysCompanyId());
            wxqyStaffSyncLogPO.setSysBrandId(brandPO.getSysBrandId());
            wxqyStaffSyncLogPO.setSysBrandCode(brandCode);
            wxqyStaffSyncLogPO.setSyncType(Integer.valueOf(1));
            HashMap<String, String> infoMap = new HashMap<String, String>();
            infoMap.put("storeCode", storeCode);
            infoMap.put("storeName", map.get("storeName"));
            infoMap.put("message", "SAP\u64cd\u4f5c\u5173\u5e97,\u4e0d\u5141\u8bb8\u8c03\u7528CRM\u63a5\u53e3");
            wxqyStaffSyncLogPO.setLogInfo(JSON.toJSONString(infoMap));
            log.info("[Cus361StoreFieldsListener-sendStaffSyncLogTopic-info-],sendRequest:{}", (Object)JSON.toJSONString((Object)wxqyStaffSyncLogPO));
            org.apache.rocketmq.client.producer.SendResult sendResult = this.rocketMQTemplate.send(Destination.builder().topic("topic_361_staff_sync_log_message").build(), (Object)wxqyStaffSyncLogPO);
            log.info("[Cus361StoreFieldsListener-sendStaffSyncLogTopic-info-],sendResult:{}", (Object)JSON.toJSONString((Object)sendResult));
        }
        catch (Exception e) {
            log.info("[Cus361StoreFieldsListener-sendStaffSyncLogTopic-info-],send topic error,storeCode:{},e:{}", (Object)storeCode, (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private void cus361StoreFieldsMessage(Cus361StoreFieldsVo vo) {
        String message361StoreBody = JacksonUtil.bean2Json((Object)vo);
        logger.info("cus361StoreFieldsMessage rocketmq message361StoreBody param:{}", (Object)message361StoreBody);
        Message message = new Message();
        message.setTopic(this.rocketMQ361Config.cus361StoreFieldsTopic);
        message.setBody(message361StoreBody.getBytes());
        SendResult sendResult = this.rocketMQClient.sendMessage(message);
        logger.info("cus361Store sendResult : {}", (Object)JacksonUtil.bean2Json((Object)sendResult));
    }

    private ResponseData getFailData() {
        ResponseData responseData = new ResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        return responseData;
    }

    private void setSuccessData(ResponseData responseData) {
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage("\u6d88\u8d39\u6210\u529f");
    }

    private boolean isChannelParamBlank(String jsonStr, Long corpId, String batchNo, String corpCode, String sapCustomerCode) {
        if (StringUtils.isBlank((CharSequence)corpCode)) {
            logger.error("\u6240\u5c5e\u516c\u53f8code\u4e3a\u7a7a");
            this.failedDataPo.setSysCompanyId(corpId);
            this.failedDataPo.setBatchNo(batchNo);
            this.failedDataPo.setBatchDataType("10");
            this.failedDataPo.setErrorPk(sapCustomerCode);
            this.failedDataPo.setErrorBody(jsonStr);
            this.failedDataPo.setErrorReason(Cus361ResponseEnum.CUS_361_CHANNEL_FAILED_GET_COMPANY_CODE.getMessage());
            this.failedDataPo.setCreateDate(new Date());
            this.failedDataPo.setStatus("0");
            this.failedBatchDataPOMapper.insertSelective(this.failedDataPo);
            return true;
        }
        if (StringUtils.isBlank((CharSequence)sapCustomerCode)) {
            logger.error("sap\u52a0\u76df\u5546code\u4e3a\u7a7a");
            this.failedDataPo.setSysCompanyId(corpId);
            this.failedDataPo.setBatchNo(batchNo);
            this.failedDataPo.setBatchDataType("10");
            this.failedDataPo.setErrorPk(sapCustomerCode);
            this.failedDataPo.setErrorBody(jsonStr);
            this.failedDataPo.setErrorReason(Cus361ResponseEnum.CUS_361_CHANNEL_FAILED_GET_SAP_CODE.getMessage());
            this.failedDataPo.setCreateDate(new Date());
            this.failedDataPo.setStatus("0");
            this.failedBatchDataPOMapper.insertSelective(this.failedDataPo);
            return true;
        }
        return false;
    }

    private boolean isPAreaParamBlank(String jsonStr, Long corpId, String batchNo, String areaCode, String areaInfo) {
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            logger.error("\u533a\u57dfcode\u4e0d\u80fd\u4e3a\u7a7a");
            this.failedDataPo.setSysCompanyId(corpId);
            this.failedDataPo.setBatchNo(batchNo);
            this.failedDataPo.setBatchDataType("20");
            this.failedDataPo.setErrorPk(areaCode);
            this.failedDataPo.setErrorBody(jsonStr);
            this.failedDataPo.setErrorReason(Cus361ResponseEnum.CUS_361_AREA_FAILED_GET_AREA_CODE.getMessage());
            this.failedDataPo.setCreateDate(new Date());
            this.failedDataPo.setStatus("0");
            this.failedBatchDataPOMapper.insertSelective(this.failedDataPo);
            return true;
        }
        if (StringUtils.isBlank((CharSequence)areaInfo)) {
            logger.error("\u533a\u57df\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            this.failedDataPo.setSysCompanyId(corpId);
            this.failedDataPo.setBatchNo(batchNo);
            this.failedDataPo.setBatchDataType("20");
            this.failedDataPo.setErrorPk(areaCode);
            this.failedDataPo.setErrorBody(jsonStr);
            this.failedDataPo.setErrorReason(Cus361ResponseEnum.CUS_361_AREA_FAILED_GET_AREA_INFO.getMessage());
            this.failedDataPo.setCreateDate(new Date());
            this.failedDataPo.setStatus("0");
            this.failedBatchDataPOMapper.insertSelective(this.failedDataPo);
            return true;
        }
        return false;
    }

    private boolean isStoreFieldsParamBlank(String storeJsonStr, String batchNo, String brandCode, String storeCode) {
        if (StringUtils.isBlank((CharSequence)brandCode)) {
            logger.error("\u54c1\u724ccode\u4e0d\u80fd\u4e3a\u7a7a");
            this.failedDataPo.setBatchNo(batchNo);
            this.failedDataPo.setBatchDataType("30");
            this.failedDataPo.setErrorPk(storeCode);
            this.failedDataPo.setErrorBody(storeJsonStr);
            this.failedDataPo.setErrorReason(Cus361ResponseEnum.CUS_361_STORE_FAILED_GET_BRAND_CODE.getMessage());
            this.failedDataPo.setCreateDate(new Date());
            this.failedDataPo.setStatus("0");
            this.failedBatchDataPOMapper.insertSelective(this.failedDataPo);
            return true;
        }
        if (StringUtils.isBlank((CharSequence)storeCode)) {
            logger.error("\u5e97\u94facode\u4e3a\u7a7a");
            this.failedDataPo.setBatchNo(batchNo);
            this.failedDataPo.setBatchDataType("30");
            this.failedDataPo.setErrorPk(storeCode);
            this.failedDataPo.setErrorBody(storeJsonStr);
            this.failedDataPo.setErrorReason(Cus361ResponseEnum.CUS_361_STORE_FAILED_GET_STORE_CODE.getMessage());
            this.failedDataPo.setCreateDate(new Date());
            this.failedDataPo.setStatus("0");
            this.failedBatchDataPOMapper.insertSelective(this.failedDataPo);
            return true;
        }
        return false;
    }

    public Integer select361OrderIntegral(Long sysCompanyId, String orderNo) {
        return this.cus361OrderPointsDetailsPOMapper.select361OrderIntegral(sysCompanyId, orderNo);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

