/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.common.constants.SysResponseEnum;
import com.bizvane.customized.company.store361.service.Cus361IntegralCalculationPayTypeService;
import com.bizvane.customized.facade.models.po.Cus361PointsCalculationPayType;
import com.bizvane.customized.facade.models.po.Cus361PointsCalculationPayTypeExample;
import com.bizvane.customized.facade.models.vo.PayTypeParamVo;
import com.bizvane.customized.mappers.Cus361PointsCalculationPayTypeMapper;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Cus361IntegralCalculationPayTypeServiceImpl
implements Cus361IntegralCalculationPayTypeService {
    private static final Logger log = LoggerFactory.getLogger(Cus361IntegralCalculationPayTypeServiceImpl.class);
    @Autowired
    private Cus361PointsCalculationPayTypeMapper cus361PointsCalculationPayTypeMapper;

    public ResponseData<PageInfo<Cus361PointsCalculationPayType>> queryPayTypePageInfoByParam(PayTypeParamVo payTypeParamVo) {
        ResponseData responseData = new ResponseData();
        Cus361PointsCalculationPayTypeExample example = new Cus361PointsCalculationPayTypeExample();
        example.createCriteria().andBrandIdEqualTo(Long.valueOf(payTypeParamVo.getSysBrandId())).andSysCompanyIdEqualTo(Long.valueOf(payTypeParamVo.getSysCompanyId()));
        PageHelper.startPage((int)payTypeParamVo.getPageNumber(), (int)payTypeParamVo.getPageSize());
        List payTypes = this.cus361PointsCalculationPayTypeMapper.selectByExample(example);
        PageInfo payTypesPageInfo = new PageInfo(payTypes);
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData((Object)payTypesPageInfo);
        return responseData;
    }

    public List<Cus361PointsCalculationPayType> queryPayTypeListByParam(long sysCompanyId) {
        Cus361PointsCalculationPayTypeExample example = new Cus361PointsCalculationPayTypeExample();
        example.createCriteria().andSysCompanyIdEqualTo(Long.valueOf(sysCompanyId));
        List payTypes = this.cus361PointsCalculationPayTypeMapper.selectByExample(example);
        return payTypes;
    }

    public ResponseData save(Cus361PointsCalculationPayType payType) {
        ResponseData responseData = new ResponseData();
        Cus361PointsCalculationPayTypeExample example = new Cus361PointsCalculationPayTypeExample();
        example.createCriteria().andPayCodeEqualTo(payType.getPayCode());
        try {
            List payTypes = this.cus361PointsCalculationPayTypeMapper.selectByExample(example);
            if (payTypes.size() > 0) {
                responseData.setCode(SysResponseEnum.REDUPLICATE_PAYTYPE.getCode());
                responseData.setMessage(SysResponseEnum.REDUPLICATE_PAYTYPE.getMessage());
                return responseData;
            }
            this.cus361PointsCalculationPayTypeMapper.insertSelective(payType);
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u914d\u7f6e\u5f02\u5e38{}", (Throwable)e);
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return responseData;
    }

    public ResponseData updateById(Cus361PointsCalculationPayType payType) {
        ResponseData responseData = new ResponseData();
        int flag = this.cus361PointsCalculationPayTypeMapper.updateByPrimaryKey(payType);
        if (flag == 1) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return responseData;
    }

    public ResponseData delByPayCodeAndId(long sysCompanyId, long sysBrandId, JSONObject ids) {
        String[] idArray;
        ResponseData responseData = new ResponseData();
        int count = 0;
        log.info("\u5220\u9664\u53c2\u6570\u4e3a{}", (Object)ids);
        if (StringUtils.isBlank((CharSequence)ids.getString("id"))) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
            return responseData;
        }
        for (String id : idArray = ids.getString("id").split(",")) {
            Cus361PointsCalculationPayTypeExample example = new Cus361PointsCalculationPayTypeExample();
            example.createCriteria().andBrandIdEqualTo(Long.valueOf(sysBrandId)).andSysCompanyIdEqualTo(Long.valueOf(sysCompanyId)).andTCus361PointsCalculationPayTypeIdEqualTo(Long.valueOf(Long.parseLong(id)));
            int flag = this.cus361PointsCalculationPayTypeMapper.deleteByExample(example);
            count += flag;
        }
        if (count == idArray.length) {
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        } else {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        }
        return responseData;
    }
}

