/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.po.SysOfflineOrgPo;
import com.bizvane.centerstageservice.models.vo.SysOfflineOrgVo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.SysOfflineOrgServcieRpc;
import com.bizvane.customized.common.utils.Assert;
import com.bizvane.customized.common.utils.BeanUtils;
import com.bizvane.customized.common.utils.ExportExcelUtil;
import com.bizvane.customized.common.utils.StreamingExportExcelUtil;
import com.bizvane.customized.company.store361.service.Cus361DistributorService;
import com.bizvane.customized.facade.models.po.Cus361DistributorDataPo;
import com.bizvane.customized.facade.models.po.Cus361DistributorDataPoExample;
import com.bizvane.customized.facade.models.po.Cus361StoreFieldsPOExample;
import com.bizvane.customized.facade.models.vo.Cus361DistributorDataVo;
import com.bizvane.customized.mappers.Cus361DistributorDataPoMapper;
import com.bizvane.customized.mappers.Cus361StoreFieldsPOMapper;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class Cus361DistributorServiceImpl
implements Cus361DistributorService {
    private static final Logger log = LoggerFactory.getLogger(Cus361DistributorServiceImpl.class);
    @Autowired
    private Cus361DistributorDataPoMapper cus361DistributorDataPoMapper;
    @Autowired
    private Cus361StoreFieldsPOMapper cus361StoreFieldsPOMapper;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;
    @Autowired
    private SysOfflineOrgServcieRpc sysOfflineOrgServcieRpc;

    @Transactional(rollbackFor={Exception.class})
    public ResponseData save(Cus361DistributorDataPo cus361DistributorDataPo, SysAccountPO stageUser) {
        Assert.isTrue((stageUser != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u7528");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)cus361DistributorDataPo.getDistributorName()), (String)"\u7ecf\u9500\u5546\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)cus361DistributorDataPo.getCorpName()), (String)"\u7ecf\u9500\u5546\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)cus361DistributorDataPo.getCorpCode()), (String)"\u7ecf\u9500\u5546code\u4e0d\u80fd\u4e3a\u7a7a");
        Cus361DistributorDataPoExample cus361DistributorDataPoExample = new Cus361DistributorDataPoExample();
        cus361DistributorDataPoExample.createCriteria().andCorpCodeEqualTo(cus361DistributorDataPo.getCorpCode()).andValidEqualTo(Boolean.TRUE);
        long count = this.cus361DistributorDataPoMapper.countByExample(cus361DistributorDataPoExample);
        Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u7ecf\u9500\u5546code\u5df2\u5b58\u5728");
        cus361DistributorDataPo.setSysCompanyId(stageUser.getSysCompanyId());
        cus361DistributorDataPo.setCreateUserId(stageUser.getSysAccountId());
        cus361DistributorDataPo.setCreateUserName(stageUser.getName());
        cus361DistributorDataPo.setCreateDate(new Date());
        cus361DistributorDataPo.setValid(Boolean.TRUE);
        log.info("361\u5b9a\u5236-\u7ecf\u9500\u5546\u4fe1\u606f\u4fdd\u5b58\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)cus361DistributorDataPo));
        this.cus361DistributorDataPoMapper.insert(cus361DistributorDataPo);
        SysOfflineOrgVo sysOfflineOrgVo = new SysOfflineOrgVo();
        sysOfflineOrgVo.setSysCompanyId(cus361DistributorDataPo.getSysCompanyId());
        sysOfflineOrgVo.setOfflineOrgCode(cus361DistributorDataPo.getCorpCode());
        sysOfflineOrgVo.setValid(Boolean.TRUE);
        Long selectCountByVoCount = (Long)this.sysOfflineOrgServcieRpc.selectCountByVo(sysOfflineOrgVo).getData();
        if (selectCountByVoCount != null && selectCountByVoCount == 0L) {
            SysOfflineOrgPo sysOfflineOrgPo = new SysOfflineOrgPo();
            sysOfflineOrgPo.setOfflineOrgCode(cus361DistributorDataPo.getCorpCode());
            sysOfflineOrgPo.setOfflineOrgName(cus361DistributorDataPo.getCorpName());
            sysOfflineOrgPo.setSysCompanyId(cus361DistributorDataPo.getSysCompanyId());
            sysOfflineOrgPo.setCreateUserId(cus361DistributorDataPo.getCreateUserId());
            sysOfflineOrgPo.setCreateUserName(cus361DistributorDataPo.getCreateUserName());
            sysOfflineOrgPo.setValid(Boolean.TRUE);
            log.info("\u7ebf\u4e0b\u7ec4\u7ec7\u8868\u63d2\u5165:{}", (Object)JSONObject.toJSONString((Object)sysOfflineOrgPo));
            ResponseData responseData = this.sysOfflineOrgServcieRpc.insert(sysOfflineOrgPo);
            if (responseData.getCode() != SysResponseEnum.SUCCESS.getCode()) {
                throw new RuntimeException(String.format("\u7ebf\u4e0b\u7ec4\u7ec7\u8868\u63d2\u5165\u5931\u8d25,%s", responseData.getMessage()));
            }
        }
        return new ResponseData();
    }

    public ResponseData update(Cus361DistributorDataPo cus361DistributorDataPo, SysAccountPO stageUser) {
        Assert.isTrue((stageUser != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u7528");
        Assert.isTrue((cus361DistributorDataPo.getCus361DistributorDataId() != null ? 1 : 0) != 0, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)cus361DistributorDataPo.getDistributorName()), (String)"\u7ecf\u9500\u5546\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)cus361DistributorDataPo.getCorpName()), (String)"\u7ecf\u9500\u5546\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        cus361DistributorDataPo.setCorpCode(null);
        cus361DistributorDataPo.setModifiedDate(new Date());
        cus361DistributorDataPo.setModifiedUserId(stageUser.getSysAccountId());
        cus361DistributorDataPo.setModifiedUserName(stageUser.getName());
        cus361DistributorDataPo.setValid(Boolean.TRUE);
        log.info("361\u5b9a\u5236-\u7ecf\u9500\u5546\u4fe1\u606f\u4fee\u6539\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)cus361DistributorDataPo));
        this.cus361DistributorDataPoMapper.updateByPrimaryKeySelective(cus361DistributorDataPo);
        return new ResponseData();
    }

    public ResponseData deleteByCorpCode(String corpCode, SysAccountPO stageUser) {
        Assert.isTrue((stageUser != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u7528");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)corpCode), (String)"corpCode\u4e0d\u80fd\u4e3a\u7a7a");
        Long sysCompanyId = stageUser.getSysCompanyId();
        Cus361StoreFieldsPOExample cus361StoreFieldsPOExample = new Cus361StoreFieldsPOExample();
        cus361StoreFieldsPOExample.createCriteria().andCorpCodeEqualTo(corpCode).andSysCompanyIdEqualTo(sysCompanyId).andValidEqualTo(Boolean.TRUE);
        long count = this.cus361StoreFieldsPOMapper.countByExample(cus361StoreFieldsPOExample);
        Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u6709\u5e97\u94fa\u5c5e\u4e8e\u6b64\u7ecf\u9500\u5546,\u4e0d\u53ef\u5220\u9664");
        Cus361DistributorDataPo cus361DistributorDataPo = new Cus361DistributorDataPo();
        cus361DistributorDataPo.setValid(Boolean.FALSE);
        cus361DistributorDataPo.setModifiedDate(new Date());
        cus361DistributorDataPo.setModifiedUserId(stageUser.getSysAccountId());
        cus361DistributorDataPo.setModifiedUserName(stageUser.getName());
        Cus361DistributorDataPoExample cus361DistributorDataPoExample = new Cus361DistributorDataPoExample();
        cus361DistributorDataPoExample.createCriteria().andCorpCodeEqualTo(corpCode).andSysCompanyIdEqualTo(sysCompanyId);
        log.info("361\u5b9a\u5236-\u7ecf\u9500\u5546\u4fe1\u606f\u5220\u9664\u6570\u636ecorpCode:{}", (Object)corpCode);
        this.cus361DistributorDataPoMapper.updateByExampleSelective(cus361DistributorDataPo, cus361DistributorDataPoExample);
        return new ResponseData();
    }

    public ResponseData<PageInfo<Cus361DistributorDataVo>> pageByVo(Cus361DistributorDataVo cus361DistributorDataVo, SysAccountPO stageUser) {
        Assert.isTrue((stageUser != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u7528");
        Cus361DistributorDataPoExample cus361DistributorDataPoExample = new Cus361DistributorDataPoExample();
        cus361DistributorDataPoExample.createCriteria().andSysCompanyIdEqualTo(stageUser.getSysCompanyId()).andValidEqualTo(Boolean.TRUE);
        cus361DistributorDataPoExample.setOrderByClause("create_date desc");
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)cus361DistributorDataPoExample));
        Page page = PageHelper.startPage((int)cus361DistributorDataVo.getPageNumber(), (int)cus361DistributorDataVo.getPageSize()).doSelectPage(() -> this.cus361DistributorDataPoMapper.selectByExample(cus361DistributorDataPoExample));
        List cus361DistributorDataPos = page.getResult();
        if (CollectionUtils.isEmpty((Collection)cus361DistributorDataPos)) {
            return new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), (Object)new PageInfo());
        }
        List cus361DistributorDataVos = (List)BeanUtils.copyProperties((Object)cus361DistributorDataPos, new ArrayList());
        PageInfo pageInfo = new PageInfo((List)page);
        pageInfo.setList(cus361DistributorDataVos);
        return new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage(), (Object)pageInfo);
    }

    public ResponseData exportExcel(SysAccountPO stageUser) {
        Assert.isTrue((stageUser != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u7528");
        Cus361DistributorDataPoExample cus361DistributorDataPoExample = new Cus361DistributorDataPoExample();
        cus361DistributorDataPoExample.createCriteria().andSysCompanyIdEqualTo(stageUser.getSysCompanyId()).andValidEqualTo(Boolean.TRUE);
        log.info("\u5bfc\u51fa\u7ecf\u9500\u5546\u4fe1\u606f,\u67e5\u8be2\u6761\u4ef6:{}", (Object)JSONObject.toJSONString((Object)cus361DistributorDataPoExample));
        long count = this.cus361DistributorDataPoMapper.countByExample(cus361DistributorDataPoExample);
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"\u5185\u5bb9\u4e3a\u7a7a,\u65e0\u9700\u5bfc\u51fa");
        Cus361DistributorDataPo cus361DistributorDataPoQuery = new Cus361DistributorDataPo();
        cus361DistributorDataPoQuery.setSysCompanyId(stageUser.getSysCompanyId());
        cus361DistributorDataPoQuery.setValid(Boolean.TRUE);
        Long taskId = Long.valueOf(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        fileTaskPo.setFileId(taskId.toString());
        fileTaskPo.setTaskTypeCode(count + "\u6761");
        fileTaskPo.setTaskName("\u5bfc\u51fa\u7ecf\u9500\u5546\u4fe1\u606f");
        fileTaskPo.setSysBrandId(stageUser.getBrandId());
        fileTaskPo.setCreateUserId(stageUser.getSysAccountId());
        fileTaskPo.setCreateUserName(stageUser.getName());
        fileTaskPo.setFileStatus(Long.valueOf(0L));
        fileTaskPo.setFileType("EXPORT");
        fileTaskPo.setValid(Boolean.valueOf(true));
        this.fileTaskServiceRpc.addFileTask(fileTaskPo);
        StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(count));
        new Thread(() -> {
            try {
                exportExcelUtil.setExportProcessId((Object)taskId);
                Method selectListByPo = this.cus361DistributorDataPoMapper.getClass().getMethod("selectListByPo", Cus361DistributorDataPo.class, Long.class, Long.class);
                exportExcelUtil.read("cus361DistributorDataPoMapper", selectListByPo, (model, row) -> {
                    Cell cell0 = row.createCell(0);
                    Cell cell1 = row.createCell(1);
                    Cell cell2 = row.createCell(2);
                    if (row.getRowNum() == 0) {
                        cell0.setCellValue("\u7ecf\u9500\u5546\u7b80\u79f0");
                        cell1.setCellValue("\u7ecf\u9500\u5546\u5168\u79f0");
                        cell2.setCellValue("\u7ecf\u9500\u5546code");
                    } else {
                        cell0.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getDistributorName(), (CharSequence)""));
                        cell1.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getCorpName(), (CharSequence)""));
                        cell2.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getCorpCode(), (CharSequence)""));
                    }
                }, new Object[]{cus361DistributorDataPoQuery});
            }
            catch (Exception e) {
                log.info("\u7ecf\u9500\u5546\u4fe1\u606f\u5bfc\u51fa_\u5f02\u5e38,taskId:{},\u5f02\u5e38\u4fe1\u606f{}", (Object)taskId, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }).start();
        new Thread(() -> ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"\u7ecf\u9500\u5546\u4fe1\u606f\u5bfc\u51fa_")).start();
        return new ResponseData();
    }
}

