/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.service.impl;

import com.bizvane.centerstageservice.models.po.FileTaskPo;
import com.bizvane.centerstageservice.models.vo.OfflineOrgCodeResponseVo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.SysOnlineOrgServcieRpc;
import com.bizvane.customized.common.utils.Assert;
import com.bizvane.customized.common.utils.BeanUtils;
import com.bizvane.customized.common.utils.ExportExcelUtil;
import com.bizvane.customized.common.utils.StreamingExportExcelUtil;
import com.bizvane.customized.company.store361.service.Cus361ChannelService;
import com.bizvane.customized.facade.models.po.Cus361ChannelDataPO;
import com.bizvane.customized.facade.models.po.Cus361ChannelDataPOExample;
import com.bizvane.customized.facade.models.po.Cus361DistributorDataPo;
import com.bizvane.customized.facade.models.po.Cus361DistributorDataPoExample;
import com.bizvane.customized.facade.models.vo.Cus361ChannelReqVo;
import com.bizvane.customized.facade.models.vo.Cus361ChannelResVo;
import com.bizvane.customized.mappers.Cus361ChannelDataPOMapper;
import com.bizvane.customized.mappers.Cus361DistributorDataPoMapper;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Cus361ChannelServiceImpl
implements Cus361ChannelService {
    private static final Logger log = LoggerFactory.getLogger(Cus361ChannelServiceImpl.class);
    @Autowired
    private Cus361ChannelDataPOMapper cus361ChannelDataPOMapper;
    @Autowired
    private Cus361DistributorDataPoMapper cus361DistributorDataPoMapper;
    @Autowired
    private SysOnlineOrgServcieRpc sysOnlineOrgServcieRpc;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;

    public ResponseData<PageInfo<Cus361ChannelResVo>> pageByVo(Cus361ChannelReqVo cus361ChannelReqVo, SysAccountPO stageUser) {
        Assert.isTrue((stageUser != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u7528");
        this.checkPageByVoParam(cus361ChannelReqVo);
        if (StringUtils.isNotBlank((CharSequence)stageUser.getOnlineOrgCode())) {
            List offlineOrgCodes = this.getOfflineOrgCodes(stageUser.getSysCompanyId(), stageUser.getOnlineOrgCode());
            if (CollectionUtils.isEmpty((Collection)offlineOrgCodes)) {
                return new ResponseData((Object)new PageInfo());
            }
            cus361ChannelReqVo.setCorpCodeList(offlineOrgCodes);
        }
        Cus361ChannelDataPOExample cus361ChannelDataPOExample = new Cus361ChannelDataPOExample();
        Cus361ChannelDataPOExample.Criteria cus361ChannelDataPOExampleCriteria = cus361ChannelDataPOExample.createCriteria().andSysCompanyIdEqualTo(stageUser.getSysCompanyId()).andValidEqualTo(Boolean.TRUE);
        if (CollectionUtils.isNotEmpty((Collection)cus361ChannelReqVo.getCorpCodeList())) {
            cus361ChannelDataPOExampleCriteria.andCorpCodeIn(cus361ChannelReqVo.getCorpCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)cus361ChannelReqVo.getChannelCodeOrName())) {
            cus361ChannelDataPOExampleCriteria.andChannelCodeOrNameRightLike(cus361ChannelReqVo.getChannelCodeOrName());
        }
        cus361ChannelDataPOExample.setOrderByClause("create_date desc");
        Page page = PageHelper.startPage((int)cus361ChannelReqVo.getPageNumber(), (int)cus361ChannelReqVo.getPageSize()).doSelectPage(() -> this.cus361ChannelDataPOMapper.selectByExample(cus361ChannelDataPOExample));
        List cus361ChannelDataPOS = page.getResult();
        if (CollectionUtils.isEmpty((Collection)cus361ChannelDataPOS)) {
            return new ResponseData((Object)new PageInfo());
        }
        Map cus361DistributorDataPoMap = this.getCus361DistributorDataPoMap(stageUser.getSysCompanyId(), cus361ChannelReqVo.getCorpCodeList());
        ArrayList<Cus361ChannelResVo> cus361ChannelResVoList = new ArrayList<Cus361ChannelResVo>();
        for (Cus361ChannelDataPO cus361ChannelDataPO : cus361ChannelDataPOS) {
            cus361ChannelResVoList.add(this.getCus361ChannelResVo(cus361DistributorDataPoMap, cus361ChannelDataPO));
        }
        PageInfo pageInfo = new PageInfo((List)page);
        pageInfo.setList(cus361ChannelResVoList);
        return new ResponseData((Object)pageInfo);
    }

    public ResponseData exportExcel(SysAccountPO stageUser) {
        long count;
        Assert.isTrue((stageUser != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u53ef\u7528");
        Cus361ChannelDataPOExample cus361ChannelDataPOExample = new Cus361ChannelDataPOExample();
        Cus361ChannelDataPOExample.Criteria cus361ChannelDataPOExampleCriteria = cus361ChannelDataPOExample.createCriteria().andSysCompanyIdEqualTo(stageUser.getSysCompanyId()).andValidEqualTo(Boolean.TRUE);
        List offlineOrgCodes = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)stageUser.getOnlineOrgCode())) {
            offlineOrgCodes = this.getOfflineOrgCodes(stageUser.getSysCompanyId(), stageUser.getOnlineOrgCode());
            Assert.isTrue((boolean)CollectionUtils.isNotEmpty(offlineOrgCodes), (String)"\u67e5\u8be2\u7528\u6237\u7ecf\u9500\u5546\u4fe1\u606f\u4e3a\u7a7a");
            cus361ChannelDataPOExampleCriteria.andCorpCodeIn(offlineOrgCodes);
        }
        Assert.isTrue(((count = this.cus361ChannelDataPOMapper.countByExample(cus361ChannelDataPOExample)) > 0L ? 1 : 0) != 0, (String)"\u5185\u5bb9\u4e3a\u7a7a,\u65e0\u9700\u5bfc\u51fa");
        Map cus361DistributorDataPoMap = this.getCus361DistributorDataPoMap(stageUser.getSysCompanyId(), offlineOrgCodes);
        Cus361ChannelReqVo cus361ChannelReqVo = new Cus361ChannelReqVo();
        cus361ChannelReqVo.setSysCompanyId(stageUser.getSysCompanyId());
        cus361ChannelReqVo.setCorpCodeList(offlineOrgCodes);
        Long taskId = Long.valueOf(String.valueOf(UUID.randomUUID().hashCode()).replaceAll("-", ""));
        FileTaskPo fileTaskPo = new FileTaskPo();
        fileTaskPo.setTaskId(taskId);
        fileTaskPo.setFileId(taskId.toString());
        fileTaskPo.setTaskTypeCode(count + "\u6761");
        fileTaskPo.setTaskName("361\u52a0\u76df\u5546\u6863\u6848\u5bfc\u51fa");
        fileTaskPo.setSysBrandId(stageUser.getBrandId());
        fileTaskPo.setCreateUserId(stageUser.getSysAccountId());
        fileTaskPo.setCreateUserName(stageUser.getName());
        fileTaskPo.setFileStatus(Long.valueOf(0L));
        fileTaskPo.setFileType("EXPORT");
        fileTaskPo.setValid(Boolean.valueOf(true));
        this.fileTaskServiceRpc.addFileTask(fileTaskPo);
        StreamingExportExcelUtil exportExcelUtil = new StreamingExportExcelUtil(Long.valueOf(count));
        new Thread(() -> {
            try {
                exportExcelUtil.setExportProcessId((Object)taskId);
                Method selectListByVo = this.cus361ChannelDataPOMapper.getClass().getMethod("selectListByVo", Cus361ChannelReqVo.class, Long.class, Long.class);
                exportExcelUtil.read("cus361ChannelDataPOMapper", selectListByVo, (model, row) -> {
                    Cell cell0 = row.createCell(0);
                    Cell cell1 = row.createCell(1);
                    Cell cell2 = row.createCell(2);
                    if (row.getRowNum() == 0) {
                        cell0.setCellValue("\u52a0\u76df\u5546\u540d\u79f0");
                        cell1.setCellValue("\u52a0\u76df\u5546code");
                        cell2.setCellValue("\u6240\u5c5e\u7ecf\u9500\u5546\u540d\u79f0");
                    } else {
                        cell0.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getChannelName(), (CharSequence)""));
                        cell1.setCellValue((String)StringUtils.defaultIfBlank((CharSequence)model.getSapCustomerCode(), (CharSequence)""));
                        if (StringUtils.isNotBlank((CharSequence)model.getCorpCode()) && cus361DistributorDataPoMap.containsKey(model.getCorpCode())) {
                            Cus361DistributorDataPo cus361DistributorDataPo = (Cus361DistributorDataPo)cus361DistributorDataPoMap.get(model.getCorpCode());
                            cell2.setCellValue(cus361DistributorDataPo.getCorpName());
                        } else {
                            cell2.setCellValue("");
                        }
                    }
                }, new Object[]{cus361ChannelReqVo});
            }
            catch (Exception e) {
                log.info("361\u52a0\u76df\u5546\u6863\u6848\u5bfc\u51fa_\u5f02\u5e38,taskId:{},\u5f02\u5e38\u4fe1\u606f{}", (Object)taskId, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }).start();
        new Thread(() -> ExportExcelUtil.exportAndUpdateTask((FileTaskPo)fileTaskPo, (StreamingExportExcelUtil)exportExcelUtil, (FileTaskServiceRpc)this.fileTaskServiceRpc, (String)"361\u52a0\u76df\u5546\u6863\u6848\u5bfc\u51fa_")).start();
        return new ResponseData();
    }

    private List<String> getOfflineOrgCodes(Long sysCompanyId, String onlineOrgCode) {
        log.info("getOfflineOrgCodes#sysCompanyId:{},onlineOrgCode:{}", (Object)sysCompanyId, (Object)onlineOrgCode);
        ResponseData offlineOrgCodeResponseVoResponseData = this.sysOnlineOrgServcieRpc.queryOfflineOrg(sysCompanyId, onlineOrgCode);
        if (offlineOrgCodeResponseVoResponseData == null) {
            return null;
        }
        if (offlineOrgCodeResponseVoResponseData.getData() == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)((OfflineOrgCodeResponseVo)offlineOrgCodeResponseVoResponseData.getData()).getOfflineOrgCodes())) {
            return null;
        }
        String offlineOrgCodes = ((OfflineOrgCodeResponseVo)offlineOrgCodeResponseVoResponseData.getData()).getOfflineOrgCodes();
        List<String> offlineOrgCodeList = Arrays.asList(offlineOrgCodes.split(","));
        log.info("getOfflineOrgCodes#offlineOrgCodeList:{}", offlineOrgCodeList);
        return offlineOrgCodeList;
    }

    private Map<String, Cus361DistributorDataPo> getCus361DistributorDataPoMap(Long sysCompanyId, List<String> corpCodeList) {
        log.info("getCus361DistributorDataPoMap#sysCompanyId:{},corpCodeList:{}", (Object)sysCompanyId, corpCodeList);
        Cus361DistributorDataPoExample cus361DistributorDataPoExample = new Cus361DistributorDataPoExample();
        Cus361DistributorDataPoExample.Criteria cus361DistributorDataPoExampleCriteria = cus361DistributorDataPoExample.createCriteria().andSysCompanyIdEqualTo(sysCompanyId).andValidEqualTo(Boolean.TRUE);
        if (CollectionUtils.isNotEmpty(corpCodeList)) {
            cus361DistributorDataPoExampleCriteria.andCorpCodeIn(corpCodeList);
        }
        List cus361DistributorDataPos = this.cus361DistributorDataPoMapper.selectByExample(cus361DistributorDataPoExample);
        Map<String, Cus361DistributorDataPo> cus361DistributorDataPoMap = new HashMap<String, Cus361DistributorDataPo>();
        if (CollectionUtils.isNotEmpty((Collection)cus361DistributorDataPos)) {
            cus361DistributorDataPoMap = cus361DistributorDataPos.stream().collect(Collectors.toMap(Cus361DistributorDataPo::getCorpCode, cus361DistributorDataPo -> cus361DistributorDataPo));
        }
        return cus361DistributorDataPoMap;
    }

    private Cus361ChannelResVo getCus361ChannelResVo(Map<String, Cus361DistributorDataPo> cus361DistributorDataPoMap, Cus361ChannelDataPO cus361ChannelDataPO) {
        Cus361ChannelResVo cus361ChannelResVo = new Cus361ChannelResVo();
        BeanUtils.copyProperties((Object)cus361ChannelDataPO, (Object)cus361ChannelResVo);
        if (StringUtils.isNotBlank((CharSequence)cus361ChannelDataPO.getCorpCode()) && cus361DistributorDataPoMap.containsKey(cus361ChannelDataPO.getCorpCode())) {
            Cus361DistributorDataPo cus361DistributorDataPo = cus361DistributorDataPoMap.get(cus361ChannelDataPO.getCorpCode());
            cus361ChannelResVo.setCorpName(cus361DistributorDataPo.getCorpName());
        }
        return cus361ChannelResVo;
    }

    private void checkPageByVoParam(Cus361ChannelReqVo cus361ChannelReqVo) {
        if (cus361ChannelReqVo == null) {
            cus361ChannelReqVo = new Cus361ChannelReqVo();
            cus361ChannelReqVo.setPageNumber(Integer.valueOf(1));
            cus361ChannelReqVo.setPageSize(Integer.valueOf(10));
        }
        if (cus361ChannelReqVo.getPageNumber() == null) {
            cus361ChannelReqVo.setPageNumber(Integer.valueOf(1));
        }
        if (cus361ChannelReqVo.getPageSize() == null) {
            cus361ChannelReqVo.setPageSize(Integer.valueOf(10));
        }
    }
}

