/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.controller;

import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.store361.service.MbrFrozenRecordService;
import com.bizvane.customized.facade.enums.MbrFrozenEnum;
import com.bizvane.customized.facade.models.vo.CusMbrFrozenRecordVo;
import com.bizvane.customized.facade.utils.ResponseUtils;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.JWTUtil;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.Api;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@Api(value="\u4f1a\u5458\u51bb\u7ed3\u8bb0\u5f55\u5217\u8868")
@RequestMapping(value={"/mbrFrozenRecord"})
@RestController
public class MbrFrozenRecordController {
    private static final Logger log = LoggerFactory.getLogger(MbrFrozenRecordController.class);
    @Autowired
    MbrFrozenRecordService mbrFrozenDefService;

    @PostMapping(value={"/queryRecordList"})
    public ResponseData queryRecordList(@RequestBody CusMbrFrozenRecordVo cusMbrFrozenRecordVo, HttpServletRequest request) {
        log.info("enter MbrFrozenRecordController queryRecordList param:{}", (Object)JacksonUtil.bean2Json((Object)cusMbrFrozenRecordVo));
        PageVo pageVo = new PageVo(cusMbrFrozenRecordVo.getPageNumber(), cusMbrFrozenRecordVo.getPageSize());
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        if (sysAccountPO == null) {
            sysAccountPO = MbrFrozenRecordController.getStageUser((HttpServletRequest)request);
        }
        if (null == sysAccountPO) {
            log.info("No login, no token available!");
            return ResponseUtils.getFailedData();
        }
        this.getBaseAttributes(cusMbrFrozenRecordVo, sysAccountPO);
        return this.mbrFrozenDefService.queryRecordList(cusMbrFrozenRecordVo, pageVo);
    }

    @PostMapping(value={"/addWhite"})
    public ResponseData addWhite(@RequestBody List<CusMbrFrozenRecordVo> cusMbrFrozenRecordVo, HttpServletRequest request) {
        log.info("enter MbrFrozenRecordController addWhite param:{}", (Object)JacksonUtil.bean2Json(cusMbrFrozenRecordVo));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        if (sysAccountPO == null) {
            sysAccountPO = MbrFrozenRecordController.getStageUser((HttpServletRequest)request);
        }
        if (null == sysAccountPO || CollectionUtils.isEmpty(cusMbrFrozenRecordVo)) {
            log.info("request param not null!");
            return ResponseUtils.getFailedData();
        }
        for (CusMbrFrozenRecordVo recordVo : cusMbrFrozenRecordVo) {
            this.getBaseAttributes(recordVo, sysAccountPO);
        }
        return this.mbrFrozenDefService.addWhite(cusMbrFrozenRecordVo, sysAccountPO);
    }

    @PostMapping(value={"/exportExcel"})
    public ResponseData exportExcel(@RequestBody CusMbrFrozenRecordVo cusMbrFrozenRecordVo, HttpServletRequest request) {
        log.info("enter MbrFrozenRecordController exportExcel param:{}", (Object)JacksonUtil.bean2Json((Object)cusMbrFrozenRecordVo));
        SysAccountPO sysAccountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        if (sysAccountPO == null) {
            sysAccountPO = MbrFrozenRecordController.getStageUser((HttpServletRequest)request);
        }
        if (null == sysAccountPO) {
            log.info("No login, no token available!");
            return ResponseUtils.getFailedData();
        }
        this.getBaseAttributes(cusMbrFrozenRecordVo, sysAccountPO);
        return this.mbrFrozenDefService.exportExcel(cusMbrFrozenRecordVo);
    }

    @PostMapping(value={"/frozenTypeSelect"})
    public ResponseData frozenTypeSelect() {
        log.info("enter MbrFrozenRecordController frozenTypeSelect ");
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        for (MbrFrozenEnum frozenEnum : MbrFrozenEnum.values()) {
            if (frozenEnum.getCode().equals(10)) continue;
            map.put(frozenEnum.getCode(), frozenEnum.getMsg());
        }
        return new ResponseData((Object)JacksonUtil.bean2Json(map));
    }

    @PostMapping(value={"/existWhitelist"})
    public ResponseData existWhitelist(@RequestBody CusMbrFrozenRecordVo cusMbrFrozenRecordVo) {
        log.info("enter MbrFrozenRecordController existWhitelist ");
        return this.mbrFrozenDefService.existWhitelist(cusMbrFrozenRecordVo);
    }

    @PostMapping(value={"/addRecord"})
    public ResponseData addRecord(@RequestBody CusMbrFrozenRecordVo cusMbrFrozenRecordVo) {
        log.info("enter MbrFrozenRecordController existWhitelist ");
        return this.mbrFrozenDefService.addRecord(cusMbrFrozenRecordVo);
    }

    private void getBaseAttributes(CusMbrFrozenRecordVo cusMbrFrozenRecordVo, SysAccountPO sysAccountPO) {
        cusMbrFrozenRecordVo.setSysCompanyId(sysAccountPO.getSysCompanyId());
        cusMbrFrozenRecordVo.setSysBrandId(sysAccountPO.getBrandId());
        if (cusMbrFrozenRecordVo.getSysBrandId() == null) {
            log.info("cusMbrFrozenRecordVo getSysBrandId\u4e3a\u7a7a");
        }
        cusMbrFrozenRecordVo.setCreateUserName(sysAccountPO.getName());
        cusMbrFrozenRecordVo.setCreateUserId(sysAccountPO.getSysAccountId());
    }

    public static SysAccountPO getStageUser(HttpServletRequest request) {
        String sysAccountPoString = request.getHeader("stageToken");
        return (SysAccountPO)JWTUtil.unsign((String)sysAccountPoString, SysAccountPO.class);
    }
}

