/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.store361.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.store361.service.Cus361IntegralCalculationPayTypeService;
import com.bizvane.customized.facade.models.po.Cus361PointsCalculationPayType;
import com.bizvane.customized.facade.models.vo.PayTypeParamVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.bizvane.utils.tokens.TokenUtils;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/integralcalculationpaytype"})
public class IntegralCalculationPayTypeController {
    private static final Logger log = LoggerFactory.getLogger(IntegralCalculationPayTypeController.class);
    @Autowired
    private Cus361IntegralCalculationPayTypeService cus361IntegralCalculationPayTypeService;

    @ApiOperation(value="\u67e5\u8be2\u652f\u4ed8\u7c7b\u578b")
    @PostMapping(value={"/queryPayTypeByParam"})
    public ResponseData<PageInfo<Cus361PointsCalculationPayType>> queryPayTypeByParam(@RequestBody PayTypeParamVo payTypeParamVo, HttpServletRequest request) {
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        payTypeParamVo.setSysBrandId(accountPO.getBrandId().longValue());
        payTypeParamVo.setSysCompanyId(accountPO.getSysCompanyId().longValue());
        return this.cus361IntegralCalculationPayTypeService.queryPayTypePageInfoByParam(payTypeParamVo);
    }

    @ApiOperation(value="\u4fdd\u5b58\u79ef\u5206\u8ba1\u7b97\u89c4\u5219")
    @PostMapping(value={"/savePayType"})
    public ResponseData save(@RequestBody Cus361PointsCalculationPayType payType, HttpServletRequest request) {
        log.info("saveIntegralCalculationRule save param:{}", (Object)JacksonUtil.bean2Json((Object)payType));
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        payType.setBrandId(accountPO.getBrandId());
        payType.setSysCompanyId(accountPO.getSysCompanyId());
        payType.setCreateUserId(accountPO.getSysAccountId());
        payType.setCreateUserName(accountPO.getName());
        payType.setModifiedUserId(accountPO.getSysAccountId());
        payType.setModifiedUserName(accountPO.getName());
        return this.cus361IntegralCalculationPayTypeService.save(payType);
    }

    @ApiOperation(value="\u6839\u636eID\u6216\u8005payCode\u4fee\u6539\u6570\u636e")
    @PostMapping(value={"/updateById"})
    public ResponseData updateById(@RequestBody Cus361PointsCalculationPayType payType, HttpServletRequest request) {
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        payType.setBrandId(accountPO.getBrandId());
        payType.setSysCompanyId(accountPO.getSysCompanyId());
        payType.setCreateUserId(accountPO.getSysAccountId());
        payType.setCreateUserName(accountPO.getName());
        payType.setModifiedUserId(accountPO.getSysAccountId());
        payType.setModifiedUserName(accountPO.getName());
        return this.cus361IntegralCalculationPayTypeService.updateById(payType);
    }

    @ApiOperation(value="\u4fdd\u5b58\u79ef\u5206\u8ba1\u7b97\u89c4\u5219")
    @PostMapping(value={"/delByPayCodeAndId"})
    public ResponseData delByPayCodeAndId(@RequestBody JSONObject ids, HttpServletRequest request) {
        SysAccountPO accountPO = TokenUtils.getStageUser((HttpServletRequest)request);
        return this.cus361IntegralCalculationPayTypeService.delByPayCodeAndId(accountPO.getSysCompanyId().longValue(), accountPO.getBrandId().longValue(), ids);
    }
}

