/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.standard.controller.rpc;

import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.common.utils.ResponseDataUtil;
import com.bizvane.customized.company.standard.service.MemberDistributionService;
import com.bizvane.customized.facade.models.po.CusDistributionExchangePO;
import com.bizvane.customized.facade.models.po.CusDistributionRecordPO;
import com.bizvane.customized.facade.models.vo.DistributionVo;
import com.bizvane.customized.facade.models.vo.MemberDistributionPageVo;
import com.bizvane.customized.facade.models.vo.MemberDistributionShareVo;
import com.bizvane.customized.facade.models.vo.MemberDistributionVo;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(description="\u4f1a\u5458\u5206\u9500")
@RestController
@RequestMapping(value={"/memberDistributionRpc"})
public class MemberDistributionRpcController {
    private static final Logger log = LoggerFactory.getLogger(MemberDistributionRpcController.class);
    @Autowired
    private MemberDistributionService memberDistributionService;

    @PostMapping(value={"/queryDistribution"})
    ResponseData<MemberDistributionPageVo> queryDistribution(@RequestBody @Valid MemberDistributionPageVo vo) {
        log.info("enter queryDistribution param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.memberDistributionService.queryDistribution(vo);
    }

    @PostMapping(value={"/querycommissionRegular"})
    ResponseData<String> queryCommissionRegular(@RequestBody @Valid MemberDistributionPageVo vo) {
        log.info("enter querycommissionRegular param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.memberDistributionService.queryCommissionRegular(vo);
    }

    @PostMapping(value={"/queryExchangeRate"})
    ResponseData<MemberDistributionPageVo> queryExchangeRate(@RequestBody @Valid MemberDistributionPageVo vo) {
        log.info("enter queryExchangeRate param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.memberDistributionService.queryExchangeRate(vo);
    }

    @PostMapping(value={"/queryCommissionExchange"})
    ResponseData<PageInfo<CusDistributionExchangePO>> queryCommissionExchange(@RequestBody @Valid MemberDistributionVo vo) {
        log.info("enter queryCommissionExchange param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.memberDistributionService.findDistributionExchange(vo);
    }

    @PostMapping(value={"/getCommissionRecord"})
    ResponseData<PageInfo<CusDistributionRecordPO>> getCommissionRecord(@RequestBody @Valid MemberDistributionVo vo) {
        log.info("MemberDistributionRpcController getCommissionRecord param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.memberDistributionService.queryCommissionRecord(vo);
    }

    @PostMapping(value={"/getChooseFriends"})
    ResponseData<MemberDistributionShareVo> getChooseFriends(@RequestBody @Valid MemberDistributionShareVo vo) {
        log.info("MemberDistributionRpcController getChooseFriends param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.memberDistributionService.getChooseFriends(vo);
    }

    @PostMapping(value={"/getSharePosters"})
    ResponseData<MemberDistributionShareVo> getSharePosters(@RequestBody @Valid MemberDistributionShareVo vo) {
        log.info("MemberDistributionRpcController getSharePosters param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.memberDistributionService.getSharePosters(vo);
    }

    @ApiOperation(value="\u4f63\u91d1\u5151\u6362\u79ef\u5206")
    @PostMapping(value={"/commissionExchangeIntegral"})
    public ResponseData commissionExchangeIntegral(@RequestBody MemberDistributionPageVo vo) {
        log.info("enter MemberDistributionRpcController commissionExchangeIntegral param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.memberDistributionService.commissionExchangeIntegral(vo);
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u67e5\u8be2\u6211\u7684\u4f1a\u5458")
    @PostMapping(value={"/queryMyMember"})
    public ResponseData queryMyMember(@RequestBody DistributionVo vo) {
        log.info("enter MemberDistributionRpcController queryMyMember param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        SysAccountPO accountPO = new SysAccountPO();
        accountPO.setSysCompanyId(vo.getSysCompanyId());
        accountPO.setBrandId(vo.getBrandId());
        Optional<SysAccountPO> currentUser = Optional.ofNullable(accountPO);
        PageRequest pageable = PageRequest.of((int)vo.getPageNumber(), (int)vo.getPageSize());
        PageInfo pageInfo = this.memberDistributionService.querySubordinateMemberList(vo, currentUser, (Pageable)pageable);
        return ResponseDataUtil.getSuccessData((Object)pageInfo);
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u67e5\u8be2\u4f63\u91d1\u79ef\u5206\u5151\u6362\u6bd4\u4f8b")
    @PostMapping(value={"/queryCommissionIntegral"})
    public ResponseData<MemberDistributionPageVo> queryCommissionIntegral(@RequestBody MemberDistributionPageVo vo) {
        log.info("enter MemberDistributionRpcController queryCommissionIntegral param:{}", (Object)JacksonUtil.bean2Json((Object)vo));
        return this.memberDistributionService.queryCommissionIntegral(vo);
    }
}

