/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.mj.service;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.baisonBase.facade.models.mj.MjQueryMemberInfoRequestVo;
import com.bizvane.baisonBase.facade.rpc.MjMemberServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.customized.common.utils.DateUtil;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.mj.service.CusMengJieService;
import com.bizvane.customized.facade.models.vo.mj.CurMjRequestVo;
import com.bizvane.customized.facade.models.vo.mj.WashProtectVo;
import com.bizvane.customized.facade.utils.OkHttpUtils;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CusMengJieServiceImpl
implements CusMengJieService {
    private static final Logger log = LoggerFactory.getLogger(CusMengJieServiceImpl.class);
    @Value(value="${mengjie.xihujinUrl}")
    private String mJXihujinUrl;
    @Autowired
    private OkHttpUtils okHttpUtils;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private MjMemberServiceRpc mjMemberServiceRpc;

    public ResponseData<WashProtectVo> getWashProtectVoByPhone(String mobile) {
        log.info("\u83b7\u53d6\u68a6\u6d01\u6d17\u62a4\u91d1\u4fe1\u606f#getWashProtectVoByPhone#phone:{},mJXihujinUrl:{}", (Object)mobile, (Object)this.mJXihujinUrl);
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return new ResponseData();
        }
        long currentTimeMillis = DateUtil.getCurrentTimeMillis();
        String sign = DigestUtils.md5Hex((String)("WXTHIRD-INVOKE-BALANCE" + currentTimeMillis + mobile));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mobile", mobile);
        params.put("timeStamp", String.valueOf(currentTimeMillis));
        params.put("sign", sign);
        JSONObject jsonObjectResult = this.okHttpUtils.httpGet(this.mJXihujinUrl, params, false);
        if (jsonObjectResult == null) {
            return new ResponseData();
        }
        String data = jsonObjectResult.getString("data");
        if (StringUtils.isBlank((CharSequence)data)) {
            return new ResponseData();
        }
        WashProtectVo washProtectVo = (WashProtectVo)JSONObject.parseObject((String)data, WashProtectVo.class);
        return new ResponseData((Object)washProtectVo);
    }

    public ResponseData<Long> queryExpireIntegral(CurMjRequestVo vo) {
        ResponseData responseData = new ResponseData(SysResponseEnum.SUCCESS.getCode(), SysResponseEnum.SUCCESS.getMessage());
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setSysCompanyId(vo.getSysCompanyId());
        memberInfoModel.setBrandId(vo.getSysBrandId());
        memberInfoModel.setMemberCode(vo.getMemberCode());
        memberInfoModel.setValid(Integer.valueOf(1));
        ResponseData memberResponseData = this.memberInfoApiService.getMemberModel(memberInfoModel);
        if (memberResponseData != null && SysResponseEnum.SUCCESS.getCode() == memberResponseData.getCode() && memberResponseData.getData() != null) {
            memberInfoModel = (MemberInfoModel)memberResponseData.getData();
        }
        MjQueryMemberInfoRequestVo requestVo = new MjQueryMemberInfoRequestVo();
        requestVo.setCardNo(memberInfoModel.getCardNo());
        requestVo.setSysCompanyId(vo.getSysCompanyId());
        requestVo.setPhone(memberInfoModel.getPhone());
        log.info("\u8c03\u7528\u7ebf\u4e0b\u4f1a\u5458\u5373\u5c06\u8fc7\u671f\u79ef\u5206 \u53c2\u6570param:{}", (Object)JacksonUtil.bean2Json((Object)requestVo));
        Result result = this.mjMemberServiceRpc.queryExpireIntegral(requestVo);
        log.info("\u8c03\u7528\u7ebf\u4e0b\u4f1a\u5458\u5373\u5c06\u8fc7\u671f\u79ef\u5206 \u8fd4\u56de\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)result));
        if (result != null && SysResponseEnum.SUCCESS.getCode() == result.getCode().intValue()) {
            responseData.setData(result.getTData());
        }
        return responseData;
    }
}

