/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.customized.company.mj.service;

import com.bizvane.baisonBase.facade.models.mj.MjQueryMemberInfoRequestVo;
import com.bizvane.baisonBase.facade.models.mj.QueryGiftRecordsResponseVo;
import com.bizvane.baisonBase.facade.rpc.MjMemberServiceRpc;
import com.bizvane.centerstageservice.models.po.SysStorePo;
import com.bizvane.centerstageservice.models.vo.QueryStoreListVo;
import com.bizvane.centerstageservice.rpc.FileTaskServiceRpc;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.connectorservice.entity.Result;
import com.bizvane.customized.common.utils.JacksonUtil;
import com.bizvane.customized.company.mj.service.CurMjGiftCardService;
import com.bizvane.customized.facade.enums.mj.GjftCardOperationTypEnum;
import com.bizvane.customized.facade.models.vo.mj.CurMjGiftCardRecordRequestVo;
import com.bizvane.customized.facade.models.vo.mj.CusMjGiftCardRequestVo;
import com.bizvane.members.facade.models.MemberInfoModel;
import com.bizvane.members.facade.service.api.MemberInfoApiService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CurMjGiftCardServiceImpl
implements CurMjGiftCardService {
    private static final Logger log = LoggerFactory.getLogger(CurMjGiftCardServiceImpl.class);
    @Autowired
    private MjMemberServiceRpc mjMemberServiceRpc;
    @Autowired
    private MemberInfoApiService memberInfoApiService;
    @Autowired
    private StoreServiceRpc storeServiceRpc;
    @Autowired
    private FileTaskServiceRpc fileTaskServiceRpc;

    public ResponseData<String> bindGiftCard(CusMjGiftCardRequestVo vo) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), "\u7ed1\u5b9a\u5931\u8d25");
        log.info("\u5f00\u59cb\u8c03\u7528\u7ebf\u4e0b\u7ed1\u793c\u54c1\u5361");
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setSysCompanyId(vo.getSysCompanyId());
        memberInfoModel.setBrandId(vo.getSysBrandId());
        memberInfoModel.setMemberCode(vo.getMemberCode());
        memberInfoModel.setValid(Integer.valueOf(1));
        ResponseData memberResponseData = this.memberInfoApiService.getMemberModel(memberInfoModel);
        if (memberResponseData != null && SysResponseEnum.SUCCESS.getCode() == memberResponseData.getCode() && memberResponseData.getData() != null) {
            memberInfoModel = (MemberInfoModel)memberResponseData.getData();
        }
        MjQueryMemberInfoRequestVo requestVo = new MjQueryMemberInfoRequestVo();
        requestVo.setSysCompanyId(vo.getSysCompanyId());
        requestVo.setCardNo(memberInfoModel.getCardNo());
        requestVo.setGiftPassWord(vo.getGiftCardPassword());
        log.info("\u8c03\u7528\u7ebf\u4e0b\u7ed1\u793c\u54c1\u5361 \u53c2\u6570param:{}", (Object)JacksonUtil.bean2Json((Object)requestVo));
        Result result = this.mjMemberServiceRpc.giftCardBind(requestVo);
        log.info("\u8c03\u7528\u7ebf\u4e0b\u7ed1\u793c\u54c1\u5361 \u8fd4\u56de\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)result));
        responseData.setCode(result.getCode().intValue());
        if (SysResponseEnum.SUCCESS.getCode() == result.getCode().intValue()) {
            responseData.setMessage("\u7ed1\u5b9a\u6210\u529f");
        } else if (-1 == result.getCode()) {
            responseData.setMessage(result.getMessage());
        } else if (100 == result.getCode()) {
            responseData.setMessage(result.getMessage());
        }
        return responseData;
    }

    public ResponseData<PageInfo<QueryGiftRecordsResponseVo>> selectPageNew(CurMjGiftCardRecordRequestVo vo) {
        ResponseData responseData = new ResponseData(SysResponseEnum.FAILED.getCode(), SysResponseEnum.FAILED.getMessage());
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setSysCompanyId(vo.getSysCompanyId());
        memberInfoModel.setBrandId(vo.getSysBrandId());
        memberInfoModel.setMemberCode(vo.getMemberCode());
        memberInfoModel.setValid(Integer.valueOf(1));
        ResponseData memberResponseData = this.memberInfoApiService.getMemberModel(memberInfoModel);
        if (memberResponseData != null && SysResponseEnum.SUCCESS.getCode() == memberResponseData.getCode() && memberResponseData.getData() != null) {
            memberInfoModel = (MemberInfoModel)memberResponseData.getData();
        }
        MjQueryMemberInfoRequestVo requestVo = new MjQueryMemberInfoRequestVo();
        requestVo.setCardNo(memberInfoModel.getCardNo());
        requestVo.setSysCompanyId(vo.getSysCompanyId());
        requestVo.setPhone(memberInfoModel.getPhone());
        requestVo.setPageNum(vo.getPageNum());
        requestVo.setNum(vo.getPageSize());
        log.info("\u8c03\u7528\u7ebf\u4e0b\u793c\u54c1\u5361\u6d41\u6c34 \u53c2\u6570param:{}", (Object)JacksonUtil.bean2Json((Object)requestVo));
        Result result = this.mjMemberServiceRpc.queryGiftRecords(requestVo);
        log.info("\u8c03\u7528\u7ebf\u4e0b\u793c\u54c1\u5361\u6d41\u6c34 \u8fd4\u56de\u7ed3\u679c:{}", (Object)JacksonUtil.bean2Json((Object)result));
        List data = new ArrayList();
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(0L);
        if (result != null && SysResponseEnum.SUCCESS.getCode() == result.getCode().intValue()) {
            Map storeMap = null;
            data = (List)result.getTData();
            if (CollectionUtils.isNotEmpty(data)) {
                List collect = data.stream().filter(t -> t.getStoreCode() != null).map(QueryGiftRecordsResponseVo::getStoreCode).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)) {
                    QueryStoreListVo storeListVo = new QueryStoreListVo();
                    storeListVo.setSysCompanyId(vo.getSysCompanyId());
                    storeListVo.setSysBrandId(vo.getSysBrandId());
                    storeListVo.setSysStoreOfflineCodeList(collect);
                    ResponseData storeResponseData = this.storeServiceRpc.queryStoreList(storeListVo);
                    if (storeResponseData != null && SysResponseEnum.SUCCESS.getCode() == storeResponseData.getCode() && CollectionUtils.isNotEmpty((Collection)((Collection)storeResponseData.getData()))) {
                        List poList = (List)storeResponseData.getData();
                        storeMap = poList.stream().collect(Collectors.toMap(SysStorePo::getSysStoreOfflineCode, Function.identity(), (a, b) -> b));
                    }
                }
                pageInfo.setTotal((long)((QueryGiftRecordsResponseVo)data.get(0)).getCount().intValue());
            }
            for (QueryGiftRecordsResponseVo t2 : data) {
                GjftCardOperationTypEnum gjftCardConsumerTypEnum;
                if (storeMap != null && storeMap.containsKey(t2.getStoreCode())) {
                    SysStorePo sysStorePo = (SysStorePo)storeMap.get(t2.getStoreCode());
                    t2.setStoreName(sysStorePo.getStoreName());
                }
                t2.setChangeName("");
                if (t2.getChangeType() == null || (gjftCardConsumerTypEnum = GjftCardOperationTypEnum.getGjftCardOperationTypEnum((Integer)t2.getChangeType())) == null) continue;
                t2.setChangeName(gjftCardConsumerTypEnum.getMessage());
            }
            responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
            responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        }
        pageInfo.setList(data);
        responseData.setData((Object)pageInfo);
        return responseData;
    }
}

